/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.blockentity;

import com.portable.storage.PortableStorage;
import com.portable.storage.blockentity.ModBlockEntities;
import com.portable.storage.newstore.ItemKeyHasher;
import com.portable.storage.newstore.NewStoreService;
import com.portable.storage.newstore.PlayerStore;
import com.portable.storage.newstore.StorageMemoryCache;
import com.portable.storage.newstore.TemplateIndex;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.player.StorageGroupService;
import com.portable.storage.storage.BarrelFilterRuleManager;
import com.portable.storage.storage.StorageInventory;
import com.portable.storage.storage.StorageType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1722;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class BoundBarrelBlockEntity
extends class_2621
implements class_1278 {
    private class_2371<class_1799> inventory;
    private UUID ownerUuid;
    private String ownerName;
    private static final ThreadLocal<Boolean> THREAD_AUTOMATION_EXTRACT = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<class_2338> THREAD_INSERT_SOURCE = new ThreadLocal();
    private long lastSlot5ProcessTick = -1L;
    private class_1799 lastSlot5Processed = class_1799.field_8037;
    private class_2338 lastSlot5SourcePos = null;
    private List<FilterRule> filterRules = new ArrayList<FilterRule>();
    private volatile boolean filterRulesEmpty = true;
    private volatile long lastFilterRulesCheckTick = -1L;
    private volatile String lastItemKey = null;
    private volatile class_1799 lastItemForKey = class_1799.field_8037;

    public List<FilterRule> getFilterRules() {
        return new ArrayList<FilterRule>(this.filterRules);
    }

    public void setFilterRules(List<FilterRule> rules) {
        this.filterRules = new ArrayList<FilterRule>(rules);
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public BoundBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BOUND_BARREL, pos, state);
        this.inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    protected class_2561 method_17823() {
        if (this.ownerName != null) {
            return class_2561.method_43469((String)"container.portable-storage.bound_barrel", (Object[])new Object[]{this.ownerName});
        }
        return class_2561.method_43471((String)"container.portable-storage.bound_barrel.unknown");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        class_1263 visibleFiveSlotInventory = new class_1263(){

            public int method_5439() {
                return 5;
            }

            public boolean method_5442() {
                return BoundBarrelBlockEntity.this.method_5442() || this.method_5438(0).method_7960() && this.method_5438(1).method_7960() && this.method_5438(2).method_7960() && this.method_5438(3).method_7960() && this.method_5438(4).method_7960();
            }

            public class_1799 method_5438(int slot) {
                return BoundBarrelBlockEntity.this.method_5438(slot);
            }

            public class_1799 method_5434(int slot, int amount) {
                return BoundBarrelBlockEntity.this.method_5434(slot, amount);
            }

            public class_1799 method_5441(int slot) {
                return BoundBarrelBlockEntity.this.method_5441(slot);
            }

            public void method_5447(int slot, class_1799 stack) {
                BoundBarrelBlockEntity.this.method_5447(slot, stack);
            }

            public void method_5431() {
                BoundBarrelBlockEntity.this.method_5431();
            }

            public boolean method_5443(class_1657 player) {
                return BoundBarrelBlockEntity.this.method_5443(player);
            }

            public void method_5448() {
                for (int i = 0; i < 5; ++i) {
                    BoundBarrelBlockEntity.this.method_5447(i, class_1799.field_8037);
                }
            }
        };
        return new class_1722(syncId, playerInventory, visibleFiveSlotInventory);
    }

    public int method_5439() {
        return 6;
    }

    public int[] method_5494(class_2350 side) {
        if (this.ownerUuid != null) {
            return new int[]{0, 1, 2, 3, 4, 5};
        }
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (this.ownerUuid == null || stack.method_7960()) {
            return false;
        }
        if (slot != 5) {
            return false;
        }
        if (this.isOwnerUsingPrimaryStorage()) {
            return false;
        }
        if (dir != null) {
            THREAD_INSERT_SOURCE.set(this.field_11867.method_10093(dir));
            return true;
        }
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (slot >= 0 && slot <= 4 && this.ownerUuid != null) {
            class_1799 marker = this.method_5438(slot);
            if (marker.method_7960()) {
                return false;
            }
            if (this.isOwnerUsingPrimaryStorage()) {
                return false;
            }
            if (dir != null) {
                if (this.field_11863 != null && this.field_11863.method_8503() != null) {
                    THREAD_AUTOMATION_EXTRACT.set(true);
                    boolean hasItem = NewStoreService.hasItemInStorage(this.field_11863.method_8503(), this.ownerUuid, marker);
                    if (hasItem) {
                        return true;
                    }
                    List<StorageInventory> storages = StorageGroupService.getStoragesByOwner(this.field_11863.method_8503(), this.ownerUuid);
                    for (StorageInventory storage : storages) {
                        for (int i = 0; i < storage.getCapacity(); ++i) {
                            class_1799 disp = storage.getDisplayStack(i);
                            if (disp.method_7960() || !class_1799.method_31577((class_1799)disp, (class_1799)marker)) continue;
                            return true;
                        }
                    }
                }
                THREAD_AUTOMATION_EXTRACT.set(false);
                return false;
            }
            return class_1799.method_31577((class_1799)stack, (class_1799)marker);
        }
        return false;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 marker;
        if (this.ownerUuid != null && slot >= 0 && slot <= 4 && amount > 0 && !(marker = this.method_5438(slot)).method_7960() && this.field_11863 != null && this.field_11863.method_8503() != null) {
            boolean isAutomation = THREAD_AUTOMATION_EXTRACT.get();
            if (isAutomation) {
                class_1799 want = marker.method_7972();
                want.method_7939(Math.min(amount, marker.method_7914()));
                class_1799 taken = NewStoreService.takeFromNewStore(this.field_11863.method_8503(), this.ownerUuid, want, want.method_7947());
                if (!taken.method_7960()) {
                    THREAD_AUTOMATION_EXTRACT.set(false);
                    return taken;
                }
                THREAD_AUTOMATION_EXTRACT.set(false);
                return class_1799.field_8037;
            }
            return super.method_5434(slot, amount);
        }
        return super.method_5434(slot, amount);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (this.ownerUuid != null && slot == 5 && !stack.method_7960() && this.field_11863 != null && this.field_11863.method_8503() != null) {
            long nowTick = this.field_11863.method_8510();
            class_2338 sourcePos = THREAD_INSERT_SOURCE.get();
            if (nowTick == this.lastSlot5ProcessTick && !this.lastSlot5Processed.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)this.lastSlot5Processed) && stack.method_7947() == this.lastSlot5Processed.method_7947() && (sourcePos == null && this.lastSlot5SourcePos == null || sourcePos != null && sourcePos.equals((Object)this.lastSlot5SourcePos))) {
                THREAD_INSERT_SOURCE.remove();
                return;
            }
            if (!this.shouldPickupItemFast(stack)) {
                THREAD_INSERT_SOURCE.remove();
                return;
            }
            class_1799 toInsert = stack.method_7972();
            this.insertIntoOwnerStorage(toInsert);
            super.method_5447(slot, class_1799.field_8037);
            this.method_5431();
            this.lastSlot5ProcessTick = nowTick;
            this.lastSlot5Processed = stack.method_7972();
            this.lastSlot5SourcePos = sourcePos;
            THREAD_INSERT_SOURCE.remove();
            return;
        }
        super.method_5447(slot, stack);
    }

    private String getItemKeyFast(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return null;
        }
        if (class_1799.method_31577((class_1799)itemStack, (class_1799)this.lastItemForKey)) {
            return this.lastItemKey;
        }
        if (this.field_11863 != null && this.field_11863.method_8503() != null) {
            String key;
            this.lastItemKey = key = ItemKeyHasher.hash(itemStack, (class_7225.class_7874)this.field_11863.method_8503().method_30611());
            this.lastItemForKey = itemStack.method_7972();
            return key;
        }
        return null;
    }

    private boolean shouldPickupItemFast(class_1799 itemStack) {
        long currentTick;
        if (itemStack.method_7960()) {
            return false;
        }
        long l = currentTick = this.field_11863 != null ? this.field_11863.method_8510() : 0L;
        if (this.lastFilterRulesCheckTick != currentTick) {
            this.filterRulesEmpty = this.filterRules.isEmpty();
            this.lastFilterRulesCheckTick = currentTick;
        }
        if (this.filterRulesEmpty) {
            return true;
        }
        return BarrelFilterRuleManager.shouldPickupItem(this, itemStack);
    }

    private void insertIntoOwnerStorage(class_1799 stack) {
        if (this.field_11863 == null || this.field_11863.method_8503() == null || this.ownerUuid == null) {
            return;
        }
        try {
            MinecraftServer server = this.field_11863.method_8503();
            String key = this.getItemKeyFast(stack);
            if (key == null || key.isEmpty()) {
                return;
            }
            TemplateIndex index = StorageMemoryCache.getTemplateIndex();
            if (index.find(key) == null) {
                int slice = index.getOrAllocateSlice();
                index.put(key, slice, 0);
                StorageMemoryCache.addTemplate(key, stack.method_7972());
            }
            long now = System.currentTimeMillis();
            PlayerStore.add(server, this.ownerUuid, key, stack.method_7947(), now);
            index.incRef(key, stack.method_7947());
            StorageMemoryCache.markTemplateIndexDirty();
        }
        catch (Throwable e) {
            PortableStorage.LOGGER.error("Failed to insert item into owner's storage", e);
        }
    }

    public void setOwner(UUID uuid, String name) {
        this.ownerUuid = uuid;
        this.ownerName = name;
        this.method_5431();
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    private boolean isOwnerUsingPrimaryStorage() {
        if (this.ownerUuid == null || this.field_11863 == null || this.field_11863.method_8503() == null) {
            return false;
        }
        class_3222 ownerPlayer = this.field_11863.method_8503().method_3760().method_14602(this.ownerUuid);
        if (ownerPlayer != null) {
            PlayerStorageAccess access = (PlayerStorageAccess)ownerPlayer;
            return access.portableStorage$getStorageType() == StorageType.PRIMARY;
        }
        return false;
    }

    public void copyDataToItem(class_1799 stack) {
        if (this.ownerUuid == null) {
            return;
        }
        class_2487 customData = new class_2487();
        customData.method_25927("ps_owner_uuid", this.ownerUuid);
        customData.method_10544("ps_owner_uuid_most", this.ownerUuid.getMostSignificantBits());
        customData.method_10544("ps_owner_uuid_least", this.ownerUuid.getLeastSignificantBits());
        if (this.ownerName != null) {
            customData.method_10582("ps_owner_name", this.ownerName);
        }
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customData));
        stack.method_57379(class_9334.field_49641, (Object)true);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (this.ownerUuid != null) {
            nbt.method_25927("ps_owner_uuid", this.ownerUuid);
        }
        if (this.ownerName != null) {
            nbt.method_10582("ps_owner_name", this.ownerName);
        }
        class_2487 filterRulesNbt = new class_2487();
        for (int i = 0; i < this.filterRules.size(); ++i) {
            filterRulesNbt.method_10566("rule_" + i, (class_2520)this.filterRules.get(i).toNbt());
        }
        filterRulesNbt.method_10569("count", this.filterRules.size());
        nbt.method_10566("filter_rules", (class_2520)filterRulesNbt);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_25928("ps_owner_uuid")) {
            this.ownerUuid = nbt.method_25926("ps_owner_uuid");
        }
        if (nbt.method_10545("ps_owner_name")) {
            this.ownerName = nbt.method_10558("ps_owner_name");
        }
        this.filterRules.clear();
        if (nbt.method_10545("filter_rules")) {
            class_2487 filterRulesNbt = nbt.method_10562("filter_rules");
            int count = filterRulesNbt.method_10550("count");
            for (int i = 0; i < count; ++i) {
                if (!filterRulesNbt.method_10545("rule_" + i)) continue;
                this.filterRules.add(FilterRule.fromNbt(filterRulesNbt.method_10562("rule_" + i)));
            }
        }
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public static class FilterRule {
        public String matchRule;
        public boolean isWhitelist;
        public boolean enabled;

        public FilterRule() {
            this("", true, true);
        }

        public FilterRule(String matchRule, boolean isWhitelist, boolean enabled) {
            this.matchRule = matchRule;
            this.isWhitelist = isWhitelist;
            this.enabled = enabled;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("matchRule", this.matchRule);
            nbt.method_10556("isWhitelist", this.isWhitelist);
            nbt.method_10556("enabled", this.enabled);
            return nbt;
        }

        public static FilterRule fromNbt(class_2487 nbt) {
            return new FilterRule(nbt.method_10558("matchRule"), nbt.method_10577("isWhitelist"), nbt.method_10577("enabled"));
        }
    }
}

