/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.portable.storage.PortableStorage;
import com.portable.storage.client.ClientVirtualCraftingConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("portable-storage-client.json");
    private static ClientConfig INSTANCE = new ClientConfig();
    public boolean collapsed = false;
    public SortMode sortMode = SortMode.COUNT;
    public boolean sortAscending = false;
    public boolean craftRefill = true;
    public boolean autoDeposit = false;
    public boolean smartCollapse = false;
    public SearchPos searchPos = SearchPos.BOTTOM;
    public StoragePos storagePos = StoragePos.BOTTOM;
    public boolean virtualCraftingVisible = false;
    public int maxVisibleRows = 6;
    public Set<String> favorites = new LinkedHashSet<String>();
    public boolean pinyinSearch = true;
    public Map<String, String[]> polyphoneMap = new HashMap<String, String[]>();
    public List<FilterRule> filterRules = new ArrayList<FilterRule>();
    public List<FilterRule> destroyRules = new ArrayList<FilterRule>();

    public static ClientConfig getInstance() {
        return INSTANCE;
    }

    private void initializeDefaultPolyphoneMap() {
        this.polyphoneMap.clear();
        this.polyphoneMap.put("\u9550", new String[]{"gao", "hao"});
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                FilterRule rule;
                JsonObject ruleObj;
                String json = Files.readString(CONFIG_PATH);
                ClientConfig defaults = new ClientConfig();
                boolean changed = false;
                JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
                ClientConfig merged = new ClientConfig();
                merged.collapsed = defaults.collapsed;
                merged.sortMode = defaults.sortMode;
                merged.sortAscending = defaults.sortAscending;
                merged.craftRefill = defaults.craftRefill;
                merged.autoDeposit = defaults.autoDeposit;
                merged.smartCollapse = defaults.smartCollapse;
                merged.searchPos = defaults.searchPos;
                merged.storagePos = defaults.storagePos;
                merged.virtualCraftingVisible = defaults.virtualCraftingVisible;
                merged.maxVisibleRows = defaults.maxVisibleRows;
                merged.favorites = new LinkedHashSet<String>(defaults.favorites);
                merged.pinyinSearch = defaults.pinyinSearch;
                merged.polyphoneMap = new HashMap<String, String[]>(defaults.polyphoneMap);
                merged.filterRules = new ArrayList<FilterRule>(defaults.filterRules);
                merged.destroyRules = new ArrayList<FilterRule>(defaults.destroyRules);
                if (obj.has("collapsed")) {
                    merged.collapsed = obj.get("collapsed").getAsBoolean();
                } else {
                    changed = true;
                }
                if (obj.has("sortMode")) {
                    try {
                        merged.sortMode = SortMode.valueOf(obj.get("sortMode").getAsString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    changed = true;
                }
                if (obj.has("sortAscending")) {
                    merged.sortAscending = obj.get("sortAscending").getAsBoolean();
                } else {
                    changed = true;
                }
                if (obj.has("craftRefill")) {
                    merged.craftRefill = obj.get("craftRefill").getAsBoolean();
                } else {
                    changed = true;
                }
                if (obj.has("autoDeposit")) {
                    merged.autoDeposit = obj.get("autoDeposit").getAsBoolean();
                } else {
                    changed = true;
                }
                if (obj.has("smartCollapse")) {
                    merged.smartCollapse = obj.get("smartCollapse").getAsBoolean();
                } else {
                    changed = true;
                }
                if (obj.has("searchPos")) {
                    try {
                        merged.searchPos = SearchPos.valueOf(obj.get("searchPos").getAsString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    changed = true;
                }
                if (obj.has("storagePos")) {
                    try {
                        merged.storagePos = StoragePos.valueOf(obj.get("storagePos").getAsString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    changed = true;
                }
                if (obj.has("virtualCraftingVisible")) {
                    merged.virtualCraftingVisible = obj.get("virtualCraftingVisible").getAsBoolean();
                } else {
                    changed = true;
                }
                if (obj.has("maxVisibleRows")) {
                    merged.maxVisibleRows = obj.get("maxVisibleRows").getAsInt();
                } else {
                    changed = true;
                }
                if (obj.has("favorites")) {
                    try {
                        JsonArray arr = obj.getAsJsonArray("favorites");
                        LinkedHashSet<String> fav = new LinkedHashSet<String>();
                        for (int i = 0; i < arr.size(); ++i) {
                            String s = arr.get(i).getAsString();
                            if (s == null || s.isEmpty()) continue;
                            fav.add(s);
                        }
                        merged.favorites = fav;
                    }
                    catch (Exception arr) {}
                } else {
                    changed = true;
                }
                if (obj.has("pinyinSearch")) {
                    merged.pinyinSearch = obj.get("pinyinSearch").getAsBoolean();
                } else {
                    changed = true;
                }
                if (obj.has("polyphoneMap")) {
                    try {
                        JsonObject polyphoneObj = obj.getAsJsonObject("polyphoneMap");
                        HashMap<String, String[]> polyphoneMap = new HashMap<String, String[]>();
                        for (String key : polyphoneObj.keySet()) {
                            JsonArray pinyinArray = polyphoneObj.getAsJsonArray(key);
                            String[] pinyins = new String[pinyinArray.size()];
                            for (int i = 0; i < pinyinArray.size(); ++i) {
                                pinyins[i] = pinyinArray.get(i).getAsString();
                            }
                            polyphoneMap.put(key, pinyins);
                        }
                        merged.polyphoneMap = polyphoneMap;
                    }
                    catch (Exception ignored) {
                        merged.initializeDefaultPolyphoneMap();
                        changed = true;
                    }
                } else {
                    merged.initializeDefaultPolyphoneMap();
                    changed = true;
                }
                if (obj.has("filterRules")) {
                    try {
                        JsonArray filterArray = obj.getAsJsonArray("filterRules");
                        ArrayList<FilterRule> filterRules = new ArrayList<FilterRule>();
                        for (int i = 0; i < filterArray.size(); ++i) {
                            ruleObj = filterArray.get(i).getAsJsonObject();
                            rule = new FilterRule();
                            rule.matchRule = ruleObj.has("matchRule") ? ruleObj.get("matchRule").getAsString() : "";
                            rule.isWhitelist = ruleObj.has("isWhitelist") ? ruleObj.get("isWhitelist").getAsBoolean() : true;
                            rule.enabled = ruleObj.has("enabled") ? ruleObj.get("enabled").getAsBoolean() : true;
                            filterRules.add(rule);
                        }
                        merged.filterRules = filterRules;
                    }
                    catch (Exception ignored) {
                        changed = true;
                    }
                } else {
                    changed = true;
                }
                if (obj.has("destroyRules")) {
                    try {
                        JsonArray destroyArray = obj.getAsJsonArray("destroyRules");
                        ArrayList<FilterRule> destroyRules = new ArrayList<FilterRule>();
                        for (int i = 0; i < destroyArray.size(); ++i) {
                            ruleObj = destroyArray.get(i).getAsJsonObject();
                            rule = new FilterRule();
                            rule.matchRule = ruleObj.has("matchRule") ? ruleObj.get("matchRule").getAsString() : "";
                            rule.isWhitelist = ruleObj.has("isWhitelist") ? ruleObj.get("isWhitelist").getAsBoolean() : true;
                            rule.enabled = ruleObj.has("enabled") ? ruleObj.get("enabled").getAsBoolean() : true;
                            destroyRules.add(rule);
                        }
                        merged.destroyRules = destroyRules;
                    }
                    catch (Exception ignored) {
                        changed = true;
                    }
                } else {
                    changed = true;
                }
                INSTANCE = merged;
                if (changed) {
                    ClientConfig.save();
                }
                PortableStorage.LOGGER.info("Loaded client config from {} (merged defaults if missing)", (Object)CONFIG_PATH);
            }
            catch (IOException e) {
                PortableStorage.LOGGER.error("Failed to load client config", (Throwable)e);
                INSTANCE = new ClientConfig();
            }
        } else {
            INSTANCE = new ClientConfig();
            INSTANCE.initializeDefaultPolyphoneMap();
            ClientConfig.save();
        }
    }

    public static void save() {
        try {
            if (!ClientVirtualCraftingConfig.isEnableVirtualCrafting()) {
                ClientConfig.INSTANCE.virtualCraftingVisible = false;
            }
            String json = GSON.toJson((Object)INSTANCE);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            PortableStorage.LOGGER.debug("Saved client config to {}", (Object)CONFIG_PATH);
        }
        catch (IOException e) {
            PortableStorage.LOGGER.error("Failed to save client config", (Throwable)e);
        }
    }

    public static void reload() {
        PortableStorage.LOGGER.info("Reloading client config...");
        ClientConfig.load();
        PortableStorage.LOGGER.info("Client config reloaded successfully");
    }

    public void addPolyphone(String character, String ... pinyins) {
        if (character != null && pinyins != null && pinyins.length > 0) {
            this.polyphoneMap.put(character, pinyins);
            ClientConfig.save();
            PortableStorage.LOGGER.info("Added polyphone: {} -> {}", (Object)character, (Object)Arrays.toString(pinyins));
        }
    }

    public void removePolyphone(String character) {
        if (character != null && this.polyphoneMap.containsKey(character)) {
            this.polyphoneMap.remove(character);
            ClientConfig.save();
            PortableStorage.LOGGER.info("Removed polyphone: {}", (Object)character);
        }
    }

    public Set<String> getAllPolyphones() {
        return new HashSet<String>(this.polyphoneMap.keySet());
    }

    @Environment(value=EnvType.CLIENT)
    public static enum SortMode {
        COUNT("count"),
        NAME("name"),
        MOD_ID("mod_id"),
        UPDATE_TIME("update_time");

        private final String key;

        private SortMode(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public SortMode next() {
            SortMode[] values = SortMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum SearchPos {
        BOTTOM,
        TOP,
        TOP2,
        MIDDLE;


        public SearchPos next() {
            SearchPos[] v = SearchPos.values();
            return v[(this.ordinal() + 1) % v.length];
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum StoragePos {
        BOTTOM,
        TOP;


        public StoragePos next() {
            StoragePos[] v = StoragePos.values();
            return v[(this.ordinal() + 1) % v.length];
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FilterRule {
        public String matchRule;
        public boolean isWhitelist;
        public boolean enabled;

        public FilterRule() {
            this("", true, true);
        }

        public FilterRule(String matchRule, boolean isWhitelist, boolean enabled) {
            this.matchRule = matchRule;
            this.isWhitelist = isWhitelist;
            this.enabled = enabled;
        }
    }
}

