/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ClientInfiniteFluidConfig {
    private static boolean enableInfiniteLava = false;
    private static boolean enableInfiniteWater = false;
    private static int infiniteLavaThreshold = 10000;
    private static int infiniteWaterThreshold = 2;

    public static void updateConfig(boolean enableLava, boolean enableWater, int lavaThreshold, int waterThreshold) {
        enableInfiniteLava = enableLava;
        enableInfiniteWater = enableWater;
        infiniteLavaThreshold = lavaThreshold;
        infiniteWaterThreshold = waterThreshold;
    }

    public static boolean isInfiniteLavaEnabled() {
        return enableInfiniteLava;
    }

    public static boolean isInfiniteWaterEnabled() {
        return enableInfiniteWater;
    }

    public static int getInfiniteLavaThreshold() {
        return infiniteLavaThreshold;
    }

    public static int getInfiniteWaterThreshold() {
        return infiniteWaterThreshold;
    }

    public static boolean shouldShowInfinite(String fluidType, int units) {
        if (fluidType == null) {
            return false;
        }
        switch (fluidType) {
            case "lava": {
                return enableInfiniteLava && units >= infiniteLavaThreshold;
            }
            case "water": {
                return enableInfiniteWater && units >= infiniteWaterThreshold;
            }
        }
        return false;
    }
}

