/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client;

import com.portable.storage.client.ClientConfig;
import com.portable.storage.client.ClientContainerDisplayConfig;
import com.portable.storage.client.ClientInfiniteFluidConfig;
import com.portable.storage.client.ClientRiftConfig;
import com.portable.storage.client.ClientStorageState;
import com.portable.storage.client.ClientUpgradeState;
import com.portable.storage.client.ClientVirtualCraftingConfig;
import com.portable.storage.client.screen.FilterListScreen;
import com.portable.storage.client.ui.VirtualCraftingOverlayState;
import com.portable.storage.net.payload.ConfigSyncS2CPayload;
import com.portable.storage.net.payload.CraftingOverlayActionC2SPayload;
import com.portable.storage.net.payload.IncrementalStorageSyncS2CPayload;
import com.portable.storage.net.payload.OpenBarrelFilterS2CPayload;
import com.portable.storage.net.payload.OverlayCraftingSyncS2CPayload;
import com.portable.storage.net.payload.RequestFilterRulesSyncS2CPayload;
import com.portable.storage.net.payload.StorageSyncS2CPayload;
import com.portable.storage.net.payload.SyncControlC2SPayload;
import com.portable.storage.net.payload.SyncFilterRulesC2SPayload;
import com.portable.storage.net.payload.XpBottleMaintenanceToggleC2SPayload;
import com.portable.storage.storage.AutoEatMode;
import com.portable.storage.storage.StorageType;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public final class ClientNetworkingHandlers {
    private ClientNetworkingHandlers() {
    }

    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver(IncrementalStorageSyncS2CPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (context.client().field_1724 == null) {
                return;
            }
            ClientStorageState.applyDiff(payload.sessionId(), payload.seq(), payload.diff());
            try {
                ClientPlayNetworking.send((class_8710)new SyncControlC2SPayload(SyncControlC2SPayload.Op.ACK, payload.seq(), true));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(StorageSyncS2CPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (context.client().field_1724 == null) {
                return;
            }
            ClientStorageState.updateFromNbt(payload.nbt(), (class_7225.class_7874)context.client().field_1724.method_56673());
        }));
        ClientPlayNetworking.registerGlobalReceiver(ConfigSyncS2CPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (context.client().field_1724 == null) {
                return;
            }
            switch (payload.topic()) {
                case UPGRADE: {
                    class_2487 nbt = payload.data();
                    if (nbt == null) break;
                    ClientUpgradeState.updateFromNbt(nbt);
                    break;
                }
                case STORAGE_ENABLEMENT: {
                    class_2487 nbt = payload.data();
                    if (nbt == null) break;
                    if (nbt.method_10545("enabled")) {
                        ClientStorageState.setStorageEnabled(nbt.method_10577("enabled"));
                    }
                    if (!nbt.method_10545("storageType")) break;
                    String typeKey = nbt.method_10558("storageType");
                    StorageType type = StorageType.fromKey(typeKey);
                    ClientStorageState.setStorageType(type);
                    break;
                }
                case XP_STEP: {
                    class_2487 nbt = payload.data();
                    if (nbt == null || !nbt.method_10545("stepIndex")) break;
                    ClientUpgradeState.setXpTransferStep(nbt.method_10550("stepIndex"));
                    break;
                }
                case AUTO_EAT_MODE: {
                    class_2487 nbt = payload.data();
                    if (nbt == null || !nbt.method_10545("modeIndex")) break;
                    int modeIndex = nbt.method_10550("modeIndex");
                    AutoEatMode mode = AutoEatMode.fromIndex(modeIndex);
                    ClientUpgradeState.setAutoEatMode(mode);
                    break;
                }
                case DISPLAY_CONFIG: {
                    class_2487 nbt = payload.data();
                    if (nbt == null) break;
                    ClientContainerDisplayConfig.getInstance().updateConfig(nbt.method_10577("stonecutter"), nbt.method_10577("cartographyTable"), nbt.method_10577("smithingTable"), nbt.method_10577("grindstone"), nbt.method_10577("loom"), nbt.method_10577("furnace"), nbt.method_10577("smoker"), nbt.method_10577("blastFurnace"), nbt.method_10577("anvil"), nbt.method_10577("enchantingTable"), nbt.method_10577("brewingStand"), nbt.method_10577("beacon"), nbt.method_10577("chest"), nbt.method_10577("barrel"), nbt.method_10577("enderChest"), nbt.method_10577("shulkerBox"), nbt.method_10577("dispenser"), nbt.method_10577("dropper"), nbt.method_10577("crafter"), nbt.method_10577("hopper"), nbt.method_10577("trappedChest"), nbt.method_10577("hopperMinecart"), nbt.method_10577("chestMinecart"), nbt.method_10577("chestBoat"), nbt.method_10577("bambooChestRaft"));
                    break;
                }
                case RIFT_CONFIG: {
                    class_2487 nbt = payload.data();
                    if (nbt == null) break;
                    String upgradeItem = nbt.method_10558("riftUpgradeItem");
                    int size = nbt.method_10550("riftSize");
                    ClientRiftConfig.updateConfig(upgradeItem, size);
                    break;
                }
                case VIRTUAL_CRAFTING_CONFIG: {
                    class_2487 nbt = payload.data();
                    if (nbt == null) break;
                    boolean enabled = nbt.method_10577("enableVirtualCrafting");
                    ClientVirtualCraftingConfig.updateConfig(enabled);
                    if (enabled) break;
                    ClientConfig config = ClientConfig.getInstance();
                    if (!config.virtualCraftingVisible) break;
                    config.virtualCraftingVisible = false;
                    ClientConfig.save();
                    ClientNetworkingHandlers.sendRefundCraftingSlots();
                    break;
                }
                case INFINITE_FLUID_CONFIG: {
                    class_2487 nbt = payload.data();
                    if (nbt == null) break;
                    boolean enableLava = nbt.method_10577("enableInfiniteLava");
                    boolean enableWater = nbt.method_10577("enableInfiniteWater");
                    int lavaThreshold = nbt.method_10550("infiniteLavaThreshold");
                    int waterThreshold = nbt.method_10550("infiniteWaterThreshold");
                    ClientInfiniteFluidConfig.updateConfig(enableLava, enableWater, lavaThreshold, waterThreshold);
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(OverlayCraftingSyncS2CPayload.ID, (payload, context) -> context.client().execute(() -> {
            try {
                VirtualCraftingOverlayState.update(payload.slots());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(OpenBarrelFilterS2CPayload.ID, (payload, context) -> context.client().execute(() -> context.client().method_1507((class_437)new FilterListScreen(context.client().field_1755, FilterListScreen.Mode.FILTER, payload.barrelPos()))));
        ClientPlayNetworking.registerGlobalReceiver(RequestFilterRulesSyncS2CPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (context.client().field_1724 == null) {
                return;
            }
            ClientNetworkingHandlers.syncFilterRulesToServer();
        }));
    }

    public static void sendXpBottleMaintenanceToggle() {
        ClientPlayNetworking.send((class_8710)new XpBottleMaintenanceToggleC2SPayload());
    }

    public static void sendRefundCraftingSlots() {
        ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.REFUND, 0, 0, false, class_1799.field_8037, "", null, null));
    }

    private static void syncFilterRulesToServer() {
        ArrayList<SyncFilterRulesC2SPayload.FilterRule> serverFilterRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>();
        ArrayList<SyncFilterRulesC2SPayload.FilterRule> serverDestroyRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>();
        for (ClientConfig.FilterRule rule : ClientConfig.getInstance().filterRules) {
            serverFilterRules.add(new SyncFilterRulesC2SPayload.FilterRule(rule.matchRule, rule.isWhitelist, rule.enabled));
        }
        for (ClientConfig.FilterRule rule : ClientConfig.getInstance().destroyRules) {
            serverDestroyRules.add(new SyncFilterRulesC2SPayload.FilterRule(rule.matchRule, rule.isWhitelist, rule.enabled));
        }
        ClientPlayNetworking.send((class_8710)new SyncFilterRulesC2SPayload(serverFilterRules, serverDestroyRules));
    }
}

