/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.portable.storage.net.payload.SyncControlC2SPayload;
import com.portable.storage.newstore.ItemKeyHasher;
import com.portable.storage.storage.StorageType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public final class ClientStorageState {
    private static class_2371<class_1799> display = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
    private static long[] counts = new long[54];
    private static long[] timestamps = new long[54];
    private static int capacity = 54;
    private static boolean storageEnabled = false;
    private static StorageType storageType = StorageType.FULL;
    private static long clientSessionId = 0L;
    private static int expectedSeq = 1;

    private ClientStorageState() {
    }

    public static class_2371<class_1799> getStacks() {
        return display;
    }

    public static int getCapacity() {
        return capacity;
    }

    public static long getCount(int index) {
        return index >= 0 && index < counts.length ? counts[index] : 0L;
    }

    public static long getTimestamp(int index) {
        return index >= 0 && index < timestamps.length ? timestamps[index] : 0L;
    }

    public static boolean isStorageEnabled() {
        return storageEnabled;
    }

    public static void setStorageEnabled(boolean enabled) {
        storageEnabled = enabled;
    }

    public static StorageType getStorageType() {
        return storageType;
    }

    public static void setStorageType(StorageType type) {
        storageType = type;
    }

    public static void updateFromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        int cap;
        if (nbt.method_10545("sessionId")) {
            clientSessionId = nbt.method_10537("sessionId");
            expectedSeq = 1;
        }
        if ((cap = nbt.method_10550("capacity")) <= 0) {
            cap = 54;
        }
        capacity = cap;
        display = class_2371.method_10213((int)capacity, (Object)class_1799.field_8037);
        counts = new long[capacity];
        timestamps = new long[capacity];
        if (!nbt.method_10573("entries", 9)) {
            return;
        }
        class_2499 list = nbt.method_10554("entries", 10);
        int idx = 0;
        for (int i = 0; i < list.size() && idx < capacity; ++i) {
            long timestamp;
            class_1792 it;
            class_2960 id;
            class_2487 itemTag;
            class_2487 e = list.method_10602(i);
            class_1799 stack = class_1799.field_8037;
            if (e.method_10545("item_full")) {
                class_2509 ops = lookup != null ? class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup) : class_2509.field_11560;
                DataResult parse = class_1799.field_24671.parse((DynamicOps)ops, (Object)e.method_10580("item_full"));
                stack = parse.result().orElse(class_1799.field_8037);
            }
            if (stack.method_7960() && e.method_10573("item", 10) && (itemTag = e.method_10562("item")).method_10545("id") && (id = class_2960.method_12829((String)itemTag.method_10558("id"))) != null && (it = (class_1792)class_7923.field_41178.method_10223(id)) != null && it != class_1802.field_8162) {
                stack = new class_1799((class_1935)it);
                if (itemTag.method_10573("custom", 10)) {
                    stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)itemTag.method_10562("custom")));
                }
                if (itemTag.method_10573("block_entity", 10)) {
                    stack.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)itemTag.method_10562("block_entity")));
                }
                if (itemTag.method_10573("glint", 1) && itemTag.method_10577("glint")) {
                    stack.method_57379(class_9334.field_49641, (Object)true);
                }
            }
            long count = Math.max(0L, e.method_10537("count"));
            long l = timestamp = e.method_10545("ts") ? e.method_10537("ts") : 0L;
            if (stack.method_7960() || count <= 0L) continue;
            ClientStorageState.counts[idx] = count;
            ClientStorageState.timestamps[idx] = timestamp;
            stack.method_7939((int)Math.min((long)stack.method_7914(), count));
            display.set(idx, (Object)stack);
            ++idx;
        }
    }

    public static void applyDiff(long sessionId, int seq, class_2487 diff) {
        int i;
        if (sessionId != clientSessionId || seq != expectedSeq) {
            try {
                ClientPlayNetworking.send((class_8710)new SyncControlC2SPayload(SyncControlC2SPayload.Op.REQUEST, 0L, false));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (diff == null) {
            ++expectedSeq;
            return;
        }
        if (diff.method_10573("removes", 9)) {
            class_2499 rm = diff.method_10554("removes", 8);
            for (i = 0; i < rm.size(); ++i) {
                String key = rm.method_10608(i);
                ClientStorageState.removeByKey(key);
            }
        }
        if (diff.method_10573("upserts", 9)) {
            class_2499 up = diff.method_10554("upserts", 10);
            for (i = 0; i < up.size(); ++i) {
                class_2487 e = up.method_10602(i);
                ClientStorageState.upsertEntry(e, ClientStorageState.lookupForClient());
            }
        }
        ++expectedSeq;
    }

    private static void removeByKey(String key) {
        for (int i = 0; i < capacity; ++i) {
            class_1799 s = (class_1799)display.get(i);
            if (s.method_7960() || !key.equals(ClientStorageState.makeKeyForStack(s))) continue;
            display.set(i, (Object)class_1799.field_8037);
            ClientStorageState.counts[i] = 0L;
            ClientStorageState.timestamps[i] = 0L;
        }
    }

    private static void upsertEntry(class_2487 e, class_7225.class_7874 lookup) {
        if (e == null) {
            return;
        }
        String key = e.method_10558("key");
        long count = Math.max(0L, e.method_10537("count"));
        long ts = e.method_10545("ts") ? e.method_10537("ts") : 0L;
        class_1799 stack = class_1799.field_8037;
        if (e.method_10545("display")) {
            class_2509 ops = lookup != null ? class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup) : class_2509.field_11560;
            DataResult parse = class_1799.field_24671.parse((DynamicOps)ops, (Object)e.method_10580("display"));
            stack = parse.result().orElse(class_1799.field_8037);
        }
        if (stack.method_7960() || count <= 0L) {
            ClientStorageState.removeByKey(key);
            return;
        }
        int idx = ClientStorageState.findIndexByKey(key);
        if (idx < 0) {
            idx = ClientStorageState.findFirstEmpty();
        }
        if (idx < 0) {
            return;
        }
        ClientStorageState.counts[idx] = count;
        ClientStorageState.timestamps[idx] = ts;
        stack.method_7939((int)Math.min((long)stack.method_7914(), count));
        display.set(idx, (Object)stack);
    }

    private static int findIndexByKey(String key) {
        for (int i = 0; i < capacity; ++i) {
            class_1799 s = (class_1799)display.get(i);
            if (s.method_7960() || !key.equals(ClientStorageState.makeKeyForStack(s))) continue;
            return i;
        }
        return -1;
    }

    private static int findFirstEmpty() {
        for (int i = 0; i < capacity; ++i) {
            if (!((class_1799)display.get(i)).method_7960()) continue;
            return i;
        }
        return -1;
    }

    private static String makeKeyForStack(class_1799 s) {
        return ItemKeyHasher.hash(s, ClientStorageState.lookupForClient());
    }

    private static class_7225.class_7874 lookupForClient() {
        class_310 mc = class_310.method_1551();
        return mc != null && mc.field_1724 != null ? mc.field_1724.method_56673() : null;
    }
}

