/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client;

import com.portable.storage.client.ClientStorageState;
import com.portable.storage.storage.AutoEatMode;
import com.portable.storage.storage.StorageType;
import com.portable.storage.storage.UpgradeInventory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;

@Environment(value=EnvType.CLIENT)
public final class ClientUpgradeState {
    private static final UpgradeInventory upgradeInventory = new UpgradeInventory();
    private static final int TOTAL_SLOT_COUNT = 10;
    private static final boolean[] disabledSlots = new boolean[10];
    private static class_1799 fluidStack = class_1799.field_8037;
    private static class_1799 trashStack = class_1799.field_8037;
    private static int cachedLavaUnits = 0;
    private static int cachedWaterUnits = 0;
    private static int cachedMilkUnits = 0;
    private static long cachedXpPool = 0L;
    private static boolean cachedLevelMaintenanceEnabled = false;
    private static int xpTransferStep = 0;
    private static AutoEatMode currentAutoEatMode = AutoEatMode.DISABLED;

    private ClientUpgradeState() {
    }

    public static void updateFromNbt(class_2487 nbt) {
        int i;
        upgradeInventory.readNbt(nbt);
        if (nbt.method_10545("XpPool")) {
            cachedXpPool = Math.max(0L, nbt.method_10537("XpPool"));
        }
        if (nbt.method_10545("LevelMaintenanceEnabled")) {
            cachedLevelMaintenanceEnabled = nbt.method_10577("LevelMaintenanceEnabled");
        }
        if (nbt.method_10545("BaseDisabledSlots")) {
            class_2487 baseDisabledNbt = nbt.method_10562("BaseDisabledSlots");
            for (i = 0; i < 5; ++i) {
                ClientUpgradeState.disabledSlots[i] = baseDisabledNbt.method_10577("slot" + i);
            }
        }
        if (nbt.method_10545("ExtendedDisabledSlots")) {
            class_2487 extendedDisabledNbt = nbt.method_10562("ExtendedDisabledSlots");
            for (i = 0; i < 5; ++i) {
                ClientUpgradeState.disabledSlots[i + 5] = extendedDisabledNbt.method_10577("slot" + i);
            }
        }
        fluidStack = upgradeInventory.getFluidStack();
        trashStack = upgradeInventory.getTrashSlot();
        cachedLavaUnits = upgradeInventory.getFluidUnits("lava");
        cachedWaterUnits = upgradeInventory.getFluidUnits("water");
        cachedMilkUnits = upgradeInventory.getFluidUnits("milk");
    }

    public static class_1799 getStack(int slot) {
        return upgradeInventory.getStack(slot);
    }

    public static class_1799 getFluidStack() {
        return fluidStack;
    }

    public static class_1799 getTrashStack() {
        return trashStack;
    }

    public static int getFluidUnits(String fluidType) {
        return switch (fluidType) {
            case "lava" -> cachedLavaUnits;
            case "water" -> cachedWaterUnits;
            case "milk" -> cachedMilkUnits;
            default -> 0;
        };
    }

    public static int getSlotCount() {
        return upgradeInventory.getSlotCount();
    }

    public static boolean isSlotDisabled(int slot) {
        StorageType currentType;
        if (slot < 0 || slot >= 10) {
            return false;
        }
        if (UpgradeInventory.isPrimaryStorageRestrictedSlot(slot) && (currentType = ClientStorageState.getStorageType()) == StorageType.PRIMARY) {
            return true;
        }
        return disabledSlots[slot];
    }

    public static void toggleSlotDisabled(int slot) {
        if (slot < 0 || slot >= 10) {
            return;
        }
        ClientUpgradeState.disabledSlots[slot] = !disabledSlots[slot];
    }

    public static void setSlotDisabled(int slot, boolean disabled) {
        if (slot < 0 || slot >= 10) {
            return;
        }
        ClientUpgradeState.disabledSlots[slot] = disabled;
    }

    public static boolean isExtendedSlot(int slot) {
        return UpgradeInventory.isExtendedSlot(slot);
    }

    public static boolean isChestUpgradeActive() {
        return upgradeInventory.isChestUpgradeActive();
    }

    public static boolean isExtendedSlotEnabled(int slot) {
        return upgradeInventory.isExtendedSlotEnabled(slot);
    }

    public static boolean isSpectralArrowUpgradeActive() {
        return upgradeInventory.isSpectralArrowUpgradeActive();
    }

    public static boolean isBedUpgradeActive() {
        return upgradeInventory.isBedUpgradeActive();
    }

    public static boolean isXpBottleUpgradeActive() {
        class_1799 stack = upgradeInventory.getStack(7);
        return stack != null && !stack.method_7960() && !ClientUpgradeState.isSlotDisabled(7);
    }

    public static boolean isEnchantedGoldenAppleUpgradeActive() {
        class_1799 stack = upgradeInventory.getStack(9);
        return stack != null && !stack.method_7960() && !ClientUpgradeState.isSlotDisabled(9);
    }

    public static boolean isTrashSlotActive() {
        return !trashStack.method_7960() && !upgradeInventory.isTrashSlotDisabled();
    }

    public static boolean isCraftingTableUpgradeActive() {
        class_1799 stack = upgradeInventory.getStack(0);
        return stack != null && !stack.method_7960() && stack.method_7909() == class_1802.field_8465 && !ClientUpgradeState.isSlotDisabled(0);
    }

    public static long getCachedXpPool() {
        return Math.max(0L, cachedXpPool);
    }

    public static boolean isLevelMaintenanceEnabled() {
        return cachedLevelMaintenanceEnabled;
    }

    public static int getXpTransferStep() {
        return xpTransferStep;
    }

    public static void cycleXpTransferStep() {
        xpTransferStep = (xpTransferStep + 1) % 4;
    }

    public static void setXpTransferStep(int step) {
        xpTransferStep = Math.max(0, Math.min(3, step));
    }

    public static AutoEatMode getCurrentAutoEatMode() {
        return currentAutoEatMode;
    }

    public static void cycleAutoEatMode() {
        currentAutoEatMode = currentAutoEatMode.next();
    }

    public static void setAutoEatMode(AutoEatMode mode) {
        currentAutoEatMode = mode != null ? mode : AutoEatMode.DISABLED;
    }
}

