/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client.emi;

import com.portable.storage.client.ClientStorageState;
import com.portable.storage.client.screen.PortableCraftingScreen;
import com.portable.storage.screen.PortableCraftingScreenHandler;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class PortableStorageEmiTransferHandler
implements StandardRecipeHandler<PortableCraftingScreenHandler> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"portable-storage/emi");

    public List<class_1735> getInputSources(PortableCraftingScreenHandler handler) {
        return List.of();
    }

    public List<class_1735> getCraftingSlots(PortableCraftingScreenHandler handler) {
        return Collections.emptyList();
    }

    public EmiPlayerInventory getInventory(class_465<PortableCraftingScreenHandler> screen) {
        ArrayList<EmiStack> stacks = new ArrayList<EmiStack>();
        PortableCraftingScreenHandler handler = (PortableCraftingScreenHandler)screen.method_17577();
        for (int i = 10; i < handler.field_7761.size(); ++i) {
            class_1799 stack = handler.method_7611(i).method_7677();
            if (stack.method_7960()) continue;
            stacks.add(EmiStack.of((class_1799)stack));
        }
        class_2371<class_1799> storageStacks = ClientStorageState.getStacks();
        for (int i = 0; i < storageStacks.size(); ++i) {
            long count;
            class_1799 item = (class_1799)storageStacks.get(i);
            if (item.method_7960() || (count = ClientStorageState.getCount(i)) <= 0L) continue;
            class_1799 stackCopy = item.method_7972();
            stackCopy.method_7939((int)Math.min(Integer.MAX_VALUE, count));
            stacks.add(EmiStack.of((class_1799)stackCopy));
        }
        return new EmiPlayerInventory(stacks);
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<PortableCraftingScreenHandler> context) {
        boolean ok = context.getInventory().canCraft(recipe);
        LOG.debug("EMI canCraft recipeId={} result={}", (Object)recipe.getId(), (Object)ok);
        return ok;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<PortableCraftingScreenHandler> context) {
        class_465 screen = context.getScreen();
        if (screen instanceof PortableCraftingScreen) {
            PortableCraftingScreen portableScreen = (PortableCraftingScreen)screen;
            portableScreen.fillRecipeFromStorage(recipe);
            LOG.debug("EMI craft sent payload for recipeId={}", (Object)recipe.getId());
            class_310.method_1551().method_1507((class_437)screen);
            return true;
        }
        return false;
    }
}

