/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client.emi;

import com.portable.storage.client.ClientConfig;
import dev.emi.emi.api.widget.Bounds;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class PortableStorageExclusionHelper {
    private PortableStorageExclusionHelper() {
    }

    public static void addAreasForScreen(Consumer<Bounds> consumer, int x, int y, int backgroundWidth, int backgroundHeight, boolean storageOnTop, boolean includeCollapseButton, boolean includeSearchPosSetting, boolean includeSwitchButton) {
        int cols = 9;
        int slotSize = 18;
        boolean slotSpacing = false;
        int gridLeft = x + 8;
        int visibleRows = ClientConfig.getInstance().maxVisibleRows;
        if (visibleRows < 2) {
            visibleRows = 2;
        }
        int storageWidth = 162;
        int storageHeight = visibleRows * 18;
        int storageTop = storageOnTop ? y - storageHeight - 6 : y + backgroundHeight + 6;
        consumer.accept(new Bounds(gridLeft, storageTop, storageWidth, storageHeight));
        int upgradeLeft = x - 24;
        int upgradeWidth = 18;
        consumer.accept(new Bounds(upgradeLeft, storageTop, upgradeWidth, storageHeight));
        int extendedLeft = upgradeLeft - 20;
        consumer.accept(new Bounds(extendedLeft, storageTop, upgradeWidth, storageHeight));
        int panelLeft = x + backgroundWidth + 8;
        int panelTop = storageTop - 6;
        int panelBottom = storageTop + storageHeight + 8;
        int settingCount = 0;
        if (includeCollapseButton) {
            ++settingCount;
        }
        settingCount += 4;
        ++settingCount;
        if (includeSearchPosSetting) {
            ++settingCount;
        }
        ++settingCount;
        if (includeSwitchButton) {
            ++settingCount;
        }
        int iconSize = 16;
        int iconSpacing = 15;
        int columnWidth = iconSize + 2;
        int currentColumn = 0;
        int currentRow = 0;
        for (int i = 0; i < settingCount; ++i) {
            int nextIconY = panelTop + currentRow * iconSpacing;
            int nextIconBottom = nextIconY + iconSize;
            if (nextIconBottom > panelBottom) {
                currentRow = 0;
                ++currentColumn;
                continue;
            }
            ++currentRow;
        }
        int columns = currentColumn + 1;
        int padding = 4;
        int settingsWidth = columns * columnWidth + padding + 8;
        consumer.accept(new Bounds(panelLeft, panelTop, settingsWidth, panelBottom - panelTop));
    }
}

