/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client.screen;

import com.portable.storage.blockentity.BoundBarrelBlockEntity;
import com.portable.storage.client.ClientConfig;
import com.portable.storage.net.payload.SyncBarrelFilterRulesC2SPayload;
import com.portable.storage.net.payload.SyncFilterRulesC2SPayload;
import com.portable.storage.sync.PlayerViewState;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class FilterListScreen
extends class_437 {
    private class_342 filterInput;
    private class_4286 whitelistMode;
    private class_4286 blacklistMode;
    private class_4185 addButton;
    private class_4185 clearButton;
    private class_4185 backButton;
    private boolean isWhitelistMode = true;
    private String currentFilter = "";
    private List<ClientConfig.FilterRule> rules;
    private float scroll = 0.0f;
    private int maxScrollRows = 0;
    private static final int BG_WIDTH = 500;
    private static final int BG_HEIGHT = 300;
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 250;
    private static final int INPUT_WIDTH = 200;
    private static final int INPUT_HEIGHT = 20;
    private static final int ADD_BUTTON_WIDTH = 60;
    private static final int CLEAR_BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BACK_BUTTON_WIDTH = 60;
    private static final int RULE_LIST_ITEM_HEIGHT = 20;
    private static final int RULE_LIST_VISIBLE_ITEMS = 8;
    private static final int RULE_LIST_HEIGHT = 160;
    private static final int SCROLLBAR_WIDTH = 8;
    private class_437 parent = null;
    private class_2338 barrelPos = null;
    private Mode mode;
    private float scale = 1.0f;
    private int actualWidth = 500;
    private int actualHeight = 300;

    public FilterListScreen(Mode mode) {
        super((class_2561)class_2561.method_43469((String)"portable-storage.filter.list.title", (Object[])new Object[]{mode.getDisplayName()}));
        this.rules = mode == Mode.FILTER ? ClientConfig.getInstance().filterRules : ClientConfig.getInstance().destroyRules;
    }

    public FilterListScreen(class_437 parent, Mode mode) {
        super((class_2561)class_2561.method_43469((String)"portable-storage.filter.list.title", (Object[])new Object[]{mode.getDisplayName()}));
        this.parent = parent;
        this.rules = mode == Mode.FILTER ? ClientConfig.getInstance().filterRules : ClientConfig.getInstance().destroyRules;
    }

    public FilterListScreen(class_437 parent, Mode mode, class_2338 barrelPos) {
        super((class_2561)class_2561.method_43469((String)"portable-storage.filter.list.title", (Object[])new Object[]{mode.getDisplayName()}));
        this.parent = parent;
        this.mode = mode;
        this.barrelPos = barrelPos;
        this.rules = new ArrayList<ClientConfig.FilterRule>();
    }

    private void calculateAdaptiveScale() {
        float scaleX = (float)(this.field_22789 - 40) / 500.0f;
        float scaleY = (float)(this.field_22790 - 40) / 300.0f;
        this.scale = Math.min(1.0f, Math.min(scaleX, scaleY));
        if (500.0f * this.scale < 400.0f) {
            this.scale = 0.8f;
        }
        if (300.0f * this.scale < 250.0f) {
            this.scale = Math.max(this.scale, 0.8333333f);
        }
        this.actualWidth = (int)(500.0f * this.scale);
        this.actualHeight = (int)(300.0f * this.scale);
    }

    protected void method_25426() {
        super.method_25426();
        this.calculateAdaptiveScale();
        int centerX = (this.field_22789 - this.actualWidth) / 2;
        int centerY = (this.field_22790 - this.actualHeight) / 2;
        this.filterInput = new class_342(this.field_22793, centerX + (int)(20.0f * this.scale), centerY + (int)(20.0f * this.scale), (int)(200.0f * this.scale), (int)(20.0f * this.scale), (class_2561)class_2561.method_43471((String)"portable-storage.filter.list.input"));
        this.filterInput.method_1880(256);
        this.filterInput.method_47404((class_2561)class_2561.method_43471((String)"portable-storage.filter.list.input.placeholder"));
        this.filterInput.method_1852(this.currentFilter);
        this.method_37063((class_364)this.filterInput);
        this.whitelistMode = class_4286.method_54787((class_2561)class_2561.method_43471((String)"portable-storage.filter.list.whitelist"), (class_327)this.field_22793).method_54789(centerX + (int)(240.0f * this.scale), centerY + (int)(20.0f * this.scale)).method_54794(this.isWhitelistMode).method_54791((checkbox, checked) -> {
            if (checked) {
                this.isWhitelistMode = true;
                this.updateModeSelection();
            }
        }).method_54788();
        this.blacklistMode = class_4286.method_54787((class_2561)class_2561.method_43471((String)"portable-storage.filter.list.blacklist"), (class_327)this.field_22793).method_54789(centerX + (int)(320.0f * this.scale), centerY + (int)(20.0f * this.scale)).method_54794(!this.isWhitelistMode).method_54791((checkbox, checked) -> {
            if (checked) {
                this.isWhitelistMode = false;
                this.updateModeSelection();
            }
        }).method_54788();
        this.addButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"portable-storage.filter.list.add"), button -> this.addRule()).method_46434(centerX + (int)(20.0f * this.scale), centerY + (int)(50.0f * this.scale), (int)(60.0f * this.scale), (int)(20.0f * this.scale)).method_46431();
        this.clearButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"portable-storage.filter.list.clear"), button -> this.clearAllRules()).method_46434(centerX + (int)(90.0f * this.scale), centerY + (int)(50.0f * this.scale), (int)(60.0f * this.scale), (int)(20.0f * this.scale)).method_46431();
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"portable-storage.filter.list.back"), button -> {
            if (this.parent != null) {
                class_310.method_1551().method_1507(this.parent);
            } else {
                this.method_25419();
            }
        }).method_46434(centerX + (int)(420.0f * this.scale), centerY + (int)(270.0f * this.scale), (int)(60.0f * this.scale), (int)(20.0f * this.scale)).method_46431();
        this.method_37063((class_364)this.whitelistMode);
        this.method_37063((class_364)this.blacklistMode);
        this.method_37063((class_364)this.addButton);
        this.method_37063((class_364)this.clearButton);
        this.method_37063((class_364)this.backButton);
        if (this.barrelPos != null) {
            this.loadRulesFromBarrel();
        } else {
            this.syncRulesToServer();
        }
        if (class_310.method_1551().field_1724 != null) {
            PlayerViewState.startViewing(class_310.method_1551().field_1724.method_5667());
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        this.renderRuleList(context);
    }

    private void renderRuleList(class_332 context) {
        int centerX = (this.field_22789 - this.actualWidth) / 2;
        int centerY = (this.field_22790 - this.actualHeight) / 2;
        int startY = centerY + (int)(76.0f * this.scale);
        int itemHeight = (int)(20.0f * this.scale);
        this.updateScrollParameters();
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"portable-storage.filter.list.header.rule"), centerX + (int)(20.0f * this.scale), startY, 0xFFFFFF);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"portable-storage.filter.list.header.mode"), centerX + (int)(170.0f * this.scale), startY, 0xFFFFFF);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"portable-storage.filter.list.header.status"), centerX + (int)(250.0f * this.scale), startY, 0xFFFFFF);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"portable-storage.filter.list.header.action"), centerX + (int)(320.0f * this.scale), startY, 0xFFFFFF);
        context.method_25294(centerX + (int)(20.0f * this.scale), startY + (int)(12.0f * this.scale), centerX + (int)(480.0f * this.scale), startY + (int)(13.0f * this.scale), -1);
        int visibleStart = (int)(this.scroll * (float)this.maxScrollRows);
        int visibleEnd = Math.min(visibleStart + 8, this.rules.size());
        for (int i = visibleStart; i < visibleEnd; ++i) {
            ClientConfig.FilterRule rule = this.rules.get(i);
            int y = startY + (int)(20.0f * this.scale) + (i - visibleStart) * itemHeight;
            String displayRule = rule.matchRule.length() > 20 ? rule.matchRule.substring(0, 17) + "..." : rule.matchRule;
            context.method_25303(this.field_22793, displayRule, centerX + (int)(20.0f * this.scale), y, 0xFFFFFF);
            class_5250 modeText = rule.isWhitelist ? class_2561.method_43471((String)"portable-storage.filter.list.mode.whitelist") : class_2561.method_43471((String)"portable-storage.filter.list.mode.blacklist");
            context.method_27535(this.field_22793, (class_2561)modeText, centerX + (int)(170.0f * this.scale), y, rule.isWhitelist ? 65280 : 0xFF0000);
            class_5250 statusText = rule.enabled ? class_2561.method_43471((String)"portable-storage.filter.list.status.enabled") : class_2561.method_43471((String)"portable-storage.filter.list.status.disabled");
            context.method_27535(this.field_22793, (class_2561)statusText, centerX + (int)(250.0f * this.scale), y, rule.enabled ? 65280 : 0xFF0000);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"portable-storage.filter.list.action.delete"), centerX + (int)(320.0f * this.scale), y, 0xFF0000);
        }
        if (this.maxScrollRows > 0) {
            this.drawScrollbar(context, centerX, centerY);
        }
    }

    public void method_25419() {
        if (class_310.method_1551().field_1724 != null) {
            PlayerViewState.stopViewing(class_310.method_1551().field_1724.method_5667());
        }
        super.method_25419();
    }

    private void addRule() {
        String matchRule = this.filterInput.method_1882().trim();
        if (!matchRule.isEmpty()) {
            ClientConfig.FilterRule rule = new ClientConfig.FilterRule(matchRule, this.isWhitelistMode, true);
            this.rules.add(rule);
            if (this.barrelPos != null) {
                this.saveRulesToBarrel();
            } else {
                ClientConfig.save();
                this.syncRulesToServer();
            }
            this.filterInput.method_1852("");
            this.currentFilter = "";
        }
    }

    private void clearAllRules() {
        this.rules.clear();
        if (this.barrelPos != null) {
            this.saveRulesToBarrel();
        } else {
            ClientConfig.save();
            this.syncRulesToServer();
        }
    }

    private void loadRulesFromBarrel() {
        if (this.barrelPos == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_2586 blockEntity = client.field_1687.method_8321(this.barrelPos);
        if (blockEntity instanceof BoundBarrelBlockEntity) {
            BoundBarrelBlockEntity barrel = (BoundBarrelBlockEntity)blockEntity;
            this.rules.clear();
            List<BoundBarrelBlockEntity.FilterRule> barrelRules = barrel.getFilterRules();
            for (BoundBarrelBlockEntity.FilterRule rule : barrelRules) {
                this.rules.add(new ClientConfig.FilterRule(rule.matchRule, rule.isWhitelist, rule.enabled));
            }
        }
    }

    private void saveRulesToBarrel() {
        BoundBarrelBlockEntity barrel;
        Object blockEntity;
        if (this.barrelPos == null) {
            return;
        }
        ArrayList<SyncBarrelFilterRulesC2SPayload.FilterRule> filterRules = new ArrayList<SyncBarrelFilterRulesC2SPayload.FilterRule>();
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && (blockEntity = client.field_1687.method_8321(this.barrelPos)) instanceof BoundBarrelBlockEntity) {
            barrel = (BoundBarrelBlockEntity)((Object)blockEntity);
            for (BoundBarrelBlockEntity.FilterRule rule : barrel.getFilterRules()) {
                filterRules.add(new SyncBarrelFilterRulesC2SPayload.FilterRule(rule.matchRule, rule.isWhitelist, rule.enabled));
            }
        }
        filterRules.clear();
        blockEntity = this.rules.iterator();
        while (blockEntity.hasNext()) {
            ClientConfig.FilterRule rule = (ClientConfig.FilterRule)blockEntity.next();
            filterRules.add(new SyncBarrelFilterRulesC2SPayload.FilterRule(rule.matchRule, rule.isWhitelist, rule.enabled));
        }
        ClientPlayNetworking.send((class_8710)new SyncBarrelFilterRulesC2SPayload(this.barrelPos, filterRules));
        if (client.field_1687 != null && (blockEntity = client.field_1687.method_8321(this.barrelPos)) instanceof BoundBarrelBlockEntity) {
            barrel = (BoundBarrelBlockEntity)((Object)blockEntity);
            ArrayList<BoundBarrelBlockEntity.FilterRule> clientFilterRules = new ArrayList<BoundBarrelBlockEntity.FilterRule>();
            for (SyncBarrelFilterRulesC2SPayload.FilterRule rule : filterRules) {
                clientFilterRules.add(new BoundBarrelBlockEntity.FilterRule(rule.matchRule(), rule.isWhitelist(), rule.enabled()));
            }
            barrel.setFilterRules(clientFilterRules);
        }
    }

    private void updateScrollParameters() {
        this.maxScrollRows = Math.max(0, this.rules.size() - 8);
        if (this.maxScrollRows <= 0) {
            this.scroll = 0.0f;
        }
    }

    private void drawScrollbar(class_332 context, int centerX, int centerY) {
        int scrollbarX = centerX + (int)(470.0f * this.scale);
        int scrollbarY = centerY + (int)(96.0f * this.scale);
        int scrollbarHeight = (int)(160.0f * this.scale);
        int scrollbarWidth = (int)(8.0f * this.scale);
        int track = 0x55000000;
        context.method_25294(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + scrollbarHeight, track);
        int visible = 8;
        int total = Math.max(visible, this.rules.size());
        float frac = (float)visible / (float)total;
        int thumbMin = (int)(8.0f * this.scale);
        int thumbHeight = Math.max(thumbMin, (int)((float)scrollbarHeight * frac));
        int maxScrollPx = scrollbarHeight - thumbHeight;
        int thumbOffset = this.maxScrollRows <= 0 ? 0 : (int)(this.scroll * (float)maxScrollPx);
        int thumbTop = scrollbarY + thumbOffset;
        int thumbBg = -6710887;
        int thumbDark = -11184811;
        int thumbLight = -1;
        context.method_25294(scrollbarX, thumbTop, scrollbarX + scrollbarWidth, thumbTop + thumbHeight, thumbBg);
        context.method_25294(scrollbarX, thumbTop, scrollbarX + scrollbarWidth, thumbTop + 1, thumbDark);
        context.method_25294(scrollbarX + scrollbarWidth - 1, thumbTop, scrollbarX + scrollbarWidth, thumbTop + thumbHeight, thumbDark);
        context.method_25294(scrollbarX, thumbTop + thumbHeight - 1, scrollbarX + scrollbarWidth, thumbTop + thumbHeight, thumbLight);
        context.method_25294(scrollbarX, thumbTop, scrollbarX + 1, thumbTop + thumbHeight, thumbLight);
    }

    private void updateModeSelection() {
        int centerX = (this.field_22789 - this.actualWidth) / 2;
        int centerY = (this.field_22790 - this.actualHeight) / 2;
        this.method_37066((class_364)this.whitelistMode);
        this.method_37066((class_364)this.blacklistMode);
        this.whitelistMode = class_4286.method_54787((class_2561)class_2561.method_43471((String)"portable-storage.filter.list.whitelist"), (class_327)this.field_22793).method_54789(centerX + (int)(240.0f * this.scale), centerY + (int)(20.0f * this.scale)).method_54794(this.isWhitelistMode).method_54791((checkbox, checked) -> {
            if (checked) {
                this.isWhitelistMode = true;
                this.updateModeSelection();
            }
        }).method_54788();
        this.blacklistMode = class_4286.method_54787((class_2561)class_2561.method_43471((String)"portable-storage.filter.list.blacklist"), (class_327)this.field_22793).method_54789(centerX + (int)(320.0f * this.scale), centerY + (int)(20.0f * this.scale)).method_54794(!this.isWhitelistMode).method_54791((checkbox, checked) -> {
            if (checked) {
                this.isWhitelistMode = false;
                this.updateModeSelection();
            }
        }).method_54788();
        this.method_37063((class_364)this.whitelistMode);
        this.method_37063((class_364)this.blacklistMode);
    }

    private void syncRulesToServer() {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        ArrayList<SyncFilterRulesC2SPayload.FilterRule> serverFilterRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>();
        ArrayList<SyncFilterRulesC2SPayload.FilterRule> serverDestroyRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>();
        for (ClientConfig.FilterRule rule : ClientConfig.getInstance().filterRules) {
            serverFilterRules.add(new SyncFilterRulesC2SPayload.FilterRule(rule.matchRule, rule.isWhitelist, rule.enabled));
        }
        for (ClientConfig.FilterRule rule : ClientConfig.getInstance().destroyRules) {
            serverDestroyRules.add(new SyncFilterRulesC2SPayload.FilterRule(rule.matchRule, rule.isWhitelist, rule.enabled));
        }
        ClientPlayNetworking.send((class_8710)new SyncFilterRulesC2SPayload(serverFilterRules, serverDestroyRules));
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.isOverRuleListArea(mouseX, mouseY) && this.maxScrollRows > 0) {
            float delta = (float)verticalAmount * -0.1f;
            this.scroll = Math.max(0.0f, Math.min(1.0f, this.scroll + delta));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private boolean isOverRuleListArea(double mouseX, double mouseY) {
        int centerX = (this.field_22789 - this.actualWidth) / 2;
        int centerY = (this.field_22790 - this.actualHeight) / 2;
        int startY = centerY + (int)(76.0f * this.scale);
        int scrollbarX = centerX + (int)(470.0f * this.scale);
        int scrollbarWidth = (int)(8.0f * this.scale);
        return mouseX >= (double)(centerX + (int)(20.0f * this.scale)) && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)startY && mouseY <= (double)(startY + (int)(160.0f * this.scale) + (int)(20.0f * this.scale));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int centerX = (this.field_22789 - this.actualWidth) / 2;
        int centerY = (this.field_22790 - this.actualHeight) / 2;
        int startY = centerY + (int)(76.0f * this.scale);
        int itemHeight = (int)(20.0f * this.scale);
        int visibleStart = (int)(this.scroll * (float)this.maxScrollRows);
        int visibleEnd = Math.min(visibleStart + 8, this.rules.size());
        for (int i = visibleStart; i < visibleEnd; ++i) {
            int y = startY + (int)(20.0f * this.scale) + (i - visibleStart) * itemHeight;
            if (mouseX >= (double)(centerX + (int)(250.0f * this.scale)) && mouseX <= (double)(centerX + (int)(320.0f * this.scale)) && mouseY >= (double)y && mouseY <= (double)(y + itemHeight)) {
                ClientConfig.FilterRule rule = this.rules.get(i);
                boolean bl = rule.enabled = !rule.enabled;
                if (this.barrelPos != null) {
                    this.saveRulesToBarrel();
                } else {
                    ClientConfig.save();
                    this.syncRulesToServer();
                }
                return true;
            }
            if (!(mouseX >= (double)(centerX + (int)(320.0f * this.scale))) || !(mouseX <= (double)(centerX + (int)(370.0f * this.scale))) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + itemHeight))) continue;
            this.rules.remove(i);
            if (this.barrelPos != null) {
                this.saveRulesToBarrel();
            } else {
                ClientConfig.save();
                this.syncRulesToServer();
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Mode {
        FILTER,
        DESTROY;


        public String getDisplayName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_2561.method_43471((String)"portable-storage.filter.list.mode.filter").getString();
                case 1 -> class_2561.method_43471((String)"portable-storage.filter.list.mode.destroy").getString();
            };
        }
    }
}

