/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client.screen;

import com.portable.storage.client.ClientConfig;
import com.portable.storage.client.ClientStorageState;
import com.portable.storage.client.ScreenSwapBypass;
import com.portable.storage.client.emi.PortableStorageExclusionHelper;
import com.portable.storage.client.ui.StorageUIComponent;
import com.portable.storage.net.payload.CraftingOverlayActionC2SPayload;
import com.portable.storage.net.payload.RequestOpenScreenC2SPayload;
import com.portable.storage.net.payload.SyncControlC2SPayload;
import com.portable.storage.screen.PortableCraftingScreenHandler;
import com.portable.storage.sync.PlayerViewState;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_8710;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class PortableCraftingScreen
extends class_465<PortableCraftingScreenHandler> {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/gui/container/crafting_table.png");
    private static final int BG_WIDTH = 176;
    private static final int BG_HEIGHT = 166;
    private static final int STORAGE_UI_HEIGHT = 108;
    private static final int GAP_BETWEEN = 6;
    private final StorageUIComponent storageUi = new StorageUIComponent();
    private final Map<Integer, class_1799> portableStorage$lastCraftingStacks = new HashMap<Integer, class_1799>();
    private class_1799 portableStorage$lastCraftingOutput = class_1799.field_8037;
    private long portableStorage$lastCraftRefillCheck = 0L;
    private long portableStorage$lastCraftingSlotClickTime = 0L;
    private ClientConfig.StoragePos portableStorage$lastStoragePos = null;

    public PortableCraftingScreen(PortableCraftingScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super((class_1703)handler, playerInventory, title);
        this.field_2792 = 176;
        this.field_2779 = 166;
    }

    protected void method_25426() {
        super.method_25426();
        ClientConfig config = ClientConfig.getInstance();
        if (config.storagePos == ClientConfig.StoragePos.TOP) {
            int totalContentHeight = 280;
            this.field_2776 = (this.field_22789 - this.field_2792) / 2;
            this.field_2800 = (this.field_22790 - totalContentHeight) / 2;
            this.field_2800 = this.field_2800 + 108 + 6;
        } else {
            int totalContentHeight = 280;
            this.field_2776 = (this.field_22789 - this.field_2792) / 2;
            this.field_2800 = (this.field_22790 - totalContentHeight) / 2;
        }
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1772 != null) {
            int fieldWidth = 120;
            int fieldHeight = 18;
            int fieldX = this.field_2776 + this.field_2792 - fieldWidth - 8;
            int fieldY = config.storagePos == ClientConfig.StoragePos.TOP ? this.field_2800 - fieldHeight - 6 : this.field_2800 - fieldHeight - 6;
            this.storageUi.initSearchField(client, fieldX, fieldY, fieldWidth, fieldHeight);
            this.storageUi.setCollapsed(false);
        }
        this.storageUi.setSwitchToVanillaCallback(() -> {
            ScreenSwapBypass.requestSkipNextCraftingSwap();
            ClientPlayNetworking.send((class_8710)new RequestOpenScreenC2SPayload(RequestOpenScreenC2SPayload.Screen.VANILLA_CRAFTING, null, ""));
        });
        PlayerViewState.startViewing(class_310.method_1551().field_1724.method_5667());
        ClientPlayNetworking.send((class_8710)new SyncControlC2SPayload(SyncControlC2SPayload.Op.REQUEST, 0L, false));
        this.portableStorage$lastStoragePos = config.storagePos;
    }

    private void portableStorage$recalculatePosition() {
        ClientConfig config = ClientConfig.getInstance();
        if (config.storagePos == ClientConfig.StoragePos.TOP) {
            int totalContentHeight = 280;
            this.field_2776 = (this.field_22789 - this.field_2792) / 2;
            this.field_2800 = (this.field_22790 - totalContentHeight) / 2;
            this.field_2800 = this.field_2800 + 108 + 6;
        } else {
            int totalContentHeight = 280;
            this.field_2776 = (this.field_22789 - this.field_2792) / 2;
            this.field_2800 = (this.field_22790 - totalContentHeight) / 2;
        }
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1772 != null) {
            int fieldWidth = 120;
            int fieldHeight = 18;
            int fieldX = this.field_2776 + this.field_2792 - fieldWidth - 8;
            int fieldY = config.storagePos == ClientConfig.StoragePos.TOP ? this.field_2800 - fieldHeight - 6 : this.field_2800 - fieldHeight - 6;
            this.storageUi.initSearchField(client, fieldX, fieldY, fieldWidth, fieldHeight);
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x0 = this.field_2776;
        int y0 = this.field_2800;
        context.method_25302(BACKGROUND_TEXTURE, x0, y0, 0, 0, this.field_2792, this.field_2779);
    }

    public void method_25419() {
        if (class_310.method_1551().field_1724 != null) {
            PlayerViewState.stopViewing(class_310.method_1551().field_1724.method_5667());
        }
        super.method_25419();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        ClientConfig config = ClientConfig.getInstance();
        if (this.portableStorage$lastStoragePos != config.storagePos) {
            this.portableStorage$recalculatePosition();
            this.portableStorage$lastStoragePos = config.storagePos;
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (ClientStorageState.isStorageEnabled()) {
            this.storageUi.render(context, mouseX, mouseY, delta, this.field_2776, this.field_2800, this.field_2792, this.field_2779);
        }
        this.method_2380(context, mouseX, mouseY);
        this.portableStorage$checkCraftRefill();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        PortableCraftingScreenHandler handler = (PortableCraftingScreenHandler)this.field_2797;
        if (handler != null) {
            int screenX = this.field_2776;
            int screenY = this.field_2800;
            for (class_1735 slot : handler.field_7761) {
                int slotX = screenX + slot.field_7873;
                int slotY = screenY + slot.field_7872;
                if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
                if (slot.field_7874 < 1 || slot.field_7874 > 9) break;
                this.portableStorage$lastCraftingSlotClickTime = System.currentTimeMillis();
                break;
            }
        }
        if (ClientStorageState.isStorageEnabled() && this.storageUi.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (ClientStorageState.isStorageEnabled() && this.storageUi.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (ClientStorageState.isStorageEnabled() && this.storageUi.charTyped(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean isMouseOverStorageArea(int mouseX, int mouseY) {
        return this.storageUi.isMouseOverStorageArea(mouseX, mouseY);
    }

    public class_1799 getStorageItemUnderMouse(int mouseX, int mouseY) {
        return this.storageUi.getItemUnderMouse(mouseX, mouseY);
    }

    public void getExclusionAreas(Consumer<Bounds> consumer) {
        ClientConfig config = ClientConfig.getInstance();
        boolean storageOnTop = config.storagePos == ClientConfig.StoragePos.TOP;
        PortableStorageExclusionHelper.addAreasForScreen(consumer, this.field_2776, this.field_2800, this.field_2792, this.field_2779, storageOnTop, false, false, true);
    }

    private void portableStorage$checkCraftRefill() {
        if (!ClientConfig.getInstance().craftRefill) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.portableStorage$lastCraftRefillCheck < 100L) {
            return;
        }
        this.portableStorage$lastCraftRefillCheck = now;
        PortableCraftingScreenHandler handler = (PortableCraftingScreenHandler)this.field_2797;
        if (handler == null) {
            return;
        }
        boolean craftOccurred = false;
        if (handler.field_7761.size() > 0) {
            class_1799 currentOutput = handler.method_7611(0).method_7677();
            if (!(this.portableStorage$lastCraftingOutput.method_7960() || !currentOutput.method_7960() && class_1799.method_31577((class_1799)currentOutput, (class_1799)this.portableStorage$lastCraftingOutput) && currentOutput.method_7947() >= this.portableStorage$lastCraftingOutput.method_7947())) {
                craftOccurred = true;
            }
            this.portableStorage$lastCraftingOutput = currentOutput.method_7972();
        }
        if (craftOccurred) {
            for (int i = 1; i <= 9; ++i) {
                class_1799 target;
                boolean recentClick;
                if (handler.field_7761.size() <= i) continue;
                class_1799 currentStack = handler.method_7611(i).method_7677();
                class_1799 lastStack = this.portableStorage$lastCraftingStacks.get(i);
                boolean bl = recentClick = now - this.portableStorage$lastCraftingSlotClickTime < 300L;
                if (lastStack == null || lastStack.method_7960()) continue;
                if (currentStack.method_7960()) {
                    if (recentClick) continue;
                    target = lastStack.method_7972();
                    target.method_7939(target.method_7914());
                    this.portableStorage$refillFromStorage(i, target);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)currentStack, (class_1799)lastStack) || currentStack.method_7947() >= lastStack.method_7947() || recentClick) continue;
                target = currentStack.method_7972();
                target.method_7939(target.method_7914());
                this.portableStorage$refillFromStorage(i, target);
            }
        }
        for (int i = 1; i <= 9; ++i) {
            if (handler.field_7761.size() <= i) continue;
            class_1799 cur = handler.method_7611(i).method_7677();
            this.portableStorage$lastCraftingStacks.put(i, cur.method_7972());
        }
    }

    private void portableStorage$refillFromStorage(int slotIndex, class_1799 targetStack) {
        if (targetStack.method_7960()) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.REFILL, slotIndex, 0, false, targetStack, "", null, null));
    }

    public void fillRecipeFromStorage(EmiRecipe recipe) {
        class_2960 recipeId = recipe.getId();
        if (recipeId == null) {
            return;
        }
        List inputs = recipe.getInputs();
        if (inputs.isEmpty()) {
            return;
        }
        ArrayList<Integer> slotIndices = new ArrayList<Integer>();
        ArrayList<Integer> itemCounts = new ArrayList<Integer>();
        for (int i = 0; i < Math.min(inputs.size(), 9); ++i) {
            EmiStack emiStack;
            class_1799 stack;
            EmiIngredient input = (EmiIngredient)inputs.get(i);
            List emiStacks = input.getEmiStacks();
            if (emiStacks.isEmpty() || (stack = (emiStack = (EmiStack)emiStacks.get(0)).getItemStack()).method_7960()) continue;
            slotIndices.add(i + 1);
            itemCounts.add(stack.method_7947());
        }
        if (!slotIndices.isEmpty()) {
            LoggerFactory.getLogger((String)"portable-storage/emi").debug("Client send EmiRecipeFill: recipeId={}, slots={}, counts={}", new Object[]{recipeId, slotIndices, itemCounts});
            int[] slotArray = slotIndices.stream().mapToInt(Integer::intValue).toArray();
            int[] countArray = itemCounts.stream().mapToInt(Integer::intValue).toArray();
            ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.EMI_FILL, 0, 0, false, class_1799.field_8037, recipeId.toString(), slotArray, countArray));
        }
    }
}

