/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client.ui;

import com.portable.storage.client.ClientConfig;
import com.portable.storage.client.ClientInfiniteFluidConfig;
import com.portable.storage.client.ClientNetworkingHandlers;
import com.portable.storage.client.ClientRiftConfig;
import com.portable.storage.client.ClientStorageState;
import com.portable.storage.client.ClientUpgradeState;
import com.portable.storage.client.ClientVirtualCraftingConfig;
import com.portable.storage.client.screen.FilterListScreen;
import com.portable.storage.client.screen.FilterMainScreen;
import com.portable.storage.client.screen.FilterScreenManager;
import com.portable.storage.client.screen.PortableCraftingScreen;
import com.portable.storage.client.util.PinyinSearchHelper;
import com.portable.storage.net.payload.FluidConversionC2SPayload;
import com.portable.storage.net.payload.RequestOpenScreenC2SPayload;
import com.portable.storage.net.payload.ScrollC2SPayload;
import com.portable.storage.net.payload.StorageActionC2SPayload;
import com.portable.storage.storage.AutoEatMode;
import com.portable.storage.storage.StorageType;
import com.portable.storage.storage.UpgradeInventory;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_479;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class StorageUIComponent {
    private static StorageUIComponent currentInstance;
    private static final class_2960 TEX_BG;
    private static final class_2960 TEX_SLOT;
    private static final class_2960 TEX_ICONS;
    private static final class_2960 TEX_DELETE;
    private Runnable switchToVanillaCallback = null;
    private final int cols = 9;
    private int visibleRows = 6;
    private final int minVisibleRows = 2;
    private final int slotSize = 18;
    private final int slotSpacing = 0;
    private final int upgradeSlotSize = 18;
    private final int upgradeSpacing = 0;
    private final int baseUpgradeCount = 5;
    private final int extendedUpgradeCount = 5;
    private final int totalUpgradeCount = 10;
    private float scroll = 0.0f;
    private boolean dragScrollbar = false;
    private int dragGrabOffset = 0;
    private int totalRows = 12;
    private int[] visibleIndexMap = new int[0];
    private String query = "";
    private boolean collapsed = false;
    private int currentScreenX = 0;
    private int currentBackgroundWidth = 176;
    private Map<Integer, CollapsedInfo> collapsedInfoByRep = new HashMap<Integer, CollapsedInfo>();
    private int expandTabLeft;
    private int expandTabTop;
    private int expandTabRight;
    private int expandTabBottom;
    private int collapseLeft;
    private int collapseTop;
    private int collapseRight;
    private int collapseBottom;
    private class_342 searchField;
    private int gridLeft;
    private int gridTop;
    private int baseY;
    private int baseBgH;
    private int scrollbarLeft;
    private int scrollbarTop;
    private int scrollbarHeight;
    private int scrollbarWidth;
    private final int[] upgradeSlotLefts = new int[10];
    private final int[] upgradeSlotTops = new int[10];
    private final int[] upgradeSlotRights = new int[10];
    private final int[] upgradeSlotBottoms = new int[10];
    private float upgradeScroll = 0.0f;
    private boolean dragUpgradeScrollbar = false;
    private int dragUpgradeGrabOffset = 0;
    private int upgradeScrollbarLeft;
    private int upgradeScrollbarTop;
    private int upgradeScrollbarHeight;
    private int upgradeScrollbarWidth;
    private int fluidSlotLeft;
    private int fluidSlotTop;
    private int fluidSlotRight;
    private int fluidSlotBottom;
    private int trashSlotLeft;
    private int trashSlotTop;
    private int trashSlotRight;
    private int trashSlotBottom;
    private int sortModeLeft;
    private int sortModeTop;
    private int sortModeRight;
    private int sortModeBottom;
    private int sortOrderLeft;
    private int sortOrderTop;
    private int sortOrderRight;
    private int sortOrderBottom;
    private int craftRefillLeft;
    private int craftRefillTop;
    private int craftRefillRight;
    private int craftRefillBottom;
    private int autoDepositLeft;
    private int autoDepositTop;
    private int autoDepositRight;
    private int autoDepositBottom;
    private int searchPosLeft;
    private int searchPosTop;
    private int searchPosRight;
    private int searchPosBottom;
    private int storagePosLeft;
    private int storagePosTop;
    private int storagePosRight;
    private int storagePosBottom;
    private int smartCollapseLeft;
    private int smartCollapseTop;
    private int smartCollapseRight;
    private int smartCollapseBottom;
    private int switchVanillaLeft;
    private int switchVanillaTop;
    private int switchVanillaRight;
    private int switchVanillaBottom;

    public static StorageUIComponent getCurrentInstance() {
        return currentInstance;
    }

    public void setSwitchToVanillaCallback(Runnable callback) {
        this.switchToVanillaCallback = callback;
    }

    public void initSearchField(class_310 client, int x, int y, int width, int height) {
        this.searchField = new class_342(client.field_1772, x, y, width, height, (class_2561)class_2561.method_43471((String)"portable-storage.search"));
        this.searchField.method_47404((class_2561)class_2561.method_43471((String)"portable-storage.search.placeholder"));
        this.searchField.method_1887(class_2561.method_43471((String)"portable-storage.search.placeholder").getString());
        this.searchField.method_1880(64);
        this.searchField.method_1888(true);
        this.searchField.method_1862(true);
        this.searchField.method_1858(true);
        this.searchField.method_1868(0xFFFFFF);
        this.searchField.method_1860(0xFFFFFF);
        try {
            Field shadowField = class_342.class.getDeclaredField("shadow");
            shadowField.setAccessible(true);
            shadowField.set(this.searchField, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.searchField.method_1863(text -> {
            this.query = text == null ? "" : text;
            this.scroll = 0.0f;
            if (text == null || text.isEmpty()) {
                this.searchField.method_1887(class_2561.method_43471((String)"portable-storage.search.placeholder").getString());
            } else {
                this.searchField.method_1887("");
            }
        });
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta, int screenX, int screenY, int backgroundWidth, int backgroundHeight, boolean enableCollapse) {
        int searchH;
        currentInstance = this;
        this.currentScreenX = screenX;
        this.currentBackgroundWidth = backgroundWidth;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1772 == null) {
            return;
        }
        if (!ClientStorageState.isStorageEnabled()) {
            return;
        }
        ClientConfig config = ClientConfig.getInstance();
        int screenHeight = client.method_22683().method_4502();
        int inventoryTop = screenY;
        int inventoryBottom = screenY + backgroundHeight;
        this.visibleRows = this.calculateAdaptiveHeight(screenHeight, inventoryTop, inventoryBottom, config);
        this.baseY = screenY;
        this.baseBgH = backgroundHeight;
        this.gridLeft = screenX + 8;
        int gapBelow = 6;
        int extraYOffset = 0;
        int n = searchH = this.searchField != null ? this.searchField.method_25364() : 18;
        if (ClientConfig.getInstance().searchPos == ClientConfig.SearchPos.MIDDLE && this.portableStorage$isInventoryOrCraftingScreen()) {
            extraYOffset = searchH + 1;
        }
        if (config.storagePos == ClientConfig.StoragePos.TOP) {
            int storageHeight = this.visibleRows * 18;
            this.gridTop = screenY - storageHeight - gapBelow - extraYOffset;
        } else {
            this.gridTop = screenY + backgroundHeight + gapBelow + extraYOffset;
        }
        if (enableCollapse && this.collapsed) {
            int tabW = 72;
            int tabH = 18;
            int tabLeft = screenX + (backgroundWidth - tabW) / 2;
            int tabTop = config.storagePos == ClientConfig.StoragePos.TOP ? screenY - tabH - 6 : screenY + backgroundHeight + 6;
            this.expandTabLeft = tabLeft;
            this.expandTabTop = tabTop;
            this.expandTabRight = tabLeft + tabW;
            this.expandTabBottom = tabTop + tabH;
            this.drawPanel(context, tabLeft, tabTop, tabW, tabH);
            class_5250 label = class_2561.method_43471((String)"portable-storage.ui.expand");
            int textW = client.field_1772.method_27525((class_5348)label);
            int tx = tabLeft + (tabW - textW) / 2;
            int ty = tabTop + (tabH - 8) / 2;
            context.method_51439(client.field_1772, (class_2561)label, tx, ty, 0xFFFFFF, true);
            return;
        }
        int upgradeLeft = screenX - 24;
        int extendedSlotWidth = 0;
        if (ClientUpgradeState.isChestUpgradeActive()) {
            extendedSlotWidth = 20;
        }
        int panelWidth = this.calculatePanelWidth(client, config, enableCollapse);
        int panelLeft = screenX + backgroundWidth + 8;
        int extLeft = upgradeLeft - 2 - extendedSlotWidth;
        int extTop = this.gridTop - 2;
        int extRight = panelLeft - 2;
        int extBottom = this.gridTop + this.visibleRows * 18 + 2;
        int bgOffsetX = 4;
        int bgOffsetY = 4;
        this.drawExtensionBackground(context, extLeft - 4, extTop - 4, extRight - extLeft + 8, extBottom - extTop + 8);
        this.renderStorageGrid(context, client, mouseX, mouseY);
        this.renderScrollbar(context);
        this.updateScrollbarDrag(mouseX, mouseY);
        this.renderUpgradeSlots(context, upgradeLeft);
        this.renderSettingsPanel(context, client, config, panelLeft, panelWidth, enableCollapse);
        this.updateSearchFieldPosition();
        if (this.searchField != null) {
            this.renderSearchFieldCustom(context, mouseX, mouseY, delta);
        }
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta, int screenX, int screenY, int backgroundWidth, int backgroundHeight) {
        this.render(context, mouseX, mouseY, delta, screenX, screenY, backgroundWidth, backgroundHeight, false);
    }

    private void renderStorageGrid(class_332 context, class_310 client, int mouseX, int mouseY) {
        Set<String> fav;
        List<Integer> filtered = this.buildFilteredIndices();
        if (this.query != null && !this.query.isEmpty()) {
            filtered.add(0, -2147483638);
        }
        for (String fluidType : new String[]{"lava", "water", "milk"}) {
            int fluidIndex;
            int units = ClientUpgradeState.getFluidUnits(fluidType);
            if (units <= 0) continue;
            switch (fluidType) {
                case "lava": {
                    int n = -2147483647;
                    break;
                }
                case "water": {
                    int n = -2147483646;
                    break;
                }
                case "milk": {
                    int n = -2147483645;
                    break;
                }
                default: {
                    int n = fluidIndex = -2147483644;
                }
            }
            if (this.query != null && !this.query.isEmpty() && !this.matchesVirtualFluidQuery(fluidType, this.query)) continue;
            filtered.add(0, fluidIndex);
        }
        boolean showXpBottle = ClientUpgradeState.isXpBottleUpgradeActive();
        if (showXpBottle && (this.query == null || this.query.isEmpty() || this.matchesXpBottleQuery(this.query))) {
            filtered.add(0, Integer.MIN_VALUE);
        }
        if ((fav = ClientConfig.getInstance().favorites) != null && !fav.isEmpty()) {
            class_2371<class_1799> stacks = ClientStorageState.getStacks();
            ArrayList<Integer> favs = new ArrayList<Integer>();
            ArrayList<Integer> normals = new ArrayList<Integer>();
            for (int idx : filtered) {
                String id;
                class_1799 st;
                if (idx >= 0 && idx < stacks.size() && (st = (class_1799)stacks.get(idx)) != null && !st.method_7960() && fav.contains(id = class_7923.field_41178.method_10221((Object)st.method_7909()).toString())) {
                    favs.add(idx);
                    continue;
                }
                normals.add(idx);
            }
            ArrayList<Integer> reordered = new ArrayList<Integer>(filtered.size());
            for (int v : filtered) {
                if (v >= 0) continue;
                reordered.add(v);
            }
            reordered.addAll(favs);
            for (int v : normals) {
                if (v >= 0) {
                    reordered.add(v);
                    continue;
                }
                if (reordered.contains(v)) continue;
                reordered.add(v);
            }
            filtered = reordered;
        }
        int filteredSize = filtered.size();
        this.totalRows = Math.max(this.visibleRows, (int)Math.ceil((double)filteredSize / 9.0));
        int maxScrollRows = Math.max(0, this.totalRows - this.visibleRows);
        int rowOffset = (int)Math.floor(this.scroll * (float)maxScrollRows + 0.5f);
        rowOffset = Math.max(0, Math.min(maxScrollRows, rowOffset));
        class_1799 hoveredStack = class_1799.field_8037;
        int hoveredIndex = -1;
        if (this.visibleIndexMap.length != this.visibleRows * 9) {
            this.visibleIndexMap = new int[this.visibleRows * 9];
        }
        Arrays.fill(this.visibleIndexMap, -1);
        for (int row = 0; row < this.visibleRows; ++row) {
            int modelRow = row + rowOffset;
            for (int col = 0; col < 9; ++col) {
                int sx = this.gridLeft + col * 18;
                int sy = this.gridTop + row * 18;
                this.drawSlotInset(context, sx, sy, 18, 18);
                int filteredIndex = modelRow * 9 + col;
                if (modelRow < this.totalRows && filteredIndex >= 0 && filteredIndex < filteredSize) {
                    class_1799 stack;
                    int storageIndex = filtered.get(filteredIndex);
                    class_2371<class_1799> stacks = ClientStorageState.getStacks();
                    if (storageIndex == Integer.MIN_VALUE) {
                        display = new class_1799((class_1935)class_1802.field_8287);
                        context.method_51448().method_22903();
                        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                        context.method_51427(display, sx + 1, sy + 1);
                        long totalXp = ClientUpgradeState.getCachedXpPool();
                        if (totalXp > 0L) {
                            String countText = this.formatCount(totalXp);
                            float scale = 0.75f;
                            int textWidth = client.field_1772.method_1727(countText);
                            int txUnscaled = sx + 18 - 1 - (int)((float)textWidth * scale);
                            int tyUnscaled = sy + 18 - (int)(9.0f * scale);
                            context.method_51448().method_22903();
                            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                            context.method_51448().method_22905(scale, scale, 1.0f);
                            context.method_51433(client.field_1772, countText, (int)((float)txUnscaled / scale), (int)((float)tyUnscaled / scale), 0xFFFFFF, true);
                            context.method_51448().method_22909();
                        }
                        context.method_51448().method_22909();
                        if (hoveredStack.method_7960() && mouseX >= sx && mouseX < sx + 18 && mouseY >= sy && mouseY < sy + 18) {
                            hoveredStack = display;
                            hoveredIndex = Integer.MIN_VALUE;
                        }
                        this.visibleIndexMap[row * 9 + col] = -2;
                    } else if (storageIndex == -2147483638) {
                        display = new class_1799((class_1935)class_1802.field_8077);
                        context.method_51448().method_22903();
                        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                        context.method_51427(display, sx + 1, sy + 1);
                        context.method_51448().method_22909();
                        if (hoveredStack.method_7960() && mouseX >= sx && mouseX < sx + 18 && mouseY >= sy && mouseY < sy + 18) {
                            hoveredStack = display;
                            hoveredIndex = -2147483638;
                        }
                        this.visibleIndexMap[row * 9 + col] = -3;
                    } else if (storageIndex < -2147482648) {
                        int units;
                        String fluidType = this.getFluidTypeFromVirtualIndex(storageIndex);
                        if (fluidType != null && (units = ClientUpgradeState.getFluidUnits(fluidType)) > 0) {
                            context.method_51448().method_22903();
                            context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                            this.drawFluidTexture(context, fluidType, sx + 1, sy + 1);
                            String countText = ClientInfiniteFluidConfig.shouldShowInfinite(fluidType, units) ? class_2561.method_43471((String)"portable-storage.fluid.infinite_symbol").getString() : this.formatCount(units);
                            float scale = 0.75f;
                            int textWidth = client.field_1772.method_1727(countText);
                            int txUnscaled = sx + 18 - 1 - (int)((float)textWidth * scale);
                            int tyUnscaled = sy + 18 - (int)(9.0f * scale);
                            context.method_51448().method_22903();
                            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                            context.method_51448().method_22905(scale, scale, 1.0f);
                            context.method_51433(client.field_1772, countText, (int)((float)txUnscaled / scale), (int)((float)tyUnscaled / scale), 0xFFFFFF, true);
                            context.method_51448().method_22909();
                            context.method_51448().method_22909();
                            if (hoveredStack.method_7960() && mouseX >= sx && mouseX < sx + 18 && mouseY >= sy && mouseY < sy + 18) {
                                hoveredStack = this.createFluidDisplayStack(fluidType);
                                hoveredIndex = storageIndex;
                            }
                            this.visibleIndexMap[row * 9 + col] = storageIndex;
                        }
                    } else if (storageIndex >= 0 && storageIndex < stacks.size() && (stack = (class_1799)stacks.get(storageIndex)) != null && !stack.method_7960()) {
                        long displayCount;
                        String id;
                        context.method_51448().method_22903();
                        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                        CollapsedInfo cinfo = this.collapsedInfoByRep.get(storageIndex);
                        class_1799 toRender = cinfo != null && cinfo.displayStack != null ? cinfo.displayStack : stack;
                        Set<String> fav2 = ClientConfig.getInstance().favorites;
                        if (fav2 != null && !fav2.isEmpty() && fav2.contains(id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString())) {
                            context.method_51448().method_22903();
                            context.method_51448().method_46416(0.0f, 0.0f, 95.0f);
                            context.method_25294(sx + 1, sy + 1, sx + 18 - 1, sy + 18 - 1, 1080279533);
                            context.method_51448().method_22909();
                        }
                        context.method_51427(toRender, sx + 1, sy + 1);
                        int originalCount = toRender.method_7947();
                        class_1799 overlayStack = toRender.method_7972();
                        overlayStack.method_7939(1);
                        context.method_51431(client.field_1772, overlayStack, sx + 1, sy + 1);
                        if (cinfo != null) {
                            context.method_51448().method_22903();
                            context.method_51448().method_46416(0.0f, 0.0f, 150.0f);
                            context.method_25294(sx + 1, sy + 1, sx + 18 - 1, sy + 18 - 1, 1079377749);
                            context.method_51448().method_22909();
                        }
                        long logicalCount = cinfo != null ? (long)cinfo.totalCount : ClientStorageState.getCount(storageIndex);
                        long l = displayCount = logicalCount > 0L ? logicalCount : (long)originalCount;
                        if (displayCount > 1L) {
                            String countText = this.formatCount(displayCount);
                            float scale = 0.75f;
                            int textWidth = client.field_1772.method_1727(countText);
                            int txUnscaled = sx + 18 - 1 - (int)((float)textWidth * scale);
                            int tyUnscaled = sy + 18 - (int)(9.0f * scale);
                            context.method_51448().method_22903();
                            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                            context.method_51448().method_22905(scale, scale, 1.0f);
                            context.method_51433(client.field_1772, countText, (int)((float)txUnscaled / scale), (int)((float)tyUnscaled / scale), 0xFFFFFF, true);
                            context.method_51448().method_22909();
                        }
                        context.method_51448().method_22909();
                        if (hoveredStack.method_7960() && mouseX >= sx && mouseX < sx + 18 && mouseY >= sy && mouseY < sy + 18) {
                            hoveredStack = stack;
                            hoveredIndex = storageIndex;
                        }
                        this.visibleIndexMap[row * 9 + col] = storageIndex;
                    }
                }
                if (mouseX < sx || mouseX >= sx + 18 || mouseY < sy || mouseY >= sy + 18) continue;
                context.method_51448().method_22903();
                context.method_51448().method_46416(0.0f, 0.0f, 240.0f);
                context.method_25294(sx + 1, sy + 1, sx + 18 - 1, sy + 18 - 1, -2130706433);
                context.method_51448().method_22909();
            }
        }
        if (this.isIn(mouseX, mouseY, this.collapseLeft, this.collapseTop, this.collapseRight, this.collapseBottom)) {
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.collapse"));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.sortModeLeft, this.sortModeTop, this.sortModeRight, this.sortModeBottom)) {
            ClientConfig config = ClientConfig.getInstance();
            String sortModeKey = switch (config.sortMode) {
                default -> throw new MatchException(null, null);
                case ClientConfig.SortMode.COUNT -> "portable-storage.sort.count";
                case ClientConfig.SortMode.NAME -> "portable-storage.sort.name";
                case ClientConfig.SortMode.MOD_ID -> "portable-storage.sort.mod_id";
                case ClientConfig.SortMode.UPDATE_TIME -> "portable-storage.sort.update_time";
            };
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.sort_mode", (Object[])new Object[]{class_2561.method_43471((String)sortModeKey).getString()}));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.sortOrderLeft, this.sortOrderTop, this.sortOrderRight, this.sortOrderBottom)) {
            ClientConfig config = ClientConfig.getInstance();
            String sortOrderKey = config.sortAscending ? "portable-storage.sort.ascending" : "portable-storage.sort.descending";
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.sort_order", (Object[])new Object[]{class_2561.method_43471((String)sortOrderKey).getString()}));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.craftRefillLeft, this.craftRefillTop, this.craftRefillRight, this.craftRefillBottom)) {
            ClientConfig config = ClientConfig.getInstance();
            String craftRefillKey = config.craftRefill ? "portable-storage.toggle.enabled" : "portable-storage.toggle.disabled";
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.craft_refill", (Object[])new Object[]{class_2561.method_43471((String)craftRefillKey).getString()}));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.autoDepositLeft, this.autoDepositTop, this.autoDepositRight, this.autoDepositBottom)) {
            ClientConfig config = ClientConfig.getInstance();
            String autoDepositKey = config.autoDeposit ? "portable-storage.toggle.enabled" : "portable-storage.toggle.disabled";
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.auto_deposit", (Object[])new Object[]{class_2561.method_43471((String)autoDepositKey).getString()}));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.smartCollapseLeft, this.smartCollapseTop, this.smartCollapseRight, this.smartCollapseBottom)) {
            ClientConfig config = ClientConfig.getInstance();
            String smartCollapseKey = config.smartCollapse ? "portable-storage.toggle.enabled" : "portable-storage.toggle.disabled";
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.smart_collapse", (Object[])new Object[]{class_2561.method_43471((String)smartCollapseKey).getString()}));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.searchPosLeft, this.searchPosTop, this.searchPosRight, this.searchPosBottom)) {
            String posKey;
            ClientConfig config = ClientConfig.getInstance();
            if (config.storagePos == ClientConfig.StoragePos.TOP && config.searchPos == ClientConfig.SearchPos.TOP2) {
                posKey = "portable-storage.search_pos.top";
            } else {
                switch (config.searchPos) {
                    case TOP: {
                        posKey = "portable-storage.search_pos.top";
                        break;
                    }
                    case TOP2: {
                        posKey = "portable-storage.search_pos.top2";
                        break;
                    }
                    case MIDDLE: {
                        posKey = "portable-storage.search_pos.middle";
                        break;
                    }
                    default: {
                        posKey = "portable-storage.search_pos.bottom";
                    }
                }
            }
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.search_pos", (Object[])new Object[]{class_2561.method_43471((String)posKey).getString()}));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.storagePosLeft, this.storagePosTop, this.storagePosRight, this.storagePosBottom)) {
            ClientConfig config = ClientConfig.getInstance();
            String storagePosKey = config.storagePos == ClientConfig.StoragePos.TOP ? "portable-storage.storage_pos.top" : "portable-storage.storage_pos.bottom";
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.storage_pos", (Object[])new Object[]{class_2561.method_43471((String)storagePosKey).getString()}));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.switchVanillaLeft, this.switchVanillaTop, this.switchVanillaRight, this.switchVanillaBottom)) {
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.switch_vanilla"));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.fluidSlotLeft, this.fluidSlotTop, this.fluidSlotRight, this.fluidSlotBottom)) {
            class_1799 fluidStack = ClientUpgradeState.getFluidStack();
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            class_5250 fluidSlotLine = class_2561.method_43471((String)"portable-storage.ui.fluid_slot");
            tooltipLines.add(fluidSlotLine);
            if (!fluidStack.method_7960()) {
                tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.fluid_name", (Object[])new Object[]{fluidStack.method_7964().getString()}));
            } else {
                tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.fluid_name", (Object[])new Object[]{class_2561.method_43471((String)"portable-storage.ui.fluid_empty").getString()}));
            }
            tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.fluid_desc"));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.isIn(mouseX, mouseY, this.trashSlotLeft, this.trashSlotTop, this.trashSlotRight, this.trashSlotBottom)) {
            class_1799 trashStack = ClientUpgradeState.getTrashStack();
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.trash_slot"));
            if (!trashStack.method_7960()) {
                tooltipLines.add(class_2561.method_43470((String)trashStack.method_7964().getString()));
            }
            tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_right_click_trash"));
            context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
        } else if (this.portableStorage$isOverUpgradeSlot(mouseX, mouseY)) {
            int slotIndex = this.portableStorage$getHoveredUpgradeSlot(mouseX, mouseY);
            if (slotIndex >= 0) {
                class_1799 stack = ClientUpgradeState.getStack(slotIndex);
                String upgradeName = this.portableStorage$getUpgradeName(slotIndex);
                boolean isDisabled = ClientUpgradeState.isSlotDisabled(slotIndex);
                ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
                boolean hasItem = !stack.method_7960();
                boolean ok = hasItem && !isDisabled;
                String symbol = ok ? "[\u2713]" : "[\u2717]";
                class_5250 slotLine = class_2561.method_43469((String)"portable-storage.ui.upgrade_slot", (Object[])new Object[]{slotIndex + 1}).method_27661().method_27693(symbol);
                tooltipLines.add(slotLine);
                tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.upgrade_name", (Object[])new Object[]{upgradeName}));
                if (UpgradeInventory.isPrimaryStorageRestrictedSlot(slotIndex) && ClientStorageState.getStorageType() == StorageType.PRIMARY) {
                    tooltipLines.add(class_2561.method_43471((String)"portable-storage.tooltip.primary_storage_restricted"));
                }
                switch (slotIndex) {
                    case 0: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.crafting_table"));
                        break;
                    }
                    case 1: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.hopper"));
                        break;
                    }
                    case 2: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.chest"));
                        break;
                    }
                    case 3: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.barrel"));
                        break;
                    }
                    case 4: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.dragon_egg"));
                        break;
                    }
                    case 5: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.spectral_arrow"));
                        break;
                    }
                    case 6: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.bed"));
                        break;
                    }
                    case 7: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.experience_bottle"));
                        break;
                    }
                    case 8: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_desc.piston"));
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_piston.auto_refill"));
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_piston.block_rotation"));
                        break;
                    }
                    case 9: {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.enchanted_golden_apple.title"));
                        AutoEatMode currentMode = ClientUpgradeState.getCurrentAutoEatMode();
                        if (currentMode.isEnabled()) {
                            tooltipLines.add(class_2561.method_43469((String)"portable-storage.enchanted_golden_apple.feed_count", (Object[])new Object[]{currentMode.getFeedCount()}));
                        } else {
                            tooltipLines.add(class_2561.method_43471((String)"portable-storage.enchanted_golden_apple.feed_disabled"));
                        }
                        tooltipLines.add(class_2561.method_43473());
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.enchanted_golden_apple.interact.right_click"));
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.enchanted_golden_apple.interact.middle_click"));
                    }
                }
                if (hasItem && isDisabled) {
                    tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_disabled"));
                }
                if (slotIndex == 4) {
                    tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_right_click_dragon_egg"));
                } else if (slotIndex == 6) {
                    tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_right_click_bed"));
                } else if (slotIndex == 7) {
                    tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_right_click_xp"));
                    tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_middle_click_maintenance"));
                    int currentStep = ClientUpgradeState.getXpTransferStep();
                    int[] steps = new int[]{1, 5, 10, 100};
                    int level = steps[currentStep];
                    tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.upgrade_current_step", (Object[])new Object[]{level}));
                } else if (slotIndex == 0) {
                    tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_right_click_custom_crafting"));
                    if (ClientVirtualCraftingConfig.isEnableVirtualCrafting()) {
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_middle_click_virtual_crafting"));
                        boolean virtualCraftingVisible = ClientConfig.getInstance().virtualCraftingVisible;
                        class_5250 virtualCraftingStatus = virtualCraftingVisible ? class_2561.method_43471((String)"portable-storage.toggle.enabled") : class_2561.method_43471((String)"portable-storage.toggle.disabled");
                        tooltipLines.add(class_2561.method_43469((String)"portable-storage.ui.upgrade_virtual_crafting_status", (Object[])new Object[]{virtualCraftingStatus}));
                        tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_virtual_crafting_warning"));
                    }
                } else if (slotIndex != 9) {
                    tooltipLines.add(class_2561.method_43471((String)"portable-storage.ui.upgrade_right_click_hint"));
                }
                context.method_51434(client.field_1772, tooltipLines, mouseX, mouseY);
            }
        } else if (!hoveredStack.method_7960()) {
            List<class_5250> lines;
            if (hoveredIndex == Integer.MIN_VALUE) {
                long totalXp = ClientUpgradeState.getCachedXpPool();
                int level = this.portableStorage$levelFromTotalXp((int)Math.min(Integer.MAX_VALUE, totalXp));
                lines = new ArrayList();
                lines.add(class_2561.method_43471((String)"portable-storage.exp_bottle.title"));
                lines.add(class_2561.method_43469((String)"portable-storage.exp_bottle.current", (Object[])new Object[]{String.valueOf(totalXp)}));
                lines.add(class_2561.method_43469((String)"portable-storage.exp_bottle.equivalent", (Object[])new Object[]{String.valueOf(level)}));
                lines.add(class_2561.method_43473());
                lines.add(class_2561.method_43471((String)"portable-storage.exp_bottle.interact.left_click"));
                lines.add(class_2561.method_43471((String)"portable-storage.exp_bottle.interact.right_click"));
                lines.add(class_2561.method_43471((String)"portable-storage.exp_bottle.interact.glass_bottle"));
            } else if (hoveredIndex == -2147483638) {
                lines = new ArrayList<class_5250>();
                lines.add(class_2561.method_43471((String)"portable-storage.ui.clear_search"));
                lines.add(class_2561.method_43471((String)"portable-storage.ui.clear_search.hint"));
            } else if (hoveredIndex < -2147482648) {
                String fluidType = this.getFluidTypeFromVirtualIndex(hoveredIndex);
                if (fluidType != null) {
                    int units = ClientUpgradeState.getFluidUnits(fluidType);
                    lines = new ArrayList();
                    lines.add(class_2561.method_43471((String)("portable-storage.fluid." + fluidType + ".title")));
                    String unitsText = ClientInfiniteFluidConfig.shouldShowInfinite(fluidType, units) ? class_2561.method_43471((String)"portable-storage.fluid.infinite").getString() : String.valueOf(units);
                    lines.add(class_2561.method_43469((String)"portable-storage.fluid.units", (Object[])new Object[]{unitsText}));
                    lines.add(class_2561.method_43471((String)"portable-storage.fluid.desc"));
                } else {
                    lines = class_437.method_25408((class_310)client, (class_1799)hoveredStack);
                }
            } else {
                lines = class_437.method_25408((class_310)client, (class_1799)hoveredStack);
            }
            if (hoveredIndex >= 0) {
                long timestamp;
                long exact = ClientStorageState.getCount(hoveredIndex);
                if (exact > 999L) {
                    String exactStr = String.format(Locale.US, "%,d", exact);
                    lines.add(1, class_2561.method_43470((String)exactStr));
                }
                if ((timestamp = ClientStorageState.getTimestamp(hoveredIndex)) > 0L) {
                    String timeStr = this.formatTimestamp(timestamp);
                    lines.add(1, class_2561.method_43469((String)"portable-storage.tooltip.last_modified", (Object[])new Object[]{timeStr}));
                }
            }
            context.method_51434(client.field_1772, lines, mouseX, mouseY);
        }
    }

    private void renderScrollbar(class_332 context) {
        int trackLeft = this.gridLeft + 162 + 4;
        int trackTop = this.gridTop;
        int trackHeight = this.visibleRows * 18;
        int trackWidth = 6;
        this.scrollbarLeft = trackLeft;
        this.scrollbarTop = trackTop;
        this.scrollbarHeight = trackHeight;
        this.scrollbarWidth = trackWidth;
        int maxScrollRows = Math.max(0, this.totalRows - this.visibleRows);
        this.drawScrollbar(context, trackLeft, trackTop, trackWidth, trackHeight, maxScrollRows, this.visibleRows, this.totalRows, this.scroll);
    }

    private void updateScrollbarDrag(double mouseX, double mouseY) {
        int height;
        boolean leftDown;
        long window;
        class_310 mc;
        if (this.dragUpgradeScrollbar) {
            mc = class_310.method_1551();
            window = mc != null && mc.method_22683() != null ? mc.method_22683().method_4490() : 0L;
            leftDown = false;
            if (window != 0L) {
                boolean bl = leftDown = GLFW.glfwGetMouseButton((long)window, (int)0) == 1;
            }
            if (!leftDown) {
                this.dragUpgradeScrollbar = false;
            } else {
                height = this.upgradeScrollbarHeight;
                int upgradeVisibleRows = this.calculateUpgradeVisibleRows();
                int leftColumnMaxRows = ClientUpgradeState.isChestUpgradeActive() ? 5 : 0;
                int rightColumnMaxRows = 7;
                int maxRowsInAnyColumn = Math.max(leftColumnMaxRows, rightColumnMaxRows);
                int visible = upgradeVisibleRows;
                int total = Math.max(visible, maxRowsInAnyColumn);
                int thumbMin = 8;
                int thumbHeight = Math.max(thumbMin, (int)((float)height * ((float)visible / (float)total)));
                int maxScrollPx = Math.max(1, height - thumbHeight);
                int top = this.upgradeScrollbarTop;
                int mouseOffset = (int)mouseY - top - this.dragUpgradeGrabOffset;
                float newScroll = (float)mouseOffset / (float)maxScrollPx;
                this.upgradeScroll = Math.max(0.0f, Math.min(1.0f, newScroll));
            }
        }
        if (this.dragScrollbar) {
            mc = class_310.method_1551();
            window = mc != null && mc.method_22683() != null ? mc.method_22683().method_4490() : 0L;
            leftDown = false;
            if (window != 0L) {
                boolean bl = leftDown = GLFW.glfwGetMouseButton((long)window, (int)0) == 1;
            }
            if (!leftDown) {
                this.dragScrollbar = false;
            } else {
                height = this.scrollbarHeight;
                int visible = this.visibleRows;
                int total = Math.max(visible, this.totalRows);
                int thumbMin = 8;
                int thumbHeight = Math.max(thumbMin, (int)((float)height * ((float)visible / (float)total)));
                int maxScrollPx = Math.max(1, height - thumbHeight);
                int top = this.scrollbarTop;
                int mouseOffset = (int)mouseY - top - this.dragGrabOffset;
                float newScroll = (float)mouseOffset / (float)maxScrollPx;
                this.scroll = Math.max(0.0f, Math.min(1.0f, newScroll));
                ClientPlayNetworking.send((class_8710)new ScrollC2SPayload(this.scroll));
            }
        }
    }

    private void renderUpgradeSlots(class_332 context, int upgradeLeft) {
        int extendedLeft;
        int rightColumnMaxRows;
        int upgradeTop = this.gridTop;
        int upgradeVisibleRows = this.calculateUpgradeVisibleRows();
        int leftColumnMaxRows = ClientUpgradeState.isChestUpgradeActive() ? 6 : 0;
        int maxRowsInAnyColumn = Math.max(leftColumnMaxRows, rightColumnMaxRows = 6);
        int maxUpgradeScrollRows = Math.max(0, maxRowsInAnyColumn - upgradeVisibleRows);
        if (maxUpgradeScrollRows <= 0) {
            this.upgradeScroll = 0.0f;
        }
        int upgradeRowOffset = (int)Math.floor(this.upgradeScroll * (float)maxUpgradeScrollRows + 0.5f);
        upgradeRowOffset = Math.max(0, Math.min(maxUpgradeScrollRows, upgradeRowOffset));
        int maxVisibleUpgradeSlots = upgradeVisibleRows;
        if (ClientUpgradeState.isChestUpgradeActive()) {
            extendedLeft = upgradeLeft - 20;
            for (int i = 0; i < 5; ++i) {
                int slotIndex = 5 + i;
                int displayRow = i + 1 - upgradeRowOffset;
                if (displayRow < 0 || displayRow >= maxVisibleUpgradeSlots) continue;
                int sx = extendedLeft;
                int sy = upgradeTop + displayRow * 18;
                this.drawSlotInset(context, sx, sy, 18, 18);
                this.upgradeSlotLefts[slotIndex] = sx;
                this.upgradeSlotTops[slotIndex] = sy;
                this.upgradeSlotRights[slotIndex] = sx + 18;
                this.upgradeSlotBottoms[slotIndex] = sy + 18;
                class_1799 upgradeStack = ClientUpgradeState.getStack(slotIndex);
                class_1799 expectedStack = UpgradeInventory.getExpectedUpgradeForSlot(slotIndex);
                if (!upgradeStack.method_7960()) {
                    context.method_51427(upgradeStack, sx + 1, sy + 1);
                    if (!ClientUpgradeState.isSlotDisabled(slotIndex)) continue;
                    context.method_51448().method_22903();
                    context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                    context.method_25294(sx + 1, sy + 1, sx + 18 - 1, sy + 18 - 1, -2130771968);
                    context.method_51448().method_22909();
                    continue;
                }
                context.method_51427(expectedStack, sx + 1, sy + 1);
                context.method_51448().method_22903();
                context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                context.method_25294(sx + 1, sy + 1, sx + 18 - 1, sy + 18 - 1, -2130706433);
                context.method_51448().method_22909();
            }
        }
        for (int i = 0; i < 5; ++i) {
            int displayRow = i + 1 - upgradeRowOffset;
            if (displayRow < 0 || displayRow >= maxVisibleUpgradeSlots) continue;
            int sx = upgradeLeft;
            int sy = upgradeTop + displayRow * 18;
            this.drawSlotInset(context, sx, sy, 18, 18);
            this.upgradeSlotLefts[i] = sx;
            this.upgradeSlotTops[i] = sy;
            this.upgradeSlotRights[i] = sx + 18;
            this.upgradeSlotBottoms[i] = sy + 18;
            class_1799 upgradeStack = ClientUpgradeState.getStack(i);
            class_1799 expectedStack = UpgradeInventory.getExpectedUpgradeForSlot(i);
            if (!upgradeStack.method_7960()) {
                context.method_51427(upgradeStack, sx + 1, sy + 1);
                if (!ClientUpgradeState.isSlotDisabled(i)) continue;
                context.method_51448().method_22903();
                context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                context.method_25294(sx + 1, sy + 1, sx + 18 - 1, sy + 18 - 1, -2130771968);
                context.method_51448().method_22909();
                continue;
            }
            context.method_51427(expectedStack, sx + 1, sy + 1);
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            context.method_25294(sx + 1, sy + 1, sx + 18 - 1, sy + 18 - 1, -2130706433);
            context.method_51448().method_22909();
        }
        if (ClientUpgradeState.isChestUpgradeActive()) {
            extendedLeft = upgradeLeft - 20;
            int trashDisplayRow = 0 - upgradeRowOffset;
            if (trashDisplayRow >= 0 && trashDisplayRow < maxVisibleUpgradeSlots) {
                int trashSlotY = upgradeTop + trashDisplayRow * 18;
                this.drawSlotInset(context, extendedLeft, trashSlotY, 18, 18);
                this.trashSlotLeft = extendedLeft;
                this.trashSlotTop = trashSlotY;
                this.trashSlotRight = extendedLeft + 18;
                this.trashSlotBottom = trashSlotY + 18;
                class_1799 trashStack = ClientUpgradeState.getTrashStack();
                if (!trashStack.method_7960()) {
                    context.method_51427(trashStack, extendedLeft + 1, trashSlotY + 1);
                } else {
                    context.method_51448().method_22903();
                    context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                    context.method_25290(TEX_DELETE, extendedLeft + 1, trashSlotY + 1, 0.0f, 0.0f, 16, 16, 16, 16);
                    context.method_51448().method_22909();
                    context.method_51448().method_22903();
                    context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                    context.method_25294(extendedLeft + 1, trashSlotY + 1, extendedLeft + 18 - 1, trashSlotY + 18 - 1, -2130706433);
                    context.method_51448().method_22909();
                }
            } else {
                this.trashSlotBottom = -1;
                this.trashSlotRight = -1;
                this.trashSlotTop = -1;
                this.trashSlotLeft = -1;
            }
        } else {
            this.trashSlotBottom = -1;
            this.trashSlotRight = -1;
            this.trashSlotTop = -1;
            this.trashSlotLeft = -1;
        }
        int fluidDisplayRow = 0 - upgradeRowOffset;
        if (fluidDisplayRow >= 0 && fluidDisplayRow < maxVisibleUpgradeSlots) {
            int fluidSlotY = upgradeTop + fluidDisplayRow * 18;
            this.drawSlotInset(context, upgradeLeft, fluidSlotY, 18, 18);
            this.fluidSlotLeft = upgradeLeft;
            this.fluidSlotTop = fluidSlotY;
            this.fluidSlotRight = upgradeLeft + 18;
            this.fluidSlotBottom = fluidSlotY + 18;
            class_1799 fluidStack = ClientUpgradeState.getFluidStack();
            class_1799 expectedFluidStack = UpgradeInventory.getExpectedFluidForSlot();
            if (!fluidStack.method_7960()) {
                context.method_51427(fluidStack, upgradeLeft + 1, fluidSlotY + 1);
            } else {
                context.method_51427(expectedFluidStack, upgradeLeft + 1, fluidSlotY + 1);
                context.method_51448().method_22903();
                context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                context.method_25294(upgradeLeft + 1, fluidSlotY + 1, upgradeLeft + 18 - 1, fluidSlotY + 18 - 1, -2130706433);
                context.method_51448().method_22909();
            }
        } else {
            this.fluidSlotBottom = -1;
            this.fluidSlotRight = -1;
            this.fluidSlotTop = -1;
            this.fluidSlotLeft = -1;
        }
        if (maxUpgradeScrollRows > 0) {
            this.renderUpgradeScrollbar(context, upgradeLeft, upgradeTop, upgradeVisibleRows, maxRowsInAnyColumn, upgradeVisibleRows);
        }
    }

    private void renderUpgradeScrollbar(class_332 context, int upgradeLeft, int upgradeTop, int visibleRows, int totalRows, int upgradeVisibleRows) {
        int trackLeft = upgradeLeft + 18 + 4;
        int trackTop = upgradeTop;
        int trackHeight = upgradeVisibleRows * 18;
        int trackWidth = 6;
        this.upgradeScrollbarLeft = trackLeft;
        this.upgradeScrollbarTop = trackTop;
        this.upgradeScrollbarHeight = trackHeight;
        this.upgradeScrollbarWidth = trackWidth;
        int maxUpgradeScrollRows = Math.max(0, totalRows - visibleRows);
        this.drawScrollbar(context, trackLeft, trackTop, trackWidth, trackHeight, maxUpgradeScrollRows, visibleRows, totalRows, this.upgradeScroll);
    }

    private void renderSettingsPanel(class_332 context, class_310 client, ClientConfig config, final int panelLeft, int panelWidth, boolean enableCollapse) {
        final int panelTop = this.gridTop - 6;
        final int panelBottom = this.gridTop + this.visibleRows * 18 + 8;
        int iconSize = 16;
        int iconSpacing = 15;
        int columnWidth = 17;
        final int[] position = new int[]{0, 0, panelLeft + 2, panelTop};
        @Environment(value=EnvType.CLIENT)
        class IconPositionCalculator {
            IconPositionCalculator() {
            }

            void nextPosition() {
                position[1] = position[1] + 1;
                int nextIconY = panelTop + position[1] * 15;
                int nextIconBottom = nextIconY + 16;
                if (nextIconBottom > panelBottom) {
                    position[1] = 0;
                    position[0] = position[0] + 1;
                    position[2] = panelLeft + 2 + position[0] * 17;
                    position[3] = panelTop;
                } else {
                    position[3] = nextIconY;
                }
            }
        }
        IconPositionCalculator positionCalc = new IconPositionCalculator();
        if (enableCollapse) {
            this.drawIcon(context, 1, 1, position[2], position[3]);
            this.collapseLeft = position[2];
            this.collapseTop = position[3];
            this.collapseRight = position[2] + 16;
            this.collapseBottom = position[3] + 16;
            positionCalc.nextPosition();
        }
        int sortModeRow = 1;
        int sortModeCol = 2;
        switch (config.sortMode) {
            case COUNT: {
                sortModeRow = 1;
                sortModeCol = 2;
                break;
            }
            case NAME: {
                sortModeRow = 1;
                sortModeCol = 3;
                break;
            }
            case MOD_ID: {
                sortModeRow = 1;
                sortModeCol = 4;
                break;
            }
            case UPDATE_TIME: {
                sortModeRow = 1;
                sortModeCol = 5;
            }
        }
        this.drawIcon(context, sortModeRow, sortModeCol, position[2], position[3]);
        this.sortModeLeft = position[2];
        this.sortModeTop = position[3];
        this.sortModeRight = position[2] + 16;
        this.sortModeBottom = position[3] + 16;
        positionCalc.nextPosition();
        int sortOrderRow = 2;
        int sortOrderCol = config.sortAscending ? 1 : 2;
        this.drawIcon(context, sortOrderRow, sortOrderCol, position[2], position[3]);
        this.sortOrderLeft = position[2];
        this.sortOrderTop = position[3];
        this.sortOrderRight = position[2] + 16;
        this.sortOrderBottom = position[3] + 16;
        positionCalc.nextPosition();
        int craftRefillRow = 2;
        int craftRefillCol = config.craftRefill ? 3 : 4;
        this.drawIcon(context, craftRefillRow, craftRefillCol, position[2], position[3]);
        this.craftRefillLeft = position[2];
        this.craftRefillTop = position[3];
        this.craftRefillRight = position[2] + 16;
        this.craftRefillBottom = position[3] + 16;
        positionCalc.nextPosition();
        int autoDepositRow = 2;
        int autoDepositCol = config.autoDeposit ? 5 : 5;
        this.drawIcon(context, autoDepositRow, autoDepositCol, position[2], position[3]);
        this.autoDepositLeft = position[2];
        this.autoDepositTop = position[3];
        this.autoDepositRight = position[2] + 16;
        this.autoDepositBottom = position[3] + 16;
        positionCalc.nextPosition();
        int smartCollapseRow = 3;
        int smartCollapseCol = config.smartCollapse ? 1 : 2;
        this.drawIcon(context, smartCollapseRow, smartCollapseCol, position[2], position[3]);
        this.smartCollapseLeft = position[2];
        this.smartCollapseTop = position[3];
        this.smartCollapseRight = position[2] + 16;
        this.smartCollapseBottom = position[3] + 16;
        positionCalc.nextPosition();
        if (this.portableStorage$isInventoryOrCraftingScreen()) {
            int searchPosRow = 3;
            this.drawIcon(context, searchPosRow, switch (config.searchPos) {
                case ClientConfig.SearchPos.BOTTOM -> 3;
                case ClientConfig.SearchPos.TOP -> 3;
                case ClientConfig.SearchPos.TOP2 -> 3;
                case ClientConfig.SearchPos.MIDDLE -> 3;
                default -> 3;
            }, position[2], position[3]);
            this.searchPosLeft = position[2];
            this.searchPosTop = position[3];
            this.searchPosRight = position[2] + 16;
            this.searchPosBottom = position[3] + 16;
            positionCalc.nextPosition();
        } else {
            this.searchPosLeft = 0;
            this.searchPosTop = 0;
            this.searchPosRight = 0;
            this.searchPosBottom = 0;
        }
        int storagePosRow = 3;
        int storagePosCol = config.storagePos == ClientConfig.StoragePos.TOP ? 4 : 4;
        this.drawIcon(context, storagePosRow, storagePosCol, position[2], position[3]);
        this.storagePosLeft = position[2];
        this.storagePosTop = position[3];
        this.storagePosRight = position[2] + 16;
        this.storagePosBottom = position[3] + 16;
        positionCalc.nextPosition();
        if (this.switchToVanillaCallback != null) {
            this.drawIcon(context, 3, 5, position[2], position[3]);
            this.switchVanillaLeft = position[2];
            this.switchVanillaTop = position[3];
            this.switchVanillaRight = position[2] + 16;
            this.switchVanillaBottom = position[3] + 16;
            positionCalc.nextPosition();
        }
    }

    private void updateSearchFieldPosition() {
        int fieldY;
        if (this.searchField == null) {
            return;
        }
        ClientConfig cfg = ClientConfig.getInstance();
        int fieldWidth = 162;
        int fieldX = this.gridLeft;
        int h = this.searchField.method_25364();
        if (cfg.storagePos == ClientConfig.StoragePos.TOP) {
            switch (cfg.searchPos) {
                case TOP: {
                    fieldY = this.gridTop - h - 6;
                    break;
                }
                case MIDDLE: {
                    fieldY = this.baseY - h;
                    break;
                }
                default: {
                    fieldY = this.baseY + this.baseBgH + 6;
                    break;
                }
                case TOP2: {
                    fieldY = this.gridTop - h - 6;
                    break;
                }
            }
        } else {
            switch (cfg.searchPos) {
                case TOP: {
                    fieldY = this.baseY - h - 6;
                    break;
                }
                case TOP2: {
                    fieldY = this.baseY - h - 6 - 18;
                    break;
                }
                case MIDDLE: {
                    fieldY = this.baseY + this.baseBgH + 1;
                    break;
                }
                default: {
                    fieldY = this.gridTop + this.visibleRows * 18 + 6;
                }
            }
        }
        this.searchField.method_25358(fieldWidth);
        this.searchField.method_46421(fieldX);
        this.searchField.method_46419(fieldY);
    }

    private List<Integer> buildFilteredIndices() {
        boolean expandForSearch;
        this.collapsedInfoByRep.clear();
        ArrayList<Integer> result = new ArrayList<Integer>();
        class_2371<class_1799> stacks = ClientStorageState.getStacks();
        boolean smartCollapse = ClientConfig.getInstance().smartCollapse;
        boolean bl = expandForSearch = this.query != null && !this.query.isEmpty();
        if (smartCollapse && !expandForSearch) {
            HashMap<String, List> groups = new HashMap<String, List>();
            for (int i = 0; i < stacks.size(); ++i) {
                class_1799 stack = (class_1799)stacks.get(i);
                if (stack == null || stack.method_7960() || !this.query.isEmpty() && !this.matchesQuery(stack, this.query)) continue;
                String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
                groups.computeIfAbsent(id, k -> new ArrayList()).add(i);
            }
            for (Map.Entry entry : groups.entrySet()) {
                List indices = (List)entry.getValue();
                if (indices.isEmpty()) continue;
                if (indices.size() == 1) {
                    result.add((Integer)indices.get(0));
                    continue;
                }
                int rep = (Integer)indices.get(0);
                long total = 0L;
                Iterator iterator = indices.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    total += ClientStorageState.getCount(idx);
                }
                if (total <= 1L) {
                    result.add(rep);
                    continue;
                }
                class_1799 repStack = (class_1799)stacks.get(rep);
                class_1799 display = new class_1799((class_1935)repStack.method_7909());
                display.method_57379(class_9334.field_49641, (Object)true);
                CollapsedInfo info = new CollapsedInfo();
                info.displayStack = display;
                info.totalCount = (int)Math.min(Integer.MAX_VALUE, total);
                info.itemId = (String)entry.getKey();
                this.collapsedInfoByRep.put(rep, info);
                result.add(rep);
            }
        } else {
            for (int i = 0; i < stacks.size(); ++i) {
                class_1799 stack = (class_1799)stacks.get(i);
                if (stack == null || stack.method_7960() || !this.query.isEmpty() && !this.matchesQuery(stack, this.query)) continue;
                result.add(i);
            }
        }
        this.sortIndices(result);
        return result;
    }

    private boolean matchesQuery(class_1799 stack, String q) {
        String lower = q.toLowerCase(Locale.ROOT);
        if (lower.startsWith("@")) {
            String modId = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836();
            return modId.contains(lower.substring(1));
        }
        if (lower.startsWith("#")) {
            List tooltip = class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack);
            for (class_2561 line : tooltip) {
                if (!line.getString().toLowerCase(Locale.ROOT).contains(lower.substring(1))) continue;
                return true;
            }
            return false;
        }
        String name = stack.method_7964().getString();
        String fullId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        return PinyinSearchHelper.matches(name, lower) || fullId.toLowerCase(Locale.ROOT).contains(lower);
    }

    private boolean matchesVirtualFluidQuery(String fluidType, String q) {
        String lower = q.toLowerCase(Locale.ROOT);
        String fluidName = class_2561.method_43471((String)("portable-storage.fluid." + fluidType + ".title")).getString();
        if (PinyinSearchHelper.matches(fluidName, lower)) {
            return true;
        }
        String fluidDesc = class_2561.method_43471((String)"portable-storage.fluid.desc").getString();
        if (PinyinSearchHelper.matches(fluidDesc, lower)) {
            return true;
        }
        String fluidNameEn = switch (fluidType) {
            case "lava" -> "lava";
            case "water" -> "water";
            case "milk" -> "milk";
            default -> fluidType;
        };
        return fluidNameEn.toLowerCase(Locale.ROOT).contains(lower);
    }

    private boolean matchesXpBottleQuery(String q) {
        String lower = q.toLowerCase(Locale.ROOT);
        String xpBottleTitle = class_2561.method_43471((String)"portable-storage.exp_bottle.title").getString();
        String xpBottleCurrent = class_2561.method_43469((String)"portable-storage.exp_bottle.current", (Object[])new Object[]{""}).getString();
        String xpBottleEquivalent = class_2561.method_43469((String)"portable-storage.exp_bottle.equivalent", (Object[])new Object[]{""}).getString();
        if (PinyinSearchHelper.matches(xpBottleTitle, lower) || PinyinSearchHelper.matches(xpBottleCurrent, lower) || PinyinSearchHelper.matches(xpBottleEquivalent, lower)) {
            return true;
        }
        return PinyinSearchHelper.matches("\u7ecf\u9a8c", lower) || "experience".toLowerCase(Locale.ROOT).contains(lower) || "xp".toLowerCase(Locale.ROOT).contains(lower);
    }

    private void sortIndices(List<Integer> indices) {
        ClientConfig config = ClientConfig.getInstance();
        class_2371<class_1799> stacks = ClientStorageState.getStacks();
        boolean ascending = config.sortAscending;
        Comparator comparator = (a, b) -> {
            class_1799 stackA = (class_1799)stacks.get(a.intValue());
            class_1799 stackB = (class_1799)stacks.get(b.intValue());
            int cmp = switch (config.sortMode) {
                default -> throw new MatchException(null, null);
                case ClientConfig.SortMode.COUNT -> Long.compare(ClientStorageState.getCount(a), ClientStorageState.getCount(b));
                case ClientConfig.SortMode.NAME -> {
                    String nameA = stackA.method_7964().getString();
                    String nameB = stackB.method_7964().getString();
                    yield nameA.compareToIgnoreCase(nameB);
                }
                case ClientConfig.SortMode.MOD_ID -> {
                    String modA = class_7923.field_41178.method_10221((Object)stackA.method_7909()).method_12836();
                    String modB = class_7923.field_41178.method_10221((Object)stackB.method_7909()).method_12836();
                    int modCmp = modA.compareToIgnoreCase(modB);
                    if (modCmp != 0) {
                        yield modCmp;
                    }
                    String nameA = stackA.method_7964().getString();
                    String nameB = stackB.method_7964().getString();
                    yield nameA.compareToIgnoreCase(nameB);
                }
                case ClientConfig.SortMode.UPDATE_TIME -> Long.compare(ClientStorageState.getTimestamp(a), ClientStorageState.getTimestamp(b));
            };
            return ascending ? cmp : -cmp;
        };
        indices.sort(comparator);
    }

    private String formatCount(long count) {
        if (count < 1000L) {
            return String.valueOf(count);
        }
        if (count < 1000000L) {
            double v = (double)count / 1000.0;
            return v < 10.0 ? String.format(Locale.US, "%.1fk", Math.floor(v * 10.0) / 10.0) : String.format(Locale.US, "%.0fk", Math.floor(v));
        }
        if (count < 1000000000L) {
            double v = (double)count / 1000000.0;
            return v < 10.0 ? String.format(Locale.US, "%.1fM", Math.floor(v * 10.0) / 10.0) : String.format(Locale.US, "%.0fM", Math.floor(v));
        }
        if (count < 1000000000000L) {
            double v = (double)count / 1.0E9;
            return v < 10.0 ? String.format(Locale.US, "%.1fG", Math.floor(v * 10.0) / 10.0) : String.format(Locale.US, "%.0fG", Math.floor(v));
        }
        if (count < 1000000000000000L) {
            double v = (double)count / 1.0E12;
            return v < 10.0 ? String.format(Locale.US, "%.1fT", Math.floor(v * 10.0) / 10.0) : String.format(Locale.US, "%.0fT", Math.floor(v));
        }
        if (count < 1000000000000000000L) {
            double v = (double)count / 1.0E15;
            return v < 10.0 ? String.format(Locale.US, "%.1fP", Math.floor(v * 10.0) / 10.0) : String.format(Locale.US, "%.0fP", Math.floor(v));
        }
        double v = (double)count / 1.0E18;
        return v < 10.0 ? String.format(Locale.US, "%.1fE", Math.floor(v * 10.0) / 10.0) : String.format(Locale.US, "%.0fE", Math.floor(v));
    }

    private String formatTimestamp(long timestamp) {
        if (timestamp <= 0L) {
            return "\u672a\u77e5";
        }
        Instant instant = Instant.ofEpochMilli(timestamp);
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy MM-dd HH:mm");
        return dateTime.format(formatter);
    }

    private int portableStorage$xpToNextLevel(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    private int portableStorage$levelFromTotalXp(int total) {
        total = Math.max(0, total);
        int lvl = 0;
        int remain = total;
        do {
            int need;
            if (remain < (need = this.portableStorage$xpToNextLevel(lvl))) {
                return lvl;
            }
            remain -= need;
        } while (++lvl <= 10000);
        return lvl;
    }

    private int calculatePanelWidth(class_310 client, ClientConfig config, boolean enableCollapse) {
        int settingCount = 0;
        if (enableCollapse) {
            ++settingCount;
        }
        settingCount += 4;
        ++settingCount;
        if (this.portableStorage$isInventoryOrCraftingScreen()) {
            ++settingCount;
        }
        ++settingCount;
        if (this.switchToVanillaCallback != null) {
            ++settingCount;
        }
        int panelTop = this.gridTop - 6;
        int panelBottom = this.gridTop + this.visibleRows * 18 + 8;
        int iconSpacing = 15;
        int iconSize = 16;
        int currentColumn = 0;
        int currentRow = 0;
        for (int i = 0; i < settingCount; ++i) {
            int nextIconY = panelTop + currentRow * 15;
            int nextIconBottom = nextIconY + 16;
            if (nextIconBottom > panelBottom) {
                currentRow = 0;
                ++currentColumn;
                continue;
            }
            ++currentRow;
        }
        int columns = currentColumn + 1;
        int columnWidth = 18;
        int padding = 4;
        return columns * 18 + 4;
    }

    private int calculateAdaptiveHeight(int screenHeight, int inventoryTop, int inventoryBottom, ClientConfig config) {
        int availableHeight = config.storagePos == ClientConfig.StoragePos.TOP ? inventoryTop - 20 : screenHeight - inventoryBottom - 20;
        int slotHeight = 18;
        int maxRows = Math.max(2, availableHeight / slotHeight);
        int configMaxRows = config.maxVisibleRows;
        return Math.min(configMaxRows, Math.max(2, maxRows));
    }

    private int calculateUpgradeVisibleRows() {
        return this.visibleRows;
    }

    private void drawExtensionBackground(class_332 ctx, int x, int y, int w, int h) {
        int texW = 75;
        int texH = 122;
        int border = 4;
        int srcLeft = 4;
        int srcRight = 71;
        int srcTop = 4;
        int srcBottom = 118;
        int dstMidW = Math.max(0, w - 8);
        int dstMidH = Math.max(0, h - 8);
        int srcMidW = 67;
        int srcMidH = 114;
        ctx.method_25290(TEX_BG, x, y, 0.0f, 0.0f, 4, 4, 75, 122);
        ctx.method_25290(TEX_BG, x + w - 4, y, (float)srcRight, 0.0f, 4, 4, 75, 122);
        ctx.method_25290(TEX_BG, x, y + h - 4, 0.0f, (float)srcBottom, 4, 4, 75, 122);
        ctx.method_25290(TEX_BG, x + w - 4, y + h - 4, (float)srcRight, (float)srcBottom, 4, 4, 75, 122);
        if (dstMidW > 0) {
            this.drawRegionScaled(ctx, TEX_BG, x + 4, y, srcLeft, 0, srcMidW, 4, dstMidW, 4, 75, 122);
            this.drawRegionScaled(ctx, TEX_BG, x + 4, y + h - 4, srcLeft, srcBottom, srcMidW, 4, dstMidW, 4, 75, 122);
        }
        if (dstMidH > 0) {
            this.drawRegionScaled(ctx, TEX_BG, x, y + 4, 0, srcTop, 4, srcMidH, 4, dstMidH, 75, 122);
            this.drawRegionScaled(ctx, TEX_BG, x + w - 4, y + 4, srcRight, srcTop, 4, srcMidH, 4, dstMidH, 75, 122);
        }
        if (dstMidW > 0 && dstMidH > 0) {
            this.drawRegionScaled(ctx, TEX_BG, x + 4, y + 4, srcLeft, srcTop, srcMidW, srcMidH, dstMidW, dstMidH, 75, 122);
        }
    }

    private void drawRegionScaled(class_332 ctx, class_2960 tex, int x, int y, int u, int v, int srcW, int srcH, int dstW, int dstH, int texW, int texH) {
        if (srcW <= 0 || srcH <= 0 || dstW <= 0 || dstH <= 0) {
            return;
        }
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)x, (float)y, 0.0f);
        float scaleX = (float)dstW / (float)srcW;
        float scaleY = (float)dstH / (float)srcH;
        ctx.method_51448().method_22905(scaleX, scaleY, 1.0f);
        ctx.method_25290(tex, 0, 0, (float)u, (float)v, srcW, srcH, texW, texH);
        ctx.method_51448().method_22909();
    }

    private void drawIcon(class_332 context, int row, int col, int x, int y) {
        int iconSize = 16;
        int cols = 5;
        int rows = 3;
        int srcX = (col - 1) * 16;
        int srcY = (row - 1) * 16;
        context.method_25290(TEX_ICONS, x, y, (float)srcX, (float)srcY, 16, 16, 80, 48);
    }

    private void drawPanel(class_332 ctx, int x, int y, int w, int h) {
        this.drawExtensionBackground(ctx, x, y, w, h);
    }

    private void drawSlotInset(class_332 ctx, int x, int y, int w, int h) {
        ctx.method_25290(TEX_SLOT, x, y, 0.0f, 0.0f, w, h, 18, 18);
    }

    private void drawScrollbar(class_332 ctx, int left, int top, int width, int height, int maxScrollRows, int visibleSlots, int totalSlots, float scroll) {
        int track = 0x55000000;
        ctx.method_25294(left, top, left + width, top + height, track);
        int visible = visibleSlots;
        int total = Math.max(visible, totalSlots);
        float frac = (float)visible / (float)total;
        int thumbMin = 8;
        int thumbHeight = Math.max(thumbMin, (int)((float)height * frac));
        int maxScrollPx = height - thumbHeight;
        int thumbOffset = maxScrollRows <= 0 ? 0 : (int)(scroll * (float)maxScrollPx);
        int thumbTop = top + thumbOffset;
        int thumbBg = -6710887;
        int thumbDark = -11184811;
        int thumbLight = -1;
        ctx.method_25294(left, thumbTop, left + width, thumbTop + thumbHeight, thumbBg);
        ctx.method_25294(left, thumbTop, left + width, thumbTop + 1, thumbDark);
        ctx.method_25294(left + width - 1, thumbTop, left + width, thumbTop + thumbHeight, thumbDark);
        ctx.method_25294(left, thumbTop + thumbHeight - 1, left + width, thumbTop + thumbHeight, thumbLight);
        ctx.method_25294(left, thumbTop, left + 1, thumbTop + thumbHeight, thumbLight);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean enableCollapse) {
        int height;
        if (enableCollapse && this.collapsed) {
            if (button == 0 && this.isIn(mouseX, mouseY, this.expandTabLeft, this.expandTabTop, this.expandTabRight, this.expandTabBottom)) {
                this.collapsed = false;
                ClientConfig.getInstance().collapsed = false;
                ClientConfig.save();
                if (this.searchField != null) {
                    this.searchField.method_25365(false);
                }
                return true;
            }
            return false;
        }
        if (this.searchField != null) {
            if (this.searchField.method_25402(mouseX, mouseY, button)) {
                this.searchField.method_25365(true);
                return true;
            }
            this.searchField.method_25365(false);
        }
        if (this.isIn(mouseX, mouseY, this.fluidSlotLeft, this.fluidSlotTop, this.fluidSlotRight, this.fluidSlotBottom)) {
            ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.FLUID, 0, button, 0, "", 0));
            return true;
        }
        if (this.isIn(mouseX, mouseY, this.trashSlotLeft, this.trashSlotTop, this.trashSlotRight, this.trashSlotBottom)) {
            ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.TRASH, 0, button, 0, "", 0));
            return true;
        }
        for (int i = 0; i < 10; ++i) {
            if (!this.isIn(mouseX, mouseY, this.upgradeSlotLefts[i], this.upgradeSlotTops[i], this.upgradeSlotRights[i], this.upgradeSlotBottoms[i])) continue;
            if (button == 1) {
                if (i == 0 && ClientUpgradeState.getStack(0) != null && !ClientUpgradeState.getStack(0).method_7960() && !ClientUpgradeState.isSlotDisabled(0)) {
                    ClientPlayNetworking.send((class_8710)new RequestOpenScreenC2SPayload(RequestOpenScreenC2SPayload.Screen.PORTABLE_CRAFTING, null, ""));
                    return true;
                }
                if (i == 6 && !ClientUpgradeState.isSlotDisabled(6) && ClientUpgradeState.isBedUpgradeActive()) {
                    ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.UPGRADE, i, button, 0, "", 0));
                    return true;
                }
                if (i == 7 && !ClientUpgradeState.isSlotDisabled(7) && ClientUpgradeState.isXpBottleUpgradeActive()) {
                    ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.UPGRADE, i, button, 0, "", 0));
                    return true;
                }
                ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.UPGRADE, i, button, 0, "", 0));
                return true;
            }
            if (button == 2) {
                if (i == 0 && ClientUpgradeState.getStack(0) != null && !ClientUpgradeState.getStack(0).method_7960() && !ClientUpgradeState.isSlotDisabled(0)) {
                    if (ClientVirtualCraftingConfig.isEnableVirtualCrafting()) {
                        ClientConfig config = ClientConfig.getInstance();
                        config.virtualCraftingVisible = !config.virtualCraftingVisible;
                        ClientConfig.save();
                        ClientNetworkingHandlers.sendRefundCraftingSlots();
                        return true;
                    }
                    class_310 client = class_310.method_1551();
                    if (client.field_1724 != null) {
                        client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.virtual_crafting_disabled_by_server"), false);
                    }
                    return true;
                }
                if (i == 1 && ClientUpgradeState.getStack(1) != null && !ClientUpgradeState.getStack(1).method_7960() && !ClientUpgradeState.isSlotDisabled(1)) {
                    class_310 client = class_310.method_1551();
                    if (client.field_1755 != null) {
                        client.method_1507((class_437)new FilterMainScreen(client.field_1755));
                    } else {
                        FilterScreenManager.openFilterMainScreen();
                    }
                    return true;
                }
                if (i == 7 && ClientUpgradeState.isXpBottleUpgradeActive()) {
                    ClientNetworkingHandlers.sendXpBottleMaintenanceToggle();
                    return true;
                }
                if (i == 9 && ClientUpgradeState.isEnchantedGoldenAppleUpgradeActive()) {
                    class_310 client = class_310.method_1551();
                    if (client.field_1755 != null) {
                        client.method_1507((class_437)new FilterListScreen(client.field_1755, FilterListScreen.Mode.FILTER));
                    } else {
                        FilterScreenManager.openFilterScreen();
                    }
                    return true;
                }
                ClientUpgradeState.toggleSlotDisabled(i);
                ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.UPGRADE, i, button, 0, "", 0));
                return true;
            }
            if (button != 0) continue;
            ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.UPGRADE, i, button, 0, "", 0));
            return true;
        }
        if (button == 0 && this.isOverUpgradeScrollbar(mouseX, mouseY)) {
            boolean overThumb;
            height = this.upgradeScrollbarHeight;
            int upgradeVisibleRows = this.calculateUpgradeVisibleRows();
            int leftColumnMaxRows = ClientUpgradeState.isChestUpgradeActive() ? 5 : 0;
            int rightColumnMaxRows = 7;
            int maxRowsInAnyColumn = Math.max(leftColumnMaxRows, rightColumnMaxRows);
            int visible = upgradeVisibleRows;
            int total = Math.max(visible, maxRowsInAnyColumn);
            int thumbMin = 8;
            int thumbHeight = Math.max(thumbMin, (int)((float)height * ((float)visible / (float)total)));
            int maxScrollPx = Math.max(1, height - thumbHeight);
            int top = this.upgradeScrollbarTop;
            int currentThumbTop = top + (int)((float)maxScrollPx * this.upgradeScroll + 0.5f);
            boolean bl = overThumb = mouseY >= (double)currentThumbTop && mouseY < (double)(currentThumbTop + thumbHeight);
            if (overThumb) {
                this.dragUpgradeScrollbar = true;
                this.dragUpgradeGrabOffset = (int)mouseY - currentThumbTop;
            } else {
                int mouseOffset = (int)mouseY - top - thumbHeight / 2;
                float newScroll = (float)mouseOffset / (float)maxScrollPx;
                this.upgradeScroll = Math.max(0.0f, Math.min(1.0f, newScroll));
                this.dragUpgradeScrollbar = true;
                this.dragUpgradeGrabOffset = thumbHeight / 2;
            }
            return true;
        }
        if (button == 0 && this.isOverScrollbar(mouseX, mouseY)) {
            boolean overThumb;
            int top = this.scrollbarTop;
            height = this.scrollbarHeight;
            int thumbMin = 8;
            int visible = this.visibleRows;
            int total = Math.max(visible, this.totalRows);
            int thumbHeight = Math.max(thumbMin, (int)((float)height * ((float)visible / (float)total)));
            int maxScrollPx = Math.max(1, height - thumbHeight);
            int currentThumbTop = top + (int)((float)maxScrollPx * this.scroll + 0.5f);
            boolean bl = overThumb = mouseY >= (double)currentThumbTop && mouseY < (double)(currentThumbTop + thumbHeight);
            if (overThumb) {
                this.dragScrollbar = true;
                this.dragGrabOffset = (int)mouseY - currentThumbTop;
            } else {
                int mouseOffset = (int)mouseY - top - thumbHeight / 2;
                float newScroll = (float)mouseOffset / (float)maxScrollPx;
                this.scroll = Math.max(0.0f, Math.min(1.0f, newScroll));
                this.dragScrollbar = true;
                this.dragGrabOffset = thumbHeight / 2;
                ClientPlayNetworking.send((class_8710)new ScrollC2SPayload(this.scroll));
            }
            return true;
        }
        if (button == 0 || button == 1 || button == 2) {
            for (int row = 0; row < this.visibleRows; ++row) {
                for (int col = 0; col < 9; ++col) {
                    class_1799 cursor;
                    String fluidType;
                    class_1799 st;
                    class_2371<class_1799> stacks;
                    int visIdx;
                    int sx = this.gridLeft + col * 18;
                    int sy = this.gridTop + row * 18;
                    if (!(mouseX >= (double)sx) || !(mouseX < (double)(sx + 18)) || !(mouseY >= (double)sy) || !(mouseY < (double)(sy + 18)) || (visIdx = row * 9 + col) >= this.visibleIndexMap.length) continue;
                    int storageIndex = this.visibleIndexMap[visIdx];
                    if (button == 2 && storageIndex >= 0 && storageIndex < (stacks = ClientStorageState.getStacks()).size() && (st = (class_1799)stacks.get(storageIndex)) != null && !st.method_7960()) {
                        String id = class_7923.field_41178.method_10221((Object)st.method_7909()).toString();
                        ClientConfig cfg = ClientConfig.getInstance();
                        if (cfg.favorites.contains(id)) {
                            cfg.favorites.remove(id);
                        } else {
                            cfg.favorites.add(id);
                        }
                        ClientConfig.save();
                        return true;
                    }
                    if (storageIndex == -2 && ClientUpgradeState.isXpBottleUpgradeActive()) {
                        if (button == 1) {
                            class_1799 cursorStack;
                            class_310 client = class_310.method_1551();
                            if (client.field_1724 != null && !(cursorStack = client.field_1724.field_7512.method_34255()).method_7960() && cursorStack.method_31574(class_1802.field_8469)) {
                                ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.XP_BOTTLE, 0, button, 0, "", 0));
                                return true;
                            }
                        }
                        ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.XP_BOTTLE, 0, button, 0, "", 0));
                        return true;
                    }
                    if (storageIndex == -3) {
                        if (button == 0) {
                            this.query = "";
                            if (this.searchField != null) {
                                this.searchField.method_1852("");
                            }
                            return true;
                        }
                    } else if (storageIndex < -2147482648 && (fluidType = this.getFluidTypeFromVirtualIndex(storageIndex)) != null) {
                        if (button == 1) {
                            class_1799 cursorStack;
                            class_310 client = class_310.method_1551();
                            if (client.field_1724 != null && !(cursorStack = client.field_1724.field_7512.method_34255()).method_7960() && cursorStack.method_31574(class_1802.field_8550)) {
                                ClientPlayNetworking.send((class_8710)new FluidConversionC2SPayload(fluidType, button));
                                return true;
                            }
                        }
                        if (button == 0) {
                            boolean shift = this.isShiftDown();
                            if (shift && ClientConfig.getInstance().autoDeposit) {
                                class_310 client = class_310.method_1551();
                                if (client.field_1724 != null) {
                                    boolean hasBucket = false;
                                    class_1703 handler = client.field_1724.field_7512;
                                    for (int i = 0; i < handler.field_7761.size(); ++i) {
                                        class_1735 slot = (class_1735)handler.field_7761.get(i);
                                        if (!slot.method_7681() || !slot.method_7677().method_31574(class_1802.field_8550)) continue;
                                        hasBucket = true;
                                        break;
                                    }
                                    if (hasBucket) {
                                        ClientPlayNetworking.send((class_8710)new FluidConversionC2SPayload(fluidType, button));
                                        return true;
                                    }
                                }
                            }
                            return true;
                        }
                    }
                    if (storageIndex >= 0) {
                        if (button == 1 && ClientConfig.getInstance().smartCollapse && this.collapsedInfoByRep.containsKey(storageIndex) && (this.searchField == null || this.searchField.method_1882().isEmpty())) {
                            String id;
                            this.query = id = this.collapsedInfoByRep.get((Object)Integer.valueOf((int)storageIndex)).itemId;
                            if (this.searchField != null) {
                                this.searchField.method_1852(id);
                            }
                            return true;
                        }
                        boolean shift = this.isShiftDown();
                        if (shift) {
                            ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.SHIFT_TAKE, StorageActionC2SPayload.Target.STORAGE, storageIndex, button, 0, "", 0));
                        } else {
                            ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.CLICK, StorageActionC2SPayload.Target.STORAGE, storageIndex, button, 0, "", 0));
                        }
                        return true;
                    }
                    class_310 mc = class_310.method_1551();
                    if (mc == null || mc.field_1724 == null || (cursor = mc.field_1724.field_7512.method_34255()).method_7960()) continue;
                    ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.DEPOSIT_CURSOR, StorageActionC2SPayload.Target.STORAGE, 0, button, 0, "", 0));
                    return true;
                }
            }
        }
        ClientConfig config = ClientConfig.getInstance();
        if (button == 0 || button == 1) {
            int hovered;
            if (enableCollapse && this.isIn(mouseX, mouseY, this.collapseLeft, this.collapseTop, this.collapseRight, this.collapseBottom)) {
                this.collapsed = true;
                config.collapsed = true;
                ClientConfig.save();
                if (this.searchField != null) {
                    this.searchField.method_25365(false);
                }
                return true;
            }
            if (button == 1 && (hovered = this.resolveHoveredIndex((int)mouseX, (int)mouseY)) >= 0 && this.collapsedInfoByRep.containsKey(hovered)) {
                String id;
                String text;
                this.query = text = (id = this.collapsedInfoByRep.get((Object)Integer.valueOf((int)hovered)).itemId);
                if (this.searchField != null) {
                    this.searchField.method_1852(text);
                }
                return true;
            }
            if (this.isIn(mouseX, mouseY, this.sortModeLeft, this.sortModeTop, this.sortModeRight, this.sortModeBottom)) {
                config.sortMode = ClientConfig.SortMode.values()[(config.sortMode.ordinal() + 1) % ClientConfig.SortMode.values().length];
                ClientConfig.save();
                return true;
            }
            if (this.isIn(mouseX, mouseY, this.sortOrderLeft, this.sortOrderTop, this.sortOrderRight, this.sortOrderBottom)) {
                config.sortAscending = !config.sortAscending;
                ClientConfig.save();
                return true;
            }
            if (this.isIn(mouseX, mouseY, this.craftRefillLeft, this.craftRefillTop, this.craftRefillRight, this.craftRefillBottom)) {
                config.craftRefill = !config.craftRefill;
                ClientConfig.save();
                return true;
            }
            if (this.isIn(mouseX, mouseY, this.autoDepositLeft, this.autoDepositTop, this.autoDepositRight, this.autoDepositBottom)) {
                config.autoDeposit = !config.autoDeposit;
                ClientConfig.save();
                return true;
            }
            if (this.isIn(mouseX, mouseY, this.smartCollapseLeft, this.smartCollapseTop, this.smartCollapseRight, this.smartCollapseBottom)) {
                config.smartCollapse = !config.smartCollapse;
                ClientConfig.save();
                return true;
            }
            if (this.portableStorage$isInventoryOrCraftingScreen() && this.isIn(mouseX, mouseY, this.searchPosLeft, this.searchPosTop, this.searchPosRight, this.searchPosBottom)) {
                if (config.storagePos == ClientConfig.StoragePos.TOP) {
                    switch (config.searchPos) {
                        case TOP: {
                            config.searchPos = ClientConfig.SearchPos.MIDDLE;
                            break;
                        }
                        case MIDDLE: {
                            config.searchPos = ClientConfig.SearchPos.BOTTOM;
                            break;
                        }
                        default: {
                            config.searchPos = ClientConfig.SearchPos.TOP;
                            break;
                        }
                        case TOP2: {
                            config.searchPos = ClientConfig.SearchPos.MIDDLE;
                            break;
                        }
                    }
                } else {
                    config.searchPos = config.searchPos.next();
                }
                ClientConfig.save();
                return true;
            }
            if (this.isIn(mouseX, mouseY, this.storagePosLeft, this.storagePosTop, this.storagePosRight, this.storagePosBottom)) {
                ClientConfig.StoragePos oldPos = config.storagePos;
                config.storagePos = config.storagePos.next();
                if (oldPos == ClientConfig.StoragePos.BOTTOM && config.storagePos == ClientConfig.StoragePos.TOP) {
                    config.searchPos = ClientConfig.SearchPos.MIDDLE;
                }
                ClientConfig.save();
                return true;
            }
            if (this.switchToVanillaCallback != null && this.isIn(mouseX, mouseY, this.switchVanillaLeft, this.switchVanillaTop, this.switchVanillaRight, this.switchVanillaBottom)) {
                this.switchToVanillaCallback.run();
                return true;
            }
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.mouseClicked(mouseX, mouseY, button, false);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.isOverUpgradeArea(mouseX, mouseY)) {
            int rightColumnMaxRows;
            int upgradeVisibleRows = this.calculateUpgradeVisibleRows();
            int leftColumnMaxRows = ClientUpgradeState.isChestUpgradeActive() ? 5 : 0;
            int maxRowsInAnyColumn = Math.max(leftColumnMaxRows, rightColumnMaxRows = 7);
            int maxUpgradeScrollRows = Math.max(0, maxRowsInAnyColumn - upgradeVisibleRows);
            if (maxUpgradeScrollRows > 0) {
                float delta = (float)verticalAmount * -0.1f;
                this.upgradeScroll = Math.max(0.0f, Math.min(1.0f, this.upgradeScroll + delta));
                return true;
            }
            this.upgradeScroll = 0.0f;
            return true;
        }
        if (this.isOverStorageArea(mouseX, mouseY)) {
            float delta = (float)verticalAmount * -0.1f;
            this.scroll = Math.max(0.0f, Math.min(1.0f, this.scroll + delta));
            ClientPlayNetworking.send((class_8710)new ScrollC2SPayload(this.scroll));
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        int hovered;
        double my;
        double mx;
        class_310 mc;
        if (this.searchField != null && this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.searchField != null && this.searchField.method_25370() && (mc = class_310.method_1551()) != null && mc.field_1690 != null && mc.field_1690.field_1822 != null) {
            try {
                if (mc.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (ClientStorageState.isStorageEnabled() && ClientConfig.getInstance().autoDeposit && (mc = class_310.method_1551()) != null && mc.field_1729 != null && this.isOverStorageArea(mx = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480(), my = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507()) && keyCode == 81 && (hovered = this.resolveHoveredIndex((int)mx, (int)my)) >= 0) {
            boolean ctrl = this.isCtrlDown();
            int amountType = ctrl ? 1 : 0;
            ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.DROP, StorageActionC2SPayload.Target.STORAGE, hovered, 0, 0, "", amountType));
            return true;
        }
        return false;
    }

    private boolean isShiftDown() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_22683() == null) {
            return false;
        }
        long win = mc.method_22683().method_4490();
        boolean left = GLFW.glfwGetKey((long)win, (int)340) == 1;
        boolean right = GLFW.glfwGetKey((long)win, (int)344) == 1;
        return left || right;
    }

    public boolean charTyped(char chr, int modifiers) {
        return this.searchField != null && this.searchField.method_25400(chr, modifiers);
    }

    private int resolveHoveredIndex(int mouseX, int mouseY) {
        int col = (mouseX - this.gridLeft) / 18;
        int row = (mouseY - this.gridTop) / 18;
        if (col < 0 || col >= 9 || row < 0 || row >= this.visibleRows) {
            return -1;
        }
        int visIdx = row * 9 + col;
        if (visIdx < 0 || visIdx >= this.visibleIndexMap.length) {
            return -1;
        }
        return this.visibleIndexMap[visIdx];
    }

    private boolean isCtrlDown() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_22683() == null) {
            return false;
        }
        long win = mc.method_22683().method_4490();
        boolean left = GLFW.glfwGetKey((long)win, (int)341) == 1;
        boolean right = GLFW.glfwGetKey((long)win, (int)345) == 1;
        return left || right;
    }

    public boolean isMouseOverStorageArea(int mouseX, int mouseY) {
        int width = 162;
        int height = this.visibleRows * 18;
        return mouseX >= this.gridLeft && mouseX < this.gridLeft + width && mouseY >= this.gridTop && mouseY < this.gridTop + height;
    }

    public class_1799 getItemUnderMouse(int mouseX, int mouseY) {
        int index;
        if (!this.isMouseOverStorageArea(mouseX, mouseY)) {
            return class_1799.field_8037;
        }
        int relativeX = mouseX - this.gridLeft;
        int relativeY = mouseY - this.gridTop;
        int col = relativeX / 18;
        int row = relativeY / 18;
        if (col >= 0 && col < 9 && row >= 0 && row < this.visibleRows && (index = row * 9 + col) < this.visibleIndexMap.length) {
            int actualIndex = this.visibleIndexMap[index];
            class_2371<class_1799> storageStacks = ClientStorageState.getStacks();
            if (actualIndex >= 0 && actualIndex < storageStacks.size()) {
                return (class_1799)storageStacks.get(actualIndex);
            }
        }
        return class_1799.field_8037;
    }

    private void renderSearchFieldCustom(class_332 context, int mouseX, int mouseY, float delta) {
        String text;
        if (this.searchField == null) {
            return;
        }
        int x = this.searchField.method_46426();
        int y = this.searchField.method_46427();
        int width = this.searchField.method_25368();
        int height = this.searchField.method_25364();
        if (this.searchField.method_1885()) {
            context.method_25294(x, y, x + width, y + height, Integer.MIN_VALUE);
            context.method_25294(x, y, x + width, y + 1, -1);
            context.method_25294(x, y, x + 1, y + height, -1);
            context.method_25294(x + width - 1, y, x + width, y + height, -1);
            context.method_25294(x, y + height - 1, x + width, y + height, -1);
        }
        if ((text = this.searchField.method_1882()) != null && !text.isEmpty()) {
            context.method_51433(class_310.method_1551().field_1772, text, x + 4, y + (height - 8) / 2, 0xFFFFFF, false);
        } else {
            String placeholder = class_2561.method_43471((String)"portable-storage.search.placeholder").getString();
            if (placeholder != null && !placeholder.isEmpty()) {
                context.method_51433(class_310.method_1551().field_1772, placeholder, x + 4, y + (height - 8) / 2, 0x808080, false);
            }
        }
        if (this.searchField.method_25370()) {
            int cursorX = x + 4 + class_310.method_1551().field_1772.method_1727(text != null ? text : "");
            int cursorY = y + 2;
            int cursorHeight = height - 4;
            context.method_25294(cursorX, cursorY, cursorX + 1, cursorY + cursorHeight, -1);
        }
    }

    private boolean isIn(double x, double y, int left, int top, int right, int bottom) {
        return x >= (double)left && x < (double)right && y >= (double)top && y < (double)bottom;
    }

    private boolean isOverScrollbar(double mouseX, double mouseY) {
        return mouseX >= (double)this.scrollbarLeft && mouseX < (double)(this.scrollbarLeft + this.scrollbarWidth) && mouseY >= (double)this.scrollbarTop && mouseY < (double)(this.scrollbarTop + this.scrollbarHeight);
    }

    private boolean isOverUpgradeScrollbar(double mouseX, double mouseY) {
        return mouseX >= (double)this.upgradeScrollbarLeft && mouseX < (double)(this.upgradeScrollbarLeft + this.upgradeScrollbarWidth) && mouseY >= (double)this.upgradeScrollbarTop && mouseY < (double)(this.upgradeScrollbarTop + this.upgradeScrollbarHeight);
    }

    private boolean isOverStorageArea(double mouseX, double mouseY) {
        int width = 162;
        int height = this.visibleRows * 18;
        return mouseX >= (double)this.gridLeft && mouseX < (double)(this.gridLeft + width) && mouseY >= (double)this.gridTop && mouseY < (double)(this.gridTop + height);
    }

    private boolean isOverUpgradeArea(double mouseX, double mouseY) {
        int extendedLeft;
        int upgradeLeft = this.gridLeft - 18 - 0 - 2;
        int upgradeTop = this.gridTop;
        int upgradeWidth = 18;
        int upgradeVisibleRows = this.calculateUpgradeVisibleRows();
        int upgradeHeight = upgradeVisibleRows * 18;
        if (mouseX >= (double)upgradeLeft && mouseX < (double)(upgradeLeft + upgradeWidth) && mouseY >= (double)upgradeTop && mouseY < (double)(upgradeTop + upgradeHeight)) {
            return true;
        }
        return ClientUpgradeState.isChestUpgradeActive() && mouseX >= (double)(extendedLeft = upgradeLeft - 20) && mouseX < (double)(extendedLeft + 18) && mouseY >= (double)upgradeTop && mouseY < (double)(upgradeTop + upgradeHeight);
    }

    public boolean isOverAnyComponent(double mouseX, double mouseY) {
        return this.isOverBackgroundArea(mouseX, mouseY);
    }

    private boolean isOverBackgroundArea(double mouseX, double mouseY) {
        int upgradeLeft = this.gridLeft - 24;
        int extendedSlotWidth = 0;
        if (ClientUpgradeState.isChestUpgradeActive()) {
            extendedSlotWidth = 20;
        }
        int screenX = this.currentScreenX;
        int backgroundWidth = this.currentBackgroundWidth;
        int panelLeft = screenX + backgroundWidth + 8;
        int extLeft = upgradeLeft - 2 - extendedSlotWidth;
        int extTop = this.gridTop - 2;
        int extRight = panelLeft - 2;
        int extBottom = this.gridTop + this.visibleRows * 18 + 2;
        int bgOffsetX = 4;
        int bgOffsetY = 4;
        int bgLeft = extLeft - 4;
        int bgTop = extTop - 4;
        int bgRight = extRight + 4;
        int bgBottom = extBottom + 4;
        return mouseX >= (double)bgLeft && mouseX < (double)bgRight && mouseY >= (double)bgTop && mouseY < (double)bgBottom;
    }

    private boolean portableStorage$isOverUpgradeSlot(double mouseX, double mouseY) {
        for (int i = 0; i < 10; ++i) {
            if (!this.isIn(mouseX, mouseY, this.upgradeSlotLefts[i], this.upgradeSlotTops[i], this.upgradeSlotRights[i], this.upgradeSlotBottoms[i])) continue;
            return true;
        }
        return false;
    }

    private int portableStorage$getHoveredUpgradeSlot(double mouseX, double mouseY) {
        for (int i = 0; i < 10; ++i) {
            if (!this.isIn(mouseX, mouseY, this.upgradeSlotLefts[i], this.upgradeSlotTops[i], this.upgradeSlotRights[i], this.upgradeSlotBottoms[i])) continue;
            return i;
        }
        return -1;
    }

    private String getFluidTypeFromVirtualIndex(int virtualIndex) {
        return switch (virtualIndex) {
            case -2147483647 -> "lava";
            case -2147483646 -> "water";
            case -2147483645 -> "milk";
            default -> null;
        };
    }

    private class_1799 createFluidDisplayStack(String fluidType) {
        return switch (fluidType) {
            case "lava" -> new class_1799((class_1935)class_1802.field_8187);
            case "water" -> new class_1799((class_1935)class_1802.field_8705);
            case "milk" -> new class_1799((class_1935)class_1802.field_8103);
            default -> class_1799.field_8037;
        };
    }

    private void drawFluidTexture(class_332 context, String fluidType, int x, int y) {
        class_2960 textureId;
        switch (fluidType) {
            case "lava": {
                class_2960 class_29602 = class_2960.method_60655((String)"portable-storage", (String)"textures/item/lava.png");
                break;
            }
            case "water": {
                class_2960 class_29602 = class_2960.method_60655((String)"portable-storage", (String)"textures/item/water.png");
                break;
            }
            case "milk": {
                class_2960 class_29602 = class_2960.method_60655((String)"portable-storage", (String)"textures/item/milk.png");
                break;
            }
            default: {
                class_2960 class_29602 = textureId = null;
            }
        }
        if (textureId != null) {
            context.method_25290(textureId, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private boolean portableStorage$isInventoryOrCraftingScreen() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1755 == null) {
            return false;
        }
        return client.field_1755 instanceof class_490 || client.field_1755 instanceof class_479 || client.field_1755 instanceof PortableCraftingScreen;
    }

    private String portableStorage$getUpgradeName(int slotIndex) {
        return class_2561.method_43471((String)(switch (slotIndex) {
            case 0 -> "block.minecraft.crafting_table";
            case 1 -> "block.minecraft.hopper";
            case 2 -> "block.minecraft.chest";
            case 3 -> "block.minecraft.barrel";
            case 4 -> ClientRiftConfig.getRiftUpgradeItemTranslationKey();
            case 5 -> "item.minecraft.spectral_arrow";
            case 6 -> "block.minecraft.red_bed";
            case 7 -> "item.minecraft.experience_bottle";
            case 8 -> "block.minecraft.piston";
            case 9 -> "item.minecraft.enchanted_golden_apple";
            default -> "portable_storage.upgrade.unknown";
        })).getString();
    }

    public class_342 getSearchField() {
        return this.searchField;
    }

    public int getGridLeft() {
        return this.gridLeft;
    }

    public int getGridTop() {
        return this.gridTop;
    }

    public int getGridWidth() {
        return 162;
    }

    public int getGridHeight() {
        return this.visibleRows * 18;
    }

    public int getScrollbarLeft() {
        return this.scrollbarLeft;
    }

    public int getScrollbarTop() {
        return this.scrollbarTop;
    }

    public int getScrollbarWidth() {
        return this.scrollbarWidth;
    }

    public int getScrollbarHeight() {
        return this.scrollbarHeight;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public void loadCollapsedState() {
        this.collapsed = ClientConfig.getInstance().collapsed;
    }

    static {
        TEX_BG = class_2960.method_60655((String)"portable-storage", (String)"textures/gui/portable_storage_gui.png");
        TEX_SLOT = class_2960.method_60655((String)"portable-storage", (String)"textures/gui/slot.png");
        TEX_ICONS = class_2960.method_60655((String)"portable-storage", (String)"textures/gui/icon.png");
        TEX_DELETE = class_2960.method_60655((String)"portable-storage", (String)"textures/gui/icon/delete.png");
    }

    @Environment(value=EnvType.CLIENT)
    private static final class CollapsedInfo {
        class_1799 displayStack;
        int totalCount;
        String itemId;

        private CollapsedInfo() {
        }
    }
}

