/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client.util;

import com.github.promeg.pinyinhelper.Pinyin;
import com.portable.storage.client.ClientConfig;
import com.portable.storage.client.util.PolyphoneDictionary;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PinyinSearchHelper {
    public static boolean matches(String text, String query) {
        String lowerQuery;
        if (text == null || query == null) {
            return false;
        }
        String lowerText = text.toLowerCase(Locale.ROOT);
        if (lowerText.contains(lowerQuery = query.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (ClientConfig.getInstance().pinyinSearch) {
            return PinyinSearchHelper.matchesPinyin(text, lowerQuery);
        }
        return false;
    }

    private static boolean matchesPinyin(String text, String lowerQuery) {
        try {
            String defaultPinyin = Pinyin.toPinyin((String)text, (String)" ");
            String lowerDefaultPinyin = defaultPinyin.toLowerCase(Locale.ROOT);
            if (lowerDefaultPinyin.contains(lowerQuery)) {
                return true;
            }
            if (PinyinSearchHelper.extractInitials(lowerDefaultPinyin).contains(lowerQuery)) {
                return true;
            }
            if (PinyinSearchHelper.containsPolyphone(text)) {
                List<String> possiblePinyins = PolyphoneDictionary.generateAllPossiblePinyins(text);
                for (String pinyin : possiblePinyins) {
                    String lowerPinyin = pinyin.toLowerCase(Locale.ROOT);
                    if (lowerPinyin.contains(lowerQuery)) {
                        return true;
                    }
                    if (!PinyinSearchHelper.extractInitials(lowerPinyin).contains(lowerQuery)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean containsPolyphone(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            String charStr = String.valueOf(text.charAt(i));
            if (!PolyphoneDictionary.isPolyphone(charStr)) continue;
            return true;
        }
        return false;
    }

    private static String extractInitials(String pinyin) {
        String[] syllables;
        if (pinyin == null || pinyin.isEmpty()) {
            return "";
        }
        StringBuilder initials = new StringBuilder();
        block0: for (String syllable : syllables = pinyin.split("\\s+")) {
            if (syllable.isEmpty()) continue;
            for (int i = 0; i < syllable.length(); ++i) {
                char c = syllable.charAt(i);
                if (!Character.isLetter(c)) continue;
                initials.append(Character.toLowerCase(c));
                continue block0;
            }
        }
        return initials.toString();
    }

    public static String getPinyin(String text) {
        if (text == null) {
            return "";
        }
        try {
            List<String> possiblePinyins;
            if (PinyinSearchHelper.containsPolyphone(text) && !(possiblePinyins = PolyphoneDictionary.generateAllPossiblePinyins(text)).isEmpty()) {
                return possiblePinyins.get(0);
            }
            return Pinyin.toPinyin((String)text, (String)" ");
        }
        catch (Exception e) {
            return text;
        }
    }

    public static String getPinyinInitials(String text) {
        if (text == null) {
            return "";
        }
        try {
            String pinyin = PinyinSearchHelper.getPinyin(text).toLowerCase(Locale.ROOT);
            return PinyinSearchHelper.extractInitials(pinyin);
        }
        catch (Exception e) {
            return text;
        }
    }

    public static List<String> getAllPossiblePinyins(String text) {
        if (text == null) {
            return List.of();
        }
        try {
            if (PinyinSearchHelper.containsPolyphone(text)) {
                return PolyphoneDictionary.generateAllPossiblePinyins(text);
            }
            String defaultPinyin = Pinyin.toPinyin((String)text, (String)" ");
            return List.of(defaultPinyin);
        }
        catch (Exception e) {
            return List.of(text);
        }
    }
}

