/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.client.util;

import com.github.promeg.pinyinhelper.Pinyin;
import com.portable.storage.client.ClientConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PolyphoneDictionary {
    private static Map<String, String[]> getPolyphoneMap() {
        return ClientConfig.getInstance().polyphoneMap;
    }

    public static boolean isPolyphone(String character) {
        return PolyphoneDictionary.getPolyphoneMap().containsKey(character);
    }

    public static String[] getPolyphonePinyins(String character) {
        return PolyphoneDictionary.getPolyphoneMap().get(character);
    }

    public static List<String> generateAllPossiblePinyins(String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return result;
        }
        PolyphoneDictionary.generatePinyinCombinations(text, 0, new StringBuilder(), result);
        return result;
    }

    private static void generatePinyinCombinations(String text, int index, StringBuilder current, List<String> result) {
        boolean needSpace;
        if (index >= text.length()) {
            if (current.length() > 0) {
                result.add(current.toString());
            }
            return;
        }
        char c = text.charAt(index);
        String charStr = String.valueOf(c);
        boolean bl = needSpace = current.length() > 0;
        if (PolyphoneDictionary.isPolyphone(charStr)) {
            String[] pinyins;
            for (String pinyin : pinyins = PolyphoneDictionary.getPolyphonePinyins(charStr)) {
                if (needSpace) {
                    current.append(" ");
                }
                current.append(pinyin);
                PolyphoneDictionary.generatePinyinCombinations(text, index + 1, current, result);
                current.setLength(current.length() - pinyin.length() - (needSpace ? 1 : 0));
            }
        } else {
            try {
                String defaultPinyin = Pinyin.toPinyin((String)charStr, (String)"");
                if (!defaultPinyin.isEmpty()) {
                    if (needSpace) {
                        current.append(" ");
                    }
                    current.append(defaultPinyin);
                    PolyphoneDictionary.generatePinyinCombinations(text, index + 1, current, result);
                    current.setLength(current.length() - defaultPinyin.length() - (needSpace ? 1 : 0));
                }
                PolyphoneDictionary.generatePinyinCombinations(text, index + 1, current, result);
            }
            catch (Exception ignored) {
                PolyphoneDictionary.generatePinyinCombinations(text, index + 1, current, result);
            }
        }
    }

    public static Set<String> getAllPolyphones() {
        return new HashSet<String>(PolyphoneDictionary.getPolyphoneMap().keySet());
    }

    public static void addPolyphone(String character, String ... pinyins) {
        ClientConfig.getInstance().addPolyphone(character, pinyins);
    }

    public static void removePolyphone(String character) {
        ClientConfig.getInstance().removePolyphone(character);
    }
}

