/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.portable.storage.PortableStorage;
import com.portable.storage.config.ServerConfig;
import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.newstore.ItemKeyHasher;
import com.portable.storage.newstore.PlayerStore;
import com.portable.storage.newstore.RefCountRebuilder;
import com.portable.storage.newstore.StorageMemoryCache;
import com.portable.storage.newstore.StoragePaths;
import com.portable.storage.newstore.TemplateIndex;
import com.portable.storage.newstore.TemplateSlices;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.player.StoragePersistence;
import com.portable.storage.storage.StorageInventory;
import com.portable.storage.util.SafeNbtIo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_6903;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public final class NewStoreCommands {
    private NewStoreCommands() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register(NewStoreCommands::registerInternal);
    }

    private static void registerInternal(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 env) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"portable-storage").requires(src -> src.method_9259(4))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"newstore").then(class_2170.method_9247((String)"migrate").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(NewStoreCommands::executeMigrate)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rebuild").executes(ctx -> NewStoreCommands.executeRebuild((CommandContext<class_2168>)ctx, false))).then(class_2170.method_9244((String)"cleanup", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> NewStoreCommands.executeRebuild((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"cleanup")))))).then(class_2170.method_9247((String)"dump").executes(NewStoreCommands::executeDumpSelf))).then(class_2170.method_9247((String)"verify").executes(NewStoreCommands::executeVerify))).then(class_2170.method_9247((String)"scan-corrupt").executes(NewStoreCommands::executeScanCorrupt))).then(class_2170.method_9247((String)"repair").executes(NewStoreCommands::executeRepair))).then(class_2170.method_9247((String)"list").executes(NewStoreCommands::executeList))).then(class_2170.method_9247((String)"list-keys").executes(NewStoreCommands::executeListKeys))).then(class_2170.method_9247((String)"inspect-unknown").executes(NewStoreCommands::executeInspectUnknown))).then(class_2170.method_9247((String)"test-large-item").executes(NewStoreCommands::executeTestLargeItem))).then(class_2170.method_9247((String)"get-item-size").executes(NewStoreCommands::executeGetItemSize)));
        dispatcher.register(root);
    }

    private static int executeRebuild(CommandContext<class_2168> ctx, boolean cleanup) {
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        RefCountRebuilder.rebuild(server, cleanup);
        ((class_2168)ctx.getSource()).method_9226(() -> cleanup ? class_2561.method_43471((String)"command.portable-storage.newstore.rebuild_cleanup") : class_2561.method_43471((String)"command.portable-storage.newstore.rebuild"), true);
        return 1;
    }

    private static int executeDumpSelf(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Only players can run dump without args"));
            return 0;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0;
        }
        Map<String, PlayerStore.Entry> m = PlayerStore.readAll(server, player.method_5667());
        long totalLocal = m.values().stream().mapToLong(e -> e.count).sum();
        int size = m.size();
        long total = totalLocal;
        long negativeCount = m.values().stream().mapToLong(e -> e.count < 0L ? e.count : 0L).sum();
        long zeroCount = m.values().stream().mapToLong(e -> e.count == 0L ? 1L : 0L).sum();
        if (negativeCount != 0L || zeroCount > 0L) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.dump.warning", (Object[])new Object[]{negativeCount, zeroCount}), false);
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.dump", (Object[])new Object[]{size, total}), false);
        return 1;
    }

    private static int executeVerify(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Only players can run verify without args"));
            return 0;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0;
        }
        Map<String, PlayerStore.Entry> m = PlayerStore.readAll(server, player.method_5667());
        int totalEntries = m.size();
        long totalCount = m.values().stream().mapToLong(e -> e.count).sum();
        int[] negativeEntries = new int[]{0};
        int[] zeroEntries = new int[]{0};
        int[] invalidEntries = new int[]{0};
        for (PlayerStore.Entry entry : m.values()) {
            if (entry.count < 0L) {
                negativeEntries[0] = negativeEntries[0] + 1;
            } else if (entry.count == 0L) {
                zeroEntries[0] = zeroEntries[0] + 1;
            }
            if (entry.key != null && !entry.key.isEmpty()) continue;
            invalidEntries[0] = invalidEntries[0] + 1;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.portable-storage.newstore.verify.title"), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.verify.total_entries", (Object[])new Object[]{totalEntries}), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.verify.total_count", (Object[])new Object[]{totalCount}), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.verify.negative_entries", (Object[])new Object[]{negativeEntries[0]}), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.verify.zero_entries", (Object[])new Object[]{zeroEntries[0]}), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.verify.invalid_entries", (Object[])new Object[]{invalidEntries[0]}), false);
        if (negativeEntries[0] > 0 || zeroEntries[0] > 0 || invalidEntries[0] > 0) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.portable-storage.newstore.verify.inconsistent"));
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.portable-storage.newstore.verify.passed"), false);
        return 1;
    }

    private static int executeMigrate(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        Collection profiles = class_2191.method_9330(ctx, (String)"player");
        int migrated = 0;
        for (GameProfile gp : profiles) {
            boolean ok;
            UUID uuid = gp.getId();
            if (uuid == null || !(ok = NewStoreCommands.migrateOne(server, uuid))) continue;
            ++migrated;
        }
        int finalMigrated = migrated;
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.migrate", (Object[])new Object[]{finalMigrated}), true);
        return migrated > 0 ? 1 : 0;
    }

    public static boolean migrateOne(MinecraftServer server, UUID uuid) {
        try {
            long cnt;
            int i;
            TemplateIndex index = TemplateIndex.load(server);
            class_3222 online = server.method_3760().method_14602(uuid);
            boolean onlinePlayer = online != null;
            StorageInventory legacy = onlinePlayer ? PlayerStorageService.getInventory((class_1657)online) : StoragePersistence.loadStorage(server, uuid);
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            ArrayList<Long> counts = new ArrayList<Long>();
            ArrayList<Long> timestamps = new ArrayList<Long>();
            for (i = 0; i < legacy.getCapacity(); ++i) {
                class_1799 disp = legacy.getDisplayStack(i);
                cnt = legacy.getCountByIndex(i);
                if (disp.method_7960() || cnt <= 0L) continue;
                stacks.add(disp.method_7972());
                counts.add(cnt);
                timestamps.add(legacy.getTimestampByIndex(i));
            }
            if (stacks.isEmpty()) {
                return false;
            }
            for (i = 0; i < stacks.size(); ++i) {
                class_1799 st = (class_1799)stacks.get(i);
                cnt = (Long)counts.get(i);
                String key = ItemKeyHasher.hash(st, (class_7225.class_7874)(onlinePlayer ? online.method_56673() : null));
                if (key == null || key.isEmpty()) continue;
                if (index.find(key) == null) {
                    TemplateSlices.putTemplate(() -> server, index, key, st, (class_7225.class_7874)(onlinePlayer ? online.method_56673() : null));
                }
                index.incRef(key, cnt);
                PlayerStore.add(server, uuid, key, cnt, System.currentTimeMillis());
            }
            for (i = 0; i < legacy.getCapacity(); ++i) {
                long left = legacy.getCountByIndex(i);
                if (left <= 0L) continue;
                legacy.takeByIndex(i, left, System.currentTimeMillis());
            }
            legacy.clear();
            index.save(server);
            StoragePersistence.saveStorage(server, uuid, legacy);
            if (onlinePlayer) {
                ServerNetworkingHandlers.sendSync(online);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static int executeScanCorrupt(CommandContext<class_2168> ctx) {
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        int[] corruptCount = new int[]{0};
        Path templatesDir = StoragePaths.getTemplatesDir(server);
        corruptCount[0] = corruptCount[0] + SafeNbtIo.scanForCorruptFiles(templatesDir);
        Path playersDir = StoragePaths.getPlayersDir(server);
        corruptCount[0] = corruptCount[0] + SafeNbtIo.scanForCorruptFiles(playersDir);
        if (corruptCount[0] > 0) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.scan_corrupt.found", (Object[])new Object[]{corruptCount[0]}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.portable-storage.newstore.scan_corrupt.none"), true);
        }
        return corruptCount[0];
    }

    private static int executeRepair(CommandContext<class_2168> ctx) {
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        int[] repairedCount = new int[]{0};
        Path templatesDir = StoragePaths.getTemplatesDir(server);
        if (Files.exists(templatesDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(templatesDir);){
                for (Path file : stream.toList()) {
                    Path originalFile;
                    Path backupFile;
                    if (!file.getFileName().toString().endsWith(".corrupt") || !Files.exists(backupFile = (originalFile = file.resolveSibling(file.getFileName().toString().replace(".corrupt", ""))).resolveSibling(String.valueOf(originalFile.getFileName()) + ".bak"), new LinkOption[0])) continue;
                    try {
                        class_2507.method_30613((Path)backupFile, (class_2505)class_2505.method_53898());
                        Files.move(backupFile, originalFile, StandardCopyOption.REPLACE_EXISTING);
                        Files.deleteIfExists(file);
                        SafeNbtIo.clearCorruptMark(originalFile);
                        repairedCount[0] = repairedCount[0] + 1;
                        PortableStorage.LOGGER.info("\u4ece\u5907\u4efd\u6062\u590d\u6587\u4ef6: {} -> {}", (Object)backupFile, (Object)originalFile);
                    }
                    catch (Exception e) {
                        PortableStorage.LOGGER.warn("\u65e0\u6cd5\u4ece\u5907\u4efd\u6062\u590d\u6587\u4ef6: {}", (Object)backupFile, (Object)e);
                    }
                }
            }
            catch (IOException e) {
                PortableStorage.LOGGER.error("\u626b\u63cf\u4fee\u590d\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        if (repairedCount[0] > 0) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.repair.success", (Object[])new Object[]{repairedCount[0]}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.portable-storage.newstore.repair.none"), true);
        }
        return repairedCount[0];
    }

    private static class_2561 trOrLiteral(String key, Object ... args) {
        if (class_2477.method_10517().method_4678(key)) {
            return class_2561.method_43469((String)key, (Object[])args);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(key).append("] ");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(args[i]));
        }
        return class_2561.method_43470((String)sb.toString());
    }

    private static int executeList(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Only players can run this command"));
            return 0;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0;
        }
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, player.method_5667());
        int totalEntries = entries.size();
        long totalCount = entries.values().stream().mapToLong(e -> e.count).sum();
        ((class_2168)ctx.getSource()).method_9226(() -> NewStoreCommands.trOrLiteral("[Player Store] Total Entries: " + totalEntries + ", Total Count: " + totalCount, new Object[0]), false);
        TemplateIndex index = StorageMemoryCache.getTemplateIndex();
        Map<String, class_1799> cache = StorageMemoryCache.getTemplateCache();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (PlayerStore.Entry e2 : entries.values()) {
            class_1799 stack = cache.get(e2.key);
            if ((stack == null || stack.method_7960()) && (stack = TemplateSlices.getTemplate(() -> server, index, e2.key, (class_7225.class_7874)server.method_30611())) != null && !stack.method_7960()) {
                StorageMemoryCache.addTemplate(e2.key, stack);
            }
            String name = stack != null && !stack.method_7960() ? stack.method_7964().getString() : "unknown";
            String tsStr = Instant.ofEpochMilli(e2.ts).atZone(ZoneId.systemDefault()).format(fmt);
            ((class_2168)ctx.getSource()).method_9226(() -> NewStoreCommands.trOrLiteral("[Player Store] Item: " + name + ", Key: " + e.key + ", Count: " + e.count + ", Timestamp: " + tsStr, new Object[0]), false);
        }
        return 1;
    }

    private static int executeInspectUnknown(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Only players can run this command"));
            return 0;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0;
        }
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, player.method_5667());
        TemplateIndex index = StorageMemoryCache.getTemplateIndex();
        Map<String, class_1799> cache = StorageMemoryCache.getTemplateCache();
        int inspected = 0;
        int unknownCount = 0;
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (PlayerStore.Entry e : entries.values()) {
            boolean isUnknown;
            if (e.count <= 0L) continue;
            class_1799 cached = cache.get(e.key);
            boolean bl = isUnknown = cached == null || cached.method_7960();
            if (!isUnknown) continue;
            ++unknownCount;
            TemplateIndex.Entry ie = index.find(e.key);
            int slice = ie != null ? ie.slice : -1;
            class_1799 fromDisk = TemplateSlices.getTemplate(() -> server, index, e.key, (class_7225.class_7874)server.method_30611());
            boolean existsOnDisk = !fromDisk.method_7960();
            String itemName = existsOnDisk ? fromDisk.method_7964().getString() : "<parse-failed>";
            String tsStr = Instant.ofEpochMilli(e.ts).atZone(ZoneId.systemDefault()).format(fmt);
            ((class_2168)ctx.getSource()).method_9226(() -> NewStoreCommands.trOrLiteral("[Inspect Unknown] key=" + e.key + ", slice=" + slice + ", onDisk=" + existsOnDisk + ", name=" + itemName + ", count=" + e.count + ", ts=" + tsStr, new Object[0]), false);
            ++inspected;
        }
        if (inspected == 0) {
            if (unknownCount == 0) {
                ((class_2168)ctx.getSource()).method_9226(() -> NewStoreCommands.trOrLiteral("[Inspect Unknown] none", new Object[0]), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> NewStoreCommands.trOrLiteral("[Inspect Unknown] none-parsed", new Object[0]), false);
            }
        }
        return inspected;
    }

    private static int executeListKeys(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Only players can run this command"));
            return 0;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0;
        }
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, player.method_5667());
        int totalEntries = entries.size();
        long totalCount = entries.values().stream().mapToLong(e -> e.count).sum();
        ((class_2168)ctx.getSource()).method_9226(() -> NewStoreCommands.trOrLiteral("[Player Store] Total Entries: " + totalEntries + ", Total Count: " + totalCount, new Object[0]), false);
        for (PlayerStore.Entry e2 : entries.values()) {
            ((class_2168)ctx.getSource()).method_9226(() -> NewStoreCommands.trOrLiteral("[Player Store] Key: " + e.key + ", Count: " + e.count, new Object[0]), false);
        }
        return 1;
    }

    private static int executeTestLargeItem(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Only players can run this command"));
            return 0;
        }
        class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        class_2499 pages = new class_2499();
        for (int pageNum = 0; pageNum < 200; ++pageNum) {
            StringBuilder pageContent = new StringBuilder();
            pageContent.append("\u6d4b\u8bd5\u9875\u9762 ").append(pageNum + 1).append("\n");
            pageContent.append("\u8fd9\u662f\u7528\u4e8e\u6d4b\u8bd5\u5b58\u50a8\u5927\u5c0f\u9650\u5236\u7684\u9875\u9762\u3002\n");
            pageContent.append("\u6bcf\u9875\u5305\u542b\u72ec\u7279\u7684\u5185\u5bb9\u6765\u589e\u52a0\u6570\u636e\u5927\u5c0f\u3002\n\n");
            for (int i = 0; i < 20; ++i) {
                int lineNum = pageNum * 20 + i + 1;
                pageContent.append("\u72ec\u7279\u5185\u5bb9\u884c ").append(lineNum).append(": ");
                pageContent.append("\u8fd9\u662f\u7b2c").append(lineNum).append("\u884c\u7684\u72ec\u7279\u6587\u672c\u5185\u5bb9\u3002");
                pageContent.append("\u5305\u542b\u968f\u673a\u6570\u636e: ").append(System.currentTimeMillis() + (long)lineNum).append("\u3002");
                pageContent.append("\u7528\u4e8e\u6d4b\u8bd5\u7269\u54c1\u5927\u5c0f\u9650\u5236\u529f\u80fd\u3002");
                pageContent.append("\u884c\u53f7: ").append(lineNum).append("\uff0c\u9875\u9762: ").append(pageNum + 1).append("\u3002");
                pageContent.append("\u65f6\u95f4\u6233: ").append(System.nanoTime() + (long)lineNum).append("\u3002");
                pageContent.append("\u968f\u673a\u5b57\u7b26\u4e32: ").append(NewStoreCommands.generateRandomString(20)).append("\u3002\n");
            }
            pageContent.append("\n\u9875\u9762\u7279\u6709\u4fe1\u606f:\n");
            pageContent.append("- \u9875\u9762\u7f16\u53f7: ").append(pageNum + 1).append("\n");
            pageContent.append("- \u751f\u6210\u65f6\u95f4: ").append(System.currentTimeMillis()).append("\n");
            pageContent.append("- \u9875\u9762\u54c8\u5e0c: ").append(Integer.toHexString((pageNum + 1) * 12345)).append("\n");
            pageContent.append("- \u5185\u5bb9\u957f\u5ea6: ").append(pageContent.length()).append(" \u5b57\u7b26\n");
            String pageText = "{\"text\":\"" + pageContent.toString().replace("\"", "\\\"") + "\"}";
            pages.add((Object)class_2519.method_23256((String)pageText));
        }
        class_2487 nbt = new class_2487();
        nbt.method_10582("title", "\u5927\u578b\u6d4b\u8bd5\u7269\u54c1");
        nbt.method_10582("author", "Portable Storage");
        nbt.method_10566("pages", (class_2520)pages);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        if (player.method_31548().method_7394(stack)) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.portable-storage.newstore.test_large_item.success"), true);
        } else {
            player.method_7328(stack, false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.portable-storage.newstore.test_large_item.dropped"), true);
        }
        return 1;
    }

    private static int executeGetItemSize(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Only players can run this command"));
            return 0;
        }
        class_1799 mainHand = player.method_6047();
        if (mainHand.method_7960()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.portable-storage.newstore.get_item_size.no_item"));
            return 0;
        }
        long itemSize = NewStoreCommands.calculateItemSize(mainHand, (class_7225.class_7874)player.method_56673());
        String formattedSize = NewStoreCommands.formatSize(itemSize);
        String itemName = mainHand.method_7964().getString();
        int count = mainHand.method_7947();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.get_item_size.result", (Object[])new Object[]{itemName, count, formattedSize}), false);
        ServerConfig config = ServerConfig.getInstance();
        if (config.isEnableSizeLimit()) {
            long maxSize = config.getMaxStorageSizeBytes();
            if (itemSize > maxSize) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.get_item_size.exceeds_limit", (Object[])new Object[]{NewStoreCommands.formatSize(maxSize)}), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.portable-storage.newstore.get_item_size.within_limit", (Object[])new Object[]{NewStoreCommands.formatSize(maxSize)}), false);
            }
        }
        return 1;
    }

    private static long calculateItemSize(class_1799 stack, class_7225.class_7874 lookup) {
        if (stack == null || stack.method_7960()) {
            return 0L;
        }
        try {
            class_2487 nbt = new class_2487();
            DataResult encoded = class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), (Object)stack);
            if (encoded.result().isEmpty()) {
                return 0L;
            }
            class_2520 itemNbt = (class_2520)encoded.result().get();
            nbt.method_10566("item", itemNbt);
            nbt.method_10569("count", stack.method_7947());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            class_2507.method_10634((class_2487)nbt, (OutputStream)baos);
            return baos.size();
        }
        catch (Exception e) {
            return 64 + (stack.method_57353().method_57837() ? 0 : 100);
        }
    }

    private static String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    private static String generateRandomString(int length) {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        return sb.toString();
    }
}

