/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.portable.storage.world.SpaceRiftManager;
import java.util.Collection;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public final class SpaceRiftCommands {
    private SpaceRiftCommands() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register(SpaceRiftCommands::registerInternal);
    }

    private static void registerInternal(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 env) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"portable-storage").requires(src -> src.method_9259(4))).then(class_2170.method_9247((String)"rift").then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(SpaceRiftCommands::executeReset))));
        dispatcher.register(root);
    }

    private static int executeReset(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection profiles = class_2191.method_9330(ctx, (String)"player");
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        class_3218 rift = SpaceRiftManager.getWorld(server);
        if (rift == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Space Rift dimension not found"));
            return 0;
        }
        for (GameProfile profile : profiles) {
            UUID id = profile.getId();
            if (id == null) continue;
            class_1923 origin = SpaceRiftManager.ensureAllocatedPlot(server, id);
            int minX = origin.method_8326();
            int minZ = origin.method_8328();
            int maxX = minX + 16 - 1;
            int maxZ = minZ + 16 - 1;
            for (int y = 0; y <= 164; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        rift.method_8501(new class_2338(x, y, z), class_2246.field_10124.method_9564());
                    }
                }
            }
            SpaceRiftManager.ensurePlotInitialized(rift, origin);
            class_3222 target = server.method_3760().method_14602(profile.getId());
            if (target != null) {
                class_2338 center = SpaceRiftManager.getPlotCenterBlock(origin);
                target.method_14251(rift, (double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5, target.method_36454(), target.method_36455());
                SpaceRiftManager.applyPersonalBorder(target);
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Reset space rift plot for " + profile.getName())), true);
        }
        return 1;
    }
}

