/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.portable.storage.PortableStorage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;

public class ServerConfig {
    private static final String CONFIG_FILE_NAME = "portable-storage-server.toml";
    private static ServerConfig INSTANCE = new ServerConfig();
    private boolean requireConditionToEnable = true;
    private String enableItem = "minecraft:nether_star";
    private boolean consumeEnableItem = true;
    private boolean enableIncrementalSync = false;
    private boolean enableOnDemandSync = true;
    private int incrementalSyncIntervalTicks = 2;
    private int incrementalSyncMaxEntries = 512;
    private boolean clearStorageOnEnable = true;
    private boolean enableRiftFeature = true;
    private String riftUpgradeItem = "block:minecraft:dragon_egg";
    private int riftSize = 1;
    private boolean limitRiftHeight = false;
    private boolean enableVirtualCrafting = true;
    private boolean enableInfiniteLava = true;
    private boolean enableInfiniteWater = true;
    private int infiniteLavaThreshold = 10000;
    private int infiniteWaterThreshold = 2;
    private boolean enableSizeLimit = true;
    private long maxStorageSizeBytes = 102400L;
    private long singleItemStackLimit = -1L;
    private boolean enablePrimaryStorage = true;
    private String primaryStorageItem = "minecraft:heart_of_the_sea";
    private boolean consumePrimaryStorageItem = true;
    private boolean stonecutter = false;
    private boolean cartographyTable = false;
    private boolean smithingTable = false;
    private boolean grindstone = false;
    private boolean loom = false;
    private boolean furnace = false;
    private boolean smoker = false;
    private boolean blastFurnace = false;
    private boolean anvil = false;
    private boolean enchantingTable = false;
    private boolean brewingStand = false;
    private boolean beacon = false;
    private boolean chest = false;
    private boolean barrel = false;
    private boolean enderChest = false;
    private boolean shulkerBox = false;
    private boolean dispenser = false;
    private boolean dropper = false;
    private boolean crafter = false;
    private boolean hopper = false;
    private boolean trappedChest = false;
    private boolean hopperMinecart = false;
    private boolean chestMinecart = false;
    private boolean chestBoat = false;
    private boolean bambooChestRaft = false;
    private CommentedFileConfig config;
    private Path configPath;

    private ServerConfig() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        this.configPath = configDir.resolve(CONFIG_FILE_NAME);
    }

    public static ServerConfig getInstance() {
        return INSTANCE;
    }

    public void load() {
        try {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                this.copyDefaultConfig();
            }
            this.config = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.configPath).build();
            this.config.load();
            boolean changed = this.ensureDefaultsWritten();
            this.readConfigValues();
            if (changed) {
                this.writeMissingKeysWithCommentsTextually();
            }
            PortableStorage.LOGGER.info("\u6210\u529f\u52a0\u8f7d\u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6: {}", (Object)this.configPath);
        }
        catch (Exception e) {
            PortableStorage.LOGGER.error("\u52a0\u8f7d\u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e", (Throwable)e);
            this.setDefaultValues();
        }
    }

    public void save() {
        if (this.config != null) {
            try {
                this.writeConfigValues();
                this.config.save();
                PortableStorage.LOGGER.debug("\u4fdd\u5b58\u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6: {}", (Object)this.configPath);
            }
            catch (Exception e) {
                PortableStorage.LOGGER.error("\u4fdd\u5b58\u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void copyDefaultConfig() throws IOException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE_NAME);){
            if (inputStream != null) {
                Files.copy(inputStream, this.configPath, StandardCopyOption.REPLACE_EXISTING);
                PortableStorage.LOGGER.info("\u5df2\u521b\u5efa\u9ed8\u8ba4\u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6: {}", (Object)this.configPath);
            } else {
                PortableStorage.LOGGER.warn("\u672a\u627e\u5230\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u8d44\u6e90: {}", (Object)CONFIG_FILE_NAME);
                this.createDefaultConfigFile();
            }
        }
    }

    private void createDefaultConfigFile() throws IOException {
        String defaultConfig = "# Portable Storage \u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6\n# \u6b64\u914d\u7f6e\u6587\u4ef6\u63a7\u5236\u670d\u52a1\u7aef\u884c\u4e3a\uff0c\u4fee\u6539\u540e\u9700\u8981\u91cd\u542f\u670d\u52a1\u5668\u751f\u6548\n\n[storage]\n# \u662f\u5426\u9700\u8981\u6761\u4ef6\u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\n# \u542f\u7528\u540e\u73a9\u5bb6\u7684\u968f\u8eab\u4ed3\u5e93\u4e0d\u518d\u662f\u9ed8\u8ba4\u5c31\u6709\u7684\uff0c\u800c\u662f\u9700\u8981\u8fbe\u6210\u6761\u4ef6\u624d\u4f1a\u6709\n# \u9ed8\u8ba4\u503c: true\nrequire_condition_to_enable = true\n\n# \u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\u7684\u9053\u5177\n# \u542f\u7528\"\u9700\u8981\u6761\u4ef6\u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\"\u540e\u7528\u4ee5\u542f\u7528\u73a9\u5bb6\u4ed3\u5e93\u7684\u7269\u54c1\uff0c\u624b\u6301\u53f3\u952e\u4ee5\u542f\u7528\n# \u9ed8\u8ba4\u503c: \"minecraft:nether_star\" (\u4e0b\u754c\u4e4b\u661f)\n# \u683c\u5f0f: \"\u547d\u540d\u7a7a\u95f4:\u7269\u54c1ID\"\nenable_item = \"minecraft:nether_star\"\n\n# \u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\u7684\u9053\u5177\u662f\u5426\u6d88\u8017\n# \u5f00\u542f\u540e\u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\u65f6\u4f1a\u6d88\u8017\u8be5\u7269\u54c1\u4e00\u4e2a\n# \u9ed8\u8ba4\u503c: true\nconsume_enable_item = true\n\n# \u662f\u5426\u542f\u7528\u589e\u91cf\u540c\u6b65\n# \u542f\u7528\u540e\u53ea\u540c\u6b65\u53d1\u751f\u53d8\u5316\u7684\u6570\u636e\uff0c\u51cf\u5c11\u7f51\u7edc\u4f20\u8f93\u91cf\n# \u53ef\u80fd\u5b58\u5728BUG\u672a\u53d1\u73b0\u6216\u672a\u4fee\u590d\u7684\u9519\u8bef\n# \u9ed8\u8ba4\u503c: false\nenable_incremental_sync = false\n\n# \u662f\u5426\u542f\u7528\u6309\u9700\u540c\u6b65\n# \u542f\u7528\u540e\u53ea\u5728\u73a9\u5bb6\u67e5\u770b\u4ed3\u5e93\u754c\u9762\u65f6\u624d\u540c\u6b65\uff0c\u5426\u5219\u79ef\u6512\u53d8\u5316\n# \u53ef\u4ee5\u663e\u8457\u51cf\u5c11\u670d\u52a1\u5668\u8d1f\u8f7d\uff0c\u4f46\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u5ef6\u8fdf\n# \u9ed8\u8ba4\u503c: true\nenable_on_demand_sync = true\n\n# \u589e\u91cf\u540c\u6b65\u53d1\u9001\u95f4\u9694\uff08tick\uff09\n# \u6570\u503c\u8d8a\u5c0f\uff0c\u66f4\u65b0\u8d8a\u53ca\u65f6\uff0c\u4f46\u7f51\u7edc\u4e0eCPU\u8d1f\u8f7d\u66f4\u9ad8\n# \u9ed8\u8ba4\u503c: 2\nincremental_sync_interval_ticks = 2\n\n# \u5355\u5305\u6700\u5927\u589e\u91cf\u6761\u76ee\u6570\uff08upserts+removes \u5408\u8ba1\u4e0a\u9650\uff09\n# \u8d85\u8fc7\u5c06\u5206\u591a\u5305\u53d1\u9001\n# \u9ed8\u8ba4\u503c: 512\nincremental_sync_max_entries = 512\n\n# \u542f\u7528\u4ed3\u5e93\u65f6\u662f\u5426\u6e05\u7a7a\u73b0\u6709\u6570\u636e\n# \u542f\u7528\u540e\u4f7f\u7528\u4ed3\u5e93\u6fc0\u6d3b\u7269\u54c1\u65f6\u4f1a\u6e05\u7a7a\u73a9\u5bb6\u73b0\u6709\u7684\u4ed3\u5e93\u6570\u636e\n# \u9ed8\u8ba4\u503c: true\nclear_storage_on_enable = true\n\n# \u662f\u5426\u542f\u7528\u521d\u7ea7\u4ed3\u5e93\u529f\u80fd\n# \u542f\u7528\u540e\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6d77\u6d0b\u4e4b\u5fc3\u6fc0\u6d3b\u521d\u7ea7\u4ed3\u5e93\n# \u9ed8\u8ba4\u503c: true\nenable_primary_storage = true\n\n# \u521d\u7ea7\u4ed3\u5e93\u6fc0\u6d3b\u7269\u54c1\n# \u7528\u4e8e\u6fc0\u6d3b\u521d\u7ea7\u4ed3\u5e93\u7684\u7269\u54c1\uff0c\u9ed8\u8ba4\u6d77\u6d0b\u4e4b\u5fc3\n# \u683c\u5f0f: \"\u547d\u540d\u7a7a\u95f4:\u7269\u54c1ID\"\n# \u9ed8\u8ba4\u503c: \"minecraft:heart_of_the_sea\"\nprimary_storage_item = \"minecraft:heart_of_the_sea\"\n\n# \u521d\u7ea7\u4ed3\u5e93\u6fc0\u6d3b\u7269\u54c1\u662f\u5426\u6d88\u8017\n# \u5f00\u542f\u540e\u6fc0\u6d3b\u521d\u7ea7\u4ed3\u5e93\u65f6\u4f1a\u6d88\u8017\u8be5\u7269\u54c1\u4e00\u4e2a\n# \u9ed8\u8ba4\u503c: true\nconsume_primary_storage_item = true\n\n# \u662f\u5426\u542f\u7528\u88c2\u9699\u529f\u80fd\n# \u542f\u7528\u540e\u73a9\u5bb6\u53ef\u4ee5\u901a\u8fc7\u88c2\u9699\u5347\u7ea7\u69fd\u8fdb\u5165\u79c1\u4eba\u88c2\u9699\u7a7a\u95f4\n# \u7981\u7528\u540e\u65e0\u6cd5\u8fdb\u5165\u88c2\u9699\uff0c\u5904\u4e8e\u88c2\u9699\u7684\u73a9\u5bb6\u4f1a\u5728\u4e0a\u7ebf\u65f6\u88ab\u9001\u56de\u539f\u4f4d\u7f6e\n# \u9ed8\u8ba4\u503c: true\nenable_rift_feature = true\n\n# \u88c2\u9699\u5347\u7ea7\u7269\u54c1\n# \u7528\u4e8e\u8fdb\u5165\u88c2\u9699\u7684\u5347\u7ea7\u69fd\u7269\u54c1\uff0c\u9ed8\u8ba4\u9f99\u86cb\n# \u683c\u5f0f: \"\u7c7b\u578b:\u547d\u540d\u7a7a\u95f4:\u7269\u54c1ID\" (\u7c7b\u578b\u4e3a block \u6216 item)\n# \u9ed8\u8ba4\u503c: \"block:minecraft:dragon_egg\"\nrift_upgrade_item = \"block:minecraft:dragon_egg\"\n\n# \u88c2\u9699\u5927\u5c0f\n# \u88c2\u9699\u7a7a\u95f4\u7684\u5927\u5c0f\uff0c\u5355\u4f4d\u4e3a\u533a\u5757\uff0816x16\u65b9\u5757\uff09\n# \u9ed8\u8ba4\u503c: 1\nrift_size = 1\n\n# \u9650\u5236\u9ad8\u5ea6\u8303\u56f4\n# \u542f\u7528\u540e\u9650\u5236\u88c2\u9699\u5185\u7684\u9ad8\u5ea6\u8303\u56f4\uff0c\u542f\u7528\u4e0a\u4e0b\u56de\u4f20\u548c\u5c4f\u969c\u5c01\u5e95\u9876\n# \u5173\u95ed\u540e\u73a9\u5bb6\u53ef\u4ee5\u5728\u6574\u4e2a\u7ef4\u5ea6\u9ad8\u5ea6\u8303\u56f4\u5185\u5efa\u9020\n#\n# \u9650\u5236\u6a21\u5f0f\uff08true\uff09\uff1a\n# - \u53ef\u5efa\u9020\u9ad8\u5ea6\uff1aY=0 \u5230 Y=163\uff08\u5171164\u5c42\uff09\n# - \u5e95\u90e8Y=0-8\u5c42\u548c\u9876\u90e8Y=155-163\u5c42\u4f1a\u751f\u6210\u5c4f\u969c\u65b9\u5757\u4f5c\u4e3a\u8fb9\u754c\u4fdd\u62a4\n# - \u73a9\u5bb6\u65e0\u6cd5\u5728\u9650\u5236\u8303\u56f4\u5916\u653e\u7f6e\u6216\u7834\u574f\u65b9\u5757\n#\n# \u975e\u9650\u5236\u6a21\u5f0f\uff08false\uff09\uff1a\n# - \u53ef\u5efa\u9020\u9ad8\u5ea6\uff1aY=-64 \u5230 Y=319\uff08\u5171384\u5c42\uff0c\u6574\u4e2a\u7ef4\u5ea6\u9ad8\u5ea6\uff09\n# - \u4e0d\u751f\u6210\u5c4f\u969c\u65b9\u5757\uff0c\u65e0\u9ad8\u5ea6\u9650\u5236\n# - \u73a9\u5bb6\u53ef\u4ee5\u5728\u6574\u4e2a\u7ef4\u5ea6\u9ad8\u5ea6\u8303\u56f4\u5185\u81ea\u7531\u5efa\u9020\n#\n# \u9ed8\u8ba4\u503c: false\nlimit_rift_height = false\n\n# \u542f\u7528\u5de5\u4f5c\u53f0\u865a\u62df\u5408\u6210\u529f\u80fd\n# \u542f\u7528\u540e\u5de5\u4f5c\u53f0\u5347\u7ea7\u69fd\u4f4d\u63d0\u4f9b3x3\u865a\u62df\u5408\u6210\u8986\u76d6\u5c42\n# \u5173\u95ed\u540e\u5de5\u4f5c\u53f0\u5347\u7ea7\u69fd\u4f4d\u7684\u865a\u62df\u5408\u6210\u63cf\u8ff0\u4e5f\u4e0d\u4f1a\u663e\u793a\n# \u9ed8\u8ba4\u503c: true\nenable_virtual_crafting = true\n\n# \u542f\u7528\u65e0\u9650\u5ca9\u6d46\u529f\u80fd\n# \u542f\u7528\u540e\u5ca9\u6d46\u6d41\u4f53\u5728\u4ed3\u5e93\u5185\u6570\u91cf\u5927\u4e8e\u9608\u503c\u65f6\u6570\u91cf\u663e\u793a\u221e\uff08\u65e0\u9650\uff09\n# \u5b58\u53d6\u90fd\u4e0d\u4f1a\u4f7f\u5176\u6570\u91cf\u53d8\u5316\n# \u9ed8\u8ba4\u503c: true\nenable_infinite_lava = true\n\n# \u542f\u7528\u65e0\u9650\u6c34\u529f\u80fd\n# \u542f\u7528\u540e\u6c34\u6d41\u4f53\u5728\u4ed3\u5e93\u5185\u6570\u91cf\u5927\u4e8e\u9608\u503c\u65f6\u6570\u91cf\u663e\u793a\u221e\uff08\u65e0\u9650\uff09\n# \u5b58\u53d6\u90fd\u4e0d\u4f1a\u4f7f\u5176\u6570\u91cf\u53d8\u5316\n# \u9ed8\u8ba4\u503c: true\nenable_infinite_water = true\n\n# \u65e0\u9650\u5ca9\u6d46\u9608\u503c\n# \u5ca9\u6d46\u6d41\u4f53\u6570\u91cf\u5927\u4e8e\u6b64\u503c\u65f6\u663e\u793a\u4e3a\u65e0\u9650\n# \u9ed8\u8ba4\u503c: 10000\ninfinite_lava_threshold = 10000\n\n# \u65e0\u9650\u6c34\u9608\u503c\n# \u6c34\u6d41\u4f53\u6570\u91cf\u5927\u4e8e\u6b64\u503c\u65f6\u663e\u793a\u4e3a\u65e0\u9650\n# \u9ed8\u8ba4\u503c: 2\ninfinite_water_threshold = 2\n\n# \u662f\u5426\u542f\u7528\u7269\u54c1\u5927\u5c0f\u9650\u5236\n# \u542f\u7528\u540e\u9650\u5236\u5355\u4e2a\u7269\u54c1\u7684\u5927\u5c0f\uff0c\u9632\u6b62\u8fc7\u5927\u7684\u7269\u54c1\u5b58\u5165\u5b58\u50a8\n# \u9ed8\u8ba4\u503c: true\nenable_size_limit = true\n\n# \u6700\u5927\u7269\u54c1\u5927\u5c0f\uff08\u5b57\u8282\uff09\n# \u5355\u4e2a\u7269\u54c1\u7684\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7\u6b64\u503c\n# \u9ed8\u8ba4\u503c: 102400 (100KB)\nmax_storage_size_bytes = 102400\n\n# \u5355\u79cd\u7269\u54c1\u7684\u5806\u53e0\u4e0a\u9650\n# -1 \u8868\u793a\u4e0d\u9650\u5236\uff08\u7b49\u6548\u4e8e Long.MAX_VALUE\uff09\n# \u6ce8\u610f\uff1a\u8be5\u9650\u5236\u9488\u5bf9\u540c\u4e00\u79cd\u7269\u54c1\u7684\u603b\u6570\u91cf\uff0c\u800c\u975e\u7269\u54c1\u5806\u53e0\u7684 NBT/\u7ec4\u4ef6\u53d8\u5316\n# \u9ed8\u8ba4\u503c: -1\nsingle_item_stack_limit = -1\n\n[container_display]\n# \u5de5\u4f5c\u53f0\u5347\u7ea7\u5728\u5bb9\u5668\u754c\u9762\u663e\u793a\u4ed3\u5e93\u7684\u914d\u7f6e\n# \u542f\u7528\u5de5\u4f5c\u53f0\u5347\u7ea7\u540e\uff0c\u4ee5\u4e0b\u5bb9\u5668\u754c\u9762\u5c06\u663e\u793a\u4ed3\u5e93\u754c\u9762\n# \u9ed8\u8ba4\u503c: \u5168\u90e8\u4e3a false\n\n# \u5207\u77f3\u673a\nstonecutter = false\n# \u5236\u56fe\u53f0\ncartography_table = false\n# \u953b\u9020\u53f0\nsmithing_table = false\n# \u7802\u8f6e\ngrindstone = false\n# \u7ec7\u5e03\u673a\nloom = false\n# \u7194\u7089\nfurnace = false\n# \u70df\u718f\u7089\nsmoker = false\n# \u9ad8\u7089\nblast_furnace = false\n# \u94c1\u7827\nanvil = false\n# \u9644\u9b54\u53f0\nenchanting_table = false\n# \u917f\u9020\u53f0\nbrewing_stand = false\n# \u4fe1\u6807\nbeacon = false\n# \u7bb1\u5b50\nchest = false\n# \u6728\u6876\nbarrel = false\n# \u672b\u5f71\u7bb1\nender_chest = false\n# \u6f5c\u5f71\u76d2\nshulker_box = false\n# \u53d1\u5c04\u5668\ndispenser = false\n# \u6295\u63b7\u5668\ndropper = false\n# \u5408\u6210\u5668\ncrafter = false\n# \u6f0f\u6597\nhopper = false\n# \u9677\u9631\u7bb1\ntrapped_chest = false\n# \u6f0f\u6597\u77ff\u8f66\nhopper_minecart = false\n# \u8fd0\u8f93\u77ff\u8f66\nchest_minecart = false\n# \u8fd0\u8f93\u8239\nchest_boat = false\n# \u8fd0\u8f93\u7af9\u7b4f\nbamboo_chest_raft = false\n";
        Files.writeString(this.configPath, (CharSequence)defaultConfig, new OpenOption[0]);
        PortableStorage.LOGGER.info("\u5df2\u521b\u5efa\u9ed8\u8ba4\u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6: {}", (Object)this.configPath);
    }

    private void readConfigValues() {
        Config storageConfig = (Config)this.config.get("storage");
        if (storageConfig != null) {
            this.requireConditionToEnable = (Boolean)storageConfig.getOrElse("require_condition_to_enable", (Object)true);
            this.enableItem = (String)storageConfig.getOrElse("enable_item", (Object)"minecraft:nether_star");
            this.consumeEnableItem = (Boolean)storageConfig.getOrElse("consume_enable_item", (Object)true);
            this.enableIncrementalSync = (Boolean)storageConfig.getOrElse("enable_incremental_sync", (Object)false);
            this.enableOnDemandSync = (Boolean)storageConfig.getOrElse("enable_on_demand_sync", (Object)true);
            this.incrementalSyncIntervalTicks = (Integer)storageConfig.getOrElse("incremental_sync_interval_ticks", (Object)2);
            this.incrementalSyncMaxEntries = (Integer)storageConfig.getOrElse("incremental_sync_max_entries", (Object)512);
            this.clearStorageOnEnable = (Boolean)storageConfig.getOrElse("clear_storage_on_enable", (Object)true);
            this.enableRiftFeature = (Boolean)storageConfig.getOrElse("enable_rift_feature", (Object)true);
            this.riftUpgradeItem = (String)storageConfig.getOrElse("rift_upgrade_item", (Object)"block:minecraft:dragon_egg");
            this.riftSize = (Integer)storageConfig.getOrElse("rift_size", (Object)1);
            this.limitRiftHeight = (Boolean)storageConfig.getOrElse("limit_rift_height", (Object)false);
            this.enableVirtualCrafting = (Boolean)storageConfig.getOrElse("enable_virtual_crafting", (Object)true);
            this.enableInfiniteLava = (Boolean)storageConfig.getOrElse("enable_infinite_lava", (Object)true);
            this.enableInfiniteWater = (Boolean)storageConfig.getOrElse("enable_infinite_water", (Object)true);
            this.infiniteLavaThreshold = (Integer)storageConfig.getOrElse("infinite_lava_threshold", (Object)10000);
            this.infiniteWaterThreshold = (Integer)storageConfig.getOrElse("infinite_water_threshold", (Object)2);
            this.enableSizeLimit = (Boolean)storageConfig.getOrElse("enable_size_limit", (Object)true);
            Object sizeValue = storageConfig.get("max_storage_size_bytes");
            this.maxStorageSizeBytes = sizeValue instanceof Integer ? ((Integer)sizeValue).longValue() : (sizeValue instanceof Long ? (Long)sizeValue : 102400L);
            Object perItemLimit = storageConfig.get("single_item_stack_limit");
            this.singleItemStackLimit = perItemLimit instanceof Integer ? ((Integer)perItemLimit).longValue() : (perItemLimit instanceof Long ? (Long)perItemLimit : -1L);
            this.enablePrimaryStorage = (Boolean)storageConfig.getOrElse("enable_primary_storage", (Object)true);
            this.primaryStorageItem = (String)storageConfig.getOrElse("primary_storage_item", (Object)"minecraft:heart_of_the_sea");
            this.consumePrimaryStorageItem = (Boolean)storageConfig.getOrElse("consume_primary_storage_item", (Object)true);
        } else {
            PortableStorage.LOGGER.warn("\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u627e\u5230 [storage] \u90e8\u5206\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c");
        }
        Config containerConfig = (Config)this.config.get("container_display");
        if (containerConfig != null) {
            this.stonecutter = (Boolean)containerConfig.getOrElse("stonecutter", (Object)false);
            this.cartographyTable = (Boolean)containerConfig.getOrElse("cartography_table", (Object)false);
            this.smithingTable = (Boolean)containerConfig.getOrElse("smithing_table", (Object)false);
            this.grindstone = (Boolean)containerConfig.getOrElse("grindstone", (Object)false);
            this.loom = (Boolean)containerConfig.getOrElse("loom", (Object)false);
            this.furnace = (Boolean)containerConfig.getOrElse("furnace", (Object)false);
            this.smoker = (Boolean)containerConfig.getOrElse("smoker", (Object)false);
            this.blastFurnace = (Boolean)containerConfig.getOrElse("blast_furnace", (Object)false);
            this.anvil = (Boolean)containerConfig.getOrElse("anvil", (Object)false);
            this.enchantingTable = (Boolean)containerConfig.getOrElse("enchanting_table", (Object)false);
            this.brewingStand = (Boolean)containerConfig.getOrElse("brewing_stand", (Object)false);
            this.beacon = (Boolean)containerConfig.getOrElse("beacon", (Object)false);
            this.chest = (Boolean)containerConfig.getOrElse("chest", (Object)false);
            this.barrel = (Boolean)containerConfig.getOrElse("barrel", (Object)false);
            this.enderChest = (Boolean)containerConfig.getOrElse("ender_chest", (Object)false);
            this.shulkerBox = (Boolean)containerConfig.getOrElse("shulker_box", (Object)false);
            this.dispenser = (Boolean)containerConfig.getOrElse("dispenser", (Object)false);
            this.dropper = (Boolean)containerConfig.getOrElse("dropper", (Object)false);
            this.crafter = (Boolean)containerConfig.getOrElse("crafter", (Object)false);
            this.hopper = (Boolean)containerConfig.getOrElse("hopper", (Object)false);
            this.trappedChest = (Boolean)containerConfig.getOrElse("trapped_chest", (Object)false);
            this.hopperMinecart = (Boolean)containerConfig.getOrElse("hopper_minecart", (Object)false);
            this.chestMinecart = (Boolean)containerConfig.getOrElse("chest_minecart", (Object)false);
            this.chestBoat = (Boolean)containerConfig.getOrElse("chest_boat", (Object)false);
            this.bambooChestRaft = (Boolean)containerConfig.getOrElse("bamboo_chest_raft", (Object)false);
        } else {
            PortableStorage.LOGGER.warn("\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u627e\u5230 [container_display] \u90e8\u5206\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c");
        }
    }

    private void writeConfigValues() {
        Config storageConfig = (Config)this.config.get("storage");
        if (storageConfig == null) {
            storageConfig = this.config.createSubConfig();
            this.config.set("storage", (Object)storageConfig);
        }
        storageConfig.set("require_condition_to_enable", (Object)this.requireConditionToEnable);
        storageConfig.set("enable_item", (Object)this.enableItem);
        storageConfig.set("consume_enable_item", (Object)this.consumeEnableItem);
        storageConfig.set("enable_incremental_sync", (Object)this.enableIncrementalSync);
        storageConfig.set("enable_on_demand_sync", (Object)this.enableOnDemandSync);
        storageConfig.set("incremental_sync_interval_ticks", (Object)this.incrementalSyncIntervalTicks);
        storageConfig.set("incremental_sync_max_entries", (Object)this.incrementalSyncMaxEntries);
        storageConfig.set("clear_storage_on_enable", (Object)this.clearStorageOnEnable);
        storageConfig.set("enable_rift_feature", (Object)this.enableRiftFeature);
        storageConfig.set("rift_upgrade_item", (Object)this.riftUpgradeItem);
        storageConfig.set("rift_size", (Object)this.riftSize);
        storageConfig.set("limit_rift_height", (Object)this.limitRiftHeight);
        storageConfig.set("enable_virtual_crafting", (Object)this.enableVirtualCrafting);
        storageConfig.set("enable_infinite_lava", (Object)this.enableInfiniteLava);
        storageConfig.set("enable_infinite_water", (Object)this.enableInfiniteWater);
        storageConfig.set("infinite_lava_threshold", (Object)this.infiniteLavaThreshold);
        storageConfig.set("infinite_water_threshold", (Object)this.infiniteWaterThreshold);
        storageConfig.set("enable_size_limit", (Object)this.enableSizeLimit);
        storageConfig.set("max_storage_size_bytes", (Object)this.maxStorageSizeBytes);
        storageConfig.set("single_item_stack_limit", (Object)this.singleItemStackLimit);
        storageConfig.set("enable_primary_storage", (Object)this.enablePrimaryStorage);
        storageConfig.set("primary_storage_item", (Object)this.primaryStorageItem);
        storageConfig.set("consume_primary_storage_item", (Object)this.consumePrimaryStorageItem);
        Config containerConfig = (Config)this.config.get("container_display");
        if (containerConfig == null) {
            containerConfig = this.config.createSubConfig();
            this.config.set("container_display", (Object)containerConfig);
        }
        containerConfig.set("stonecutter", (Object)this.stonecutter);
        containerConfig.set("cartography_table", (Object)this.cartographyTable);
        containerConfig.set("smithing_table", (Object)this.smithingTable);
        containerConfig.set("grindstone", (Object)this.grindstone);
        containerConfig.set("loom", (Object)this.loom);
        containerConfig.set("furnace", (Object)this.furnace);
        containerConfig.set("smoker", (Object)this.smoker);
        containerConfig.set("blast_furnace", (Object)this.blastFurnace);
        containerConfig.set("anvil", (Object)this.anvil);
        containerConfig.set("enchanting_table", (Object)this.enchantingTable);
        containerConfig.set("brewing_stand", (Object)this.brewingStand);
        containerConfig.set("beacon", (Object)this.beacon);
        containerConfig.set("chest", (Object)this.chest);
        containerConfig.set("barrel", (Object)this.barrel);
        containerConfig.set("ender_chest", (Object)this.enderChest);
        containerConfig.set("shulker_box", (Object)this.shulkerBox);
        containerConfig.set("dispenser", (Object)this.dispenser);
        containerConfig.set("dropper", (Object)this.dropper);
        containerConfig.set("crafter", (Object)this.crafter);
        containerConfig.set("hopper", (Object)this.hopper);
        containerConfig.set("trapped_chest", (Object)this.trappedChest);
        containerConfig.set("hopper_minecart", (Object)this.hopperMinecart);
        containerConfig.set("chest_minecart", (Object)this.chestMinecart);
        containerConfig.set("chest_boat", (Object)this.chestBoat);
        containerConfig.set("bamboo_chest_raft", (Object)this.bambooChestRaft);
    }

    private boolean ensureDefaultsWritten() {
        String[] containerKeys;
        Config containerConfig;
        boolean changed = false;
        Config storageConfig = (Config)this.config.get("storage");
        if (storageConfig == null) {
            changed = true;
        }
        if (storageConfig == null || !storageConfig.contains("require_condition_to_enable")) {
            storageConfig.set("require_condition_to_enable", (Object)false);
            changed = true;
        }
        if (storageConfig == null || !storageConfig.contains("enable_item")) {
            storageConfig.set("enable_item", (Object)"minecraft:nether_star");
            changed = true;
        }
        if (storageConfig == null || !storageConfig.contains("consume_enable_item")) {
            storageConfig.set("consume_enable_item", (Object)true);
            changed = true;
        }
        if (storageConfig == null || !storageConfig.contains("enable_incremental_sync")) {
            storageConfig.set("enable_incremental_sync", (Object)false);
            changed = true;
        }
        if (storageConfig == null || !storageConfig.contains("enable_on_demand_sync")) {
            storageConfig.set("enable_on_demand_sync", (Object)true);
            changed = true;
        }
        if (storageConfig == null || !storageConfig.contains("incremental_sync_interval_ticks")) {
            storageConfig.set("incremental_sync_interval_ticks", (Object)2);
            changed = true;
        }
        if (storageConfig == null || !storageConfig.contains("incremental_sync_max_entries")) {
            storageConfig.set("incremental_sync_max_entries", (Object)512);
            changed = true;
        }
        if (storageConfig == null || !storageConfig.contains("single_item_stack_limit")) {
            storageConfig.set("single_item_stack_limit", (Object)-1);
            changed = true;
        }
        if ((containerConfig = (Config)this.config.get("container_display")) == null) {
            containerConfig = this.config.createSubConfig();
            this.config.set("container_display", (Object)containerConfig);
            changed = true;
        }
        for (String key : containerKeys = new String[]{"stonecutter", "cartography_table", "smithing_table", "grindstone", "loom", "furnace", "smoker", "blast_furnace", "anvil", "enchanting_table", "brewing_stand", "beacon", "chest", "barrel", "ender_chest", "shulker_box", "dispenser", "dropper", "crafter", "hopper", "trapped_chest", "hopper_minecart", "chest_minecart", "chest_boat", "bamboo_chest_raft"}) {
            if (containerConfig.contains(key)) continue;
            containerConfig.set(key, (Object)false);
            changed = true;
        }
        return changed;
    }

    private void writeMissingKeysWithCommentsTextually() {
        try {
            int containerSectionStart;
            String content = Files.readString(this.configPath);
            String sectionHeader = "[storage]";
            int sectionStart = ServerConfig.findSectionStart(content, sectionHeader);
            if (sectionStart < 0) {
                String block = ServerConfig.buildFullStorageSection();
                String sep = content.endsWith("\n") ? "" : System.lineSeparator();
                Files.writeString(this.configPath, (CharSequence)(content + sep + sep + block), new OpenOption[0]);
                return;
            }
            int sectionEnd = ServerConfig.findSectionEnd(content, sectionStart);
            String section = content.substring(sectionStart, sectionEnd);
            StringBuilder toAppend = new StringBuilder();
            if (!ServerConfig.containsKey(section, "require_condition_to_enable")) {
                toAppend.append(ServerConfig.buildRequireConditionBlock());
            }
            if (!ServerConfig.containsKey(section, "enable_item")) {
                toAppend.append(ServerConfig.buildEnableItemBlock());
            }
            if (!ServerConfig.containsKey(section, "consume_enable_item")) {
                toAppend.append(ServerConfig.buildConsumeEnableBlock());
            }
            if (!ServerConfig.containsKey(section, "enable_incremental_sync")) {
                toAppend.append(ServerConfig.buildIncrementalSyncBlock());
            }
            if (!ServerConfig.containsKey(section, "enable_on_demand_sync")) {
                toAppend.append(ServerConfig.buildOnDemandSyncBlock());
            }
            if (!ServerConfig.containsKey(section, "single_item_stack_limit")) {
                toAppend.append(ServerConfig.buildSingleItemStackLimitBlock());
            }
            if ((containerSectionStart = ServerConfig.findSectionStart(content, "[container_display]")) < 0) {
                toAppend.append(System.lineSeparator()).append(ServerConfig.buildFullContainerDisplaySection());
            } else {
                String[] containerKeys;
                int containerSectionEnd = ServerConfig.findSectionEnd(content, containerSectionStart);
                String containerSection = content.substring(containerSectionStart, containerSectionEnd);
                for (String key : containerKeys = new String[]{"stonecutter", "cartography_table", "smithing_table", "grindstone", "loom", "furnace", "smoker", "blast_furnace", "anvil", "enchanting_table", "brewing_stand", "beacon", "chest", "barrel", "ender_chest", "shulker_box", "dispenser", "dropper", "crafter", "hopper", "trapped_chest", "hopper_minecart", "chest_minecart", "chest_boat", "bamboo_chest_raft"}) {
                    if (ServerConfig.containsKey(containerSection, key)) continue;
                    toAppend.append(ServerConfig.buildContainerConfigBlock(key));
                }
            }
            if (toAppend.length() == 0) {
                return;
            }
            String insertion = (section.endsWith("\n\n") ? "" : (section.endsWith("\n") ? "\n" : "\n\n")) + toAppend.toString();
            String newContent = content.substring(0, sectionEnd) + insertion + content.substring(sectionEnd);
            Files.writeString(this.configPath, (CharSequence)newContent, new OpenOption[0]);
        }
        catch (IOException e) {
            PortableStorage.LOGGER.error("\u5199\u56de\u7f3a\u5931\u914d\u7f6e\u9879\u5931\u8d25(\u6587\u672c\u63d2\u5165)", (Throwable)e);
        }
    }

    private static int findSectionStart(String content, String header) {
        String[] lines = content.split("\n", -1);
        int pos = 0;
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.equals(header)) {
                return pos;
            }
            pos += line.length() + 1;
        }
        return -1;
    }

    private static int findSectionEnd(String content, int sectionStart) {
        int nextHeader = content.indexOf("\n[", sectionStart + 1);
        return nextHeader >= 0 ? nextHeader : content.length();
    }

    private static boolean containsKey(String sectionContent, String key) {
        String regex = "(^|\n)" + Pattern.quote(key) + " *= *";
        return Pattern.compile(regex).matcher(sectionContent).find();
    }

    private static String buildFullStorageSection() {
        String ls = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("[storage]").append(ls);
        sb.append(ServerConfig.buildRequireConditionBlock());
        sb.append(ServerConfig.buildEnableItemBlock());
        sb.append(ServerConfig.buildConsumeEnableBlock());
        sb.append(ServerConfig.buildIncrementalSyncBlock());
        sb.append(ServerConfig.buildOnDemandSyncBlock());
        sb.append(ServerConfig.buildSingleItemStackLimitBlock());
        sb.append(ls).append(ServerConfig.buildFullContainerDisplaySection());
        return sb.toString();
    }

    private static String buildRequireConditionBlock() {
        String ls = System.lineSeparator();
        return "# \u662f\u5426\u9700\u8981\u6761\u4ef6\u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93" + ls + "# \u542f\u7528\u540e\u73a9\u5bb6\u7684\u968f\u8eab\u4ed3\u5e93\u4e0d\u518d\u662f\u9ed8\u8ba4\u5c31\u6709\u7684\uff0c\u800c\u662f\u9700\u8981\u8fbe\u6210\u6761\u4ef6\u624d\u4f1a\u6709" + ls + "# \u9ed8\u8ba4\u503c: true" + ls + "require_condition_to_enable = true" + ls + ls;
    }

    private static String buildEnableItemBlock() {
        String ls = System.lineSeparator();
        return "# \u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\u7684\u9053\u5177" + ls + "# \u542f\u7528\"\u9700\u8981\u6761\u4ef6\u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\"\u540e\u7528\u4ee5\u542f\u7528\u73a9\u5bb6\u4ed3\u5e93\u7684\u7269\u54c1\uff0c\u624b\u6301\u53f3\u952e\u4ee5\u542f\u7528" + ls + "# \u9ed8\u8ba4\u503c: \"minecraft:nether_star\" (\u4e0b\u754c\u4e4b\u661f)" + ls + "# \u683c\u5f0f: \"\u547d\u540d\u7a7a\u95f4:\u7269\u54c1ID\"" + ls + "enable_item = \"minecraft:nether_star\"" + ls + ls;
    }

    private static String buildConsumeEnableBlock() {
        String ls = System.lineSeparator();
        return "# \u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\u7684\u9053\u5177\u662f\u5426\u6d88\u8017" + ls + "# \u5f00\u542f\u540e\u542f\u7528\u73a9\u5bb6\u968f\u8eab\u4ed3\u5e93\u65f6\u4f1a\u6d88\u8017\u8be5\u7269\u54c1\u4e00\u4e2a" + ls + "# \u9ed8\u8ba4\u503c: true" + ls + "consume_enable_item = true" + ls + ls;
    }

    private static String buildIncrementalSyncBlock() {
        String ls = System.lineSeparator();
        return "# \u662f\u5426\u542f\u7528\u589e\u91cf\u540c\u6b65" + ls + "# \u542f\u7528\u540e\u53ea\u540c\u6b65\u53d1\u751f\u53d8\u5316\u7684\u6570\u636e\uff0c\u51cf\u5c11\u7f51\u7edc\u4f20\u8f93\u91cf" + ls + "# \u53ef\u80fd\u5b58\u5728BUG\u672a\u53d1\u73b0\u6216\u672a\u4fee\u590d\u7684\u9519\u8bef" + ls + "# \u9ed8\u8ba4\u503c: false" + ls + "enable_incremental_sync = false" + ls + ls;
    }

    private static String buildOnDemandSyncBlock() {
        String ls = System.lineSeparator();
        return "# \u662f\u5426\u542f\u7528\u6309\u9700\u540c\u6b65" + ls + "# \u542f\u7528\u540e\u53ea\u5728\u73a9\u5bb6\u67e5\u770b\u4ed3\u5e93\u754c\u9762\u65f6\u624d\u540c\u6b65\uff0c\u5426\u5219\u79ef\u6512\u53d8\u5316" + ls + "# \u53ef\u4ee5\u663e\u8457\u51cf\u5c11\u670d\u52a1\u5668\u8d1f\u8f7d\uff0c\u4f46\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u5ef6\u8fdf" + ls + "# \u9ed8\u8ba4\u503c: false" + ls + "enable_on_demand_sync = false" + ls + ls;
    }

    private static String buildSingleItemStackLimitBlock() {
        String ls = System.lineSeparator();
        return "# \u5355\u79cd\u7269\u54c1\u7684\u5806\u53e0\u4e0a\u9650" + ls + "# -1 \u8868\u793a\u4e0d\u9650\u5236\uff08\u7b49\u6548\u4e8e Long.MAX_VALUE\uff09" + ls + "# \u6ce8\u610f\uff1a\u8be5\u9650\u5236\u9488\u5bf9\u540c\u4e00\u79cd\u7269\u54c1\u7684\u603b\u6570\u91cf\uff0c\u800c\u975e\u7269\u54c1\u5806\u53e0\u7684 NBT/\u7ec4\u4ef6\u53d8\u5316" + ls + "# \u9ed8\u8ba4\u503c: -1" + ls + "single_item_stack_limit = -1" + ls + ls;
    }

    private static String buildFullContainerDisplaySection() {
        String ls = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("[container_display]").append(ls);
        sb.append("# \u5de5\u4f5c\u53f0\u5347\u7ea7\u5728\u5bb9\u5668\u754c\u9762\u663e\u793a\u4ed3\u5e93\u7684\u914d\u7f6e").append(ls);
        sb.append("# \u542f\u7528\u5de5\u4f5c\u53f0\u5347\u7ea7\u540e\uff0c\u4ee5\u4e0b\u5bb9\u5668\u754c\u9762\u5c06\u663e\u793a\u4ed3\u5e93\u754c\u9762").append(ls);
        sb.append("# \u9ed8\u8ba4\u503c: \u5168\u90e8\u4e3a false").append(ls).append(ls);
        String[] containerConfigs = new String[]{"stonecutter", "\u5207\u77f3\u673a", "cartography_table", "\u5236\u56fe\u53f0", "smithing_table", "\u953b\u9020\u53f0", "grindstone", "\u7802\u8f6e", "loom", "\u7ec7\u5e03\u673a", "furnace", "\u7194\u7089", "smoker", "\u70df\u718f\u7089", "blast_furnace", "\u9ad8\u7089", "anvil", "\u94c1\u7827", "enchanting_table", "\u9644\u9b54\u53f0", "brewing_stand", "\u917f\u9020\u53f0", "beacon", "\u4fe1\u6807", "chest", "\u7bb1\u5b50", "barrel", "\u6728\u6876", "ender_chest", "\u672b\u5f71\u7bb1", "shulker_box", "\u6f5c\u5f71\u76d2", "dispenser", "\u53d1\u5c04\u5668", "dropper", "\u6295\u63b7\u5668", "crafter", "\u5408\u6210\u5668", "hopper", "\u6f0f\u6597", "trapped_chest", "\u9677\u9631\u7bb1", "hopper_minecart", "\u6f0f\u6597\u77ff\u8f66", "chest_minecart", "\u8fd0\u8f93\u77ff\u8f66", "chest_boat", "\u8fd0\u8f93\u8239", "bamboo_chest_raft", "\u8fd0\u8f93\u7af9\u7b4f"};
        for (int i = 0; i < containerConfigs.length; i += 2) {
            String key = containerConfigs[i];
            String comment = containerConfigs[i + 1];
            sb.append("# ").append(comment).append(ls);
            sb.append(key).append(" = false").append(ls);
        }
        return sb.toString();
    }

    private static String buildContainerConfigBlock(String key) {
        String ls = System.lineSeparator();
        String comment = ServerConfig.getContainerComment(key);
        return "# " + comment + ls + key + " = false" + ls;
    }

    private static String getContainerComment(String key) {
        switch (key) {
            case "stonecutter": {
                return "\u5207\u77f3\u673a";
            }
            case "cartography_table": {
                return "\u5236\u56fe\u53f0";
            }
            case "smithing_table": {
                return "\u953b\u9020\u53f0";
            }
            case "grindstone": {
                return "\u7802\u8f6e";
            }
            case "loom": {
                return "\u7ec7\u5e03\u673a";
            }
            case "furnace": {
                return "\u7194\u7089";
            }
            case "smoker": {
                return "\u70df\u718f\u7089";
            }
            case "blast_furnace": {
                return "\u9ad8\u7089";
            }
            case "anvil": {
                return "\u94c1\u7827";
            }
            case "enchanting_table": {
                return "\u9644\u9b54\u53f0";
            }
            case "brewing_stand": {
                return "\u917f\u9020\u53f0";
            }
            case "beacon": {
                return "\u4fe1\u6807";
            }
            case "chest": {
                return "\u7bb1\u5b50";
            }
            case "barrel": {
                return "\u6728\u6876";
            }
            case "ender_chest": {
                return "\u672b\u5f71\u7bb1";
            }
            case "shulker_box": {
                return "\u6f5c\u5f71\u76d2";
            }
            case "dispenser": {
                return "\u53d1\u5c04\u5668";
            }
            case "dropper": {
                return "\u6295\u63b7\u5668";
            }
            case "crafter": {
                return "\u5408\u6210\u5668";
            }
            case "hopper": {
                return "\u6f0f\u6597";
            }
            case "trapped_chest": {
                return "\u9677\u9631\u7bb1";
            }
            case "hopper_minecart": {
                return "\u6f0f\u6597\u77ff\u8f66";
            }
            case "chest_minecart": {
                return "\u8fd0\u8f93\u77ff\u8f66";
            }
            case "chest_boat": {
                return "\u8fd0\u8f93\u8239";
            }
            case "bamboo_chest_raft": {
                return "\u8fd0\u8f93\u7af9\u7b4f";
            }
        }
        return key;
    }

    private void setDefaultValues() {
        this.requireConditionToEnable = true;
        this.enableItem = "minecraft:nether_star";
        this.consumeEnableItem = true;
        this.enableIncrementalSync = false;
        this.enableOnDemandSync = true;
        this.enableInfiniteLava = true;
        this.enableInfiniteWater = true;
        this.infiniteLavaThreshold = 10000;
        this.infiniteWaterThreshold = 2;
        this.enableSizeLimit = true;
        this.maxStorageSizeBytes = 102400L;
        this.singleItemStackLimit = -1L;
        this.enablePrimaryStorage = true;
        this.primaryStorageItem = "minecraft:heart_of_the_sea";
        this.consumePrimaryStorageItem = true;
        this.stonecutter = false;
        this.cartographyTable = false;
        this.smithingTable = false;
        this.grindstone = false;
        this.loom = false;
        this.furnace = false;
        this.smoker = false;
        this.blastFurnace = false;
        this.anvil = false;
        this.enchantingTable = false;
        this.brewingStand = false;
        this.beacon = false;
        this.chest = false;
        this.barrel = false;
        this.enderChest = false;
        this.shulkerBox = false;
        this.dispenser = false;
        this.dropper = false;
        this.crafter = false;
        this.hopper = false;
        this.trappedChest = false;
        this.hopperMinecart = false;
        this.chestMinecart = false;
        this.chestBoat = false;
        this.bambooChestRaft = false;
    }

    public boolean isRequireConditionToEnable() {
        return this.requireConditionToEnable;
    }

    public String getEnableItem() {
        return this.enableItem;
    }

    public boolean isConsumeEnableItem() {
        return this.consumeEnableItem;
    }

    public boolean isEnableIncrementalSync() {
        return this.enableIncrementalSync;
    }

    public boolean isEnableOnDemandSync() {
        return this.enableOnDemandSync;
    }

    public int getIncrementalSyncIntervalTicks() {
        return this.incrementalSyncIntervalTicks;
    }

    public int getIncrementalSyncMaxEntries() {
        return this.incrementalSyncMaxEntries;
    }

    public boolean isClearStorageOnEnable() {
        return this.clearStorageOnEnable;
    }

    public boolean isEnablePrimaryStorage() {
        return this.enablePrimaryStorage;
    }

    public String getPrimaryStorageItem() {
        return this.primaryStorageItem;
    }

    public boolean isConsumePrimaryStorageItem() {
        return this.consumePrimaryStorageItem;
    }

    public boolean isEnableRiftFeature() {
        return this.enableRiftFeature;
    }

    public String getRiftUpgradeItem() {
        return this.riftUpgradeItem;
    }

    public int getRiftSize() {
        return this.riftSize;
    }

    public boolean isLimitRiftHeight() {
        return this.limitRiftHeight;
    }

    public boolean isEnableVirtualCrafting() {
        return this.enableVirtualCrafting;
    }

    public boolean isEnableInfiniteLava() {
        return this.enableInfiniteLava;
    }

    public boolean isEnableInfiniteWater() {
        return this.enableInfiniteWater;
    }

    public int getInfiniteLavaThreshold() {
        return this.infiniteLavaThreshold;
    }

    public int getInfiniteWaterThreshold() {
        return this.infiniteWaterThreshold;
    }

    public boolean isEnableSizeLimit() {
        return this.enableSizeLimit;
    }

    public long getMaxStorageSizeBytes() {
        return this.maxStorageSizeBytes;
    }

    public long getSingleItemStackLimit() {
        return this.singleItemStackLimit;
    }

    public void setRequireConditionToEnable(boolean requireConditionToEnable) {
        this.requireConditionToEnable = requireConditionToEnable;
    }

    public void setEnableItem(String enableItem) {
        this.enableItem = enableItem;
    }

    public void setConsumeEnableItem(boolean consumeEnableItem) {
        this.consumeEnableItem = consumeEnableItem;
    }

    public void setEnableIncrementalSync(boolean enableIncrementalSync) {
        this.enableIncrementalSync = enableIncrementalSync;
    }

    public void setEnableOnDemandSync(boolean enableOnDemandSync) {
        this.enableOnDemandSync = enableOnDemandSync;
    }

    public void setRiftUpgradeItem(String riftUpgradeItem) {
        this.riftUpgradeItem = riftUpgradeItem;
    }

    public void setRiftSize(int riftSize) {
        this.riftSize = riftSize;
    }

    public void setEnableVirtualCrafting(boolean enableVirtualCrafting) {
        this.enableVirtualCrafting = enableVirtualCrafting;
    }

    public void setEnableInfiniteLava(boolean enableInfiniteLava) {
        this.enableInfiniteLava = enableInfiniteLava;
    }

    public void setEnableInfiniteWater(boolean enableInfiniteWater) {
        this.enableInfiniteWater = enableInfiniteWater;
    }

    public void setInfiniteLavaThreshold(int infiniteLavaThreshold) {
        this.infiniteLavaThreshold = infiniteLavaThreshold;
    }

    public void setInfiniteWaterThreshold(int infiniteWaterThreshold) {
        this.infiniteWaterThreshold = infiniteWaterThreshold;
    }

    public void setEnableSizeLimit(boolean enableSizeLimit) {
        this.enableSizeLimit = enableSizeLimit;
    }

    public void setMaxStorageSizeBytes(long maxStorageSizeBytes) {
        this.maxStorageSizeBytes = maxStorageSizeBytes;
    }

    public void setSingleItemStackLimit(long singleItemStackLimit) {
        this.singleItemStackLimit = singleItemStackLimit;
    }

    public boolean isStonecutter() {
        return this.stonecutter;
    }

    public boolean isCartographyTable() {
        return this.cartographyTable;
    }

    public boolean isSmithingTable() {
        return this.smithingTable;
    }

    public boolean isGrindstone() {
        return this.grindstone;
    }

    public boolean isLoom() {
        return this.loom;
    }

    public boolean isFurnace() {
        return this.furnace;
    }

    public boolean isSmoker() {
        return this.smoker;
    }

    public boolean isBlastFurnace() {
        return this.blastFurnace;
    }

    public boolean isAnvil() {
        return this.anvil;
    }

    public boolean isEnchantingTable() {
        return this.enchantingTable;
    }

    public boolean isBrewingStand() {
        return this.brewingStand;
    }

    public boolean isBeacon() {
        return this.beacon;
    }

    public boolean isChest() {
        return this.chest;
    }

    public boolean isBarrel() {
        return this.barrel;
    }

    public boolean isEnderChest() {
        return this.enderChest;
    }

    public boolean isShulkerBox() {
        return this.shulkerBox;
    }

    public boolean isDispenser() {
        return this.dispenser;
    }

    public boolean isDropper() {
        return this.dropper;
    }

    public boolean isCrafter() {
        return this.crafter;
    }

    public boolean isHopper() {
        return this.hopper;
    }

    public boolean isTrappedChest() {
        return this.trappedChest;
    }

    public boolean isHopperMinecart() {
        return this.hopperMinecart;
    }

    public boolean isChestMinecart() {
        return this.chestMinecart;
    }

    public boolean isChestBoat() {
        return this.chestBoat;
    }

    public boolean isBambooChestRaft() {
        return this.bambooChestRaft;
    }

    public void setStonecutter(boolean stonecutter) {
        this.stonecutter = stonecutter;
    }

    public void setCartographyTable(boolean cartographyTable) {
        this.cartographyTable = cartographyTable;
    }

    public void setSmithingTable(boolean smithingTable) {
        this.smithingTable = smithingTable;
    }

    public void setGrindstone(boolean grindstone) {
        this.grindstone = grindstone;
    }

    public void setLoom(boolean loom) {
        this.loom = loom;
    }

    public void setFurnace(boolean furnace) {
        this.furnace = furnace;
    }

    public void setSmoker(boolean smoker) {
        this.smoker = smoker;
    }

    public void setBlastFurnace(boolean blastFurnace) {
        this.blastFurnace = blastFurnace;
    }

    public void setAnvil(boolean anvil) {
        this.anvil = anvil;
    }

    public void setEnchantingTable(boolean enchantingTable) {
        this.enchantingTable = enchantingTable;
    }

    public void setBrewingStand(boolean brewingStand) {
        this.brewingStand = brewingStand;
    }

    public void setBeacon(boolean beacon) {
        this.beacon = beacon;
    }

    public void setChest(boolean chest) {
        this.chest = chest;
    }

    public void setBarrel(boolean barrel) {
        this.barrel = barrel;
    }

    public void setEnderChest(boolean enderChest) {
        this.enderChest = enderChest;
    }

    public void setShulkerBox(boolean shulkerBox) {
        this.shulkerBox = shulkerBox;
    }

    public void setDispenser(boolean dispenser) {
        this.dispenser = dispenser;
    }

    public void setDropper(boolean dropper) {
        this.dropper = dropper;
    }

    public void setCrafter(boolean crafter) {
        this.crafter = crafter;
    }

    public void setHopper(boolean hopper) {
        this.hopper = hopper;
    }

    public void setTrappedChest(boolean trappedChest) {
        this.trappedChest = trappedChest;
    }

    public void setHopperMinecart(boolean hopperMinecart) {
        this.hopperMinecart = hopperMinecart;
    }

    public void setChestMinecart(boolean chestMinecart) {
        this.chestMinecart = chestMinecart;
    }

    public void setChestBoat(boolean chestBoat) {
        this.chestBoat = chestBoat;
    }

    public void setBambooChestRaft(boolean bambooChestRaft) {
        this.bambooChestRaft = bambooChestRaft;
    }

    public boolean shouldShowStorageInContainer(String containerId) {
        if (containerId == null) {
            return false;
        }
        switch (containerId) {
            case "minecraft:stonecutter": {
                return this.stonecutter;
            }
            case "minecraft:cartography_table": {
                return this.cartographyTable;
            }
            case "minecraft:smithing_table": {
                return this.smithingTable;
            }
            case "minecraft:grindstone": {
                return this.grindstone;
            }
            case "minecraft:loom": {
                return this.loom;
            }
            case "minecraft:furnace": {
                return this.furnace;
            }
            case "minecraft:smoker": {
                return this.smoker;
            }
            case "minecraft:blast_furnace": {
                return this.blastFurnace;
            }
            case "minecraft:anvil": {
                return this.anvil;
            }
            case "minecraft:enchanting_table": {
                return this.enchantingTable;
            }
            case "minecraft:brewing_stand": {
                return this.brewingStand;
            }
            case "minecraft:beacon": {
                return this.beacon;
            }
            case "minecraft:chest": {
                return this.chest;
            }
            case "minecraft:barrel": {
                return this.barrel;
            }
            case "minecraft:ender_chest": {
                return this.enderChest;
            }
            case "minecraft:shulker_box": {
                return this.shulkerBox;
            }
            case "minecraft:dispenser": {
                return this.dispenser;
            }
            case "minecraft:dropper": {
                return this.dropper;
            }
            case "minecraft:crafter": {
                return this.crafter;
            }
            case "minecraft:hopper": {
                return this.hopper;
            }
            case "minecraft:trapped_chest": {
                return this.trappedChest;
            }
            case "minecraft:hopper_minecart": {
                return this.hopperMinecart;
            }
            case "minecraft:chest_minecart": {
                return this.chestMinecart;
            }
            case "minecraft:oak_chest_boat": 
            case "minecraft:birch_chest_boat": 
            case "minecraft:spruce_chest_boat": 
            case "minecraft:jungle_chest_boat": 
            case "minecraft:acacia_chest_boat": 
            case "minecraft:dark_oak_chest_boat": 
            case "minecraft:mangrove_chest_boat": 
            case "minecraft:cherry_chest_boat": {
                return this.chestBoat;
            }
            case "minecraft:bamboo_chest_raft": {
                return this.bambooChestRaft;
            }
        }
        return false;
    }
}

