/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;

public final class OverlayCraftingManager {
    private static final Map<UUID, State> STATE_BY_PLAYER = new ConcurrentHashMap<UUID, State>();

    private OverlayCraftingManager() {
    }

    public static State get(class_3222 player) {
        return STATE_BY_PLAYER.computeIfAbsent(player.method_5667(), k -> new State());
    }

    public static void clear(class_3222 player) {
        STATE_BY_PLAYER.remove(player.method_5667());
    }

    public static void refundAll(class_3222 player) {
        State st = OverlayCraftingManager.get(player);
        for (int i = 1; i <= 9; ++i) {
            class_1799 s = st.slots[i];
            if (s.method_7960()) continue;
            class_1799 copy = s.method_7972();
            st.slots[i] = class_1799.field_8037;
            if (player.method_31548().method_7394(copy)) continue;
            player.method_7328(copy, false);
        }
        st.slots[0] = class_1799.field_8037;
        OverlayCraftingManager.updateResult(player, st);
        player.field_7512.method_7623();
    }

    public static void setInput(class_3222 player, int slot1to9, class_1799 stack) {
        if (slot1to9 < 1 || slot1to9 > 9) {
            return;
        }
        State st = OverlayCraftingManager.get(player);
        st.slots[slot1to9] = stack.method_7972();
        OverlayCraftingManager.updateResult(player, st);
    }

    public static void updateResult(class_3222 player) {
        OverlayCraftingManager.updateResult(player, OverlayCraftingManager.get(player));
    }

    private static void updateResult(class_3222 player, State st) {
        class_1860 class_18602;
        class_1937 world = player.method_37908();
        ArrayList<class_1799> list = new ArrayList<class_1799>(9);
        for (int i = 1; i <= 9; ++i) {
            list.add(st.slots[i].method_7972());
        }
        class_9694 input = class_9694.method_59986((int)3, (int)3, list);
        class_8786 match = world.method_8433().method_8132(class_3956.field_17545, (class_9695)input, world).orElse(null);
        if (match != null && (class_18602 = match.comp_1933()) instanceof class_3955) {
            class_1799 out;
            class_3955 recipe = (class_3955)class_18602;
            st.slots[0] = out = recipe.method_8116((class_9695)input, (class_7225.class_7874)world.method_30349());
        } else {
            st.slots[0] = class_1799.field_8037;
        }
    }

    public static void handleClick(class_3222 player, int slotIndex, int button, boolean shift) {
        if (slotIndex == -1) {
            OverlayCraftingManager.refundAll(player);
            return;
        }
        State st = OverlayCraftingManager.get(player);
        if (slotIndex == 0) {
            OverlayCraftingManager.handleResultClick(player, st, button, shift);
            return;
        }
        if (slotIndex >= 1 && slotIndex <= 9) {
            OverlayCraftingManager.handleInputClick(player, st, slotIndex, button, shift);
            return;
        }
    }

    private static void handleInputClick(class_3222 player, State st, int slot, int button, boolean shift) {
        class_1799 cursor = player.field_7512.method_34255();
        class_1799 slotStack = st.slots[slot];
        if (shift) {
            if (!slotStack.method_7960()) {
                if (!player.method_31548().method_7394(slotStack)) {
                    player.method_7328(slotStack, false);
                }
                st.slots[slot] = class_1799.field_8037;
            }
            OverlayCraftingManager.updateResult(player);
            return;
        }
        if (button == 0) {
            if (cursor.method_7960()) {
                player.field_7512.method_34254(slotStack.method_7972());
                st.slots[slot] = class_1799.field_8037;
            } else if (slotStack.method_7960()) {
                st.slots[slot] = cursor.method_7972();
                player.field_7512.method_34254(class_1799.field_8037);
            } else if (class_1799.method_31577((class_1799)cursor, (class_1799)slotStack)) {
                int max = Math.min(slotStack.method_7914(), player.method_31548().method_5444());
                int can = Math.min(cursor.method_7947(), Math.max(0, max - slotStack.method_7947()));
                if (can > 0) {
                    slotStack.method_7933(can);
                    cursor.method_7934(can);
                    player.field_7512.method_34254(cursor);
                } else {
                    st.slots[slot] = cursor.method_7972();
                    player.field_7512.method_34254(slotStack.method_7972());
                }
            } else {
                st.slots[slot] = cursor.method_7972();
                player.field_7512.method_34254(slotStack.method_7972());
            }
        } else if (button == 1) {
            if (cursor.method_7960()) {
                if (!slotStack.method_7960()) {
                    int half = (int)Math.ceil((double)slotStack.method_7947() / 2.0);
                    class_1799 taken = slotStack.method_7972();
                    taken.method_7939(half);
                    slotStack.method_7934(half);
                    if (slotStack.method_7960()) {
                        st.slots[slot] = class_1799.field_8037;
                    }
                    player.field_7512.method_34254(taken);
                }
            } else if (slotStack.method_7960()) {
                class_1799 put = cursor.method_7972();
                put.method_7939(1);
                st.slots[slot] = put;
                cursor.method_7934(1);
                player.field_7512.method_34254(cursor);
            } else if (class_1799.method_31577((class_1799)cursor, (class_1799)slotStack)) {
                int max = Math.min(slotStack.method_7914(), player.method_31548().method_5444());
                if (slotStack.method_7947() < max && cursor.method_7947() > 0) {
                    slotStack.method_7933(1);
                    cursor.method_7934(1);
                    player.field_7512.method_34254(cursor);
                }
            }
        }
        OverlayCraftingManager.updateResult(player, st);
        player.field_7512.method_7623();
    }

    private static void handleResultClick(class_3222 player, State st, int button, boolean shift) {
        if (st.slots[0].method_7960()) {
            return;
        }
        class_1799 resultTemplate = st.slots[0].method_7972();
        class_1937 world = player.method_37908();
        int maxCrafts = OverlayCraftingManager.maxCraftableTimes(world, st);
        if (maxCrafts <= 0) {
            return;
        }
        if (shift) {
            for (int crafted = 0; crafted < maxCrafts; ++crafted) {
                class_1799 out = resultTemplate.method_7972();
                if (player.method_31548().method_7394(out)) {
                    OverlayCraftingManager.consumeOnce(player, st);
                    continue;
                }
                break;
            }
        } else {
            class_1799 out = resultTemplate.method_7972();
            class_1799 cursor = player.field_7512.method_34255();
            if (button == 1) {
                out.method_7939(1);
            }
            OverlayCraftingManager.tryPlaceToCursorOrInventory(player, cursor, out);
            OverlayCraftingManager.consumeOnce(player, st);
        }
        OverlayCraftingManager.updateResult(player, st);
        player.field_7512.method_7623();
    }

    private static boolean tryPlaceToCursorOrInventory(class_3222 player, class_1799 cursor, class_1799 out) {
        boolean placed = false;
        if (cursor.method_7960()) {
            player.field_7512.method_34254(out);
            placed = true;
        } else if (class_1799.method_31577((class_1799)cursor, (class_1799)out)) {
            int max = Math.min(out.method_7914(), player.method_31548().method_5444());
            int can = Math.min(out.method_7947(), Math.max(0, max - cursor.method_7947()));
            if (can > 0) {
                cursor.method_7933(can);
                out.method_7934(can);
                player.field_7512.method_34254(cursor);
                placed = out.method_7960();
            }
        }
        if (!placed && !player.method_31548().method_7394(out)) {
            player.method_7328(out, false);
        }
        return true;
    }

    private static int maxCraftableTimes(class_1937 world, State st) {
        ArrayList<class_1799> list = new ArrayList<class_1799>(9);
        for (int i = 1; i <= 9; ++i) {
            list.add(st.slots[i].method_7972());
        }
        class_9694 input = class_9694.method_59986((int)3, (int)3, list);
        class_8786 match = world.method_8433().method_8132(class_3956.field_17545, (class_9695)input, world).orElse(null);
        if (match == null || !(match.comp_1933() instanceof class_3955)) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (int i = 1; i <= 9; ++i) {
            if (st.slots[i].method_7960()) continue;
            min = Math.min(min, st.slots[i].method_7947());
        }
        return min == Integer.MAX_VALUE ? 0 : Math.max(0, min);
    }

    private static void consumeOnce(class_3222 player, State st) {
        for (int i = 1; i <= 9; ++i) {
            class_1799 s = st.slots[i];
            if (s.method_7960()) continue;
            class_1792 remainderItem = s.method_7909().method_7858();
            s.method_7934(1);
            if (remainderItem != null) {
                class_1799 rem = new class_1799((class_1935)remainderItem);
                if (s.method_7960()) {
                    st.slots[i] = rem;
                    continue;
                }
                if (player.method_31548().method_7394(rem)) continue;
                player.method_7328(rem, false);
                continue;
            }
            if (!s.method_7960()) continue;
            st.slots[i] = class_1799.field_8037;
        }
    }

    public static final class State {
        public final class_1799[] slots = new class_1799[10];

        public State() {
            Arrays.fill(this.slots, class_1799.field_8037);
        }
    }
}

