/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.storage.AutoEatMode;
import com.portable.storage.storage.UpgradeInventory;
import com.portable.storage.util.FoodUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class EnchantedGoldenAppleHandler {
    private static final Map<UUID, Long> lastCheckTime = new HashMap<UUID, Long>();
    private static final long CHECK_INTERVAL = 20L;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            long currentTime = server.method_3780();
            for (class_3222 player : server.method_3760().method_14571()) {
                UUID playerId = player.method_5667();
                Long lastCheck = lastCheckTime.get(playerId);
                if (lastCheck != null && currentTime - lastCheck < 20L) continue;
                EnchantedGoldenAppleHandler.checkAndAutoEat(player);
                lastCheckTime.put(playerId, currentTime);
            }
        });
    }

    private static void checkAndAutoEat(class_3222 player) {
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        if (!access.portableStorage$isStorageEnabled()) {
            return;
        }
        if (!upgrades.isEnchantedGoldenAppleUpgradeActive()) {
            return;
        }
        AutoEatMode currentMode = ServerNetworkingHandlers.getPlayerAutoEatMode(player);
        if (!currentMode.isEnabled()) {
            return;
        }
        int feedCount = currentMode.getFeedCount();
        if (!FoodUtils.needsFood(player, feedCount)) {
            return;
        }
        FoodUtils.AutoEatResult result = FoodUtils.autoEatFromNewStore(player, feedCount);
        if (result.success) {
            if (result.itemsConsumed > 0) {
                String foodName = result.lastFoodName != null ? result.lastFoodName : "\u98df\u7269";
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.enchanted_golden_apple.auto_eat", (Object[])new Object[]{result.itemsConsumed, foodName, result.foodRestored}), true);
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.enchanted_golden_apple.no_food"), true);
        }
    }
}

