/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.config.ServerConfig;
import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.sync.PlayerViewState;
import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3222;

public final class IncrementalSyncTickHandler {
    private static int tickCounter = 0;
    private static int intervalTicks = 2;

    private IncrementalSyncTickHandler() {
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList<class_3222> targets;
            ++tickCounter;
            try {
                ServerConfig cfg = ServerConfig.getInstance();
                if (!cfg.isEnableIncrementalSync()) {
                    return;
                }
                intervalTicks = Math.max(1, cfg.getIncrementalSyncIntervalTicks());
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if (tickCounter % intervalTicks != 0) {
                return;
            }
            try {
                ServerConfig cfg = ServerConfig.getInstance();
                if (cfg.isEnableOnDemandSync()) {
                    ArrayList<class_3222> list = new ArrayList<class_3222>();
                    for (UUID uuid : PlayerViewState.getViewingPlayers()) {
                        class_3222 p = server.method_3760().method_14602(uuid);
                        if (p == null) continue;
                        list.add(p);
                    }
                    targets = list;
                } else {
                    targets = server.method_3760().method_14571();
                }
            }
            catch (Throwable t) {
                targets = server.method_3760().method_14571();
            }
            for (class_3222 p : targets) {
                try {
                    ServerNetworkingHandlers.sendIncrementalSyncOnDemand(p);
                }
                catch (Throwable throwable) {}
            }
        });
    }
}

