/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.storage.UpgradeInventory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class PistonUpgradeHandler {
    private static final Map<UUID, Long> lastCheckTime = new HashMap<UUID, Long>();
    private static final long CHECK_INTERVAL = 6L;
    private static final Map<UUID, class_1799> lastMainHandItems = new HashMap<UUID, class_1799>();
    private static final Map<UUID, class_1799> lastOffHandItems = new HashMap<UUID, class_1799>();
    private static final Map<UUID, Integer> lastMainHandSlot = new HashMap<UUID, Integer>();

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            long currentTime = server.method_3780();
            for (class_3222 player : server.method_3760().method_14571()) {
                UUID playerId = player.method_5667();
                Long lastCheck = lastCheckTime.get(playerId);
                if (lastCheck != null && currentTime - lastCheck < 6L) continue;
                PistonUpgradeHandler.checkAndRefillHands(player);
                lastCheckTime.put(playerId, currentTime);
            }
        });
    }

    private static void checkAndRefillHands(class_3222 player) {
        boolean mainHandSlotChanged;
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        UUID playerId = player.method_5667();
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        if (!access.portableStorage$isStorageEnabled()) {
            PistonUpgradeHandler.cleanupPlayer(playerId);
            return;
        }
        if (!upgrades.isPistonUpgradeActive()) {
            PistonUpgradeHandler.cleanupPlayer(playerId);
            return;
        }
        class_1799 currentMainHand = player.method_6047();
        class_1799 lastMainHand = lastMainHandItems.get(playerId);
        int currentMainHandSlot = player.method_31548().field_7545;
        Integer lastMainHandSlotIndex = lastMainHandSlot.get(playerId);
        boolean bl = mainHandSlotChanged = lastMainHandSlotIndex != null && lastMainHandSlotIndex != currentMainHandSlot;
        if (!mainHandSlotChanged && PistonUpgradeHandler.shouldRefillSlot(currentMainHand, lastMainHand)) {
            class_1799 targetStack = currentMainHand.method_7960() ? lastMainHand : currentMainHand;
            PistonUpgradeHandler.refillFromStorage(player, targetStack, class_1268.field_5808);
        }
        lastMainHandItems.put(playerId, currentMainHand.method_7972());
        lastMainHandSlot.put(playerId, currentMainHandSlot);
        class_1799 currentOffHand = player.method_6079();
        class_1799 lastOffHand = lastOffHandItems.get(playerId);
        if (PistonUpgradeHandler.shouldRefillSlot(currentOffHand, lastOffHand)) {
            class_1799 targetStack = currentOffHand.method_7960() ? lastOffHand : currentOffHand;
            PistonUpgradeHandler.refillFromStorage(player, targetStack, class_1268.field_5810);
        }
        lastOffHandItems.put(playerId, currentOffHand.method_7972());
    }

    private static boolean shouldRefillSlot(class_1799 current, class_1799 last) {
        if (last == null || last.method_7960()) {
            return false;
        }
        if (current.method_7960()) {
            return true;
        }
        if (!class_1799.method_31577((class_1799)current, (class_1799)last)) {
            return false;
        }
        if (current.method_7947() < last.method_7947()) {
            int maxCount = current.method_7914();
            if (maxCount > 1) {
                int halfStack = maxCount / 2;
                return current.method_7947() < halfStack;
            }
            return true;
        }
        return false;
    }

    private static void refillFromStorage(class_3222 player, class_1799 targetStack, class_1268 hand) {
        if (targetStack.method_7960()) {
            return;
        }
        class_1799 currentStack = hand == class_1268.field_5808 ? player.method_6047() : player.method_6079();
        int currentCount = currentStack.method_7960() ? 0 : currentStack.method_7947();
        int maxCount = targetStack.method_7914();
        int needCount = maxCount - currentCount;
        if (needCount <= 0) {
            return;
        }
        long availableCount = ServerNetworkingHandlers.getAvailableCount(player, targetStack);
        if (availableCount <= 0L) {
            return;
        }
        int actualTake = (int)Math.min((long)needCount, availableCount);
        long taken = ServerNetworkingHandlers.takeFromStorage(player, targetStack, actualTake);
        if (taken <= 0L) {
            return;
        }
        if (currentStack.method_7960()) {
            class_1799 newStack = targetStack.method_7972();
            newStack.method_7939((int)taken);
            if (hand == class_1268.field_5808) {
                player.method_6122(class_1268.field_5808, newStack);
            } else {
                player.method_6122(class_1268.field_5810, newStack);
            }
        } else {
            class_1799 newStack = currentStack.method_7972();
            newStack.method_7939(currentCount + (int)taken);
            if (hand == class_1268.field_5808) {
                player.method_6122(class_1268.field_5808, newStack);
            } else {
                player.method_6122(class_1268.field_5810, newStack);
            }
        }
        ServerNetworkingHandlers.sendSync(player);
        PistonUpgradeHandler.showRefillMessage(player, targetStack, (int)taken, availableCount - taken);
    }

    private static void showRefillMessage(class_3222 player, class_1799 itemStack, int refilledCount, long remainingCount) {
        if (refilledCount <= 0) {
            return;
        }
        String itemName = itemStack.method_7964().getString();
        class_5250 message = class_2561.method_43469((String)"portable-storage.piston.refill_message", (Object[])new Object[]{refilledCount, itemName, remainingCount});
        player.method_7353((class_2561)message, true);
    }

    public static void cleanupPlayer(UUID playerId) {
        lastCheckTime.remove(playerId);
        lastMainHandItems.remove(playerId);
        lastOffHandItems.remove(playerId);
        lastMainHandSlot.remove(playerId);
    }
}

