/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.PortableStorage;
import com.portable.storage.item.StorageKeyItem;
import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.world.SpaceRiftManager;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;

public class PlayerDeathEventHandler {
    public static void register() {
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (oldPlayer == null || newPlayer == null) {
                return;
            }
            try {
                PlayerStorageAccess oldAccess = (PlayerStorageAccess)oldPlayer;
                PlayerStorageAccess newAccess = (PlayerStorageAccess)newPlayer;
                if (oldAccess.portableStorage$getInventory() != null) {
                    newAccess.portableStorage$setInventory(oldAccess.portableStorage$getInventory());
                }
                if (oldAccess.portableStorage$getUpgradeInventory() != null) {
                    newAccess.portableStorage$setUpgradeInventory(oldAccess.portableStorage$getUpgradeInventory());
                }
                ServerNetworkingHandlers.sendSync(newPlayer);
                PortableStorage.LOGGER.info("Restored portable storage data for player {} after respawn", (Object)newPlayer.method_5477().getString());
            }
            catch (Exception e) {
                PortableStorage.LOGGER.error("Failed to restore portable storage data for player {} after respawn", (Object)newPlayer.method_5477().getString(), (Object)e);
            }
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            if (oldPlayer == null || newPlayer == null) {
                return;
            }
            try {
                PlayerStorageAccess oldAccess = (PlayerStorageAccess)oldPlayer;
                PlayerStorageAccess newAccess = (PlayerStorageAccess)newPlayer;
                if (oldAccess.portableStorage$isStorageEnabled()) {
                    boolean keepInventory = newPlayer.method_37908().method_8450().method_8355(class_1928.field_19389);
                    if (!keepInventory) {
                        newAccess.portableStorage$setStorageEnabled(false);
                        if (oldPlayer.method_37908().method_27983() == SpaceRiftManager.DIMENSION_KEY) {
                            PlayerDeathEventHandler.dropStorageKeyAtReturnPoint(oldPlayer);
                        } else {
                            PlayerDeathEventHandler.dropStorageKeyAtPosition(oldPlayer, oldPlayer.method_19538());
                        }
                        PortableStorage.LOGGER.info("Player {} died with storage enabled, dropped storage key", (Object)oldPlayer.method_5477().getString());
                    } else {
                        newAccess.portableStorage$setStorageEnabled(true);
                        PortableStorage.LOGGER.info("Player {} died with keepInventory enabled, storage remains active", (Object)oldPlayer.method_5477().getString());
                    }
                }
                if (oldAccess.portableStorage$getInventory() != null) {
                    newAccess.portableStorage$setInventory(oldAccess.portableStorage$getInventory());
                }
                if (oldAccess.portableStorage$getUpgradeInventory() != null) {
                    newAccess.portableStorage$setUpgradeInventory(oldAccess.portableStorage$getUpgradeInventory());
                }
                PortableStorage.LOGGER.info("Copied portable storage data for player {} during respawn", (Object)newPlayer.method_5477().getString());
            }
            catch (Exception e) {
                PortableStorage.LOGGER.error("Failed to copy portable storage data for player {} during respawn", (Object)newPlayer.method_5477().getString(), (Object)e);
            }
        });
    }

    private static void dropStorageKeyAtReturnPoint(class_3222 player) {
        try {
            class_4208 returnPoint = SpaceRiftManager.getReturnPoint(player.method_5667());
            if (returnPoint != null) {
                class_3218 returnWorld = player.method_5682().method_3847(returnPoint.comp_2207());
                if (returnWorld != null) {
                    class_243 returnPos = class_243.method_24953((class_2382)returnPoint.comp_2208());
                    PlayerDeathEventHandler.dropStorageKeyAtPosition(player, returnWorld, returnPos);
                    PortableStorage.LOGGER.info("Dropped storage key for player {} at return point {}", (Object)player.method_5477().getString(), (Object)returnPoint);
                } else {
                    class_3218 overworld = player.method_5682().method_30002();
                    class_2338 spawn = overworld.method_43126();
                    PlayerDeathEventHandler.dropStorageKeyAtPosition(player, overworld, class_243.method_24953((class_2382)spawn));
                    PortableStorage.LOGGER.info("Return world not found, dropped storage key for player {} at overworld spawn", (Object)player.method_5477().getString());
                }
            } else {
                class_3218 overworld = player.method_5682().method_30002();
                class_2338 spawn = overworld.method_43126();
                PlayerDeathEventHandler.dropStorageKeyAtPosition(player, overworld, class_243.method_24953((class_2382)spawn));
                PortableStorage.LOGGER.info("No return point found, dropped storage key for player {} at overworld spawn", (Object)player.method_5477().getString());
            }
        }
        catch (Exception e) {
            PortableStorage.LOGGER.error("Failed to drop storage key at return point for player {}", (Object)player.method_5477().getString(), (Object)e);
        }
    }

    private static void dropStorageKeyAtPosition(class_3222 player, class_243 position) {
        PlayerDeathEventHandler.dropStorageKeyAtPosition(player, player.method_51469(), position);
    }

    private static void dropStorageKeyAtPosition(class_3222 player, class_3218 world, class_243 position) {
        try {
            class_1799 storageKey = StorageKeyItem.createStorageKey(player);
            class_1542 itemEntity = new class_1542((class_1937)world, position.field_1352, position.field_1351, position.field_1350, storageKey);
            itemEntity.method_6982(40);
            itemEntity.method_18800(0.0, 0.2, 0.0);
            world.method_8649((class_1297)itemEntity);
            PortableStorage.LOGGER.info("Dropped storage key for player {} at position {}", (Object)player.method_5477().getString(), (Object)position);
        }
        catch (Exception e) {
            PortableStorage.LOGGER.error("Failed to drop storage key for player {}", (Object)player.method_5477().getString(), (Object)e);
        }
    }
}

