/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.PortableStorage;
import com.portable.storage.config.ServerConfig;
import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.newstore.NewStoreService;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.storage.StorageType;
import com.portable.storage.storage.UpgradeInventory;
import com.portable.storage.util.StorageActivationConfirmation;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class PlayerInteractEventHandler {
    public static void register() {
        UseItemCallback.EVENT.register(PlayerInteractEventHandler::onUseItem);
    }

    private static class_1271<class_1799> onUseItem(class_1657 player, class_1937 world, class_1268 hand) {
        StorageType currentType;
        if (world.field_9236) {
            return class_1271.method_22430((Object)player.method_5998(hand));
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1799 stack = player.method_5998(hand);
        ServerConfig config = ServerConfig.getInstance();
        if (!config.isRequireConditionToEnable()) {
            return class_1271.method_22430((Object)stack);
        }
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        if (access.portableStorage$isStorageEnabled() && (currentType = access.portableStorage$getStorageType()) == StorageType.FULL) {
            return class_1271.method_22430((Object)stack);
        }
        String enableItemId = config.getEnableItem();
        String primaryStorageItemId = config.getPrimaryStorageItem();
        String currentItemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        StorageType targetStorageType = null;
        if (enableItemId.equals(currentItemId)) {
            targetStorageType = StorageType.FULL;
        } else if (config.isEnablePrimaryStorage() && primaryStorageItemId.equals(currentItemId)) {
            targetStorageType = StorageType.PRIMARY;
        }
        if (targetStorageType == null) {
            return class_1271.method_22430((Object)stack);
        }
        if (access.portableStorage$isStorageEnabled()) {
            currentType = access.portableStorage$getStorageType();
            if (currentType != StorageType.PRIMARY || targetStorageType != StorageType.FULL) {
                if (currentType == StorageType.FULL && targetStorageType == StorageType.PRIMARY) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.cannot_downgrade_storage").method_27692(class_124.field_1061), false);
                    return class_1271.method_22431((Object)stack);
                }
                if (currentType == targetStorageType) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.storage_already_enabled").method_27692(class_124.field_1054), false);
                    return class_1271.method_22431((Object)stack);
                }
            }
        } else {
            currentType = access.portableStorage$getStorageType();
            if (currentType == StorageType.FULL && targetStorageType == StorageType.PRIMARY && !config.isClearStorageOnEnable()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.cannot_downgrade_storage").method_27692(class_124.field_1061), false);
                return class_1271.method_22431((Object)stack);
            }
        }
        if (StorageActivationConfirmation.hasPendingConfirmation(serverPlayer)) {
            if (StorageActivationConfirmation.confirmActivation(serverPlayer)) {
                return PlayerInteractEventHandler.performStorageActivation(serverPlayer, stack, hand, config, targetStorageType);
            }
            StorageActivationConfirmation.cancelPendingConfirmation(serverPlayer);
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.activation_timeout").method_27692(class_124.field_1061), false);
            return class_1271.method_22431((Object)stack);
        }
        if (config.isClearStorageOnEnable()) {
            boolean newStorageHasData;
            boolean oldStorageHasData = !access.portableStorage$getInventory().isEmpty();
            boolean bl = newStorageHasData = !NewStoreService.isPlayerStorageEmpty(serverPlayer);
            if (oldStorageHasData || newStorageHasData) {
                StorageActivationConfirmation.setPendingConfirmation(serverPlayer);
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.confirm_activation").method_27692(class_124.field_1054), false);
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.confirm_activation_hint").method_27692(class_124.field_1080), false);
                return class_1271.method_22431((Object)stack);
            }
        }
        return PlayerInteractEventHandler.performStorageActivation(serverPlayer, stack, hand, config, targetStorageType);
    }

    private static class_1271<class_1799> performStorageActivation(class_3222 player, class_1799 stack, class_1268 hand, ServerConfig config, StorageType storageType) {
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        boolean wasAlreadyEnabled = access.portableStorage$isStorageEnabled();
        StorageType previousType = wasAlreadyEnabled ? access.portableStorage$getStorageType() : null;
        access.portableStorage$setStorageEnabled(true);
        access.portableStorage$setStorageType(storageType);
        if (config.isClearStorageOnEnable() && !wasAlreadyEnabled) {
            access.portableStorage$getInventory().clear();
            NewStoreService.clearPlayerStorage(player);
            PortableStorage.LOGGER.info("Cleared storage data for player {} when enabling storage", (Object)player.method_5477().getString());
            try {
                UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
                for (int i = 0; i < upgrades.getBaseSlotCount(); ++i) {
                    upgrades.setStack(i, class_1799.field_8037);
                }
                upgrades.clearExtendedSlots();
                upgrades.setTrashSlot(class_1799.field_8037);
                upgrades.setFluidStack(class_1799.field_8037);
                upgrades.setFluidUnits("lava", 0);
                upgrades.setFluidUnits("water", 0);
                upgrades.setFluidUnits("milk", 0);
                ServerNetworkingHandlers.sendUpgradeSync(player);
                ServerNetworkingHandlers.sendSync(player);
            }
            catch (Throwable upgrades) {
                // empty catch block
            }
        }
        boolean shouldConsume = false;
        if (storageType == StorageType.FULL && config.isConsumeEnableItem()) {
            shouldConsume = true;
        } else if (storageType == StorageType.PRIMARY && config.isConsumePrimaryStorageItem()) {
            shouldConsume = true;
        }
        if (shouldConsume) {
            if (stack.method_7947() > 1) {
                stack.method_7934(1);
            } else {
                player.method_6122(hand, class_1799.field_8037);
            }
        }
        String itemName = stack.method_7909().method_7848().getString();
        String messageKey = wasAlreadyEnabled && previousType == StorageType.PRIMARY && storageType == StorageType.FULL ? "portable-storage.message.storage_upgraded" : (storageType == StorageType.PRIMARY ? "portable-storage.message.primary_storage_enabled" : "portable-storage.message.storage_enabled");
        player.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{itemName}).method_27692(class_124.field_1060), false);
        if (wasAlreadyEnabled && previousType == StorageType.PRIMARY && storageType == StorageType.FULL) {
            ServerNetworkingHandlers.sendUpgradeSync(player);
            ServerNetworkingHandlers.sendSync(player);
            ServerNetworkingHandlers.sendEnablementSync(player);
        }
        PortableStorage.LOGGER.info("Player {} enabled portable storage with item {}", (Object)player.method_5477().getString(), (Object)config.getEnableItem());
        return class_1271.method_22427((Object)player.method_5998(hand));
    }
}

