/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.command.NewStoreCommands;
import com.portable.storage.event.PistonUpgradeHandler;
import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.storage.StorageInventory;
import com.portable.storage.storage.UpgradeInventory;
import com.portable.storage.sync.ChangeAccumulator;
import com.portable.storage.sync.PlayerViewState;
import com.portable.storage.sync.StorageSyncManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PlayerJoinEventHandler {
    private static final Map<UUID, Integer> pendingMigrations = new HashMap<UUID, Integer>();

    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            ServerNetworkingHandlers.sendEnablementSync(player);
            pendingMigrations.put(player.method_5667(), 20);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.field_14140;
            StorageSyncManager.cleanupPlayer(player.method_5667());
            PlayerViewState.cleanupPlayer(player.method_5667());
            ChangeAccumulator.cleanupPlayer(player.method_5667());
            PistonUpgradeHandler.cleanupPlayer(player.method_5667());
            UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
            if (upgrades.isTrashSlotActive()) {
                upgrades.setTrashSlot(class_1799.field_8037);
            }
            pendingMigrations.remove(player.method_5667());
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (pendingMigrations.isEmpty()) {
                return;
            }
            ArrayList<UUID> due = new ArrayList<UUID>();
            for (Map.Entry<UUID, Integer> e : pendingMigrations.entrySet()) {
                int left = e.getValue() - 1;
                if (left <= 0) {
                    due.add(e.getKey());
                    continue;
                }
                pendingMigrations.put(e.getKey(), left);
            }
            for (UUID id : due) {
                boolean ok;
                pendingMigrations.remove(id);
                class_3222 p = server.method_3760().method_14602(id);
                if (p == null) continue;
                StorageInventory legacy = PlayerStorageService.getInventory((class_1657)p);
                boolean hasOld = false;
                for (int i = 0; i < legacy.getCapacity() && !hasOld; ++i) {
                    if (legacy.getCountByIndex(i) <= 0L) continue;
                    hasOld = true;
                }
                if (!hasOld || !(ok = NewStoreCommands.migrateOne(server, id))) continue;
                p.method_43496((class_2561)class_2561.method_43471((String)"message.portable-storage.newstore.migrated"));
            }
        });
    }
}

