/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.PortableStorage;
import com.portable.storage.config.ServerConfig;
import com.portable.storage.world.SpaceRiftManager;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.server.MinecraftServer;

public final class SpaceRiftEvents {
    private SpaceRiftEvents() {
    }

    public static void register() {
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {});
        ServerTickEvents.END_SERVER_TICK.register(SpaceRiftEvents::onEndServerTick);
        ServerLifecycleEvents.SERVER_STARTED.register(SpaceRiftEvents::onServerStarted);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            try {
                UUID id = handler.field_14140.method_5667();
                SpaceRiftManager.setPlayerPlotForced(server, id, true);
                if (!ServerConfig.getInstance().isEnableRiftFeature() && handler.field_14140.method_37908().method_27983() == SpaceRiftManager.DIMENSION_KEY) {
                    server.execute(() -> SpaceRiftManager.safelyKickPlayerFromRift(handler.field_14140));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            try {
                UUID id = handler.field_14140.method_5667();
                SpaceRiftManager.setPlayerPlotForced(server, id, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private static void onEndServerTick(MinecraftServer server) {
        class_3218 rift = SpaceRiftManager.getWorld(server);
        if (rift == null) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            boolean isSpectatorOrCreative;
            if (player.method_37908() != rift) continue;
            boolean bl = isSpectatorOrCreative = player.method_7325() || player.method_7337();
            if (!isSpectatorOrCreative) {
                SpaceRiftManager.applyPersonalBorder(player);
            }
            SpaceRiftManager.updateLastRiftPos(player);
            if (isSpectatorOrCreative) continue;
            class_2338 pos = player.method_24515();
            if (pos.method_10264() < rift.method_31607()) {
                SpaceRiftEvents.exitRiftFromVoid(player);
                continue;
            }
            if (SpaceRiftManager.isInsideOwnPlot(player, pos)) continue;
            class_1923 origin = SpaceRiftManager.ensureAllocatedPlot(server, player.method_5667());
            class_2338 center = SpaceRiftManager.getPlotCenterBlock(origin);
            player.method_14251(rift, (double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5, player.method_36454(), player.method_36455());
        }
    }

    private static void exitRiftFromVoid(class_3222 player) {
        try {
            UUID id = player.method_5667();
            class_4208 returnPoint = SpaceRiftManager.getReturnPoint(id);
            if (returnPoint != null) {
                class_3218 targetWorld = player.method_5682().method_3847(returnPoint.comp_2207());
                if (targetWorld != null) {
                    class_2338 pos = returnPoint.comp_2208();
                    SpaceRiftManager.clearReturnPoint(id);
                    SpaceRiftManager.resetToWorldBorder(player);
                    SpaceRiftManager.ensureAvatarOnExit(player);
                    player.method_14251(targetWorld, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                    player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.rift_void_exit"), true);
                    PortableStorage.LOGGER.info("Player {} exited rift from void to return point", (Object)player.method_5477().getString());
                } else {
                    SpaceRiftEvents.exitToOverworldSpawn(player);
                }
            } else {
                SpaceRiftEvents.exitToOverworldSpawn(player);
            }
        }
        catch (Exception e) {
            PortableStorage.LOGGER.error("Failed to exit player {} from rift void", (Object)player.method_5477().getString(), (Object)e);
            SpaceRiftEvents.exitToOverworldSpawn(player);
        }
    }

    private static void exitToOverworldSpawn(class_3222 player) {
        try {
            class_3218 overworld = player.method_5682().method_30002();
            class_2338 spawn = overworld.method_43126();
            SpaceRiftManager.clearReturnPoint(player.method_5667());
            SpaceRiftManager.resetToWorldBorder(player);
            SpaceRiftManager.ensureAvatarOnExit(player);
            player.method_14251(overworld, (double)spawn.method_10263() + 0.5, (double)spawn.method_10264(), (double)spawn.method_10260() + 0.5, player.method_36454(), player.method_36455());
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.rift_void_exit_spawn"), true);
            PortableStorage.LOGGER.info("Player {} exited rift from void to overworld spawn", (Object)player.method_5477().getString());
        }
        catch (Exception e) {
            PortableStorage.LOGGER.error("Failed to exit player {} to overworld spawn", (Object)player.method_5477().getString(), (Object)e);
        }
    }

    private static void onServerStarted(MinecraftServer server) {
        server.execute(() -> {
            try {
                if (!ServerConfig.getInstance().isEnableRiftFeature()) {
                    for (class_3222 player : server.method_3760().method_14571()) {
                        if (player.method_37908().method_27983() != SpaceRiftManager.DIMENSION_KEY) continue;
                        SpaceRiftManager.safelyKickPlayerFromRift(player);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

