/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.config.ServerConfig;
import com.portable.storage.world.SpaceRiftManager;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class SpaceRiftProtectionEvents {
    private SpaceRiftProtectionEvents() {
    }

    public static void register() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            if (world.method_27983() != SpaceRiftManager.DIMENSION_KEY) {
                return class_1269.field_5811;
            }
            if (!(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_2338 placePos = hitResult.method_17777().method_10093(hitResult.method_17780());
            if (!SpaceRiftProtectionEvents.isAllowedBuild((class_3222)player, placePos)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (world.method_27983() != SpaceRiftManager.DIMENSION_KEY) {
                return true;
            }
            if (!(player instanceof class_3222)) {
                return true;
            }
            return SpaceRiftProtectionEvents.isAllowedBuild((class_3222)player, pos);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 100 == 0) {
                SpaceRiftProtectionEvents.cleanupBoundaryViolations(server);
            }
        });
    }

    private static boolean isAllowedBuild(class_3222 player, class_2338 pos) {
        if (player.method_7325() || player.method_7337()) {
            return true;
        }
        boolean insideXZ = SpaceRiftManager.isInsideOwnPlot(player, pos);
        boolean insideY = true;
        if (ServerConfig.getInstance().isLimitRiftHeight()) {
            int bottom = player.method_37908().method_31607();
            int top = player.method_37908().method_31600() - 1;
            insideY = pos.method_10264() >= bottom && pos.method_10264() <= top;
        }
        return insideXZ && insideY;
    }

    private static void cleanupBoundaryViolations(MinecraftServer server) {
        class_3218 riftWorld = SpaceRiftManager.getWorld(server);
        if (riftWorld == null) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player.method_37908() != riftWorld || player.method_7325() || player.method_7337()) continue;
            SpaceRiftProtectionEvents.cleanupPlayerPlot(riftWorld, player);
        }
    }

    private static void cleanupPlayerPlot(class_3218 world, class_3222 player) {
        class_1923 origin = SpaceRiftManager.getPlayerPlotOrigin(player.method_5667());
        if (origin == null) {
            return;
        }
        int chunkSize = SpaceRiftManager.getPlotChunkSize();
        int minX = origin.method_8326();
        int minZ = origin.method_8328();
        int maxX = minX + 16 * chunkSize - 1;
        int maxZ = minZ + 16 * chunkSize - 1;
        for (int x = minX - 1; x <= maxX + 1; ++x) {
            for (int z = minZ - 1; z <= maxZ + 1; ++z) {
                boolean isBoundary;
                boolean bl = isBoundary = x == minX - 1 || x == maxX + 1 || z == minZ - 1 || z == maxZ + 1;
                if (!isBoundary) continue;
                for (int y = world.method_31607(); y < world.method_31600(); ++y) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    if (state.method_26215() || SpaceRiftProtectionEvents.isAllowedBuild(player, pos)) continue;
                    world.method_8501(pos, class_2246.field_10124.method_9564());
                }
            }
        }
    }
}

