/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.item.StorageKeyItem;
import com.portable.storage.player.PlayerStorageAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class StorageKeyAutoUseHandler {
    private static final Map<UUID, Long> lastCheckTime = new HashMap<UUID, Long>();
    private static final long CHECK_INTERVAL = 20L;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            long currentTime = server.method_3780();
            for (class_3222 player : server.method_3760().method_14571()) {
                UUID playerId = player.method_5667();
                Long lastCheck = lastCheckTime.get(playerId);
                if (lastCheck != null && currentTime - lastCheck < 20L) continue;
                StorageKeyAutoUseHandler.checkAndAutoUseStorageKey(player);
                lastCheckTime.put(playerId, currentTime);
            }
        });
    }

    private static void checkAndAutoUseStorageKey(class_3222 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!StorageKeyItem.isStorageKey(stack) || !StorageKeyItem.isOwner(player, stack)) continue;
            StorageKeyAutoUseHandler.autoUseStorageKey(player, stack, i);
            return;
        }
    }

    private static void autoUseStorageKey(class_3222 player, class_1799 stack, int slotIndex) {
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        if (access.portableStorage$isStorageEnabled()) {
            StorageKeyAutoUseHandler.consumeStorageKey(player, stack, slotIndex);
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.storage_key_consumed_already_enabled").method_27692(class_124.field_1054), false);
        } else {
            access.portableStorage$setStorageEnabled(true);
            StorageKeyAutoUseHandler.consumeStorageKey(player, stack, slotIndex);
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.storage_reactivated").method_27692(class_124.field_1060), false);
        }
    }

    private static void consumeStorageKey(class_3222 player, class_1799 stack, int slotIndex) {
        if (stack.method_7947() > 1) {
            stack.method_7934(1);
        } else {
            player.method_31548().method_5447(slotIndex, class_1799.field_8037);
        }
    }
}

