/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.net.ServerNetworkingHandlers;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.server.MinecraftServer;

public class TempBedCleanupHandler {
    private static long lastCleanupTime = 0L;
    private static final long CLEANUP_INTERVAL = 20L;

    public static void tick(MinecraftServer server) {
        long currentTime = server.method_30002().method_8510();
        if (currentTime - lastCleanupTime < 20L) {
            return;
        }
        lastCleanupTime = currentTime;
        for (class_1937 world : server.method_3738()) {
            TempBedCleanupHandler.cleanupTempBedsInWorld(world, currentTime);
        }
    }

    private static void cleanupTempBedsInWorld(class_1937 world, long currentTime) {
        Set<class_2338> tempBedPositions = ServerNetworkingHandlers.getTempBedPositions();
        Iterator<class_2338> iterator = tempBedPositions.iterator();
        while (iterator.hasNext()) {
            class_2338 pos = iterator.next();
            if (pos.method_10264() < world.method_31607() || pos.method_10264() > world.method_31600() || !TempBedCleanupHandler.shouldCleanupTempBed(world, pos, currentTime)) continue;
            ServerNetworkingHandlers.cleanupCompleteTempBed(pos, world);
            iterator.remove();
        }
    }

    private static boolean shouldCleanupTempBed(class_1937 world, class_2338 pos, long currentTime) {
        if (world.method_8530()) {
            return true;
        }
        return ServerNetworkingHandlers.isTempBedExpired(pos, currentTime);
    }
}

