/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.event;

import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.storage.UpgradeInventory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class XpMaintenanceHandler {
    private static final Map<UUID, Integer> lastPlayerLevels = new HashMap<UUID, Integer>();

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                XpMaintenanceHandler.checkAndMaintainLevel(player);
            }
        });
    }

    private static void checkAndMaintainLevel(class_3222 player) {
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        if (!access.portableStorage$isStorageEnabled()) {
            lastPlayerLevels.remove(player.method_5667());
            return;
        }
        if (!upgrades.isXpBottleUpgradeActive() || !upgrades.isLevelMaintenanceEnabled()) {
            lastPlayerLevels.remove(player.method_5667());
            return;
        }
        int currentLevel = player.field_7520;
        UUID playerId = player.method_5667();
        Integer lastLevel = lastPlayerLevels.get(playerId);
        if (lastLevel == null) {
            lastPlayerLevels.put(playerId, currentLevel);
            return;
        }
        if (lastLevel.equals(currentLevel)) {
            return;
        }
        int levelDiff = currentLevel - lastLevel;
        if (levelDiff > 0) {
            int xpToDeposit = XpMaintenanceHandler.calculateXpForLevels(lastLevel, levelDiff);
            if (xpToDeposit > 0) {
                upgrades.addToXpPool(xpToDeposit);
                player.field_7520 = lastLevel;
                player.field_7510 = 0.0f;
                player.method_7255(0);
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.maintenance_deposit", (Object[])new Object[]{xpToDeposit}), true);
            }
        } else if (levelDiff < 0) {
            int xpNeeded = XpMaintenanceHandler.calculateXpForLevels(currentLevel, -levelDiff);
            long availableXp = upgrades.getXpPool();
            if (availableXp >= (long)xpNeeded) {
                upgrades.removeFromXpPool(xpNeeded);
                player.field_7520 = lastLevel;
                player.field_7510 = 0.0f;
                player.method_7255(0);
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.maintenance_withdraw", (Object[])new Object[]{xpNeeded}), true);
            } else if (availableXp > 0L) {
                upgrades.removeFromXpPool(availableXp);
                player.method_7255((int)Math.min(Integer.MAX_VALUE, availableXp));
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.maintenance_partial", (Object[])new Object[]{availableXp}), true);
            }
        }
        lastPlayerLevels.put(playerId, player.field_7520);
    }

    private static int calculateXpForLevels(int baseLevel, int levels) {
        if (levels <= 0) {
            return 0;
        }
        int from = XpMaintenanceHandler.totalXpForLevel(baseLevel);
        int to = XpMaintenanceHandler.totalXpForLevel(baseLevel + levels);
        return Math.max(0, to - from);
    }

    private static int totalXpForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }
}

