/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.item;

import com.portable.storage.PortableStorage;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.storage.StorageType;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class StorageKeyItem
extends class_1792 {
    public static final String NBT_OWNER_UUID = "storage_key_owner_uuid";
    public static final String NBT_OWNER_NAME = "storage_key_owner_name";
    public static final String NBT_DROP_TICK = "storage_key_drop_tick";

    public StorageKeyItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        class_3222 serverPlayer = (class_3222)user;
        class_1799 stack = user.method_5998(hand);
        if (!StorageKeyItem.isOwner(serverPlayer, stack)) {
            user.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.key_not_owner").method_27692(class_124.field_1061), false);
            return class_1271.method_22431((Object)stack);
        }
        PlayerStorageAccess access = (PlayerStorageAccess)serverPlayer;
        if (access.portableStorage$isStorageEnabled()) {
            user.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.storage_already_enabled").method_27692(class_124.field_1054), false);
            return class_1271.method_22431((Object)stack);
        }
        access.portableStorage$setStorageEnabled(true);
        access.portableStorage$setStorageType(StorageType.PRIMARY);
        if (stack.method_7947() > 1) {
            stack.method_7934(1);
        } else {
            user.method_6122(hand, class_1799.field_8037);
        }
        user.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.primary_storage_reactivated").method_27692(class_124.field_1060), false);
        PortableStorage.LOGGER.info("Player {} reactivated storage using storage key", (Object)serverPlayer.method_5477().getString());
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public static class_1799 createStorageKey(class_3222 player) {
        class_1799 key = new class_1799((class_1935)PortableStorage.STORAGE_KEY_ITEM);
        key.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)new class_2487()));
        class_2487 nbt = StorageKeyItem.getCustomData(key);
        nbt.method_25927(NBT_OWNER_UUID, player.method_5667());
        String playerName = player.method_7334() != null ? player.method_7334().getName() : player.method_5477().getString();
        nbt.method_10582(NBT_OWNER_NAME, playerName);
        nbt.method_10544(NBT_DROP_TICK, player.method_37908().method_8510());
        StorageKeyItem.setCustomData(key, nbt);
        key.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"item.portable-storage.storage_key").method_27692(class_124.field_1065));
        key.method_57379(class_9334.field_49633, (Object)class_9304.field_49385);
        return key;
    }

    public static boolean isOwner(class_3222 player, class_1799 stack) {
        if (player == null || stack == null || stack.method_7960()) {
            return false;
        }
        if (!StorageKeyItem.isStorageKey(stack)) {
            return false;
        }
        class_2487 nbt = StorageKeyItem.getCustomData(stack);
        if (nbt == null || !nbt.method_25928(NBT_OWNER_UUID)) {
            return false;
        }
        try {
            UUID owner = nbt.method_25926(NBT_OWNER_UUID);
            return owner.equals(player.method_5667());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isStorageKey(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_7909() != PortableStorage.STORAGE_KEY_ITEM) {
            return false;
        }
        class_2487 nbt = StorageKeyItem.getCustomData(stack);
        return nbt != null && nbt.method_25928(NBT_OWNER_UUID);
    }

    public static class_2561 getBoundTooltip(class_1799 stack) {
        if (!StorageKeyItem.isStorageKey(stack)) {
            return null;
        }
        class_2487 nbt = StorageKeyItem.getCustomData(stack);
        if (nbt == null || !nbt.method_25928(NBT_OWNER_UUID)) {
            return null;
        }
        String name = nbt.method_10545(NBT_OWNER_NAME) ? nbt.method_10558(NBT_OWNER_NAME) : "?";
        UUID uuid = nbt.method_25926(NBT_OWNER_UUID);
        String uuidPart = uuid.toString();
        return class_2561.method_43469((String)"portable-storage.tooltip.bound_to", (Object[])new Object[]{name, uuidPart}).method_27692(class_124.field_1080);
    }

    public static void markDropTick(class_1799 stack, long tick) {
        class_2487 nbt = StorageKeyItem.getCustomData(stack);
        nbt.method_10544(NBT_DROP_TICK, tick);
        StorageKeyItem.setCustomData(stack, nbt);
    }

    public static long getDropTick(class_1799 stack) {
        class_2487 nbt = StorageKeyItem.getCustomData(stack);
        return nbt.method_10545(NBT_DROP_TICK) ? nbt.method_10537(NBT_DROP_TICK) : -1L;
    }

    private static class_2487 getCustomData(class_1799 stack) {
        try {
            class_9279 comp = (class_9279)stack.method_57824(class_9334.field_49628);
            return comp != null ? comp.method_57461() : new class_2487();
        }
        catch (Exception e) {
            return new class_2487();
        }
    }

    private static void setCustomData(class_1799 stack, class_2487 nbt) {
        try {
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

