/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.mixin;

import com.portable.storage.config.ServerConfig;
import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.net.payload.SyncFilterRulesC2SPayload;
import com.portable.storage.newstore.NewStoreService;
import com.portable.storage.player.PlayerEnablementState;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.storage.AutoEatMode;
import com.portable.storage.storage.FilterRuleManager;
import com.portable.storage.storage.StorageInventory;
import com.portable.storage.storage.StorageType;
import com.portable.storage.storage.UpgradeInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements PlayerStorageAccess {
    @Unique
    private StorageInventory portableStorage$inventory;
    @Unique
    private UpgradeInventory portableStorage$upgradeInventory;
    @Unique
    private boolean portableStorage$enabled = false;
    @Unique
    private StorageType portableStorage$storageType = StorageType.FULL;
    @Unique
    private static final String PORTABLE_STORAGE_NBT = "portable_storage";
    @Unique
    private static final String PORTABLE_STORAGE_UPGRADES_NBT = "portable_storage_upgrades";
    @Unique
    private static final String PORTABLE_STORAGE_ENABLED_NBT = "portable_storage_enabled";
    @Unique
    private static final String PORTABLE_STORAGE_TYPE_NBT = "portable_storage_type";
    @Unique
    private static final String PORTABLE_STORAGE_AUTO_EAT_MODE_NBT = "portable_storage_auto_eat_mode";
    @Unique
    private static final String PORTABLE_STORAGE_FILTER_RULES_NBT = "portable_storage_filter_rules";
    @Unique
    private static final String PORTABLE_STORAGE_DESTROY_RULES_NBT = "portable_storage_destroy_rules";
    @Unique
    private long portableStorage$lastHopperCheck = 0L;
    @Unique
    private static final long HOPPER_CHECK_INTERVAL = 20L;

    @Override
    public StorageInventory portableStorage$getInventory() {
        if (this.portableStorage$inventory == null) {
            this.portableStorage$inventory = new StorageInventory(54);
        }
        return this.portableStorage$inventory;
    }

    @Override
    public void portableStorage$setInventory(StorageInventory inventory) {
        this.portableStorage$inventory = inventory;
    }

    @Override
    public UpgradeInventory portableStorage$getUpgradeInventory() {
        if (this.portableStorage$upgradeInventory == null) {
            this.portableStorage$upgradeInventory = new UpgradeInventory();
        }
        return this.portableStorage$upgradeInventory;
    }

    @Override
    public void portableStorage$setUpgradeInventory(UpgradeInventory inventory) {
        this.portableStorage$upgradeInventory = inventory;
    }

    @Override
    public boolean portableStorage$isStorageEnabled() {
        ServerConfig config = ServerConfig.getInstance();
        if (!config.isRequireConditionToEnable()) {
            return this.portableStorage$enabled;
        }
        return this.portableStorage$enabled;
    }

    @Override
    public void portableStorage$setStorageEnabled(boolean enabled) {
        class_1657 self = (class_1657)this;
        this.portableStorage$enabled = enabled;
        if (self instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)self;
            PlayerEnablementState state = PlayerEnablementState.get(serverPlayer.method_5682());
            state.setPlayerEnabled(serverPlayer.method_5667(), enabled);
        }
    }

    @Override
    public StorageType portableStorage$getStorageType() {
        return this.portableStorage$storageType;
    }

    @Override
    public void portableStorage$setStorageType(StorageType type) {
        this.portableStorage$storageType = type;
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void portableStorage$read(class_2487 nbt, CallbackInfo ci) {
        class_1657 self = (class_1657)this;
        if (nbt.method_10545(PORTABLE_STORAGE_NBT)) {
            StorageInventory inv = new StorageInventory(54);
            class_5455 lookup = null;
            try {
                if (self != null && self.method_56673() != null) {
                    lookup = self.method_56673();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (lookup != null) {
                inv.readNbt(nbt.method_10562(PORTABLE_STORAGE_NBT), (class_7225.class_7874)lookup);
            } else {
                inv.readNbt(nbt.method_10562(PORTABLE_STORAGE_NBT));
            }
            this.portableStorage$inventory = inv;
        }
        if (nbt.method_10545(PORTABLE_STORAGE_UPGRADES_NBT)) {
            UpgradeInventory upgrades = new UpgradeInventory();
            upgrades.readNbt(nbt.method_10562(PORTABLE_STORAGE_UPGRADES_NBT));
            this.portableStorage$upgradeInventory = upgrades;
        }
        if (nbt.method_10545(PORTABLE_STORAGE_ENABLED_NBT)) {
            this.portableStorage$enabled = nbt.method_10577(PORTABLE_STORAGE_ENABLED_NBT);
        } else {
            ServerConfig config = ServerConfig.getInstance();
            boolean bl = this.portableStorage$enabled = !config.isRequireConditionToEnable();
        }
        if (nbt.method_10545(PORTABLE_STORAGE_TYPE_NBT)) {
            String typeKey = nbt.method_10558(PORTABLE_STORAGE_TYPE_NBT);
            this.portableStorage$storageType = StorageType.fromKey(typeKey);
        } else {
            this.portableStorage$storageType = StorageType.FULL;
        }
        if (self instanceof class_3222) {
            class_2487 ruleNbt;
            int i;
            int count;
            class_3222 serverPlayer = (class_3222)self;
            if (nbt.method_10545(PORTABLE_STORAGE_AUTO_EAT_MODE_NBT)) {
                int modeIndex = nbt.method_10550(PORTABLE_STORAGE_AUTO_EAT_MODE_NBT);
                AutoEatMode mode = AutoEatMode.fromIndex(modeIndex);
                ServerNetworkingHandlers.setPlayerAutoEatMode(serverPlayer, mode);
            }
            ArrayList<SyncFilterRulesC2SPayload.FilterRule> filterRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>();
            ArrayList<SyncFilterRulesC2SPayload.FilterRule> destroyRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>();
            if (nbt.method_10545(PORTABLE_STORAGE_FILTER_RULES_NBT)) {
                class_2487 filterRulesNbt = nbt.method_10562(PORTABLE_STORAGE_FILTER_RULES_NBT);
                count = filterRulesNbt.method_10550("count");
                for (i = 0; i < count; ++i) {
                    if (!filterRulesNbt.method_10545("rule_" + i)) continue;
                    ruleNbt = filterRulesNbt.method_10562("rule_" + i);
                    filterRules.add(new SyncFilterRulesC2SPayload.FilterRule(ruleNbt.method_10558("matchRule"), ruleNbt.method_10577("isWhitelist"), ruleNbt.method_10577("enabled")));
                }
            }
            if (nbt.method_10545(PORTABLE_STORAGE_DESTROY_RULES_NBT)) {
                class_2487 destroyRulesNbt = nbt.method_10562(PORTABLE_STORAGE_DESTROY_RULES_NBT);
                count = destroyRulesNbt.method_10550("count");
                for (i = 0; i < count; ++i) {
                    if (!destroyRulesNbt.method_10545("rule_" + i)) continue;
                    ruleNbt = destroyRulesNbt.method_10562("rule_" + i);
                    destroyRules.add(new SyncFilterRulesC2SPayload.FilterRule(ruleNbt.method_10558("matchRule"), ruleNbt.method_10577("isWhitelist"), ruleNbt.method_10577("enabled")));
                }
            }
            if (!filterRules.isEmpty() || !destroyRules.isEmpty()) {
                FilterRuleManager.syncPlayerRules(serverPlayer, filterRules, destroyRules);
            }
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void portableStorage$write(class_2487 nbt, CallbackInfo ci) {
        class_2487 out;
        if (this.portableStorage$inventory != null) {
            out = new class_2487();
            class_5455 lookup = null;
            try {
                class_1657 self = (class_1657)this;
                if (self != null && self.method_56673() != null) {
                    lookup = self.method_56673();
                }
            }
            catch (Throwable self) {
                // empty catch block
            }
            if (lookup != null) {
                this.portableStorage$inventory.writeNbt(out, (class_7225.class_7874)lookup);
            } else {
                this.portableStorage$inventory.writeNbt(out);
            }
            nbt.method_10566(PORTABLE_STORAGE_NBT, (class_2520)out);
        }
        if (this.portableStorage$upgradeInventory != null) {
            out = new class_2487();
            this.portableStorage$upgradeInventory.writeNbt(out);
            nbt.method_10566(PORTABLE_STORAGE_UPGRADES_NBT, (class_2520)out);
        }
        nbt.method_10556(PORTABLE_STORAGE_ENABLED_NBT, this.portableStorage$enabled);
        nbt.method_10582(PORTABLE_STORAGE_TYPE_NBT, this.portableStorage$storageType.getKey());
        class_1657 self = (class_1657)this;
        if (self instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)self;
            AutoEatMode mode = ServerNetworkingHandlers.getPlayerAutoEatMode(serverPlayer);
            nbt.method_10569(PORTABLE_STORAGE_AUTO_EAT_MODE_NBT, mode.getIndex());
            FilterRuleManager.PlayerFilterRules rules = FilterRuleManager.getPlayerRules(serverPlayer);
            if (rules != null) {
                class_2487 ruleNbt;
                SyncFilterRulesC2SPayload.FilterRule rule;
                int i;
                if (!rules.filterRules.isEmpty()) {
                    class_2487 filterRulesNbt = new class_2487();
                    filterRulesNbt.method_10569("count", rules.filterRules.size());
                    for (i = 0; i < rules.filterRules.size(); ++i) {
                        rule = rules.filterRules.get(i);
                        ruleNbt = new class_2487();
                        ruleNbt.method_10582("matchRule", rule.matchRule);
                        ruleNbt.method_10556("isWhitelist", rule.isWhitelist);
                        ruleNbt.method_10556("enabled", rule.enabled);
                        filterRulesNbt.method_10566("rule_" + i, (class_2520)ruleNbt);
                    }
                    nbt.method_10566(PORTABLE_STORAGE_FILTER_RULES_NBT, (class_2520)filterRulesNbt);
                }
                if (!rules.destroyRules.isEmpty()) {
                    class_2487 destroyRulesNbt = new class_2487();
                    destroyRulesNbt.method_10569("count", rules.destroyRules.size());
                    for (i = 0; i < rules.destroyRules.size(); ++i) {
                        rule = rules.destroyRules.get(i);
                        ruleNbt = new class_2487();
                        ruleNbt.method_10582("matchRule", rule.matchRule);
                        ruleNbt.method_10556("isWhitelist", rule.isWhitelist);
                        ruleNbt.method_10556("enabled", rule.enabled);
                        destroyRulesNbt.method_10566("rule_" + i, (class_2520)ruleNbt);
                    }
                    nbt.method_10566(PORTABLE_STORAGE_DESTROY_RULES_NBT, (class_2520)destroyRulesNbt);
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void portableStorage$tick(CallbackInfo ci) {
        long currentTime;
        class_1657 self = (class_1657)this;
        class_1937 world = self.method_37908();
        if (this.portableStorage$hasHopperUpgrade(self) && (currentTime = world.method_8510()) - this.portableStorage$lastHopperCheck >= 20L) {
            this.portableStorage$lastHopperCheck = currentTime;
            this.portableStorage$collectNearbyItems(self, world);
        }
    }

    @Unique
    private boolean portableStorage$hasHopperUpgrade(class_1657 player) {
        if (this.portableStorage$upgradeInventory == null) {
            return false;
        }
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        if (!access.portableStorage$isStorageEnabled()) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            class_1799 stack = this.portableStorage$upgradeInventory.getStack(i);
            if (stack.method_7960() || stack.method_7909() != class_1802.field_8239 || this.portableStorage$upgradeInventory.isSlotDisabled(i, (class_3222)player)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private void portableStorage$collectNearbyItems(class_1657 player, class_1937 world) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            FilterRuleManager.requestRulesSync(sp);
        }
        class_238 searchBox = new class_238(player.method_23317() - 5.0, player.method_23318() - 5.0, player.method_23321() - 5.0, player.method_23317() + 5.0, player.method_23318() + 5.0, player.method_23321() + 5.0);
        List itemEntities = world.method_8390(class_1542.class, searchBox, item -> item.method_5805() && !item.method_6983().method_7960());
        for (class_1542 itemEntity : itemEntities) {
            String fluidType;
            class_1799 itemStack = itemEntity.method_6983();
            if (itemStack.method_7960() || !(player instanceof class_3222)) continue;
            class_3222 sp = (class_3222)player;
            if (UpgradeInventory.isValidFluidItem(itemStack) && !itemStack.method_31574(class_1802.field_8550) && (fluidType = UpgradeInventory.getFluidType(itemStack)) != null) {
                class_1799 emptyBucket;
                long accepted;
                UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)sp);
                ServerConfig config = ServerConfig.getInstance();
                boolean shouldNotAdd = false;
                if (fluidType.equals("lava") && config.isEnableInfiniteLava()) {
                    int units = upgrades.getFluidUnits(fluidType);
                    shouldNotAdd = units >= config.getInfiniteLavaThreshold();
                } else if (fluidType.equals("water") && config.isEnableInfiniteWater()) {
                    int units = upgrades.getFluidUnits(fluidType);
                    boolean bl = shouldNotAdd = units >= config.getInfiniteWaterThreshold();
                }
                if (!shouldNotAdd) {
                    upgrades.addFluidUnits(fluidType, 1);
                }
                if ((accepted = NewStoreService.insertCountForOnlinePlayer(sp, emptyBucket = new class_1799((class_1935)class_1802.field_8550))) <= 0L) {
                    sp.method_7328(emptyBucket, false);
                }
                itemEntity.method_31472();
                continue;
            }
            boolean shouldProcess = false;
            boolean shouldDiscard = false;
            if (FilterRuleManager.shouldDestroyItem(sp, itemStack)) {
                shouldProcess = true;
                shouldDiscard = true;
            } else if (FilterRuleManager.shouldPickupItem(sp, itemStack)) {
                PlayerStorageAccess access = (PlayerStorageAccess)sp;
                StorageType storageType = access.portableStorage$getStorageType();
                if (storageType.hasCapacityLimit()) {
                    if (!NewStoreService.canAddNewItemType(sp, itemStack)) {
                        shouldProcess = false;
                        shouldDiscard = false;
                    } else {
                        long accepted = NewStoreService.insertCountForOnlinePlayer(sp, itemStack);
                        if (accepted > 0L) {
                            shouldProcess = true;
                            cnt = itemStack.method_7947();
                            if (accepted >= (long)cnt) {
                                shouldDiscard = true;
                            } else {
                                itemStack.method_7939(cnt - (int)Math.min(Integer.MAX_VALUE, accepted));
                                shouldDiscard = false;
                            }
                        }
                    }
                } else {
                    long accepted = NewStoreService.insertCountForOnlinePlayer(sp, itemStack);
                    if (accepted > 0L) {
                        shouldProcess = true;
                        cnt = itemStack.method_7947();
                        if (accepted >= (long)cnt) {
                            shouldDiscard = true;
                        } else {
                            itemStack.method_7939(cnt - (int)Math.min(Integer.MAX_VALUE, accepted));
                            shouldDiscard = false;
                        }
                    }
                }
            }
            if (!shouldProcess || !shouldDiscard) continue;
            itemEntity.method_31472();
        }
    }
}

