/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.mixin.client;

import com.portable.storage.PortableStorage;
import com.portable.storage.client.ClientConfig;
import com.portable.storage.client.ClientStorageState;
import com.portable.storage.client.ClientUpgradeState;
import com.portable.storage.client.ui.StorageUIComponent;
import com.portable.storage.net.payload.CraftingOverlayActionC2SPayload;
import com.portable.storage.net.payload.SyncControlC2SPayload;
import com.portable.storage.sync.PlayerViewState;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_479;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_479.class})
public abstract class CraftingScreenMixin {
    @Unique
    private final StorageUIComponent portableStorage$uiComponent = new StorageUIComponent();
    @Unique
    private final Map<Integer, class_1799> portableStorage$lastCraftingStacks = new HashMap<Integer, class_1799>();
    @Unique
    private class_1799 portableStorage$lastCraftingOutput = class_1799.field_8037;
    @Unique
    private long portableStorage$lastCraftRefillCheck = 0L;
    @Unique
    private long portableStorage$lastCraftingSlotClickTime = 0L;

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void portableStorage$init(CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1772 == null) {
            return;
        }
        class_479 self = (class_479)this;
        int screenWidth = self.field_22789;
        int screenHeight = self.field_22790;
        int backgroundWidth = 176;
        int backgroundHeight = 166;
        int x = (screenWidth - backgroundWidth) / 2;
        int y = (screenHeight - backgroundHeight) / 2;
        int fieldWidth = 120;
        int fieldHeight = 18;
        int fieldX = x + backgroundWidth - fieldWidth - 8;
        int fieldY = y - fieldHeight - 6;
        this.portableStorage$uiComponent.initSearchField(client, fieldX, fieldY, fieldWidth, fieldHeight);
        this.portableStorage$uiComponent.setCollapsed(false);
        PortableStorage.LOGGER.debug("Portable Storage: Crafting screen UI component initialized");
        PlayerViewState.startViewing(class_310.method_1551().field_1724.method_5667());
        ClientPlayNetworking.send((class_8710)new SyncControlC2SPayload(SyncControlC2SPayload.Op.REQUEST, 0L, false));
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void portableStorage$renderOverlay(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_479 self = (class_479)this;
        int screenWidth = self.field_22789;
        int screenHeight = self.field_22790;
        int backgroundWidth = 176;
        int backgroundHeight = 166;
        int x = (screenWidth - backgroundWidth) / 2;
        int y = (screenHeight - backgroundHeight) / 2;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1772 != null && ClientStorageState.isStorageEnabled() && this.portableStorage$hasCraftingTableUpgrade()) {
            this.portableStorage$uiComponent.render(context, mouseX, mouseY, delta, x, y, backgroundWidth, backgroundHeight);
        }
        this.portableStorage$checkCraftRefill();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        class_1703 handler;
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null && (handler = mc.field_1724.field_7512) instanceof class_1714) {
            class_479 self = (class_479)this;
            int screenWidth = self.field_22789;
            int screenHeight = self.field_22790;
            int backgroundWidth = 176;
            int backgroundHeight = 166;
            int screenX = (screenWidth - backgroundWidth) / 2;
            int screenY = (screenHeight - backgroundHeight) / 2;
            for (class_1735 slot : handler.field_7761) {
                int slotX = screenX + slot.field_7873;
                int slotY = screenY + slot.field_7872;
                if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
                if (slot.field_7874 < 1 || slot.field_7874 > 9) break;
                this.portableStorage$lastCraftingSlotClickTime = System.currentTimeMillis();
                break;
            }
        }
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$uiComponent.mouseClicked(mouseX, mouseY, button)) {
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$uiComponent.keyPressed(keyCode, scanCode, modifiers)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$charTyped(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$uiComponent.charTyped(chr, modifiers)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private void portableStorage$checkCraftRefill() {
        class_1799 currentStack;
        if (!ClientConfig.getInstance().craftRefill) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.portableStorage$lastCraftRefillCheck < 100L) {
            return;
        }
        this.portableStorage$lastCraftRefillCheck = now;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        class_1703 handler = mc.field_1724.field_7512;
        if (!(handler instanceof class_1714)) {
            return;
        }
        boolean craftOccurred = false;
        if (handler.field_7761.size() > 0) {
            class_1799 currentOutput = handler.method_7611(0).method_7677();
            if (!(this.portableStorage$lastCraftingOutput.method_7960() || !currentOutput.method_7960() && class_1799.method_31577((class_1799)currentOutput, (class_1799)this.portableStorage$lastCraftingOutput) && currentOutput.method_7947() >= this.portableStorage$lastCraftingOutput.method_7947())) {
                craftOccurred = true;
            }
            this.portableStorage$lastCraftingOutput = currentOutput.method_7972();
        }
        if (craftOccurred) {
            for (int i = 1; i <= 9; ++i) {
                class_1799 targetStack;
                boolean recentClick;
                if (handler.field_7761.size() <= i) continue;
                currentStack = handler.method_7611(i).method_7677();
                class_1799 lastStack = this.portableStorage$lastCraftingStacks.get(i);
                if (lastStack == null || lastStack.method_7960()) continue;
                boolean bl = recentClick = now - this.portableStorage$lastCraftingSlotClickTime < 300L;
                if (currentStack.method_7960()) {
                    if (recentClick) continue;
                    targetStack = lastStack.method_7972();
                    targetStack.method_7939(targetStack.method_7914());
                    this.portableStorage$refillFromStorage(i, targetStack);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)currentStack, (class_1799)lastStack) || currentStack.method_7947() >= lastStack.method_7947() || recentClick) continue;
                targetStack = currentStack.method_7972();
                targetStack.method_7939(targetStack.method_7914());
                this.portableStorage$refillFromStorage(i, targetStack);
            }
        }
        for (int i = 1; i <= 9; ++i) {
            if (handler.field_7761.size() <= i) continue;
            currentStack = handler.method_7611(i).method_7677();
            this.portableStorage$lastCraftingStacks.put(i, currentStack.method_7972());
        }
    }

    @Unique
    private void portableStorage$refillFromStorage(int slotIndex, class_1799 targetStack) {
        if (targetStack.method_7960()) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.REFILL, slotIndex, 0, false, targetStack, "", null, null));
    }

    @Unique
    private boolean portableStorage$hasCraftingTableUpgrade() {
        for (int i = 0; i < 5; ++i) {
            class_1799 stack = ClientUpgradeState.getStack(i);
            if (stack.method_7960() || stack.method_7909() != class_1802.field_8465 || ClientUpgradeState.isSlotDisabled(i)) continue;
            return true;
        }
        return false;
    }
}

