/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.mixin.client;

import com.portable.storage.client.ClientContainerDisplayConfig;
import com.portable.storage.client.ClientStorageState;
import com.portable.storage.client.ClientUpgradeState;
import com.portable.storage.client.emi.HasPortableStorageExclusionAreas;
import com.portable.storage.client.emi.PortableStorageExclusionHelper;
import com.portable.storage.client.ui.StorageUIComponent;
import com.portable.storage.util.ContainerTypeDetector;
import dev.emi.emi.api.widget.Bounds;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class GenericContainerScreenMixin
implements HasPortableStorageExclusionAreas {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    protected int field_2792;
    @Shadow
    protected int field_2779;
    @Unique
    private StorageUIComponent portableStorage$uiComponent;

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void portableStorage$init(CallbackInfo ci) {
        if (this.portableStorage$uiComponent == null) {
            this.portableStorage$uiComponent = new StorageUIComponent();
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void portableStorage$renderOverlay(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if ((class_465)this instanceof class_490 || (class_465)this instanceof class_479) {
            return;
        }
        if (!this.portableStorage$shouldShowStorageInContainer()) {
            return;
        }
        if (this.portableStorage$uiComponent != null) {
            this.portableStorage$uiComponent.render(context, mouseX, mouseY, delta, this.field_2776, this.field_2800, this.field_2792, this.field_2779);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if ((class_465)this instanceof class_490 || (class_465)this instanceof class_479) {
            return;
        }
        if (!this.portableStorage$shouldShowStorageInContainer()) {
            return;
        }
        if (this.portableStorage$uiComponent != null && this.portableStorage$uiComponent.mouseClicked(mouseX, mouseY, button)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$mouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if ((class_465)this instanceof class_490 || (class_465)this instanceof class_479) {
            return;
        }
        if (!this.portableStorage$shouldShowStorageInContainer()) {
            return;
        }
        if (this.portableStorage$uiComponent != null && this.portableStorage$uiComponent.isOverAnyComponent(mouseX, mouseY)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        if ((class_465)this instanceof class_490 || (class_465)this instanceof class_479) {
            return;
        }
        if (!this.portableStorage$shouldShowStorageInContainer()) {
            return;
        }
        if (this.portableStorage$uiComponent != null && this.portableStorage$uiComponent.isOverAnyComponent(mouseX, mouseY)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean portableStorage$shouldShowStorageInContainer() {
        if (!ClientStorageState.isStorageEnabled()) {
            return false;
        }
        if (!this.portableStorage$hasCraftingTableUpgrade()) {
            return false;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return false;
        }
        class_1703 handler = client.field_1724.field_7512;
        if (handler == null) {
            return false;
        }
        String containerId = ContainerTypeDetector.getContainerId(handler);
        if (containerId == null) {
            return false;
        }
        if (!ContainerTypeDetector.isSupportedContainer(containerId)) {
            return false;
        }
        return ClientContainerDisplayConfig.getInstance().shouldShowStorageInContainer(containerId);
    }

    @Unique
    private boolean portableStorage$hasCraftingTableUpgrade() {
        for (int i = 0; i < 5; ++i) {
            class_1799 stack = ClientUpgradeState.getStack(i);
            if (stack.method_7960() || stack.method_7909() != class_1802.field_8465 || ClientUpgradeState.isSlotDisabled(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getPortableStorageExclusionAreas(Consumer<Bounds> consumer) {
        if (!this.portableStorage$shouldShowStorageInContainer()) {
            return;
        }
        PortableStorageExclusionHelper.addAreasForScreen(consumer, this.field_2776, this.field_2800, this.field_2792, this.field_2779, false, false, false, false);
    }
}

