/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.mixin.client;

import com.portable.storage.client.ClientConfig;
import com.portable.storage.client.ClientContainerDisplayConfig;
import com.portable.storage.client.ClientStorageState;
import com.portable.storage.client.ClientUpgradeState;
import com.portable.storage.client.screen.PortableCraftingScreen;
import com.portable.storage.net.payload.StorageActionC2SPayload;
import com.portable.storage.screen.PortableCraftingScreenHandler;
import com.portable.storage.util.ContainerTypeDetector;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_490;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class HandledScreenMixin {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    protected int field_2792;
    @Shadow
    protected int field_2779;

    @Shadow
    protected abstract void method_2383(class_1735 var1, int var2, int var3, class_1713 var4);

    @Inject(method={"onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$onMouseClick(class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        class_1703 handler;
        if (!ClientConfig.getInstance().autoDeposit) {
            return;
        }
        if (!ClientStorageState.isStorageEnabled()) {
            return;
        }
        if (!((class_465)this instanceof class_490) && !((class_465)this instanceof class_479)) {
            return;
        }
        if (actionType != class_1713.field_7794) {
            return;
        }
        if (slot == null || !slot.method_7681()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null && ((handler = client.field_1724.field_7512) instanceof class_1723 ? slotId >= 0 && slotId <= 4 : handler instanceof class_1714 && slotId >= 0 && slotId <= 9)) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new StorageActionC2SPayload(StorageActionC2SPayload.Action.DEPOSIT_SLOT, StorageActionC2SPayload.Target.SLOT, 0, 0, slotId, "", 0));
        ci.cancel();
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$mouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.portableStorage$isOverStorage(mouseX, mouseY) || this.portableStorage$isOverScrollbar(mouseX, mouseY) || this.portableStorage$isOverUpgradeSlots(mouseX, mouseY) || this.portableStorage$isOverCraftingStorage(mouseX, mouseY) || this.portableStorage$isOverCraftingUpgradeSlots(mouseX, mouseY)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private int portableStorage$calculateStorageGridTop() {
        int visibleRows = 6;
        int slotSize = 18;
        int slotSpacing = 0;
        int gapBelow = 6;
        ClientConfig config = ClientConfig.getInstance();
        if (config.storagePos == ClientConfig.StoragePos.TOP) {
            int storageHeight = visibleRows * (slotSize + slotSpacing);
            return this.field_2800 - storageHeight - gapBelow;
        }
        return this.field_2800 + this.field_2779 + gapBelow;
    }

    @Unique
    private boolean portableStorage$isOverStorage(double mouseX, double mouseY) {
        if (ClientConfig.getInstance().collapsed) {
            return false;
        }
        if (!this.portableStorage$shouldShowStorageInContainer()) {
            return false;
        }
        int cols = 9;
        int visibleRows = 6;
        int slotSize = 18;
        int slotSpacing = 0;
        int gridLeft = this.field_2776 + 8;
        int gridTop = this.portableStorage$calculateStorageGridTop();
        int width = cols * (slotSize + slotSpacing);
        int height = visibleRows * (slotSize + slotSpacing);
        return mouseX >= (double)gridLeft && mouseX < (double)(gridLeft + width) && mouseY >= (double)gridTop && mouseY < (double)(gridTop + height);
    }

    @Unique
    private boolean portableStorage$isOverScrollbar(double mouseX, double mouseY) {
        if (ClientConfig.getInstance().collapsed) {
            return false;
        }
        if (!this.portableStorage$shouldShowStorageInContainer()) {
            return false;
        }
        int cols = 9;
        int visibleRows = 6;
        int slotSize = 18;
        int slotSpacing = 0;
        int gridLeft = this.field_2776 + 8;
        int gridTop = this.portableStorage$calculateStorageGridTop();
        int trackLeft = gridLeft + cols * (slotSize + slotSpacing) + 4;
        int trackTop = gridTop;
        int trackWidth = 6;
        int trackHeight = visibleRows * (slotSize + slotSpacing);
        return mouseX >= (double)trackLeft && mouseX < (double)(trackLeft + trackWidth) && mouseY >= (double)trackTop && mouseY < (double)(trackTop + trackHeight);
    }

    @Unique
    private boolean portableStorage$isOverUpgradeSlots(double mouseX, double mouseY) {
        if (ClientConfig.getInstance().collapsed) {
            return false;
        }
        if (!this.portableStorage$shouldShowStorageInContainer()) {
            return false;
        }
        int gridTop = this.portableStorage$calculateStorageGridTop();
        int upgradeLeft = this.field_2776 - 24;
        int upgradeSlotSize = 18;
        int upgradeSpacing = 0;
        int baseUpgradeCount = 5;
        int extendedUpgradeCount = 6;
        for (int i = 0; i < baseUpgradeCount; ++i) {
            int sx = upgradeLeft;
            int sy = gridTop + i * (upgradeSlotSize + upgradeSpacing);
            if (!(mouseX >= (double)sx) || !(mouseX < (double)(sx + upgradeSlotSize)) || !(mouseY >= (double)sy) || !(mouseY < (double)(sy + upgradeSlotSize))) continue;
            return true;
        }
        if (ClientUpgradeState.isChestUpgradeActive()) {
            int extendedLeft = upgradeLeft - (upgradeSlotSize + upgradeSpacing + 2);
            for (int i = 0; i < extendedUpgradeCount; ++i) {
                int sx = extendedLeft;
                int sy = gridTop + i * (upgradeSlotSize + upgradeSpacing);
                if (!(mouseX >= (double)sx) || !(mouseX < (double)(sx + upgradeSlotSize)) || !(mouseY >= (double)sy) || !(mouseY < (double)(sy + upgradeSlotSize))) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private boolean portableStorage$isOverCraftingStorage(double mouseX, double mouseY) {
        if (!((class_465)this instanceof class_479) && !((class_465)this instanceof PortableCraftingScreen)) {
            return false;
        }
        if (!this.portableStorage$hasCraftingTableUpgrade()) {
            return false;
        }
        int cols = 9;
        int visibleRows = 6;
        int slotSize = 18;
        int slotSpacing = 0;
        int gridLeft = this.field_2776 + 8;
        int gridTop = this.portableStorage$calculateStorageGridTop();
        int width = cols * (slotSize + slotSpacing);
        int height = visibleRows * (slotSize + slotSpacing);
        return mouseX >= (double)gridLeft && mouseX < (double)(gridLeft + width) && mouseY >= (double)gridTop && mouseY < (double)(gridTop + height);
    }

    @Unique
    private boolean portableStorage$isOverCraftingUpgradeSlots(double mouseX, double mouseY) {
        if (!((class_465)this instanceof class_479) && !((class_465)this instanceof PortableCraftingScreen)) {
            return false;
        }
        if (!this.portableStorage$hasCraftingTableUpgrade()) {
            return false;
        }
        int gridTop = this.portableStorage$calculateStorageGridTop();
        int upgradeLeft = this.field_2776 - 24;
        int upgradeSlotSize = 18;
        int upgradeSpacing = 0;
        int baseUpgradeCount = 5;
        int extendedUpgradeCount = 6;
        for (int i = 0; i < baseUpgradeCount; ++i) {
            int sx = upgradeLeft;
            int sy = gridTop + i * (upgradeSlotSize + upgradeSpacing);
            if (!(mouseX >= (double)sx) || !(mouseX < (double)(sx + upgradeSlotSize)) || !(mouseY >= (double)sy) || !(mouseY < (double)(sy + upgradeSlotSize))) continue;
            return true;
        }
        if (ClientUpgradeState.isChestUpgradeActive()) {
            int extendedLeft = upgradeLeft - (upgradeSlotSize + upgradeSpacing + 2);
            for (int i = 0; i < extendedUpgradeCount; ++i) {
                int sx = extendedLeft;
                int sy = gridTop + i * (upgradeSlotSize + upgradeSpacing);
                if (!(mouseX >= (double)sx) || !(mouseX < (double)(sx + upgradeSlotSize)) || !(mouseY >= (double)sy) || !(mouseY < (double)(sy + upgradeSlotSize))) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private boolean portableStorage$hasCraftingTableUpgrade() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return false;
        }
        class_1703 handler = client.field_1724.field_7512;
        if (handler instanceof PortableCraftingScreenHandler) {
            return true;
        }
        if (!(handler instanceof class_1714)) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            class_1799 stack = ClientUpgradeState.getStack(i);
            if (stack.method_7960() || stack.method_7909() != class_1802.field_8465 || ClientUpgradeState.isSlotDisabled(i)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private boolean portableStorage$shouldShowStorageInContainer() {
        if (!ClientStorageState.isStorageEnabled()) {
            return false;
        }
        if (!this.portableStorage$hasCraftingTableUpgrade()) {
            return false;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return false;
        }
        class_1703 handler = client.field_1724.field_7512;
        if (handler == null) {
            return false;
        }
        String containerId = ContainerTypeDetector.getContainerId(handler);
        if (containerId == null) {
            return false;
        }
        if (!ContainerTypeDetector.isSupportedContainer(containerId)) {
            return false;
        }
        return ClientContainerDisplayConfig.getInstance().shouldShowStorageInContainer(containerId);
    }
}

