/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.mixin.client;

import com.portable.storage.PortableStorage;
import com.portable.storage.client.ClientConfig;
import com.portable.storage.client.ClientStorageState;
import com.portable.storage.client.ClientUpgradeState;
import com.portable.storage.client.ClientVirtualCraftingConfig;
import com.portable.storage.client.ui.StorageUIComponent;
import com.portable.storage.client.ui.VirtualCraftingOverlayState;
import com.portable.storage.net.payload.CraftingOverlayActionC2SPayload;
import com.portable.storage.net.payload.SyncControlC2SPayload;
import com.portable.storage.sync.PlayerViewState;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_490.class})
public abstract class InventoryScreenMixin {
    @Unique
    private final StorageUIComponent portableStorage$uiComponent = new StorageUIComponent();
    @Unique
    private final Map<Integer, class_1799> portableStorage$lastCraftingStacks = new HashMap<Integer, class_1799>();
    @Unique
    private class_1799 portableStorage$lastCraftingOutput = class_1799.field_8037;
    @Unique
    private long portableStorage$lastCraftRefillCheck = 0L;
    @Unique
    private long portableStorage$lastCraftingSlotClickTime = 0L;
    @Unique
    private static final class_2960 portableStorage$SLOT_TEX = class_2960.method_60655((String)"portable-storage", (String)"textures/gui/slot.png");
    @Unique
    private long portableStorage$lastClickTs = 0L;
    @Unique
    private double portableStorage$lastClickX = 0.0;
    @Unique
    private double portableStorage$lastClickY = 0.0;

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void portableStorage$init(CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1772 == null) {
            return;
        }
        class_490 self = (class_490)this;
        int screenWidth = self.field_22789;
        int screenHeight = self.field_22790;
        int backgroundWidth = 176;
        int backgroundHeight = 166;
        int x = (screenWidth - backgroundWidth) / 2;
        int y = (screenHeight - backgroundHeight) / 2;
        int fieldWidth = 120;
        int fieldHeight = 18;
        int fieldX = x + backgroundWidth - fieldWidth - 8;
        int fieldY = y - fieldHeight - 6;
        this.portableStorage$uiComponent.initSearchField(client, fieldX, fieldY, fieldWidth, fieldHeight);
        this.portableStorage$uiComponent.loadCollapsedState();
        PortableStorage.LOGGER.debug("Portable Storage: UI component initialized, collapsed={}", (Object)this.portableStorage$uiComponent.isCollapsed());
        PlayerViewState.startViewing(class_310.method_1551().field_1724.method_5667());
        ClientPlayNetworking.send((class_8710)new SyncControlC2SPayload(SyncControlC2SPayload.Op.REQUEST, 0L, false));
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void portableStorage$renderOverlay(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_490 self = (class_490)this;
        int screenWidth = self.field_22789;
        int screenHeight = self.field_22790;
        int backgroundWidth = 176;
        int backgroundHeight = 166;
        int x = (screenWidth - backgroundWidth) / 2;
        int y = (screenHeight - backgroundHeight) / 2;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1772 != null) {
            class_1703 class_17032;
            class_310 mc2;
            if (ClientStorageState.isStorageEnabled()) {
                this.portableStorage$uiComponent.render(context, mouseX, mouseY, delta, x, y, backgroundWidth, backgroundHeight, true);
            }
            if (ClientStorageState.isStorageEnabled() && this.portableStorage$hasCraftingUpgradeClient() && ClientConfig.getInstance().virtualCraftingVisible && ClientVirtualCraftingConfig.isEnableVirtualCrafting() && (mc2 = class_310.method_1551()) != null && mc2.field_1724 != null && (class_17032 = mc2.field_1724.field_7512) instanceof class_1723) {
                class_1723 handler = (class_1723)class_17032;
                if (handler.field_7761.size() > 4) {
                    class_1799 tip;
                    int slotSize = 18;
                    int sx1 = x + handler.method_7611((int)1).field_7873;
                    int sy1 = y + handler.method_7611((int)1).field_7872;
                    int overlayLeft = sx1;
                    int overlayTop = sy1;
                    int hoveredSlotIdx = -1;
                    for (int r = 0; r < 3; ++r) {
                        for (int c = 0; c < 3; ++c) {
                            int sxOverlay = overlayLeft + c * slotSize - 1;
                            int syOverlay = overlayTop + r * slotSize - 1;
                            context.method_25290(portableStorage$SLOT_TEX, sxOverlay, syOverlay, 0.0f, 0.0f, 18, 18, 18, 18);
                            int idx = 1 + r * 3 + c;
                            class_1799 vis = VirtualCraftingOverlayState.get(idx);
                            if (!vis.method_7960()) {
                                context.method_51427(vis, sxOverlay + 1, syOverlay + 1);
                                context.method_51431(class_310.method_1551().field_1772, vis, sxOverlay + 1, syOverlay + 1);
                            }
                            if (mouseX < sxOverlay || mouseX >= sxOverlay + 18 || mouseY < syOverlay || mouseY >= syOverlay + 18) continue;
                            hoveredSlotIdx = idx;
                            context.method_25294(sxOverlay + 1, syOverlay + 1, sxOverlay + 17, syOverlay + 17, -2130706433);
                        }
                    }
                    int outX = x + handler.method_7611((int)0).field_7873 - 1;
                    int outY = y + handler.method_7611((int)0).field_7872 - 1;
                    context.method_25290(portableStorage$SLOT_TEX, outX, outY, 0.0f, 0.0f, 18, 18, 18, 18);
                    class_1799 resultVis = VirtualCraftingOverlayState.get(0);
                    if (!resultVis.method_7960()) {
                        context.method_51427(resultVis, outX + 1, outY + 1);
                        context.method_51431(class_310.method_1551().field_1772, resultVis, outX + 1, outY + 1);
                    }
                    if (mouseX >= outX && mouseX < outX + 18 && mouseY >= outY && mouseY < outY + 18) {
                        hoveredSlotIdx = 0;
                        context.method_25294(outX + 1, outY + 1, outX + 17, outY + 17, -2130706433);
                    }
                    if (hoveredSlotIdx >= 0 && !(tip = VirtualCraftingOverlayState.get(hoveredSlotIdx)).method_7960()) {
                        context.method_51446(class_310.method_1551().field_1772, tip, mouseX, mouseY);
                    }
                }
            }
        }
        this.portableStorage$checkCraftRefill();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        class_1703 screenHeight22;
        class_310 mc3;
        int backgroundHeight;
        int backgroundWidth;
        class_1703 handler;
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null && (handler = mc.field_1724.field_7512) instanceof class_1723) {
            class_490 self = (class_490)this;
            int screenWidth = self.field_22789;
            int screenHeight = self.field_22790;
            backgroundWidth = 176;
            backgroundHeight = 166;
            int screenX = (screenWidth - backgroundWidth) / 2;
            int screenY = (screenHeight - backgroundHeight) / 2;
            for (class_1703 slot : handler.field_7761) {
                int slotX = screenX + slot.field_7873;
                int slotY = screenY + slot.field_7872;
                if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
                if (slot.field_7874 < 1 || slot.field_7874 > 4) break;
                this.portableStorage$lastCraftingSlotClickTime = System.currentTimeMillis();
                break;
            }
        }
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$hasCraftingUpgradeClient() && ClientConfig.getInstance().virtualCraftingVisible) {
            class_1703 slot;
            class_490 self2 = (class_490)this;
            int screenWidth2 = self2.field_22789;
            int screenHeight22 = self2.field_22790;
            int backgroundWidth2 = 176;
            int backgroundHeight2 = 166;
            int x2 = (screenWidth2 - backgroundWidth2) / 2;
            int y2 = (screenHeight22 - backgroundHeight2) / 2;
            class_310 mc2 = class_310.method_1551();
            if (mc2 != null && mc2.field_1724 != null && (slot = mc2.field_1724.field_7512) instanceof class_1723) {
                class_1723 handler2 = (class_1723)slot;
                if (handler2.field_7761.size() > 4) {
                    int slotSize = 18;
                    int sx1 = x2 + handler2.method_7611((int)1).field_7873;
                    int sy1 = y2 + handler2.method_7611((int)1).field_7872;
                    int overlayLeft = sx1;
                    int overlayTop = sy1;
                    int overlayRight = overlayLeft + 3 * slotSize;
                    int overlayBottom = overlayTop + 3 * slotSize;
                    boolean shift = mc2.field_1690 != null && mc2.field_1690.field_1832.method_1434() || class_437.method_25442();
                    boolean isDoubleClick = false;
                    long nowTs = System.currentTimeMillis();
                    if (nowTs - this.portableStorage$lastClickTs < 250L && Math.hypot(mouseX - this.portableStorage$lastClickX, mouseY - this.portableStorage$lastClickY) <= 6.0) {
                        class_1799 cursorNow = mc2.field_1724.field_7512.method_34255();
                        isDoubleClick = !cursorNow.method_7960();
                    }
                    this.portableStorage$lastClickTs = nowTs;
                    this.portableStorage$lastClickX = mouseX;
                    this.portableStorage$lastClickY = mouseY;
                    if (mouseX >= (double)overlayLeft && mouseX < (double)overlayRight && mouseY >= (double)overlayTop && mouseY < (double)overlayBottom) {
                        if (isDoubleClick) {
                            ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.DOUBLE_CLICK, 0, 0, false, class_1799.field_8037, "", null, null));
                            cir.setReturnValue((Object)true);
                            return;
                        }
                        int relX = (int)(mouseX - (double)overlayLeft);
                        int relY = (int)(mouseY - (double)overlayTop);
                        int col = Math.min(2, Math.max(0, relX / slotSize));
                        int row = Math.min(2, Math.max(0, relY / slotSize));
                        int slotIndex = 1 + row * 3 + col;
                        ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.CLICK, slotIndex, button, shift, class_1799.field_8037, "", null, null));
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    int outX = x2 + handler2.method_7611((int)0).field_7873;
                    int outY = y2 + handler2.method_7611((int)0).field_7872;
                    if (mouseX >= (double)outX && mouseX < (double)(outX + 18) && mouseY >= (double)outY && mouseY < (double)(outY + 18)) {
                        if (isDoubleClick) {
                            ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.DOUBLE_CLICK, 0, 0, false, class_1799.field_8037, "", null, null));
                            cir.setReturnValue((Object)true);
                            return;
                        }
                        class_1799 resultVis = VirtualCraftingOverlayState.get(0);
                        if (!resultVis.method_7960()) {
                            class_1799 cursor = mc2.field_1724.field_7512.method_34255();
                            if (!cursor.method_7960() && !class_1799.method_31577((class_1799)cursor, (class_1799)resultVis)) {
                                cir.setReturnValue((Object)true);
                                return;
                            }
                            if (!cursor.method_7960() && class_1799.method_31577((class_1799)cursor, (class_1799)resultVis)) {
                                int maxPerStack = Math.min(resultVis.method_7914(), mc2.field_1724.method_31548().method_5444());
                                int would = cursor.method_7947() + resultVis.method_7947();
                                if (cursor.method_7947() >= maxPerStack || would > maxPerStack) {
                                    cir.setReturnValue((Object)true);
                                    return;
                                }
                            }
                        }
                        ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.CLICK, 0, button, shift, class_1799.field_8037, "", null, null));
                        cir.setReturnValue((Object)true);
                        return;
                    }
                }
            }
        }
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$hasCraftingUpgradeClient() && ClientConfig.getInstance().virtualCraftingVisible && (mc3 = class_310.method_1551()) != null && mc3.field_1724 != null && (screenHeight22 = mc3.field_1724.field_7512) instanceof class_1723) {
            class_1723 handler3 = (class_1723)screenHeight22;
            int screenX = ((class_490)this).field_22789;
            int screenY = ((class_490)this).field_22790;
            backgroundWidth = 176;
            backgroundHeight = 166;
            int x0 = (screenX - backgroundWidth) / 2;
            int y0 = (screenY - backgroundHeight) / 2;
            for (int i = 1; i <= 4 && i < handler3.field_7761.size(); ++i) {
                int sx = x0 + handler3.method_7611((int)i).field_7873;
                int sy = y0 + handler3.method_7611((int)i).field_7872;
                if (!(mouseX >= (double)sx) || !(mouseX < (double)(sx + 18)) || !(mouseY >= (double)sy) || !(mouseY < (double)(sy + 18))) continue;
                cir.setReturnValue((Object)true);
                return;
            }
        }
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$uiComponent.mouseClicked(mouseX, mouseY, button, true)) {
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$mouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        class_1703 class_17032;
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$uiComponent.isOverAnyComponent(mouseX, mouseY)) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (!(ClientStorageState.isStorageEnabled() && this.portableStorage$hasCraftingUpgradeClient() && ClientConfig.getInstance().virtualCraftingVisible)) {
            return;
        }
        class_490 self = (class_490)this;
        int screenWidth = self.field_22789;
        int screenHeight = self.field_22790;
        int backgroundWidth = 176;
        int backgroundHeight = 166;
        int x = (screenWidth - backgroundWidth) / 2;
        int y = (screenHeight - backgroundHeight) / 2;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null || !((class_17032 = mc.field_1724.field_7512) instanceof class_1723)) {
            return;
        }
        class_1723 handler = (class_1723)class_17032;
        if (handler.field_7761.size() <= 4) {
            return;
        }
        int slotSize = 18;
        int sx1 = x + handler.method_7611((int)1).field_7873;
        int sy1 = y + handler.method_7611((int)1).field_7872;
        int overlayLeft = sx1;
        int overlayTop = sy1;
        int overlayRight = overlayLeft + 3 * slotSize;
        int overlayBottom = overlayTop + 3 * slotSize;
        if (mouseX >= (double)overlayLeft && mouseX < (double)overlayRight && mouseY >= (double)overlayTop && mouseY < (double)overlayBottom) {
            cir.setReturnValue((Object)true);
            return;
        }
        int outX = x + handler.method_7611((int)0).field_7873;
        int outY = y + handler.method_7611((int)0).field_7872;
        if (mouseX >= (double)outX && mouseX < (double)(outX + 18) && mouseY >= (double)outY && mouseY < (double)(outY + 18)) {
            cir.setReturnValue((Object)true);
            return;
        }
        for (int i = 1; i <= 4 && i < handler.field_7761.size(); ++i) {
            int sx = x + handler.method_7611((int)i).field_7873;
            int sy = y + handler.method_7611((int)i).field_7872;
            if (!(mouseX >= (double)sx) || !(mouseX < (double)(sx + 18)) || !(mouseY >= (double)sy) || !(mouseY < (double)(sy + 18))) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$uiComponent.keyPressed(keyCode, scanCode, modifiers)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    private void portableStorage$charTyped(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (ClientStorageState.isStorageEnabled() && this.portableStorage$uiComponent.charTyped(chr, modifiers)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private void portableStorage$checkCraftRefill() {
        class_1799 currentStack;
        if (!ClientConfig.getInstance().craftRefill) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.portableStorage$lastCraftRefillCheck < 100L) {
            return;
        }
        this.portableStorage$lastCraftRefillCheck = now;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        class_1703 handler = mc.field_1724.field_7512;
        if (!(handler instanceof class_1723)) {
            return;
        }
        boolean craftOccurred = false;
        if (handler.field_7761.size() > 0) {
            class_1799 currentOutput = handler.method_7611(0).method_7677();
            if (!(this.portableStorage$lastCraftingOutput.method_7960() || !currentOutput.method_7960() && class_1799.method_31577((class_1799)currentOutput, (class_1799)this.portableStorage$lastCraftingOutput) && currentOutput.method_7947() >= this.portableStorage$lastCraftingOutput.method_7947())) {
                craftOccurred = true;
            }
            this.portableStorage$lastCraftingOutput = currentOutput.method_7972();
        }
        if (craftOccurred) {
            for (int i = 1; i <= 4; ++i) {
                class_1799 targetStack;
                boolean recentClick;
                if (handler.field_7761.size() <= i) continue;
                currentStack = handler.method_7611(i).method_7677();
                class_1799 lastStack = this.portableStorage$lastCraftingStacks.get(i);
                if (lastStack == null || lastStack.method_7960()) continue;
                boolean bl = recentClick = now - this.portableStorage$lastCraftingSlotClickTime < 300L;
                if (currentStack.method_7960()) {
                    if (recentClick) continue;
                    targetStack = lastStack.method_7972();
                    targetStack.method_7939(targetStack.method_7914());
                    this.portableStorage$refillFromStorage(i, targetStack);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)currentStack, (class_1799)lastStack) || currentStack.method_7947() >= lastStack.method_7947() || recentClick) continue;
                targetStack = currentStack.method_7972();
                targetStack.method_7939(targetStack.method_7914());
                this.portableStorage$refillFromStorage(i, targetStack);
            }
        }
        for (int i = 1; i <= 4; ++i) {
            if (handler.field_7761.size() <= i) continue;
            currentStack = handler.method_7611(i).method_7677();
            this.portableStorage$lastCraftingStacks.put(i, currentStack.method_7972());
        }
    }

    @Unique
    private void portableStorage$refillFromStorage(int slotIndex, class_1799 targetStack) {
        if (targetStack.method_7960()) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new CraftingOverlayActionC2SPayload(CraftingOverlayActionC2SPayload.Action.REFILL, slotIndex, 0, false, targetStack, "", null, null));
    }

    @Unique
    private boolean portableStorage$hasCraftingUpgradeClient() {
        for (int i = 0; i < ClientUpgradeState.getSlotCount(); ++i) {
            class_1799 st = ClientUpgradeState.getStack(i);
            if (st.method_7960() || st.method_7909() != class_1802.field_8465 || ClientUpgradeState.isSlotDisabled(i)) continue;
            return true;
        }
        return false;
    }
}

