/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.net;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.portable.storage.block.ModBlocks;
import com.portable.storage.blockentity.BoundBarrelBlockEntity;
import com.portable.storage.config.ServerConfig;
import com.portable.storage.crafting.OverlayCraftingManager;
import com.portable.storage.net.payload.ConfigSyncS2CPayload;
import com.portable.storage.net.payload.CraftingOverlayActionC2SPayload;
import com.portable.storage.net.payload.FluidClickC2SPayload;
import com.portable.storage.net.payload.FluidConversionC2SPayload;
import com.portable.storage.net.payload.FluidSlotClickC2SPayload;
import com.portable.storage.net.payload.IncrementalStorageSyncS2CPayload;
import com.portable.storage.net.payload.OverlayCraftingSyncS2CPayload;
import com.portable.storage.net.payload.RequestOpenScreenC2SPayload;
import com.portable.storage.net.payload.StorageActionC2SPayload;
import com.portable.storage.net.payload.StorageSyncS2CPayload;
import com.portable.storage.net.payload.SyncBarrelFilterRulesC2SPayload;
import com.portable.storage.net.payload.SyncControlC2SPayload;
import com.portable.storage.net.payload.SyncFilterRulesC2SPayload;
import com.portable.storage.net.payload.XpBottleClickC2SPayload;
import com.portable.storage.net.payload.XpBottleConversionC2SPayload;
import com.portable.storage.net.payload.XpBottleMaintenanceToggleC2SPayload;
import com.portable.storage.newstore.ItemKeyHasher;
import com.portable.storage.newstore.NewStoreService;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.player.StoragePersistence;
import com.portable.storage.screen.PortableCraftingScreenHandler;
import com.portable.storage.storage.AutoEatMode;
import com.portable.storage.storage.FilterRuleManager;
import com.portable.storage.storage.StorageInventory;
import com.portable.storage.storage.StorageType;
import com.portable.storage.storage.UpgradeInventory;
import com.portable.storage.sync.PlayerViewState;
import com.portable.storage.sync.StorageSyncManager;
import com.portable.storage.world.SpaceRiftManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_3955;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.slf4j.LoggerFactory;

public final class ServerNetworkingHandlers {
    private static final Map<UUID, Integer> xpStepIndexByPlayer = new ConcurrentHashMap<UUID, Integer>();
    private static final int[] XP_STEPS = new int[]{1, 5, 10, 100};
    private static final Map<UUID, AutoEatMode> autoEatModeByPlayer = new ConcurrentHashMap<UUID, AutoEatMode>();
    private static final Map<class_2338, TempBedData> tempBeds = new ConcurrentHashMap<class_2338, TempBedData>();

    private ServerNetworkingHandlers() {
    }

    public static AutoEatMode getPlayerAutoEatMode(class_3222 player) {
        return autoEatModeByPlayer.getOrDefault(player.method_5667(), AutoEatMode.DISABLED);
    }

    public static void setPlayerAutoEatMode(class_3222 player, AutoEatMode mode) {
        autoEatModeByPlayer.put(player.method_5667(), mode);
    }

    private static boolean isPlayerStorageEnabled(class_3222 player) {
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        return access.portableStorage$isStorageEnabled();
    }

    private static boolean checkAndRejectIfNotEnabled(class_3222 player) {
        return !ServerNetworkingHandlers.isPlayerStorageEnabled(player);
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(SyncControlC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            if (payload.op() == SyncControlC2SPayload.Op.REQUEST) {
                PlayerViewState.startViewing(player.method_5667());
                ServerNetworkingHandlers.sendEnablementSync(player);
                if (!ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                    ServerNetworkingHandlers.sendSync(player);
                }
            } else if (payload.op() == SyncControlC2SPayload.Op.ACK) {
                StorageSyncManager.handleSyncAck(player.method_5667(), payload.syncId(), payload.success());
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(StorageActionC2SPayload.ID, (payload, context) -> {
            StorageActionC2SPayload p = payload;
            context.server().execute(() -> {
                class_3222 player = context.player();
                if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                    return;
                }
                switch (p.target()) {
                    case STORAGE: {
                        ServerNetworkingHandlers.handleStorageAction(player, p);
                        break;
                    }
                    case UPGRADE: {
                        ServerNetworkingHandlers.handleUpgradeAction(player, p);
                        break;
                    }
                    case FLUID: {
                        ServerNetworkingHandlers.handleFluidAction(player, p);
                        break;
                    }
                    case XP_BOTTLE: {
                        ServerNetworkingHandlers.handleXpBottleAction(player, p);
                        break;
                    }
                    case SLOT: {
                        ServerNetworkingHandlers.handleSlotDepositAction(player, p);
                        break;
                    }
                    case TRASH: {
                        ServerNetworkingHandlers.handleTrashAction(player, p);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(CraftingOverlayActionC2SPayload.ID, (payload, context) -> {
            CraftingOverlayActionC2SPayload p = payload;
            context.server().execute(() -> {
                class_3222 player = context.player();
                if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                    return;
                }
                switch (p.action()) {
                    case CLICK: {
                        OverlayCraftingManager.handleClick(player, p.slotIndex(), p.button(), p.shift());
                        OverlayCraftingManager.State st = OverlayCraftingManager.get(player);
                        class_1799[] copy = new class_1799[st.slots.length];
                        for (int i = 0; i < st.slots.length; ++i) {
                            copy[i] = st.slots[i].method_7972();
                        }
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new OverlayCraftingSyncS2CPayload(copy));
                        break;
                    }
                    case DOUBLE_CLICK: {
                        OverlayCraftingManager.State st = OverlayCraftingManager.get(player);
                        class_1799 cursor = player.field_7512.method_34255();
                        if (cursor.method_7960()) {
                            return;
                        }
                        int maxPer = Math.min(cursor.method_7914(), player.method_31548().method_5444());
                        for (int i = 1; i <= 9 && cursor.method_7947() < maxPer; ++i) {
                            int can;
                            class_1799 s = st.slots[i];
                            if (s.method_7960() || !class_1799.method_31577((class_1799)s, (class_1799)cursor) || (can = Math.min(maxPer - cursor.method_7947(), s.method_7947())) <= 0) continue;
                            cursor.method_7933(can);
                            s.method_7934(can);
                            if (!s.method_7960()) continue;
                            st.slots[i] = class_1799.field_8037;
                        }
                        player.field_7512.method_34254(cursor);
                        OverlayCraftingManager.updateResult(player);
                        class_1799[] copy = new class_1799[st.slots.length];
                        for (int i = 0; i < st.slots.length; ++i) {
                            copy[i] = st.slots[i].method_7972();
                        }
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new OverlayCraftingSyncS2CPayload(copy));
                        break;
                    }
                    case REFILL: {
                        ServerNetworkingHandlers.refillCraftingFromStorage(player, p.slotIndex(), p.targetStack());
                        break;
                    }
                    case EMI_FILL: {
                        ServerNetworkingHandlers.handleEmiRecipeFill(player, p.recipeId(), p.slotIndices(), p.itemCounts());
                        break;
                    }
                    case REFUND: {
                        OverlayCraftingManager.refundAll(player);
                        class_1703 handler = player.field_7512;
                        if (handler instanceof class_1723) {
                            class_1723 playerHandler = (class_1723)handler;
                            for (int i = 1; i <= 4 && i < playerHandler.field_7761.size(); ++i) {
                                class_1735 slot = playerHandler.method_7611(i);
                                class_1799 stack = slot.method_7677();
                                if (stack.method_7960()) continue;
                                if (!player.method_31548().method_7394(stack)) {
                                    player.method_7328(stack, false);
                                }
                                slot.method_53512(class_1799.field_8037);
                                slot.method_7668();
                            }
                            class_1735 outputSlot = playerHandler.method_7611(0);
                            if (!outputSlot.method_7677().method_7960()) {
                                class_1799 outputStack = outputSlot.method_7677();
                                if (!player.method_31548().method_7394(outputStack)) {
                                    player.method_7328(outputStack, false);
                                }
                                outputSlot.method_53512(class_1799.field_8037);
                                outputSlot.method_7668();
                            }
                        }
                        handler.method_7623();
                        ServerNetworkingHandlers.sendSync(player);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(FluidSlotClickC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                return;
            }
            UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
            class_1799 cursor = player.field_7512.method_34255();
            class_1799 fluidStack = upgrades.getFluidStack();
            if (cursor.method_7960()) {
                if (!fluidStack.method_7960()) {
                    upgrades.setFluidStack(class_1799.field_8037);
                    player.field_7512.method_34254(fluidStack);
                    player.field_7512.method_7623();
                    ServerNetworkingHandlers.sendSync(player);
                }
            } else if (UpgradeInventory.isValidFluidItem(cursor)) {
                if (cursor.method_31574(class_1802.field_8550)) {
                    boolean hasFluid = false;
                    for (String fluidType : new String[]{"lava", "water", "milk"}) {
                        if (upgrades.getFluidUnits(fluidType) <= 0) continue;
                        upgrades.removeFluidUnits(fluidType, 1);
                        player.field_7512.method_34254(UpgradeInventory.createFluidBucket(fluidType));
                        hasFluid = true;
                        break;
                    }
                    if (!hasFluid) {
                        upgrades.setFluidStack(cursor.method_7972());
                        player.field_7512.method_34254(fluidStack);
                    }
                } else {
                    String fluidType = UpgradeInventory.getFluidType(cursor);
                    if (fluidType != null) {
                        upgrades.addFluidUnits(fluidType, 1);
                        player.field_7512.method_34254(new class_1799((class_1935)class_1802.field_8550));
                    } else {
                        upgrades.setFluidStack(cursor.method_7972());
                        player.field_7512.method_34254(fluidStack);
                    }
                }
                player.field_7512.method_7623();
                ServerNetworkingHandlers.sendSync(player);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(FluidClickC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_1799 cursor;
            class_3222 player = context.player();
            if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                return;
            }
            UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
            String fluidType = payload.fluidType();
            int button = payload.button();
            if (button == 0) {
                return;
            }
            if (button == 1 && !(cursor = player.field_7512.method_34255()).method_7960() && cursor.method_31574(UpgradeInventory.createFluidBucket(fluidType).method_7909())) {
                ServerConfig config = ServerConfig.getInstance();
                boolean shouldNotAdd = false;
                if (fluidType.equals("lava") && config.isEnableInfiniteLava()) {
                    int units = upgrades.getFluidUnits(fluidType);
                    shouldNotAdd = units >= config.getInfiniteLavaThreshold();
                } else if (fluidType.equals("water") && config.isEnableInfiniteWater()) {
                    int units = upgrades.getFluidUnits(fluidType);
                    boolean bl = shouldNotAdd = units >= config.getInfiniteWaterThreshold();
                }
                if (!shouldNotAdd) {
                    upgrades.addFluidUnits(fluidType, 1);
                }
                player.field_7512.method_34254(new class_1799((class_1935)class_1802.field_8550));
                player.field_7512.method_7623();
                ServerNetworkingHandlers.sendSync(player);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(FluidConversionC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            int units;
            class_3222 player = context.player();
            if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                return;
            }
            UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
            String fluidType = payload.fluidType();
            int button = payload.button();
            if (button == 1) {
                int units2;
                class_1799 cursor = player.field_7512.method_34255();
                if (!cursor.method_7960() && cursor.method_31574(class_1802.field_8550) && (units2 = upgrades.getFluidUnits(fluidType)) > 0) {
                    ServerConfig config = ServerConfig.getInstance();
                    boolean shouldNotConsume = false;
                    if (fluidType.equals("lava") && config.isEnableInfiniteLava()) {
                        shouldNotConsume = units2 >= config.getInfiniteLavaThreshold();
                    } else if (fluidType.equals("water") && config.isEnableInfiniteWater()) {
                        boolean bl = shouldNotConsume = units2 >= config.getInfiniteWaterThreshold();
                    }
                    if (!shouldNotConsume) {
                        upgrades.removeFluidUnits(fluidType, 1);
                    }
                    class_1799 fluidBucket = UpgradeInventory.createFluidBucket(fluidType);
                    if (cursor.method_7947() > 1) {
                        class_1799 remainingBuckets = cursor.method_7972();
                        remainingBuckets.method_7934(1);
                        ServerNetworkingHandlers.insertIntoNewStorage(player, remainingBuckets);
                        player.field_7512.method_34254(fluidBucket);
                    } else {
                        player.field_7512.method_34254(fluidBucket);
                    }
                    player.field_7512.method_7623();
                    ServerNetworkingHandlers.sendSync(player);
                }
            } else if (button == 0 && (units = upgrades.getFluidUnits(fluidType)) > 0) {
                class_1799 bucketToConsume = null;
                int bucketSlot = -1;
                class_1703 handler = player.field_7512;
                for (int i = 0; i < handler.field_7761.size(); ++i) {
                    class_1735 slot = (class_1735)handler.field_7761.get(i);
                    if (!slot.method_7681() || !slot.method_7677().method_31574(class_1802.field_8550)) continue;
                    bucketToConsume = slot.method_7677();
                    bucketSlot = i;
                    break;
                }
                if (bucketToConsume != null) {
                    ServerConfig config = ServerConfig.getInstance();
                    boolean shouldNotConsume = false;
                    if (fluidType.equals("lava") && config.isEnableInfiniteLava()) {
                        shouldNotConsume = units >= config.getInfiniteLavaThreshold();
                    } else if (fluidType.equals("water") && config.isEnableInfiniteWater()) {
                        shouldNotConsume = units >= config.getInfiniteWaterThreshold();
                    }
                    bucketToConsume.method_7934(1);
                    if (bucketToConsume.method_7960()) {
                        ((class_1735)handler.field_7761.get(bucketSlot)).method_53512(class_1799.field_8037);
                    }
                    if (!shouldNotConsume) {
                        upgrades.removeFluidUnits(fluidType, 1);
                    }
                    class_1799 fluidBucket = UpgradeInventory.createFluidBucket(fluidType);
                    ServerNetworkingHandlers.insertIntoPlayerInventory(player, fluidBucket);
                    player.field_7512.method_7623();
                    ServerNetworkingHandlers.sendSync(player);
                }
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(SyncFilterRulesC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            FilterRuleManager.syncPlayerRules(player, payload.filterRules(), payload.destroyRules());
        }));
        ServerPlayNetworking.registerGlobalReceiver(SyncBarrelFilterRulesC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1937 world = player.method_37908();
            class_2586 blockEntity = world.method_8321(payload.barrelPos());
            if (blockEntity instanceof BoundBarrelBlockEntity) {
                BoundBarrelBlockEntity barrel = (BoundBarrelBlockEntity)blockEntity;
                ArrayList<BoundBarrelBlockEntity.FilterRule> filterRules = new ArrayList<BoundBarrelBlockEntity.FilterRule>();
                for (SyncBarrelFilterRulesC2SPayload.FilterRule rule : payload.filterRules()) {
                    filterRules.add(new BoundBarrelBlockEntity.FilterRule(rule.matchRule(), rule.isWhitelist(), rule.enabled()));
                }
                barrel.setFilterRules(filterRules);
                barrel.method_5431();
                System.out.println("\u670d\u52a1\u5668\u66f4\u65b0\u7ed1\u5b9a\u6728\u6876\u89c4\u5219: \u7b5b\u9009=" + filterRules.size());
            }
        }));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            if (player != null) {
                ServerConfig config = ServerConfig.getInstance();
                class_2487 data = new class_2487();
                data.method_10556("stonecutter", config.isStonecutter());
                data.method_10556("cartographyTable", config.isCartographyTable());
                data.method_10556("smithingTable", config.isSmithingTable());
                data.method_10556("grindstone", config.isGrindstone());
                data.method_10556("loom", config.isLoom());
                data.method_10556("furnace", config.isFurnace());
                data.method_10556("smoker", config.isSmoker());
                data.method_10556("blastFurnace", config.isBlastFurnace());
                data.method_10556("anvil", config.isAnvil());
                data.method_10556("enchantingTable", config.isEnchantingTable());
                data.method_10556("brewingStand", config.isBrewingStand());
                data.method_10556("beacon", config.isBeacon());
                data.method_10556("chest", config.isChest());
                data.method_10556("barrel", config.isBarrel());
                data.method_10556("enderChest", config.isEnderChest());
                data.method_10556("shulkerBox", config.isShulkerBox());
                data.method_10556("dispenser", config.isDispenser());
                data.method_10556("dropper", config.isDropper());
                data.method_10556("crafter", config.isCrafter());
                data.method_10556("hopper", config.isHopper());
                data.method_10556("trappedChest", config.isTrappedChest());
                data.method_10556("hopperMinecart", config.isHopperMinecart());
                data.method_10556("chestMinecart", config.isChestMinecart());
                data.method_10556("chestBoat", config.isChestBoat());
                data.method_10556("bambooChestRaft", config.isBambooChestRaft());
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.DISPLAY_CONFIG, data));
                class_2487 riftData = new class_2487();
                riftData.method_10582("riftUpgradeItem", config.getRiftUpgradeItem());
                riftData.method_10569("riftSize", config.getRiftSize());
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.RIFT_CONFIG, riftData));
                class_2487 virtualCraftingData = new class_2487();
                virtualCraftingData.method_10556("enableVirtualCrafting", config.isEnableVirtualCrafting());
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.VIRTUAL_CRAFTING_CONFIG, virtualCraftingData));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(XpBottleClickC2SPayload.ID, (payload, context) -> {
            int button = payload.button();
            context.server().execute(() -> {
                class_3222 player = context.player();
                if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                    return;
                }
                UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
                if (upgrades.isSlotDisabled(7, player) || upgrades.getStack(7).method_7960()) {
                    return;
                }
                if (upgrades.isLevelMaintenanceEnabled()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.exp_bottle.maintenance_blocked"), true);
                    return;
                }
                int idx = xpStepIndexByPlayer.getOrDefault(player.method_5667(), 0);
                int levels = XP_STEPS[idx];
                if (button == 0) {
                    long taken;
                    int xpNeeded = ServerNetworkingHandlers.xpForLevels(player.field_7520, levels);
                    long availableXp = upgrades.getXpPool();
                    if (availableXp >= (long)xpNeeded) {
                        long taken2 = upgrades.removeFromXpPool(xpNeeded);
                        if (taken2 > 0L) {
                            int actualWithdrawn = ServerNetworkingHandlers.withdrawPlayerXpByLevels(player, levels);
                            player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.delta", (Object[])new Object[]{"+" + actualWithdrawn}), true);
                        }
                    } else if (availableXp > 0L && (taken = upgrades.removeFromXpPool(availableXp)) > 0L) {
                        player.method_7255((int)Math.min(Integer.MAX_VALUE, taken));
                        player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.delta", (Object[])new Object[]{"+" + taken}), true);
                    }
                    ServerNetworkingHandlers.sendUpgradeSync(player);
                } else {
                    int deposited = ServerNetworkingHandlers.depositPlayerXpByLevels(player, levels);
                    if (deposited > 0) {
                        upgrades.addToXpPool(deposited);
                        player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.delta", (Object[])new Object[]{"-" + deposited}), true);
                    }
                    ServerNetworkingHandlers.sendUpgradeSync(player);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(XpBottleMaintenanceToggleC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                return;
            }
            UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
            if (upgrades.isSlotDisabled(7, player) || upgrades.getStack(7).method_7960()) {
                return;
            }
            upgrades.toggleLevelMaintenance();
            boolean enabled = upgrades.isLevelMaintenanceEnabled();
            class_5250 status = enabled ? class_2561.method_43471((String)"portable-storage.toggle.enabled") : class_2561.method_43471((String)"portable-storage.toggle.disabled");
            player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.maintenance_toggle", (Object[])new Object[]{status}), true);
            ServerNetworkingHandlers.sendUpgradeSync(player);
        }));
        ServerPlayNetworking.registerGlobalReceiver(XpBottleConversionC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            long availableXp;
            class_3222 player = context.player();
            if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                return;
            }
            UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
            if (upgrades.isSlotDisabled(7, player) || upgrades.getStack(7).method_7960()) {
                return;
            }
            class_1799 cursorStack = player.field_7512.method_34255();
            if (cursorStack.method_7960() || !cursorStack.method_31574(class_1802.field_8469)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.exp_bottle.conversion.no_bottle"), true);
                return;
            }
            int bottleCount = cursorStack.method_7947();
            int maxConvertible = (int)Math.min((long)bottleCount, (availableXp = upgrades.getXpPool()) / 11L);
            if (maxConvertible <= 0) {
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.exp_bottle.conversion.insufficient_xp"), true);
                return;
            }
            long xpUsed = (long)maxConvertible * 11L;
            upgrades.removeFromXpPool(xpUsed);
            class_1799 experienceBottles = new class_1799((class_1935)class_1802.field_8287, maxConvertible);
            int remainingBottles = bottleCount - maxConvertible;
            if (remainingBottles > 0) {
                class_1799 remainingBottleStack = new class_1799((class_1935)class_1802.field_8469, remainingBottles);
                ServerNetworkingHandlers.insertIntoNewStorage(player, remainingBottleStack);
                player.field_7512.method_34254(experienceBottles);
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.conversion.partial", (Object[])new Object[]{maxConvertible, remainingBottles}), true);
            } else {
                player.field_7512.method_34254(experienceBottles);
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.conversion.complete", (Object[])new Object[]{maxConvertible}), true);
            }
            ServerNetworkingHandlers.sendUpgradeSync(player);
            ServerNetworkingHandlers.sendSync(player);
        }));
        ServerPlayNetworking.registerGlobalReceiver(RequestOpenScreenC2SPayload.ID, (payload, context) -> context.server().execute(() -> {
            final class_3222 player = context.player();
            if (payload.screen() == RequestOpenScreenC2SPayload.Screen.VANILLA_CRAFTING) {
                final class_2338[] openPosHolder = new class_2338[1];
                final class_1937[] openWorldHolder = new class_1937[1];
                class_1703 patt0$temp = player.field_7512;
                if (patt0$temp instanceof PortableCraftingScreenHandler) {
                    PortableCraftingScreenHandler pch = (PortableCraftingScreenHandler)patt0$temp;
                    for (int i = 1; i <= 9 && i < pch.field_7761.size(); ++i) {
                        class_1735 slot = pch.method_7611(i);
                        class_1799 st = slot.method_7677();
                        if (st.method_7960()) continue;
                        class_1799 copy = st.method_7972();
                        slot.method_53512(class_1799.field_8037);
                        ServerNetworkingHandlers.insertIntoPlayerInventory(player, copy);
                    }
                    pch.getContext().method_17393((w, pos) -> {
                        openWorldHolder[0] = w;
                        openPosHolder[0] = pos;
                    });
                }
                player.method_7346();
                player.method_17355(new class_3908(){

                    public class_2561 method_5476() {
                        return class_2561.method_43471((String)"container.crafting");
                    }

                    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 playerEntity) {
                        class_1937 w = openWorldHolder[0] != null ? openWorldHolder[0] : player.method_37908();
                        class_2338 p = openPosHolder[0] != null ? openPosHolder[0] : player.method_24515();
                        return new class_1714(syncId, inv, class_3914.method_17392((class_1937)w, (class_2338)p));
                    }
                });
            } else if (payload.screen() == RequestOpenScreenC2SPayload.Screen.PORTABLE_CRAFTING) {
                if (ServerNetworkingHandlers.checkAndRejectIfNotEnabled(player)) {
                    return;
                }
                UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
                boolean hasCraftingUpgrade = false;
                for (int i = 0; i < upgrades.getSlotCount(); ++i) {
                    class_1799 st = upgrades.getStack(i);
                    if (st.method_7960() || st.method_7909() != class_1802.field_8465 || upgrades.isSlotDisabled(i, player)) continue;
                    hasCraftingUpgrade = true;
                    break;
                }
                if (!hasCraftingUpgrade) {
                    return;
                }
                player.method_7346();
                player.method_17355(new class_3908(){

                    public class_2561 method_5476() {
                        return class_2561.method_43471((String)"container.crafting");
                    }

                    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 p) {
                        return new PortableCraftingScreenHandler(syncId, inv, class_3914.method_17392((class_1937)player.method_37908(), (class_2338)player.method_24515()));
                    }
                });
            } else if (payload.screen() == RequestOpenScreenC2SPayload.Screen.FILTER_MAIN || payload.screen() == RequestOpenScreenC2SPayload.Screen.FILTER_SCREEN || payload.screen() == RequestOpenScreenC2SPayload.Screen.DESTROY_SCREEN || payload.screen() == RequestOpenScreenC2SPayload.Screen.BARREL_FILTER) {
                // empty if block
            }
        }));
    }

    private static int totalXpForLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)Math.floor(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)Math.floor(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private static int xpToNextLevel(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    private static int depositPlayerXpByLevels(class_3222 player, int levels) {
        if (levels <= 0) {
            return 0;
        }
        int currentLevel = player.field_7520;
        float currentProgress = player.field_7510;
        int xpInCurrentLevel = (int)(currentProgress * (float)ServerNetworkingHandlers.xpToNextLevel(currentLevel));
        int totalDeposited = 0;
        if (xpInCurrentLevel > 0) {
            totalDeposited += xpInCurrentLevel;
            player.field_7510 = 0.0f;
        }
        for (int i = 0; i < levels && currentLevel > 0; ++i) {
            int xpForThisLevel = ServerNetworkingHandlers.xpToNextLevel(--currentLevel);
            totalDeposited += xpForThisLevel;
            player.field_7520 = currentLevel;
        }
        player.method_7255(0);
        return totalDeposited;
    }

    private static int withdrawPlayerXpByLevels(class_3222 player, int levels) {
        if (levels <= 0) {
            return 0;
        }
        int currentLevel = player.field_7520;
        float currentProgress = player.field_7510;
        int xpInCurrentLevel = (int)(currentProgress * (float)ServerNetworkingHandlers.xpToNextLevel(currentLevel));
        int totalWithdrawn = 0;
        if (xpInCurrentLevel > 0) {
            totalWithdrawn += xpInCurrentLevel;
            player.field_7510 = 0.0f;
        }
        for (int i = 0; i < levels; ++i) {
            int xpNeededToNextLevel = ServerNetworkingHandlers.xpToNextLevel(currentLevel) - (int)(player.field_7510 * (float)ServerNetworkingHandlers.xpToNextLevel(currentLevel));
            totalWithdrawn += xpNeededToNextLevel;
            player.field_7520 = ++currentLevel;
            player.field_7510 = 0.0f;
        }
        player.method_7255(0);
        return totalWithdrawn;
    }

    private static int xpForLevels(int baseLevel, int levels) {
        int from = ServerNetworkingHandlers.totalXpForLevel(baseLevel);
        int to = ServerNetworkingHandlers.totalXpForLevel(baseLevel + levels);
        return Math.max(0, to - from);
    }

    private static UUID getOwnerUuidFromItem(class_1799 stack) {
        try {
            class_9279 comp = (class_9279)stack.method_57824(class_9334.field_49628);
            if (comp == null) {
                return null;
            }
            class_2487 nbt = comp.method_57461();
            if (nbt.method_10545("ps_owner_uuid_most") && nbt.method_10545("ps_owner_uuid_least")) {
                return new UUID(nbt.method_10537("ps_owner_uuid_most"), nbt.method_10537("ps_owner_uuid_least"));
            }
            if (nbt.method_10545("ps_owner_uuid")) {
                return nbt.method_25926("ps_owner_uuid");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void insertIntoPlayerInventory(class_3222 player, class_1799 stack) {
        int i;
        class_1661 inv = player.method_31548();
        if (stack.method_7960()) {
            return;
        }
        for (i = 0; i <= 35 && !stack.method_7960(); ++i) {
            class_1799 cur = inv.method_5438(i);
            if (cur.method_7960() || !class_1799.method_31577((class_1799)cur, (class_1799)stack)) continue;
            int max = Math.min(cur.method_7914(), inv.method_5444());
            int can = Math.min(stack.method_7947(), max - cur.method_7947());
            if (can <= 0) continue;
            cur.method_7933(can);
            stack.method_7934(can);
            inv.method_5431();
        }
        for (i = 0; i <= 35 && !stack.method_7960(); ++i) {
            if (!inv.method_5438(i).method_7960()) continue;
            inv.method_5447(i, stack.method_7972());
            stack.method_7939(0);
            inv.method_5431();
            break;
        }
        if (!stack.method_7960()) {
            player.method_7328(stack, false);
        }
    }

    private static class_1799 insertIntoNewStorage(class_3222 player, class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return stack;
        }
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        StorageType storageType = access.portableStorage$getStorageType();
        if (storageType.hasCapacityLimit() && !NewStoreService.canAddNewItemType(player, stack)) {
            return stack;
        }
        long accepted = NewStoreService.insertCountForOnlinePlayer(player, stack);
        int original = stack.method_7947();
        if (accepted <= 0L) {
            return stack;
        }
        if (accepted >= (long)original) {
            return class_1799.field_8037;
        }
        class_1799 remainder = stack.method_7972();
        remainder.method_7939(original - (int)Math.min(Integer.MAX_VALUE, accepted));
        return remainder;
    }

    public static void sendSync(class_3222 player) {
        StorageInventory merged = ServerNetworkingHandlers.buildMergedSnapshot(player);
        class_2487 nbt = new class_2487();
        StorageSyncManager.startNewSession(player.method_5667());
        long sid = StorageSyncManager.getOrStartSession(player.method_5667());
        nbt.method_10544("sessionId", sid);
        merged.writeNbt(nbt, (class_7225.class_7874)player.method_56673());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new StorageSyncS2CPayload(nbt));
        StorageSyncManager.setLastSnapshot(player.method_5667(), ServerNetworkingHandlers.toSnapshotMap(merged));
        ServerNetworkingHandlers.sendUpgradeSync(player);
        ServerNetworkingHandlers.sendEnablementSync(player);
        ServerNetworkingHandlers.sendInfiniteFluidConfigSync(player);
        ServerNetworkingHandlers.sendRiftConfigSync(player);
        ServerNetworkingHandlers.sendVirtualCraftingConfigSync(player);
        ServerNetworkingHandlers.sendContainerDisplayConfigSync(player);
    }

    private static void sendIncrementalAll(class_3222 player) {
        long sid = StorageSyncManager.getOrStartSession(player.method_5667());
        int seq = StorageSyncManager.nextSeq(player.method_5667());
        StorageInventory cur = ServerNetworkingHandlers.buildMergedSnapshot(player);
        class_2487 diff = ServerNetworkingHandlers.buildRealDiffFromSnapshots(player, cur);
        int maxEntries = 512;
        try {
            maxEntries = Math.max(1, ServerConfig.getInstance().getIncrementalSyncMaxEntries());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        List<class_2487> chunks = ServerNetworkingHandlers.splitDiff(diff, maxEntries);
        for (class_2487 part : chunks) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new IncrementalStorageSyncS2CPayload(sid, seq, part));
            seq = StorageSyncManager.nextSeq(player.method_5667());
        }
        StorageSyncManager.setLastSnapshot(player.method_5667(), ServerNetworkingHandlers.toSnapshotMap(cur));
    }

    private static class_2487 buildRealDiffFromSnapshots(class_3222 player, StorageInventory current) {
        class_2487 diff = new class_2487();
        class_2499 upserts = new class_2499();
        class_2499 removes = new class_2499();
        Map<String, StorageSyncManager.SnapshotEntry> last = StorageSyncManager.getLastSnapshot(player.method_5667());
        HashSet<String> visited = new HashSet<String>();
        for (int i = 0; i < current.getCapacity(); ++i) {
            StorageSyncManager.SnapshotEntry pre;
            class_1799 disp = current.getDisplayStack(i);
            long cnt = current.getCountByIndex(i);
            if (disp.method_7960() || cnt <= 0L) continue;
            String key = ServerNetworkingHandlers.makeKeyForStack(disp);
            long ts = current.getTimestampByIndex(i);
            StorageSyncManager.SnapshotEntry snapshotEntry = pre = last != null ? last.get(key) : null;
            if (pre == null || pre.count != cnt || pre.timestamp != ts) {
                class_2487 e = new class_2487();
                e.method_10582("key", key);
                e.method_10544("count", cnt);
                e.method_10544("ts", ts);
                class_5455 lookup = player.method_56673();
                class_2509 ops = lookup != null ? class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup) : class_2509.field_11560;
                DataResult encoded = class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)disp.method_7972());
                encoded.result().ifPresent(n -> e.method_10566("display", n));
                upserts.add((Object)e);
            }
            visited.add(key);
        }
        if (last != null) {
            for (Map.Entry<String, StorageSyncManager.SnapshotEntry> entry : last.entrySet()) {
                if (visited.contains(entry.getKey())) continue;
                removes.add((Object)class_2519.method_23256((String)entry.getKey()));
            }
        }
        if (!upserts.isEmpty()) {
            diff.method_10566("upserts", (class_2520)upserts);
        }
        if (!removes.isEmpty()) {
            diff.method_10566("removes", (class_2520)removes);
        }
        return diff;
    }

    private static List<class_2487> splitDiff(class_2487 diff, int maxEntries) {
        ArrayList<class_2487> parts = new ArrayList<class_2487>();
        class_2499 up = diff.method_10573("upserts", 9) ? diff.method_10554("upserts", 10) : new class_2499();
        class_2499 rm = diff.method_10573("removes", 9) ? diff.method_10554("removes", 8) : new class_2499();
        int ui = 0;
        int ri = 0;
        while (ui < up.size() || ri < rm.size()) {
            int count;
            class_2487 part = new class_2487();
            class_2499 upPart = new class_2499();
            class_2499 rmPart = new class_2499();
            for (count = 0; ui < up.size() && count < maxEntries; ++count) {
                upPart.add((Object)up.method_10534(ui++));
            }
            while (ri < rm.size() && count < maxEntries) {
                rmPart.add((Object)rm.method_10534(ri++));
                ++count;
            }
            if (!upPart.isEmpty()) {
                part.method_10566("upserts", (class_2520)upPart);
            }
            if (!rmPart.isEmpty()) {
                part.method_10566("removes", (class_2520)rmPart);
            }
            parts.add(part);
        }
        if (parts.isEmpty()) {
            parts.add(new class_2487());
        }
        return parts;
    }

    private static Map<String, StorageSyncManager.SnapshotEntry> toSnapshotMap(StorageInventory inv) {
        HashMap<String, StorageSyncManager.SnapshotEntry> map = new HashMap<String, StorageSyncManager.SnapshotEntry>();
        for (int i = 0; i < inv.getCapacity(); ++i) {
            class_1799 disp = inv.getDisplayStack(i);
            long cnt = inv.getCountByIndex(i);
            if (disp.method_7960() || cnt <= 0L) continue;
            String key = ServerNetworkingHandlers.makeKeyForStack(disp);
            long ts = inv.getTimestampByIndex(i);
            map.put(key, new StorageSyncManager.SnapshotEntry(cnt, ts));
        }
        return map;
    }

    private static String makeKeyForStack(class_1799 s) {
        return ItemKeyHasher.hash(s, null);
    }

    public static void sendIncrementalSync(class_3222 player) {
        ServerNetworkingHandlers.sendIncrementalAll(player);
    }

    public static void sendIncrementalSyncOnDemand(class_3222 player) {
        ServerNetworkingHandlers.sendIncrementalAll(player);
    }

    private static void dropItemTowardsLook(class_3222 player, class_1799 stack) {
        class_1799 copy = stack.method_7972();
        stack.method_7939(0);
        class_1542 itemEntity = new class_1542(player.method_37908(), player.method_23317(), player.method_23320() - 0.3, player.method_23321(), copy);
        class_243 look = player.method_5828(1.0f).method_1029();
        class_243 spawnOffset = look.method_1021(0.3);
        itemEntity.method_23327(itemEntity.method_23317() + spawnOffset.field_1352, itemEntity.method_23318() + spawnOffset.field_1351, itemEntity.method_23321() + spawnOffset.field_1350);
        double speed = 0.35;
        class_243 vel = look.method_1021(speed);
        vel = vel.method_1031(0.0, 0.1, 0.0);
        itemEntity.method_18799(vel);
        itemEntity.method_6982(10);
        player.method_37908().method_8649((class_1297)itemEntity);
    }

    public static void sendUpgradeSync(class_3222 player) {
        UpgradeInventory up = PlayerStorageService.getUpgradeInventory((class_1657)player);
        class_2487 nbt = new class_2487();
        up.writeNbt(nbt);
        class_2487 data = nbt;
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.UPGRADE, data));
        int xpStep = xpStepIndexByPlayer.getOrDefault(player.method_5667(), 0);
        class_2487 data2 = new class_2487();
        data2.method_10569("stepIndex", xpStep);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.XP_STEP, data2));
        AutoEatMode mode = autoEatModeByPlayer.getOrDefault(player.method_5667(), AutoEatMode.DISABLED);
        data2 = new class_2487();
        data2.method_10569("modeIndex", mode.getIndex());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.AUTO_EAT_MODE, data2));
    }

    public static void sendEnablementSync(class_3222 player) {
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        boolean enabled = access.portableStorage$isStorageEnabled();
        StorageType storageType = access.portableStorage$getStorageType();
        class_2487 data = new class_2487();
        data.method_10556("enabled", enabled);
        data.method_10582("storageType", storageType.getKey());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.STORAGE_ENABLEMENT, data));
    }

    public static void sendInfiniteFluidConfigSync(class_3222 player) {
        ServerConfig config = ServerConfig.getInstance();
        class_2487 data = new class_2487();
        data.method_10556("enableInfiniteLava", config.isEnableInfiniteLava());
        data.method_10556("enableInfiniteWater", config.isEnableInfiniteWater());
        data.method_10569("infiniteLavaThreshold", config.getInfiniteLavaThreshold());
        data.method_10569("infiniteWaterThreshold", config.getInfiniteWaterThreshold());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.INFINITE_FLUID_CONFIG, data));
    }

    public static void sendRiftConfigSync(class_3222 player) {
        ServerConfig config = ServerConfig.getInstance();
        class_2487 data = new class_2487();
        data.method_10582("riftUpgradeItem", config.getRiftUpgradeItem());
        data.method_10569("riftSize", config.getRiftSize());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.RIFT_CONFIG, data));
    }

    public static void sendVirtualCraftingConfigSync(class_3222 player) {
        ServerConfig config = ServerConfig.getInstance();
        class_2487 data = new class_2487();
        data.method_10556("enableVirtualCrafting", config.isEnableVirtualCrafting());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.VIRTUAL_CRAFTING_CONFIG, data));
    }

    public static void sendContainerDisplayConfigSync(class_3222 player) {
        ServerConfig config = ServerConfig.getInstance();
        class_2487 data = new class_2487();
        data.method_10556("stonecutter", config.isStonecutter());
        data.method_10556("cartographyTable", config.isCartographyTable());
        data.method_10556("smithingTable", config.isSmithingTable());
        data.method_10556("grindstone", config.isGrindstone());
        data.method_10556("loom", config.isLoom());
        data.method_10556("furnace", config.isFurnace());
        data.method_10556("smoker", config.isSmoker());
        data.method_10556("blastFurnace", config.isBlastFurnace());
        data.method_10556("anvil", config.isAnvil());
        data.method_10556("enchantingTable", config.isEnchantingTable());
        data.method_10556("brewingStand", config.isBrewingStand());
        data.method_10556("beacon", config.isBeacon());
        data.method_10556("chest", config.isChest());
        data.method_10556("barrel", config.isBarrel());
        data.method_10556("enderChest", config.isEnderChest());
        data.method_10556("shulkerBox", config.isShulkerBox());
        data.method_10556("dispenser", config.isDispenser());
        data.method_10556("dropper", config.isDropper());
        data.method_10556("crafter", config.isCrafter());
        data.method_10556("hopper", config.isHopper());
        data.method_10556("trappedChest", config.isTrappedChest());
        data.method_10556("hopperMinecart", config.isHopperMinecart());
        data.method_10556("chestMinecart", config.isChestMinecart());
        data.method_10556("chestBoat", config.isChestBoat());
        data.method_10556("bambooChestRaft", config.isBambooChestRaft());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.DISPLAY_CONFIG, data));
    }

    private static List<StorageInventory> getViewStorages(class_3222 viewer) {
        ArrayList<StorageInventory> list = new ArrayList<StorageInventory>();
        LinkedHashSet<UUID> added = new LinkedHashSet<UUID>();
        list.add(PlayerStorageService.getInventory((class_1657)viewer));
        added.add(viewer.method_5667());
        LinkedHashSet<UUID> rootOwners = new LinkedHashSet<UUID>();
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)viewer);
        for (int i = 0; i < upgrades.getSlotCount(); ++i) {
            UUID owner;
            class_1799 st = upgrades.getStack(i);
            if (st.method_7960() || st.method_7909() != class_1802.field_16307 || (owner = ServerNetworkingHandlers.getOwnerUuidFromItem(st)) == null || owner.equals(viewer.method_5667())) continue;
            rootOwners.add(owner);
        }
        if (rootOwners.isEmpty()) {
            rootOwners.add(viewer.method_5667());
        }
        List players = viewer.field_13995.method_3760().method_14571();
        for (UUID root : rootOwners) {
            class_3222 ownerPlayer = viewer.field_13995.method_3760().method_14602(root);
            if (ownerPlayer != null) {
                if (added.add(root)) {
                    list.add(PlayerStorageService.getInventory((class_1657)ownerPlayer));
                }
            } else if (added.add(root)) {
                list.add(StoragePersistence.loadStorage(viewer.field_13995, root));
            }
            for (class_3222 p : players) {
                UpgradeInventory up = PlayerStorageService.getUpgradeInventory((class_1657)p);
                boolean usesRoot = false;
                for (int i = 0; i < up.getSlotCount(); ++i) {
                    UUID owner;
                    class_1799 st = up.getStack(i);
                    if (st.method_7960() || st.method_7909() != class_1802.field_16307 || (owner = ServerNetworkingHandlers.getOwnerUuidFromItem(st)) == null || !owner.equals(root)) continue;
                    usesRoot = true;
                    break;
                }
                if (!usesRoot || !added.add(p.method_5667())) continue;
                list.add(PlayerStorageService.getInventory((class_1657)p));
            }
        }
        return list;
    }

    private static void handleStorageAction(class_3222 player, StorageActionC2SPayload p) {
        switch (p.action()) {
            case CLICK: {
                ServerNetworkingHandlers.handleStorageClick(player, p.index(), p.button());
                break;
            }
            case SHIFT_TAKE: {
                ServerNetworkingHandlers.handleStorageShiftTake(player, p.index(), p.button());
                break;
            }
            case DROP: {
                ServerNetworkingHandlers.handleStorageDrop(player, p.index(), p.amountType());
                break;
            }
            case DEPOSIT_CURSOR: {
                ServerNetworkingHandlers.handleDepositCursor(player, p.button());
                break;
            }
            case DEPOSIT_SLOT: {
                ServerNetworkingHandlers.handleSlotDepositAction(player, p);
            }
        }
    }

    private static void handleUpgradeAction(class_3222 player, StorageActionC2SPayload p) {
        int slot = p.index();
        int button = p.button();
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        if (slot < 0 || slot >= upgrades.getSlotCount()) {
            return;
        }
        if (button == 1) {
            PlayerStorageAccess access;
            if (slot == 4 && !upgrades.isSlotDisabled(4, player) && !upgrades.getStack(4).method_7960()) {
                ServerNetworkingHandlers.handleRiftTeleport(player);
                return;
            }
            if (slot == 6 && !upgrades.isSlotDisabled(6, player) && upgrades.isBedUpgradeActive()) {
                PlayerStorageAccess access2 = (PlayerStorageAccess)player;
                if (access2.portableStorage$isStorageEnabled()) {
                    ServerNetworkingHandlers.handleBedUpgradeSleep(player);
                }
                return;
            }
            if (slot == 7 && !upgrades.isSlotDisabled(7, player) && !upgrades.getStack(7).method_7960()) {
                int idx = xpStepIndexByPlayer.getOrDefault(player.method_5667(), 0);
                idx = (idx + 1) % XP_STEPS.length;
                xpStepIndexByPlayer.put(player.method_5667(), idx);
                int step = XP_STEPS[idx];
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.step", (Object[])new Object[]{step}), true);
                class_2487 data = new class_2487();
                data.method_10569("stepIndex", idx);
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.XP_STEP, data));
                return;
            }
            if (slot == 9 && !upgrades.isSlotDisabled(9, player) && !upgrades.getStack(9).method_7960()) {
                AutoEatMode currentMode = autoEatModeByPlayer.getOrDefault(player.method_5667(), AutoEatMode.DISABLED);
                AutoEatMode nextMode = currentMode.next();
                autoEatModeByPlayer.put(player.method_5667(), nextMode);
                if (nextMode.isEnabled()) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.enchanted_golden_apple.feed_count_switched", (Object[])new Object[]{nextMode.getFeedCount()}), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.enchanted_golden_apple.feed_disabled"), true);
                }
                class_2487 data = new class_2487();
                data.method_10569("modeIndex", nextMode.getIndex());
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(ConfigSyncS2CPayload.Topic.AUTO_EAT_MODE, data));
                return;
            }
            if (UpgradeInventory.isPrimaryStorageRestrictedSlot(slot) && (access = (PlayerStorageAccess)player).portableStorage$getStorageType() == StorageType.PRIMARY) {
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.primary_storage_cannot_toggle"), true);
                return;
            }
            upgrades.toggleSlotDisabled(slot);
            ServerNetworkingHandlers.sendUpgradeSync(player);
            return;
        }
        if (button == 2) {
            upgrades.toggleSlotDisabled(slot);
            ServerNetworkingHandlers.sendUpgradeSync(player);
            return;
        }
        class_1799 cursor = player.field_7512.method_34255();
        class_1799 slotStack = upgrades.getStack(slot);
        if (cursor.method_7960()) {
            if (!slotStack.method_7960()) {
                class_1799 taken = upgrades.takeStack(slot);
                if (slot == 2 && taken.method_7909() == class_1802.field_8106) {
                    ServerNetworkingHandlers.handleChestUpgradeRemoval(player, upgrades);
                }
                player.field_7512.method_34254(taken);
                player.field_7512.method_7623();
                ServerNetworkingHandlers.sendUpgradeSync(player);
            }
        } else if (slotStack.method_7960()) {
            if (!cursor.method_7960()) {
                class_1799 one = cursor.method_7972();
                one.method_7939(1);
                if (upgrades.tryInsert(slot, one, player, null, null)) {
                    cursor.method_7934(1);
                    if (cursor.method_7960()) {
                        player.field_7512.method_34254(class_1799.field_8037);
                    } else {
                        player.field_7512.method_34254(cursor);
                    }
                    player.field_7512.method_7623();
                    ServerNetworkingHandlers.sendSync(player);
                }
            }
        } else if (cursor.method_7947() == 1) {
            class_1799 taken = upgrades.takeStack(slot);
            if (upgrades.tryInsert(slot, cursor, player, null, null)) {
                player.field_7512.method_34254(taken);
                player.field_7512.method_7623();
                ServerNetworkingHandlers.sendSync(player);
            } else {
                upgrades.setStack(slot, taken);
            }
        }
    }

    private static void handleRiftTeleport(class_3222 player) {
        try {
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            class_3218 rift = SpaceRiftManager.getWorld(server);
            if (rift == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Space Rift dimension not found"), true);
                return;
            }
            if (player.method_37908() == rift) {
                class_3218 targetWorld;
                UUID id = player.method_5667();
                class_4208 back = SpaceRiftManager.getReturnPoint(id);
                if (back != null && (targetWorld = server.method_3847(back.comp_2207())) != null) {
                    SpaceRiftManager.clearReturnPoint(id);
                    SpaceRiftManager.resetToWorldBorder(player);
                    SpaceRiftManager.ensureAvatarOnExit(player);
                    class_2338 p = back.comp_2208();
                    player.method_14251(targetWorld, (double)p.method_10263() + 0.5, (double)p.method_10264(), (double)p.method_10260() + 0.5, player.method_36454(), player.method_36455());
                    return;
                }
                SpaceRiftManager.ensureAvatarOnExit(player);
                class_3218 overworld = server.method_30002();
                class_2338 spawn = overworld.method_43126();
                player.method_14251(overworld, (double)spawn.method_10263() + 0.5, (double)spawn.method_10264(), (double)spawn.method_10260() + 0.5, player.method_36454(), player.method_36455());
                return;
            }
            if (!ServerConfig.getInstance().isEnableRiftFeature()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.rift_feature_disabled"), true);
                return;
            }
            SpaceRiftManager.rememberReturnPoint(player);
            UUID id = player.method_5667();
            class_1923 origin = SpaceRiftManager.ensureAllocatedPlot(server, id);
            SpaceRiftManager.ensurePlotInitialized(rift, origin);
            class_2338 teleportPos = SpaceRiftManager.getAvatarPositionOrCenter(player, origin);
            SpaceRiftManager.removeAvatar(player);
            player.method_14251(rift, (double)teleportPos.method_10263() + 0.5, (double)teleportPos.method_10264(), (double)teleportPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
            SpaceRiftManager.applyPersonalBorder(player);
        }
        catch (Exception e) {
            player.method_7353((class_2561)class_2561.method_43470((String)("Teleport failed: " + e.getMessage())), true);
        }
    }

    private static void handleTrashAction(class_3222 player, StorageActionC2SPayload p) {
        int button = p.button();
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        if (button == 0) {
            class_1799 trashItem;
            class_1799 cursor = player.field_7512.method_34255();
            if (!cursor.method_7960()) {
                if (upgrades.tryInsertTrashSlot(cursor)) {
                    player.field_7512.method_34254(class_1799.field_8037);
                    player.field_7512.method_7623();
                    ServerNetworkingHandlers.sendUpgradeSync(player);
                }
            } else if (upgrades.isTrashSlotActive() && !(trashItem = upgrades.takeTrashSlot()).method_7960()) {
                player.field_7512.method_34254(trashItem);
                player.field_7512.method_7623();
                ServerNetworkingHandlers.sendUpgradeSync(player);
            }
        } else if (button == 1 && upgrades.isTrashSlotActive()) {
            upgrades.setTrashSlot(class_1799.field_8037);
            ServerNetworkingHandlers.sendUpgradeSync(player);
        }
    }

    private static void handleFluidAction(class_3222 player, StorageActionC2SPayload p) {
        String fluidType = p.resourceType();
        int button = p.button();
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        if (fluidType != null && !fluidType.isEmpty()) {
            class_1799 cursor;
            if (button == 0) {
                int units = upgrades.getFluidUnits(fluidType);
                if (units > 0) {
                    class_1799 bucketToConsume = null;
                    int bucketSlot = -1;
                    class_1703 handler = player.field_7512;
                    for (int i = 0; i < handler.field_7761.size(); ++i) {
                        class_1735 slot = (class_1735)handler.field_7761.get(i);
                        if (!slot.method_7681() || !slot.method_7677().method_31574(class_1802.field_8550)) continue;
                        bucketToConsume = slot.method_7677();
                        bucketSlot = i;
                        break;
                    }
                    if (bucketToConsume != null) {
                        bucketToConsume.method_7934(1);
                        if (bucketToConsume.method_7960()) {
                            ((class_1735)handler.field_7761.get(bucketSlot)).method_53512(class_1799.field_8037);
                        }
                        upgrades.removeFluidUnits(fluidType, 1);
                        class_1799 fluidBucket = UpgradeInventory.createFluidBucket(fluidType);
                        ServerNetworkingHandlers.insertIntoPlayerInventory(player, fluidBucket);
                        player.field_7512.method_7623();
                        ServerNetworkingHandlers.sendSync(player);
                    }
                }
            } else if (button == 1 && !(cursor = player.field_7512.method_34255()).method_7960() && cursor.method_31574(UpgradeInventory.createFluidBucket(fluidType).method_7909())) {
                upgrades.addFluidUnits(fluidType, 1);
                player.field_7512.method_34254(new class_1799((class_1935)class_1802.field_8550));
                player.field_7512.method_7623();
                ServerNetworkingHandlers.sendSync(player);
            }
            return;
        }
        class_1799 cursor = player.field_7512.method_34255();
        class_1799 fluidStack = upgrades.getFluidStack();
        if (cursor.method_7960()) {
            if (!fluidStack.method_7960()) {
                upgrades.setFluidStack(class_1799.field_8037);
                player.field_7512.method_34254(fluidStack);
                player.field_7512.method_7623();
                ServerNetworkingHandlers.sendSync(player);
            }
        } else if (UpgradeInventory.isValidFluidItem(cursor)) {
            if (cursor.method_31574(class_1802.field_8550)) {
                boolean hasFluid = false;
                for (String ft : new String[]{"lava", "water", "milk"}) {
                    if (upgrades.getFluidUnits(ft) <= 0) continue;
                    upgrades.removeFluidUnits(ft, 1);
                    player.field_7512.method_34254(UpgradeInventory.createFluidBucket(ft));
                    hasFluid = true;
                    break;
                }
                if (!hasFluid) {
                    upgrades.setFluidStack(cursor.method_7972());
                    player.field_7512.method_34254(fluidStack);
                }
            } else {
                String ft = UpgradeInventory.getFluidType(cursor);
                if (ft != null) {
                    upgrades.addFluidUnits(ft, 1);
                    player.field_7512.method_34254(new class_1799((class_1935)class_1802.field_8550));
                } else {
                    upgrades.setFluidStack(cursor.method_7972());
                    player.field_7512.method_34254(fluidStack);
                }
            }
            player.field_7512.method_7623();
            ServerNetworkingHandlers.sendSync(player);
        }
    }

    private static void handleXpBottleAction(class_3222 player, StorageActionC2SPayload p) {
        class_1799 cursorStack;
        int button = p.button();
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        if (upgrades.isSlotDisabled(7, player) || upgrades.getStack(7).method_7960()) {
            return;
        }
        if (upgrades.isLevelMaintenanceEnabled()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.exp_bottle.maintenance_blocked"), true);
            return;
        }
        if (button == 1 && !(cursorStack = player.field_7512.method_34255()).method_7960() && cursorStack.method_31574(class_1802.field_8469)) {
            long availableXp;
            int bottleCount = cursorStack.method_7947();
            int maxConvertible = (int)Math.min((long)bottleCount, (availableXp = upgrades.getXpPool()) / 11L);
            if (maxConvertible > 0) {
                long xpUsed = (long)maxConvertible * 11L;
                upgrades.removeFromXpPool(xpUsed);
                class_1799 experienceBottles = new class_1799((class_1935)class_1802.field_8287, maxConvertible);
                int remainingBottles = bottleCount - maxConvertible;
                if (remainingBottles > 0) {
                    class_1799 remainingBottleStack = new class_1799((class_1935)class_1802.field_8469, remainingBottles);
                    ServerNetworkingHandlers.insertIntoNewStorage(player, remainingBottleStack);
                    player.field_7512.method_34254(experienceBottles);
                    player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.conversion.partial", (Object[])new Object[]{maxConvertible, remainingBottles}), true);
                } else {
                    player.field_7512.method_34254(experienceBottles);
                    player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.conversion.complete", (Object[])new Object[]{maxConvertible}), true);
                }
                ServerNetworkingHandlers.sendUpgradeSync(player);
                ServerNetworkingHandlers.sendSync(player);
                return;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.exp_bottle.conversion.insufficient_xp"), true);
            return;
        }
        int idx = xpStepIndexByPlayer.getOrDefault(player.method_5667(), 0);
        int levels = XP_STEPS[idx];
        if (button == 0) {
            long taken;
            int xpNeeded = ServerNetworkingHandlers.xpForLevels(player.field_7520, levels);
            long availableXp = upgrades.getXpPool();
            if (availableXp >= (long)xpNeeded) {
                long taken2 = upgrades.removeFromXpPool(xpNeeded);
                if (taken2 > 0L) {
                    int actualWithdrawn = ServerNetworkingHandlers.withdrawPlayerXpByLevels(player, levels);
                    player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.delta", (Object[])new Object[]{"+" + actualWithdrawn}), true);
                }
            } else if (availableXp > 0L && (taken = upgrades.removeFromXpPool(availableXp)) > 0L) {
                player.method_7255((int)Math.min(Integer.MAX_VALUE, taken));
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.delta", (Object[])new Object[]{"+" + taken}), true);
            }
            ServerNetworkingHandlers.sendUpgradeSync(player);
        } else {
            int deposited = ServerNetworkingHandlers.depositPlayerXpByLevels(player, levels);
            if (deposited > 0) {
                upgrades.addToXpPool(deposited);
                player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.exp_bottle.delta", (Object[])new Object[]{"-" + deposited}), true);
            }
            ServerNetworkingHandlers.sendUpgradeSync(player);
        }
    }

    private static void handleSlotDepositAction(class_3222 player, StorageActionC2SPayload p) {
        String fluidType;
        int handlerSlotId = p.handlerSlotId();
        class_1703 sh = player.field_7512;
        if (handlerSlotId < 0 || handlerSlotId >= sh.field_7761.size()) {
            return;
        }
        class_1735 slot = sh.method_7611(handlerSlotId);
        class_1799 from = slot.method_7677();
        if (from.method_7960()) {
            return;
        }
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        if (UpgradeInventory.isValidFluidItem(from) && !from.method_31574(class_1802.field_8550) && (fluidType = UpgradeInventory.getFluidType(from)) != null) {
            int count = from.method_7947();
            upgrades.addFluidUnits(fluidType, count);
            class_1799 emptyBuckets = new class_1799((class_1935)class_1802.field_8550, count);
            class_1799 r = ServerNetworkingHandlers.insertIntoNewStorage(player, emptyBuckets);
            slot.method_53512(r);
            slot.method_7668();
            sh.method_7623();
            ServerNetworkingHandlers.sendSync(player);
            return;
        }
        class_1799 remainder = ServerNetworkingHandlers.insertIntoNewStorage(player, from);
        slot.method_53512(remainder);
        slot.method_7668();
        sh.method_7623();
        ServerNetworkingHandlers.sendSync(player);
    }

    private static void handleStorageClick(class_3222 player, int slotIndex, int button) {
        StorageInventory merged = ServerNetworkingHandlers.buildMergedSnapshot(player);
        if (slotIndex < 0 || slotIndex >= merged.getCapacity()) {
            return;
        }
        class_1799 slotStack = merged.getDisplayStack(slotIndex);
        class_1799 cursor = player.field_7512.method_34255();
        if (cursor.method_7960()) {
            if (slotStack.method_7960()) {
                return;
            }
            if (button == 0) {
                long want = slotStack.method_7914();
                long got = ServerNetworkingHandlers.takeFromMerged(player, slotStack, (int)want);
                class_1799 taken = slotStack.method_7972();
                taken.method_7939((int)Math.min((long)slotStack.method_7914(), got));
                player.field_7512.method_34254(taken);
            } else {
                int half = Math.max(1, Math.min(32, (int)Math.ceil((double)slotStack.method_7914() / 2.0)));
                long got = ServerNetworkingHandlers.takeFromMerged(player, slotStack, half);
                class_1799 taken = slotStack.method_7972();
                taken.method_7939((int)Math.min((long)slotStack.method_7914(), got));
                player.field_7512.method_34254(taken);
            }
        } else if (button == 0) {
            class_1799 remainder = ServerNetworkingHandlers.insertIntoNewStorage(player, cursor);
            player.field_7512.method_34254(remainder);
        } else if (cursor.method_7947() > 0) {
            class_1799 singleStack = cursor.method_7972();
            singleStack.method_7939(1);
            class_1799 remainder = ServerNetworkingHandlers.insertIntoNewStorage(player, singleStack);
            if (remainder.method_7960()) {
                cursor.method_7934(1);
                player.field_7512.method_34254(cursor);
            }
        }
        player.field_7512.method_7623();
        ServerNetworkingHandlers.sendSync(player);
    }

    private static void handleStorageShiftTake(class_3222 player, int slotIndex, int button) {
        StorageInventory merged = ServerNetworkingHandlers.buildMergedSnapshot(player);
        if (slotIndex < 0 || slotIndex >= merged.getCapacity()) {
            return;
        }
        class_1799 disp = merged.getDisplayStack(slotIndex);
        if (disp.method_7960()) {
            return;
        }
        int desired = button == 1 ? 1 : disp.method_7914();
        int canInsert = ServerNetworkingHandlers.computeInsertableIntoMainHotbar(player, disp, desired);
        if (canInsert <= 0) {
            return;
        }
        long got = ServerNetworkingHandlers.takeFromMerged(player, disp, canInsert);
        if (got <= 0L) {
            return;
        }
        ServerNetworkingHandlers.insertVariantIntoMainHotbar(player, disp, (int)Math.min(Integer.MAX_VALUE, got));
        ServerNetworkingHandlers.sendSync(player);
    }

    private static int computeInsertableIntoMainHotbar(class_3222 player, class_1799 variant, int desired) {
        int i;
        if (desired <= 0) {
            return 0;
        }
        class_1661 inv = player.method_31548();
        int remaining = desired;
        for (i = 0; i <= 35 && remaining > 0; ++i) {
            int max;
            int room;
            class_1799 cur = inv.method_5438(i);
            if (cur.method_7960() || !class_1799.method_31577((class_1799)cur, (class_1799)variant) || (room = Math.max(0, (max = Math.min(cur.method_7914(), inv.method_5444())) - cur.method_7947())) <= 0) continue;
            remaining -= Math.min(room, remaining);
        }
        for (i = 0; i <= 35 && remaining > 0; ++i) {
            if (!inv.method_5438(i).method_7960()) continue;
            int max = Math.min(variant.method_7914(), inv.method_5444());
            remaining -= Math.min(max, remaining);
        }
        return desired - Math.max(0, remaining);
    }

    private static void insertVariantIntoMainHotbar(class_3222 player, class_1799 variant, int totalCount) {
        int i;
        if (totalCount <= 0) {
            return;
        }
        class_1661 inv = player.method_31548();
        int remaining = totalCount;
        for (i = 0; i <= 35 && remaining > 0; ++i) {
            int max;
            int room;
            class_1799 cur = inv.method_5438(i);
            if (cur.method_7960() || !class_1799.method_31577((class_1799)cur, (class_1799)variant) || (room = Math.max(0, (max = Math.min(cur.method_7914(), inv.method_5444())) - cur.method_7947())) <= 0) continue;
            int add = Math.min(room, remaining);
            cur.method_7933(add);
            remaining -= add;
            inv.method_5431();
        }
        for (i = 0; i <= 35 && remaining > 0; ++i) {
            int max;
            int put;
            if (!inv.method_5438(i).method_7960() || (put = Math.min(max = Math.min(variant.method_7914(), inv.method_5444()), remaining)) <= 0) continue;
            class_1799 copy = variant.method_7972();
            copy.method_7939(put);
            inv.method_5447(i, copy);
            remaining -= put;
            inv.method_5431();
        }
        if (remaining > 0) {
            class_1799 drop = variant.method_7972();
            drop.method_7939(remaining);
            player.method_7328(drop, false);
        }
    }

    private static void handleDepositCursor(class_3222 serverPlayer, int button) {
        class_1799 cursor = serverPlayer.field_7512.method_34255();
        if (cursor.method_7960()) {
            return;
        }
        if (button == 0) {
            class_1799 remainder = ServerNetworkingHandlers.insertIntoNewStorage(serverPlayer, cursor);
            serverPlayer.field_7512.method_34254(remainder);
        } else if (button == 1 && cursor.method_7947() > 0) {
            class_1799 singleStack = cursor.method_7972();
            singleStack.method_7939(1);
            class_1799 remainder = ServerNetworkingHandlers.insertIntoNewStorage(serverPlayer, singleStack);
            if (remainder.method_7960()) {
                cursor.method_7934(1);
                serverPlayer.field_7512.method_34254(cursor);
            }
        }
        serverPlayer.field_7512.method_7623();
        ServerNetworkingHandlers.sendSync(serverPlayer);
    }

    private static void handleStorageDrop(class_3222 player, int slotIndex, int amountType) {
        StorageInventory merged = ServerNetworkingHandlers.buildMergedSnapshot(player);
        if (slotIndex < 0 || slotIndex >= merged.getCapacity()) {
            return;
        }
        class_1799 disp = merged.getDisplayStack(slotIndex);
        if (disp.method_7960()) {
            return;
        }
        int want = amountType == 1 ? disp.method_7914() : 1;
        long got = ServerNetworkingHandlers.takeFromMerged(player, disp, want);
        if (got <= 0L) {
            return;
        }
        class_1799 drop = disp.method_7972();
        drop.method_7939((int)Math.min((long)disp.method_7914(), got));
        ServerNetworkingHandlers.dropItemTowardsLook(player, drop);
        ServerNetworkingHandlers.sendSync(player);
    }

    public static StorageInventory buildMergedSnapshot(class_3222 viewer) {
        MinecraftServer server = viewer.method_5682();
        if (server == null) {
            return new StorageInventory(0);
        }
        Set<UUID> sharedUuids = ServerNetworkingHandlers.getSharedUuids(viewer);
        return NewStoreService.buildSharedView(server, viewer.method_5667(), sharedUuids);
    }

    private static Set<UUID> getSharedUuids(class_3222 viewer) {
        LinkedHashSet<UUID> sharedUuids = new LinkedHashSet<UUID>();
        sharedUuids.add(viewer.method_5667());
        LinkedHashSet<UUID> rootOwners = new LinkedHashSet<UUID>();
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)viewer);
        for (int i = 0; i < upgrades.getSlotCount(); ++i) {
            UUID owner;
            class_1799 st = upgrades.getStack(i);
            if (st.method_7960() || st.method_7909() != class_1802.field_16307 || (owner = ServerNetworkingHandlers.getOwnerUuidFromItem(st)) == null || owner.equals(viewer.method_5667())) continue;
            rootOwners.add(owner);
        }
        if (rootOwners.isEmpty()) {
            rootOwners.add(viewer.method_5667());
        }
        sharedUuids.addAll(rootOwners);
        List players = viewer.field_13995.method_3760().method_14571();
        for (class_3222 p : players) {
            UpgradeInventory up = PlayerStorageService.getUpgradeInventory((class_1657)p);
            boolean usesRoot = false;
            for (int i = 0; i < up.getSlotCount(); ++i) {
                UUID owner;
                class_1799 st = up.getStack(i);
                if (st.method_7960() || st.method_7909() != class_1802.field_16307 || (owner = ServerNetworkingHandlers.getOwnerUuidFromItem(st)) == null || !rootOwners.contains(owner)) continue;
                usesRoot = true;
                break;
            }
            if (!usesRoot) continue;
            sharedUuids.add(p.method_5667());
        }
        return sharedUuids;
    }

    private static long takeFromMerged(class_3222 viewer, class_1799 variant, int want) {
        MinecraftServer server = viewer.method_5682();
        if (server == null) {
            return 0L;
        }
        Set<UUID> sharedUuids = ServerNetworkingHandlers.getSharedUuids(viewer);
        long got = NewStoreService.takeFromSharedView(server, viewer.method_5667(), sharedUuids, variant, want);
        ServerNetworkingHandlers.broadcastToRelated(viewer);
        return got;
    }

    private static void broadcastToRelated(class_3222 actor) {
        List players = actor.field_13995.method_3760().method_14571();
        for (class_3222 p : players) {
            ServerNetworkingHandlers.sendIncrementalSyncOnDemand(p);
        }
    }

    public static long getAvailableCount(class_3222 player, class_1799 variant) {
        if (variant.method_7960()) {
            return 0L;
        }
        StorageInventory merged = ServerNetworkingHandlers.buildMergedSnapshot(player);
        long totalCount = 0L;
        for (int i = 0; i < merged.getCapacity(); ++i) {
            class_1799 disp = merged.getDisplayStack(i);
            if (disp.method_7960() || !class_1799.method_31577((class_1799)disp, (class_1799)variant)) continue;
            totalCount += merged.getCountByIndex(i);
        }
        return totalCount;
    }

    public static long takeFromStorage(class_3222 player, class_1799 variant, int want) {
        return ServerNetworkingHandlers.takeFromMerged(player, variant, want);
    }

    private static void handleEmiRecipeFill(class_3222 player, String recipeIdStr, int[] slotIndices, int[] itemCounts) {
        class_1860 class_18602;
        LoggerFactory.getLogger((String)"portable-storage/emi").debug("Server handle EmiRecipeFill: player={}, recipeId={}, slots={}, counts={}", new Object[]{player.method_5477().getString(), recipeIdStr, Arrays.toString(slotIndices), Arrays.toString(itemCounts)});
        class_1703 handler = player.field_7512;
        if (!(handler instanceof class_1714) && !(handler instanceof PortableCraftingScreenHandler)) {
            LoggerFactory.getLogger((String)"portable-storage/emi").debug("EMI fill ignored: handler={} not crafting", (Object)handler.getClass().getName());
            return;
        }
        class_2960 id = class_2960.method_12829((String)recipeIdStr);
        if (id == null) {
            return;
        }
        class_8786 entry = player.method_51469().method_8433().method_8130(id).orElse(null);
        if (entry == null || !((class_18602 = entry.comp_1933()) instanceof class_3955)) {
            return;
        }
        class_3955 crafting = (class_3955)class_18602;
        class_1856[] needs = new class_1856[9];
        if (crafting instanceof class_1869) {
            class_1869 shaped = (class_1869)crafting;
            int w = shaped.method_8150();
            int h = shaped.method_8158();
            class_2371 list = shaped.method_8117();
            for (int i = 0; i < 9; ++i) {
                int idx;
                int r = i / 3;
                int c = i % 3;
                needs[i] = r < h && c < w ? ((idx = r * w + c) < list.size() ? (class_1856)list.get(idx) : class_1856.field_9017) : class_1856.field_9017;
            }
        } else {
            class_2371 list = crafting.method_8117();
            for (int i = 0; i < 9; ++i) {
                needs[i] = i < list.size() ? (class_1856)list.get(i) : class_1856.field_9017;
            }
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 any;
            long taken;
            int slotIndex;
            class_1735 slot;
            class_1856 ing = needs[i];
            if (ing == null || ing.method_8103() || !(slot = handler.method_7611(slotIndex = 1 + i)).method_7677().method_7960()) continue;
            class_1799 variant = ServerNetworkingHandlers.findFirstMatchingInMerged(player, ing);
            if (!variant.method_7960() && (taken = ServerNetworkingHandlers.takeFromMerged(player, variant, 1)) > 0L) {
                class_1799 put = variant.method_7972();
                put.method_7939((int)taken);
                slot.method_53512(put);
                continue;
            }
            if (!ServerNetworkingHandlers.takeFromPlayerInventory(player, ing, 1) || (any = ServerNetworkingHandlers.pickAnyFromIngredient(ing)).method_7960()) continue;
            any.method_7939(1);
            slot.method_53512(any);
        }
        handler.method_7623();
        ServerNetworkingHandlers.sendSync(player);
        LoggerFactory.getLogger((String)"portable-storage/emi").debug("Server EmiRecipeFill finished: synced storage state");
    }

    private static class_1799 findFirstMatchingInMerged(class_3222 viewer, class_1856 ing) {
        StorageInventory merged = ServerNetworkingHandlers.buildMergedSnapshot(viewer);
        for (int i = 0; i < merged.getCapacity(); ++i) {
            class_1799 disp = merged.getDisplayStack(i);
            if (disp.method_7960() || !ing.method_8093(disp)) continue;
            return disp;
        }
        return class_1799.field_8037;
    }

    private static boolean takeFromPlayerInventory(class_3222 player, class_1856 ing, int needed) {
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439() && needed > 0; ++i) {
            class_1799 st = inv.method_5438(i);
            if (st.method_7960() || !ing.method_8093(st)) continue;
            st.method_7934(1);
            if (st.method_7960()) {
                inv.method_5447(i, class_1799.field_8037);
            }
            --needed;
        }
        return needed == 0;
    }

    private static class_1799 pickAnyFromIngredient(class_1856 ing) {
        class_1799[] stacks = ing.method_8105();
        return stacks.length > 0 ? stacks[0].method_7972() : class_1799.field_8037;
    }

    private static boolean portableStorage$hasCraftingTableUpgrade(class_3222 player) {
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        if (!access.portableStorage$isStorageEnabled()) {
            return false;
        }
        UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
        class_1703 handler = player.field_7512;
        if (!(handler instanceof class_1714)) {
            return false;
        }
        for (int i = 0; i < upgrades.getSlotCount(); ++i) {
            class_1799 stack = upgrades.getStack(i);
            if (stack.method_7960() || stack.method_7909() != class_1802.field_8465 || upgrades.isSlotDisabled(i, player)) continue;
            return true;
        }
        return false;
    }

    private static void handleChestUpgradeRemoval(class_3222 player, UpgradeInventory upgrades) {
        List<class_1799> extendedItems = upgrades.getExtendedSlotItems();
        if (!extendedItems.isEmpty()) {
            for (class_1799 item : extendedItems) {
                if (player.method_31548().method_7394(item)) continue;
                player.method_7328(item, false);
            }
            upgrades.clearExtendedSlots();
        }
    }

    private static void handleBedUpgradeSleep(class_3222 player) {
        if (player.method_37908().method_27983() == SpaceRiftManager.DIMENSION_KEY) {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed.no_sleep_in_rift"), true);
            return;
        }
        if (player.method_37908().method_8530()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed.no_sleep"), true);
            return;
        }
        if (player.method_37908().method_8320(player.method_24515().method_10074()).method_26215()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed.no_safe_place"), true);
            return;
        }
        class_2338 bedPos = player.method_24515();
        class_2350 facing = player.method_5735();
        class_2338 footPos = bedPos.method_10093(facing.method_10153());
        class_2680 curState = player.method_37908().method_8320(bedPos);
        class_2680 footCurState = player.method_37908().method_8320(footPos);
        if (curState.method_26204() instanceof class_2244 || footCurState.method_26204() instanceof class_2244) {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed.no_safe_place"), true);
            return;
        }
        if (tempBeds.containsKey(bedPos) || tempBeds.containsKey(footPos)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed.no_safe_place"), true);
            return;
        }
        if (!player.method_37908().method_8320(footPos).method_26215()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed.no_safe_place"), true);
            return;
        }
        class_2680 headOriginalState = player.method_37908().method_8320(bedPos);
        class_2680 footOriginalState = player.method_37908().method_8320(footPos);
        class_2680 headBedState = (class_2680)((class_2680)((class_2680)ModBlocks.TEMP_BED.method_9564().method_11657((class_2769)class_2244.field_11177, (Comparable)facing)).method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560)).method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false));
        class_2680 footBedState = (class_2680)((class_2680)((class_2680)ModBlocks.TEMP_BED.method_9564().method_11657((class_2769)class_2244.field_11177, (Comparable)facing)).method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12557)).method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false));
        TempBedData headBedData = new TempBedData(headOriginalState, player.method_37908().method_8510());
        TempBedData footBedData = new TempBedData(footOriginalState, player.method_37908().method_8510());
        tempBeds.put(bedPos, headBedData);
        tempBeds.put(footPos, footBedData);
        player.method_37908().method_8501(bedPos, headBedState);
        player.method_37908().method_8501(footPos, footBedState);
        try {
            class_2680 bedState = player.method_37908().method_8320(bedPos);
            if (bedState.method_26204() instanceof class_2244) {
                class_3965 hitResult = new class_3965(new class_243((double)bedPos.method_10263() + 0.5, (double)bedPos.method_10264() + 0.5, (double)bedPos.method_10260() + 0.5), class_2350.field_11036, bedPos, false);
                bedState.method_55781(player.method_37908(), (class_1657)player, hitResult);
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed_placed"), true);
            } else {
                ServerNetworkingHandlers.cleanupCompleteTempBed(bedPos, player.method_37908());
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed.no_safe_place"), true);
            }
        }
        catch (Exception e) {
            ServerNetworkingHandlers.cleanupCompleteTempBed(bedPos, player.method_37908());
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.bed.no_safe_place"), true);
        }
    }

    public static void cleanupTempBed(class_2338 pos, class_1937 world) {
        TempBedData bedData = tempBeds.remove(pos);
        if (bedData != null) {
            world.method_8501(pos, bedData.getOriginalState());
        }
    }

    public static void cleanupCompleteTempBed(class_2338 headPos, class_1937 world) {
        ServerNetworkingHandlers.cleanupTempBed(headPos, world);
        class_2680 headState = world.method_8320(headPos);
        if (headState.method_26204() instanceof class_2244) {
            class_2350 facing = (class_2350)headState.method_11654((class_2769)class_2244.field_11177);
            class_2338 footPos = headPos.method_10093(facing.method_10153());
            ServerNetworkingHandlers.cleanupTempBed(footPos, world);
        }
    }

    public static class_2680 getOriginalState(class_2338 pos) {
        TempBedData bedData = tempBeds.get(pos);
        return bedData != null ? bedData.getOriginalState() : null;
    }

    public static void removeTempBed(class_2338 pos) {
        tempBeds.remove(pos);
    }

    public static boolean isTempBed(class_2338 pos) {
        return tempBeds.containsKey(pos);
    }

    public static Set<class_2338> getTempBedPositions() {
        return tempBeds.keySet();
    }

    private static void refillCraftingFromStorage(class_3222 player, int slotIndex, class_1799 targetStack) {
        if (targetStack == null || targetStack.method_7960()) {
            return;
        }
        class_1703 handler = player.field_7512;
        boolean allowed = handler instanceof PortableCraftingScreenHandler ? true : (handler instanceof class_1714 ? ServerNetworkingHandlers.portableStorage$hasCraftingTableUpgrade(player) : handler instanceof class_1723);
        if (!allowed) {
            return;
        }
        if (slotIndex < 0 || slotIndex >= handler.field_7761.size()) {
            return;
        }
        class_1735 slot = handler.method_7611(slotIndex);
        class_1799 current = slot.method_7677();
        if (!current.method_7960() && !class_1799.method_31577((class_1799)current, (class_1799)targetStack)) {
            return;
        }
        int maxPerSlot = Math.min(targetStack.method_7914(), player.method_31548().method_5444());
        ArrayList<Integer> group = new ArrayList<Integer>();
        group.add(slotIndex);
        for (int i = 1; i < Math.min(10, handler.field_7761.size()); ++i) {
            class_1735 s;
            class_1799 st;
            if (i == slotIndex || (st = (s = handler.method_7611(i)).method_7677()).method_7960() || !class_1799.method_31577((class_1799)st, (class_1799)targetStack)) continue;
            group.add(i);
        }
        int[] needBySlot = new int[group.size()];
        int totalNeed = 0;
        for (int gi = 0; gi < group.size(); ++gi) {
            int need;
            class_1735 gs = handler.method_7611(((Integer)group.get(gi)).intValue());
            class_1799 cs = gs.method_7677();
            int curCnt = cs.method_7960() ? 0 : cs.method_7947();
            needBySlot[gi] = need = Math.max(0, maxPerSlot - curCnt);
            totalNeed += need;
        }
        if (totalNeed == 0 && current.method_7960()) {
            int need;
            needBySlot[0] = need = Math.max(0, Math.min(maxPerSlot, targetStack.method_7914()));
            totalNeed = need;
        }
        if (totalNeed <= 0) {
            return;
        }
        long got = ServerNetworkingHandlers.takeFromMerged(player, targetStack, totalNeed);
        if (got <= 0L) {
            return;
        }
        int[] alloc = new int[group.size()];
        int remain = (int)got;
        while (remain > 0) {
            boolean progressed = false;
            for (int gi = 0; gi < group.size() && remain > 0; ++gi) {
                int room = needBySlot[gi] - alloc[gi];
                if (room <= 0) continue;
                int n = gi;
                alloc[n] = alloc[n] + 1;
                --remain;
                progressed = true;
            }
            if (progressed) continue;
            break;
        }
        for (int gi = 0; gi < group.size(); ++gi) {
            int idx = (Integer)group.get(gi);
            int add = alloc[gi];
            if (add <= 0) continue;
            class_1735 gs = handler.method_7611(idx);
            class_1799 cs = gs.method_7677();
            if (cs.method_7960()) {
                class_1799 put = targetStack.method_7972();
                put.method_7939(add);
                gs.method_53512(put);
            } else {
                cs.method_7933(add);
            }
            gs.method_7668();
        }
        handler.method_7623();
        ServerNetworkingHandlers.sendSync(player);
    }

    public static boolean isTempBedExpired(class_2338 pos, long currentTime) {
        TempBedData bedData = tempBeds.get(pos);
        if (bedData == null) {
            return false;
        }
        long createTime = bedData.getCreateTime();
        return currentTime - createTime >= 200L;
    }

    private static class TempBedData {
        private final class_2680 originalState;
        private final long createTime;

        public TempBedData(class_2680 originalState, long createTime) {
            this.originalState = originalState;
            this.createTime = createTime;
        }

        public class_2680 getOriginalState() {
            return this.originalState;
        }

        public long getCreateTime() {
            return this.createTime;
        }
    }
}

