/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.newstore;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.portable.storage.PortableStorage;
import com.portable.storage.config.ServerConfig;
import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.newstore.ItemKeyHasher;
import com.portable.storage.newstore.PlayerStore;
import com.portable.storage.newstore.StorageMemoryCache;
import com.portable.storage.newstore.TemplateIndex;
import com.portable.storage.newstore.TemplateSlices;
import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.player.StoragePersistence;
import com.portable.storage.storage.StorageInventory;
import com.portable.storage.storage.StorageType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public final class NewStoreService {
    private NewStoreService() {
    }

    public static void insertForOnlinePlayer(class_3222 player, class_1799 stack) {
        NewStoreService.insertCountForOnlinePlayer(player, stack);
    }

    public static long insertCountForOnlinePlayer(class_3222 player, class_1799 stack) {
        long remainingCap;
        long maxSize;
        long itemSize;
        if (player == null || stack == null || stack.method_7960()) {
            return 0L;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0L;
        }
        ServerConfig config = ServerConfig.getInstance();
        if (config.isEnableSizeLimit() && (itemSize = NewStoreService.calculateItemSize(stack, (class_7225.class_7874)player.method_56673())) > (maxSize = config.getMaxStorageSizeBytes())) {
            return 0L;
        }
        TemplateIndex index = StorageMemoryCache.getTemplateIndex();
        String key = ItemKeyHasher.hash(stack, (class_7225.class_7874)player.method_56673());
        if (key == null || key.isEmpty()) {
            return 0L;
        }
        long perItemLimit = config.getSingleItemStackLimit();
        if (perItemLimit < 0L) {
            perItemLimit = Long.MAX_VALUE;
        }
        long currentCount = 0L;
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, player.method_5667());
        PlayerStore.Entry e = entries.get(key);
        if (e != null) {
            currentCount = Math.max(0L, e.count);
        }
        if ((remainingCap = perItemLimit - currentCount) <= 0L) {
            return 0L;
        }
        long allowed = Math.min((long)stack.method_7947(), remainingCap);
        if (allowed <= 0L) {
            return 0L;
        }
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        StorageType storageType = access.portableStorage$getStorageType();
        if (storageType.hasCapacityLimit() && !NewStoreService.canAddNewItemType(player, stack)) {
            return 0L;
        }
        if (index.find(key) == null) {
            int slice = index.getOrAllocateSlice();
            index.put(key, slice, 0);
            StorageMemoryCache.addTemplate(key, stack.method_7972());
        } else if (!StorageMemoryCache.getTemplateCache().containsKey(key)) {
            StorageMemoryCache.addTemplate(key, stack.method_7972());
            StorageMemoryCache.markTemplateIndexDirty();
        }
        long now = System.currentTimeMillis();
        PlayerStore.add(server, player.method_5667(), key, allowed, now);
        index.incRef(key, allowed);
        StorageMemoryCache.markTemplateIndexDirty();
        ServerNetworkingHandlers.sendSync(player);
        return allowed;
    }

    public static void insertForOfflineUuid(MinecraftServer server, UUID uuid, class_1799 stack, class_7225.class_7874 lookup) {
        long remainingCap;
        if (server == null || uuid == null || stack == null || stack.method_7960()) {
            return;
        }
        TemplateIndex index = StorageMemoryCache.getTemplateIndex();
        String key = ItemKeyHasher.hash(stack, lookup);
        if (key == null || key.isEmpty()) {
            return;
        }
        long perItemLimit = ServerConfig.getInstance().getSingleItemStackLimit();
        if (perItemLimit < 0L) {
            perItemLimit = Long.MAX_VALUE;
        }
        long currentCount = 0L;
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, uuid);
        PlayerStore.Entry e = entries.get(key);
        if (e != null) {
            currentCount = Math.max(0L, e.count);
        }
        if ((remainingCap = perItemLimit - currentCount) <= 0L) {
            return;
        }
        long allowed = Math.min((long)stack.method_7947(), remainingCap);
        if (allowed <= 0L) {
            return;
        }
        if (index.find(key) == null) {
            int slice = index.getOrAllocateSlice();
            index.put(key, slice, 0);
            StorageMemoryCache.addTemplate(key, stack.method_7972());
        } else if (!StorageMemoryCache.getTemplateCache().containsKey(key)) {
            StorageMemoryCache.addTemplate(key, stack.method_7972());
            StorageMemoryCache.markTemplateIndexDirty();
        }
        long now = System.currentTimeMillis();
        PlayerStore.add(server, uuid, key, allowed, now);
        index.incRef(key, allowed);
        StorageMemoryCache.markTemplateIndexDirty();
    }

    public static long takeForOnlinePlayer(class_3222 player, class_1799 variant, int want) {
        if (player == null || variant == null || variant.method_7960() || want <= 0) {
            return 0L;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return 0L;
        }
        String key = ItemKeyHasher.hash(variant, (class_7225.class_7874)player.method_56673());
        if (key == null || key.isEmpty()) {
            return 0L;
        }
        long taken = PlayerStore.remove(server, player.method_5667(), key, want, System.currentTimeMillis());
        if (taken > 0L) {
            TemplateIndex index = StorageMemoryCache.getTemplateIndex();
            index.incRef(key, -taken);
            if (index.find(key) != null && index.find((String)key).ref <= 0L) {
                StorageMemoryCache.getTemplateCache().remove(key);
            }
            StorageMemoryCache.markTemplateIndexDirty();
            ServerNetworkingHandlers.sendSync(player);
        }
        return taken;
    }

    public static class_1799 takeFromNewStore(MinecraftServer server, UUID uuid, class_1799 variant, int want) {
        if (server == null || uuid == null || variant == null || variant.method_7960() || want <= 0) {
            return class_1799.field_8037;
        }
        String key = ItemKeyHasher.hash(variant, null);
        if (key == null || key.isEmpty()) {
            return class_1799.field_8037;
        }
        long taken = PlayerStore.remove(server, uuid, key, want, System.currentTimeMillis());
        if (taken > 0L) {
            TemplateIndex index = StorageMemoryCache.getTemplateIndex();
            index.incRef(key, -taken);
            if (index.find(key) != null && index.find((String)key).ref <= 0L) {
                StorageMemoryCache.getTemplateCache().remove(key);
            }
            StorageMemoryCache.markTemplateIndexDirty();
            class_1799 result = variant.method_7972();
            result.method_7939((int)Math.min((long)variant.method_7914(), taken));
            return result;
        }
        return class_1799.field_8037;
    }

    public static void clearPlayerStorage(class_3222 player) {
        if (player == null) {
            return;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        UUID uuid = player.method_5667();
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, uuid);
        TemplateIndex index = StorageMemoryCache.getTemplateIndex();
        for (PlayerStore.Entry entry : entries.values()) {
            if (entry.key == null || entry.key.isEmpty() || entry.count <= 0L) continue;
            index.incRef(entry.key, -entry.count);
        }
        PlayerStore.writeAll(server, uuid, new LinkedHashMap<String, PlayerStore.Entry>(), System.currentTimeMillis());
        StorageMemoryCache.markTemplateIndexDirty();
        PortableStorage.LOGGER.info("Cleared new storage data for player {}", (Object)player.method_5477().getString());
    }

    public static StorageInventory buildSharedView(MinecraftServer server, UUID viewerUuid, Set<UUID> sharedUuids) {
        StorageInventory agg = new StorageInventory(0);
        if (server == null || sharedUuids == null || sharedUuids.isEmpty()) {
            return agg;
        }
        for (UUID uuid : sharedUuids) {
            StorageInventory legacy = StoragePersistence.loadStorage(server, uuid);
            for (int i = 0; i < legacy.getCapacity(); ++i) {
                int chunk;
                long cnt;
                class_1799 disp = legacy.getDisplayStack(i);
                if (disp.method_7960() || (cnt = legacy.getCountByIndex(i)) <= 0L) continue;
                for (long left = cnt; left > 0L; left -= (long)chunk) {
                    chunk = (int)Math.min(Integer.MAX_VALUE, left);
                    class_1799 copy = disp.method_7972();
                    copy.method_7939(chunk);
                    agg.insertItemStackWithOriginalTimestamp(copy, legacy.getTimestampByIndex(i));
                }
            }
        }
        TemplateIndex index = StorageMemoryCache.getTemplateIndex();
        class_5455.class_6890 lookup = server.method_30611();
        for (UUID uuid : sharedUuids) {
            Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, uuid);
            for (PlayerStore.Entry e : entries.values()) {
                int chunk;
                if (e.count <= 0L) continue;
                class_1799 stack = StorageMemoryCache.getTemplateCache().get(e.key);
                if ((stack == null || stack.method_7960()) && (stack = TemplateSlices.getTemplate(() -> server, index, e.key, (class_7225.class_7874)lookup)) != null && !stack.method_7960()) {
                    StorageMemoryCache.addTemplate(e.key, stack);
                }
                if (stack == null || stack.method_7960()) continue;
                for (long left = e.count; left > 0L; left -= (long)chunk) {
                    chunk = (int)Math.min(Integer.MAX_VALUE, left);
                    class_1799 copy = stack.method_7972();
                    copy.method_7939(chunk);
                    agg.insertItemStackWithOriginalTimestamp(copy, e.ts);
                }
            }
        }
        return agg;
    }

    public static long takeFromSharedView(MinecraftServer server, UUID viewerUuid, Set<UUID> sharedUuids, class_1799 variant, int want) {
        class_5455.class_6890 lookup;
        String key;
        if (server == null || sharedUuids == null || sharedUuids.isEmpty() || variant == null || variant.method_7960() || want <= 0) {
            return 0L;
        }
        long remaining = want;
        long got = 0L;
        for (UUID uuid : sharedUuids) {
            if (remaining <= 0L) break;
            StorageInventory legacy = StoragePersistence.loadStorage(server, uuid);
            for (int i = 0; i < legacy.getCapacity() && remaining > 0L; ++i) {
                long can;
                class_1799 disp = legacy.getDisplayStack(i);
                if (disp.method_7960() || !class_1799.method_31577((class_1799)disp, (class_1799)variant) || (can = Math.min(remaining, legacy.getCountByIndex(i))) <= 0L) continue;
                long t = legacy.takeByIndex(i, can, System.currentTimeMillis());
                got += t;
                remaining -= t;
            }
            StoragePersistence.saveStorage(server, uuid, legacy);
        }
        if (remaining > 0L && (key = ItemKeyHasher.hash(variant, (class_7225.class_7874)(lookup = server.method_30611()))) != null && !key.isEmpty()) {
            for (UUID uuid : sharedUuids) {
                if (remaining <= 0L) break;
                long taken = PlayerStore.remove(server, uuid, key, remaining, System.currentTimeMillis());
                if (taken <= 0L) continue;
                got += taken;
                remaining -= taken;
            }
            if (got > 0L) {
                TemplateIndex index = StorageMemoryCache.getTemplateIndex();
                index.incRef(key, -got);
                if (index.find(key) != null && index.find((String)key).ref <= 0L) {
                    TemplateSlices.removeTemplate(() -> server, index, key);
                    StorageMemoryCache.getTemplateCache().remove(key);
                }
                StorageMemoryCache.markTemplateIndexDirty();
            }
        }
        return got;
    }

    private static long calculateItemSize(class_1799 stack, class_7225.class_7874 lookup) {
        if (stack == null || stack.method_7960()) {
            return 0L;
        }
        try {
            class_2487 nbt = new class_2487();
            DataResult encoded = class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), (Object)stack);
            if (encoded.result().isEmpty()) {
                return 0L;
            }
            class_2520 itemNbt = (class_2520)encoded.result().get();
            nbt.method_10566("item", itemNbt);
            nbt.method_10569("count", stack.method_7947());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            class_2507.method_10634((class_2487)nbt, (OutputStream)baos);
            return baos.size();
        }
        catch (Exception e) {
            return 64 + (stack.method_57353().method_57837() ? 0 : 100);
        }
    }

    private static String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    public static boolean hasItemInStorage(MinecraftServer server, UUID ownerUuid, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        String key = ItemKeyHasher.hash(itemStack, (class_7225.class_7874)server.method_30611());
        if (key == null) {
            return false;
        }
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, ownerUuid);
        PlayerStore.Entry entry = entries.get(key);
        return entry != null && entry.count > 0L;
    }

    public static boolean canAddNewItemType(class_3222 player, class_1799 stack) {
        if (player == null || stack == null || stack.method_7960()) {
            return false;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, player.method_5667());
        int currentTypeCount = entries.size();
        String key = ItemKeyHasher.hash(stack, (class_7225.class_7874)player.method_56673());
        if (key != null && !key.isEmpty() && entries.containsKey(key)) {
            return true;
        }
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        StorageType storageType = access.portableStorage$getStorageType();
        return currentTypeCount < storageType.getCapacityLimit();
    }

    public static boolean isPlayerStorageEmpty(class_3222 player) {
        if (player == null) {
            return true;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return true;
        }
        Map<String, PlayerStore.Entry> entries = PlayerStore.readAll(server, player.method_5667());
        for (PlayerStore.Entry entry : entries.values()) {
            if (entry == null || entry.count <= 0L) continue;
            return false;
        }
        return true;
    }
}

