/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.newstore;

import com.portable.storage.newstore.StorageMemoryCache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public final class PlayerStore {
    public static final String SESSION = "sessionId";
    public static final String ENTRIES = "entries";

    private PlayerStore() {
    }

    public static Map<String, Entry> readAll(MinecraftServer server, UUID uuid) {
        StorageMemoryCache.PlayerCacheEntry cacheEntry = StorageMemoryCache.getPlayerCache(uuid, server);
        if (cacheEntry == null) {
            return new LinkedHashMap<String, Entry>();
        }
        return new LinkedHashMap<String, Entry>(cacheEntry.entries);
    }

    public static void writeAll(MinecraftServer server, UUID uuid, Map<String, Entry> entries, Long sessionId) {
        StorageMemoryCache.PlayerCacheEntry cacheEntry = StorageMemoryCache.getPlayerCache(uuid, server);
        if (cacheEntry == null) {
            cacheEntry = new StorageMemoryCache.PlayerCacheEntry(sessionId);
        }
        cacheEntry.entries.clear();
        cacheEntry.entries.putAll(entries);
        cacheEntry.sessionId = sessionId;
        cacheEntry.dirty = true;
        StorageMemoryCache.playerCache.put(uuid, cacheEntry);
    }

    public static void add(MinecraftServer server, UUID uuid, String key, long delta, long now) {
        if (delta <= 0L) {
            return;
        }
        StorageMemoryCache.PlayerCacheEntry cacheEntry = StorageMemoryCache.getPlayerCache(uuid, server);
        if (cacheEntry == null) {
            cacheEntry = new StorageMemoryCache.PlayerCacheEntry(null);
        }
        Entry e = cacheEntry.entries.computeIfAbsent(key, k -> new Entry());
        e.key = key;
        e.count = Math.max(0L, e.count + delta);
        e.ts = now;
        cacheEntry.dirty = true;
        StorageMemoryCache.playerCache.put(uuid, cacheEntry);
    }

    public static long remove(MinecraftServer server, UUID uuid, String key, long delta, long now) {
        if (delta <= 0L) {
            return 0L;
        }
        StorageMemoryCache.PlayerCacheEntry cacheEntry = StorageMemoryCache.getPlayerCache(uuid, server);
        if (cacheEntry == null) {
            return 0L;
        }
        Entry e = cacheEntry.entries.get(key);
        if (e == null || e.count <= 0L) {
            return 0L;
        }
        long take = Math.min(delta, e.count);
        e.count -= take;
        e.ts = now;
        if (e.count <= 0L) {
            cacheEntry.entries.remove(key);
        }
        cacheEntry.dirty = true;
        StorageMemoryCache.playerCache.put(uuid, cacheEntry);
        return take;
    }

    public static final class Entry {
        public String key;
        public long count;
        public long ts;
    }
}

