/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.newstore;

import com.portable.storage.newstore.StoragePaths;
import com.portable.storage.newstore.TemplateIndex;
import com.portable.storage.newstore.TemplateSlices;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.server.MinecraftServer;

public final class RefCountRebuilder {
    private RefCountRebuilder() {
    }

    public static void rebuild(MinecraftServer server, boolean cleanupZeroRefs) {
        StoragePaths.ensureDirectories(server);
        TemplateIndex index = TemplateIndex.load(server);
        HashMap totals = new HashMap();
        Path playersDir = StoragePaths.getPlayersDir(server);
        try (Stream<Path> stream2 = Files.list(playersDir);){
            stream2.filter(p -> p.getFileName().toString().endsWith(".nbt")).forEach(file -> {
                try {
                    class_2487 root = class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
                    if (root == null) {
                        return;
                    }
                    if (!root.method_10573("entries", 9)) {
                        return;
                    }
                    class_2499 list = root.method_10554("entries", 10);
                    for (int i = 0; i < list.size(); ++i) {
                        class_2487 c = list.method_10602(i);
                        String key = c.method_10558("key");
                        long count = c.method_10537("count");
                        if (key == null || key.isEmpty() || count <= 0L) continue;
                        totals.merge(key, count, Long::sum);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException stream2) {
            // empty catch block
        }
        for (String k : index.keys()) {
            TemplateIndex.Entry e = index.get(k);
            long ref = totals.getOrDefault(k, 0L);
            e.ref = Math.max(0L, ref);
        }
        if (cleanupZeroRefs) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String k : index.keys()) {
                TemplateIndex.Entry e = index.get(k);
                if (e == null || e.ref > 0L) continue;
                TemplateSlices.removeTemplate(() -> server, index, k);
                toRemove.add(k);
            }
            for (String k : toRemove) {
                index.remove(k);
            }
        }
        index.save(server);
    }
}

