/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.newstore;

import com.portable.storage.PortableStorage;
import com.portable.storage.newstore.PlayerStore;
import com.portable.storage.newstore.StoragePaths;
import com.portable.storage.newstore.TemplateIndex;
import com.portable.storage.newstore.TemplateSlices;
import com.portable.storage.util.SafeNbtIo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public final class StorageMemoryCache {
    private static final int MAX_CACHE_SIZE = 1000;
    private static final long SAVE_INTERVAL_SECONDS = 30L;
    private static volatile TemplateIndex templateIndex;
    private static volatile Map<String, class_1799> templateCache;
    private static volatile boolean templateIndexDirty;
    static final Map<UUID, PlayerCacheEntry> playerCache;
    private static volatile ScheduledExecutorService saveScheduler;
    private static volatile boolean isInitialized;
    private static volatile MinecraftServer currentServer;

    private StorageMemoryCache() {
    }

    public static synchronized void initialize(MinecraftServer server) {
        if (isInitialized) {
            PortableStorage.LOGGER.info("Reinitializing storage memory cache...");
            StorageMemoryCache.clearAllCaches();
        } else {
            PortableStorage.LOGGER.info("Initializing storage memory cache...");
        }
        currentServer = server;
        StorageMemoryCache.loadTemplatesToMemory(server);
        StorageMemoryCache.startPeriodicSave(server);
        isInitialized = true;
        PortableStorage.LOGGER.info("Storage memory cache initialized successfully");
    }

    public static synchronized void shutdown() {
        if (!isInitialized) {
            return;
        }
        PortableStorage.LOGGER.info("Shutting down storage memory cache...");
        if (saveScheduler != null) {
            saveScheduler.shutdown();
            try {
                if (!saveScheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                    saveScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                saveScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (currentServer != null) {
            PortableStorage.LOGGER.info("Saving all dirty data before shutdown...");
            StorageMemoryCache.saveDirtyData(currentServer);
        } else {
            PortableStorage.LOGGER.warn("No server instance available for final save");
        }
        StorageMemoryCache.clearAllCaches();
        isInitialized = false;
        PortableStorage.LOGGER.info("Storage memory cache shutdown completed");
    }

    private static void clearAllCaches() {
        templateIndex = null;
        templateCache.clear();
        templateIndexDirty = false;
        playerCache.clear();
        currentServer = null;
        PortableStorage.LOGGER.info("All caches cleared");
    }

    private static void loadTemplatesToMemory(MinecraftServer server) {
        try {
            templateIndex = TemplateIndex.load(server);
            templateCache.clear();
            Thread templateLoader = new Thread(() -> {
                try {
                    int loadedCount = 0;
                    for (String key : templateIndex.keys()) {
                        class_1799 template;
                        TemplateIndex.Entry entry = templateIndex.get(key);
                        if (entry == null || (template = TemplateSlices.getTemplate(() -> server, templateIndex, key, (class_7225.class_7874)server.method_30611())).method_7960()) continue;
                        templateCache.put(key, template);
                        ++loadedCount;
                    }
                    PortableStorage.LOGGER.info("Asynchronously loaded {} templates to memory", (Object)loadedCount);
                }
                catch (Exception e) {
                    PortableStorage.LOGGER.error("Failed to load templates to memory asynchronously", (Throwable)e);
                }
            }, "TemplateLoader");
            templateLoader.setDaemon(true);
            templateLoader.start();
            PortableStorage.LOGGER.info("Started asynchronous template loading...");
        }
        catch (Exception e) {
            PortableStorage.LOGGER.error("Failed to initialize template loading", (Throwable)e);
        }
    }

    private static void startPeriodicSave(MinecraftServer server) {
        saveScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "StorageMemoryCache-Save");
            t.setDaemon(true);
            return t;
        });
        saveScheduler.scheduleWithFixedDelay(() -> {
            try {
                StorageMemoryCache.saveDirtyData(server);
            }
            catch (Exception e) {
                PortableStorage.LOGGER.error("Error in periodic save task", (Throwable)e);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    public static PlayerCacheEntry getPlayerCache(UUID uuid, MinecraftServer server) {
        if (!isInitialized) {
            return new PlayerCacheEntry(null);
        }
        PlayerCacheEntry entry = playerCache.get(uuid);
        if (entry == null) {
            entry = StorageMemoryCache.loadPlayerFromFile(server, uuid);
            if (entry != null) {
                if (playerCache.size() >= 1000) {
                    StorageMemoryCache.cleanupOldestEntries();
                }
                playerCache.put(uuid, entry);
            }
        } else {
            entry.lastAccessTime = System.currentTimeMillis();
        }
        return entry;
    }

    private static PlayerCacheEntry loadPlayerFromFile(MinecraftServer server, UUID uuid) {
        try {
            StoragePaths.ensureDirectories(server);
            Path file = StoragePaths.getPlayerFile(server, uuid);
            LinkedHashMap<String, PlayerStore.Entry> entries = new LinkedHashMap<String, PlayerStore.Entry>();
            if (!Files.exists(file, new LinkOption[0])) {
                return new PlayerCacheEntry(null);
            }
            class_2487 root = class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
            if (root == null) {
                return new PlayerCacheEntry(null);
            }
            if (root.method_10573("entries", 9)) {
                class_2499 list = root.method_10554("entries", 10);
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 c = list.method_10602(i);
                    PlayerStore.Entry e = new PlayerStore.Entry();
                    e.key = c.method_10558("key");
                    e.count = c.method_10537("count");
                    e.ts = c.method_10537("ts");
                    if (e.key == null || e.key.isEmpty() || e.count <= 0L) continue;
                    entries.put(e.key, e);
                }
            }
            PlayerCacheEntry entry = new PlayerCacheEntry(null);
            entry.entries.putAll(entries);
            return entry;
        }
        catch (Exception e) {
            PortableStorage.LOGGER.error("Failed to load player data for UUID: " + String.valueOf(uuid), (Throwable)e);
            return null;
        }
    }

    private static void cleanupOldestEntries() {
        PlayerCacheEntry entry;
        if (playerCache.size() < 1000) {
            return;
        }
        UUID oldestUuid = null;
        long oldestTime = Long.MAX_VALUE;
        for (Map.Entry<UUID, PlayerCacheEntry> entry2 : playerCache.entrySet()) {
            if (entry2.getValue().lastAccessTime >= oldestTime) continue;
            oldestTime = entry2.getValue().lastAccessTime;
            oldestUuid = entry2.getKey();
        }
        if (oldestUuid != null && (entry = playerCache.remove(oldestUuid)) != null && entry.dirty) {
            PortableStorage.LOGGER.warn("Evicting dirty player cache entry for UUID: " + String.valueOf(oldestUuid));
        }
    }

    private static void saveDirtyData(MinecraftServer server) {
        int savedCount = 0;
        for (Map.Entry<UUID, PlayerCacheEntry> entry : playerCache.entrySet()) {
            if (!entry.getValue().dirty) continue;
            try {
                StorageMemoryCache.writePlayerToFile(server, entry.getKey(), entry.getValue());
                entry.getValue().dirty = false;
                ++savedCount;
            }
            catch (Exception e) {
                PortableStorage.LOGGER.error("Failed to save player data for UUID: " + String.valueOf(entry.getKey()), (Throwable)e);
            }
        }
        if (templateIndexDirty && templateIndex != null) {
            try {
                templateIndex.save(server);
                for (Map.Entry<Object, PlayerCacheEntry> entry : templateCache.entrySet()) {
                    TemplateIndex.Entry entry2;
                    String key = (String)entry.getKey();
                    class_1799 stack = (class_1799)entry.getValue();
                    if (stack == null || stack.method_7960() || (entry2 = templateIndex.find(key)) == null) continue;
                    TemplateSlices.putTemplate(() -> server, templateIndex, key, stack, (class_7225.class_7874)server.method_30611());
                }
                templateIndexDirty = false;
                ++savedCount;
            }
            catch (Exception e) {
                PortableStorage.LOGGER.error("Failed to save template data", (Throwable)e);
            }
        }
        if (savedCount > 0) {
            PortableStorage.LOGGER.debug("Saved {} dirty cache entries", (Object)savedCount);
        }
    }

    private static void writePlayerToFile(MinecraftServer server, UUID uuid, PlayerCacheEntry entry) {
        try {
            StoragePaths.ensureDirectories(server);
            Path file = StoragePaths.getPlayerFile(server, uuid);
            class_2487 root = new class_2487();
            if (entry.sessionId != null) {
                root.method_10544("sessionId", entry.sessionId.longValue());
            }
            class_2499 list = new class_2499();
            for (PlayerStore.Entry e : entry.entries.values()) {
                if (e.count <= 0L) continue;
                class_2487 c = new class_2487();
                c.method_10582("key", e.key);
                c.method_10544("count", e.count);
                c.method_10544("ts", e.ts);
                list.add((Object)c);
            }
            root.method_10566("entries", (class_2520)list);
            SafeNbtIo.writeCompressed(root, file);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write player data to file", e);
        }
    }

    public static void markPlayerDirty(UUID uuid) {
        PlayerCacheEntry entry = playerCache.get(uuid);
        if (entry != null) {
            entry.dirty = true;
        }
    }

    public static void markTemplateIndexDirty() {
        templateIndexDirty = true;
    }

    public static TemplateIndex getTemplateIndex() {
        if (!isInitialized) {
            return new TemplateIndex();
        }
        return templateIndex;
    }

    public static Map<String, class_1799> getTemplateCache() {
        if (!isInitialized) {
            return new ConcurrentHashMap<String, class_1799>();
        }
        return templateCache;
    }

    public static void addTemplate(String key, class_1799 template) {
        templateCache.put(key, template);
    }

    public static void removePlayerCache(UUID uuid) {
        playerCache.remove(uuid);
    }

    public static String getCacheStats() {
        return String.format("Player cache: %d entries, Template cache: %d entries", playerCache.size(), templateCache.size());
    }

    static {
        templateCache = new ConcurrentHashMap<String, class_1799>();
        templateIndexDirty = false;
        playerCache = new ConcurrentHashMap<UUID, PlayerCacheEntry>();
        isInitialized = false;
        currentServer = null;
    }

    public static final class PlayerCacheEntry {
        public final Map<String, PlayerStore.Entry> entries = new LinkedHashMap<String, PlayerStore.Entry>();
        public Long sessionId;
        public volatile boolean dirty = false;
        public volatile long lastAccessTime = System.currentTimeMillis();

        public PlayerCacheEntry(Long sessionId) {
            this.sessionId = sessionId;
        }
    }
}

