/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.newstore;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public final class StoragePaths {
    public static final String ROOT_DIR_NAME = "portable_storage";
    public static final String TEMPLATES_DIR_NAME = "templates";
    public static final String PLAYERS_DIR_NAME = "players";
    public static final String INDEX_FILE_NAME = "index.nbt";

    private StoragePaths() {
    }

    public static Path getRootDir(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve(ROOT_DIR_NAME);
    }

    public static Path getTemplatesDir(MinecraftServer server) {
        return StoragePaths.getRootDir(server).resolve(TEMPLATES_DIR_NAME);
    }

    public static Path getPlayersDir(MinecraftServer server) {
        return StoragePaths.getRootDir(server).resolve(PLAYERS_DIR_NAME);
    }

    public static Path getIndexFile(MinecraftServer server) {
        return StoragePaths.getTemplatesDir(server).resolve(INDEX_FILE_NAME);
    }

    public static Path getSliceFile(MinecraftServer server, int sliceOrdinal) {
        String fileName = String.format("slice_%03d.nbt", Math.max(1, sliceOrdinal));
        return StoragePaths.getTemplatesDir(server).resolve(fileName);
    }

    public static Path getPlayerFile(MinecraftServer server, UUID uuid) {
        return StoragePaths.getPlayersDir(server).resolve(uuid.toString() + ".nbt");
    }

    public static void ensureDirectories(MinecraftServer server) {
        try {
            Files.createDirectories(StoragePaths.getTemplatesDir(server), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Files.createDirectories(StoragePaths.getPlayersDir(server), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

