/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.newstore;

import com.portable.storage.newstore.StoragePaths;
import com.portable.storage.util.SafeNbtIo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;

public final class TemplateIndex {
    public static final String ROOT = "map";
    private final Map<String, Entry> map = new HashMap<String, Entry>();
    private int currentMaxSlice = 1;

    public static TemplateIndex load(MinecraftServer server) {
        StoragePaths.ensureDirectories(server);
        Path file = StoragePaths.getIndexFile(server);
        TemplateIndex idx = new TemplateIndex();
        if (!Files.exists(file, new LinkOption[0])) {
            return idx;
        }
        try {
            class_2487 root = SafeNbtIo.readCompressed(file, class_2505.method_53898());
            if (root != null && root.method_10545(ROOT)) {
                class_2487 m = root.method_10562(ROOT);
                for (String k : m.method_10541()) {
                    class_2487 v = m.method_10562(k);
                    Entry e = new Entry();
                    e.slice = v.method_10550("slice");
                    e.ref = v.method_10545("ref") ? v.method_10537("ref") : -1L;
                    e.size = v.method_10545("size") ? v.method_10550("size") : 0;
                    idx.map.put(k, e);
                    if (e.slice <= idx.currentMaxSlice) continue;
                    idx.currentMaxSlice = e.slice;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return idx;
    }

    public void save(MinecraftServer server) {
        StoragePaths.ensureDirectories(server);
        Path file = StoragePaths.getIndexFile(server);
        class_2487 root = new class_2487();
        class_2487 m = new class_2487();
        for (Map.Entry<String, Entry> en : this.map.entrySet()) {
            class_2487 v = new class_2487();
            v.method_10569("slice", Math.max(1, en.getValue().slice));
            if (en.getValue().ref >= 0L) {
                v.method_10544("ref", en.getValue().ref);
            }
            if (en.getValue().size > 0) {
                v.method_10569("size", en.getValue().size);
            }
            m.method_10566(en.getKey(), (class_2520)v);
        }
        root.method_10566(ROOT, (class_2520)m);
        try {
            SafeNbtIo.writeCompressed(root, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Entry find(String key) {
        return this.map.get(key);
    }

    public void put(String key, int slice, int sizeEstimate) {
        Entry e = this.map.computeIfAbsent(key, k -> new Entry());
        e.slice = Math.max(1, slice);
        if (sizeEstimate > 0) {
            e.size = sizeEstimate;
        }
        if (e.ref < 0L) {
            e.ref = 0L;
        }
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void incRef(String key, long delta) {
        Entry e = this.map.get(key);
        if (e != null) {
            if (e.ref < 0L) {
                e.ref = 0L;
            }
            e.ref += delta;
            if (e.ref < 0L) {
                e.ref = 0L;
            }
        }
    }

    public int getOrAllocateSlice() {
        return Math.max(1, this.currentMaxSlice);
    }

    public void rollToNextSlice() {
        this.currentMaxSlice = Math.max(1, this.currentMaxSlice + 1);
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public Entry get(String key) {
        return this.map.get(key);
    }

    public static final class Entry {
        public int slice;
        public long ref;
        public int size;
    }
}

