/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.newstore;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.portable.storage.PortableStorage;
import com.portable.storage.newstore.StoragePaths;
import com.portable.storage.newstore.TemplateIndex;
import com.portable.storage.util.SafeNbtIo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public final class TemplateSlices {
    public static final long SLICE_MAX_BYTES = 0x3200000L;

    private TemplateSlices() {
    }

    public static class_1799 getTemplate(MinecraftServerLike server, TemplateIndex index, String key, class_7225.class_7874 lookup) {
        TemplateIndex.Entry e = index.find(key);
        if (e == null) {
            return class_1799.field_8037;
        }
        Path sliceFile = StoragePaths.getSliceFile(server.getServer(), e.slice);
        if (!Files.exists(sliceFile, new LinkOption[0])) {
            return class_1799.field_8037;
        }
        try {
            class_2487 root = SafeNbtIo.readCompressed(sliceFile, class_2505.method_53898());
            if (root == null || !root.method_10545("templates")) {
                return class_1799.field_8037;
            }
            class_2487 templates = root.method_10562("templates");
            if (!templates.method_10545(key)) {
                return class_1799.field_8037;
            }
            class_2509 ops = lookup != null ? class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup) : class_2509.field_11560;
            DataResult parse = class_1799.field_24671.parse((DynamicOps)ops, (Object)templates.method_10580(key));
            return parse.result().orElse(class_1799.field_8037);
        }
        catch (IOException ex) {
            PortableStorage.LOGGER.warn("\u8bfb\u53d6\u6a21\u677f\u5207\u7247\u5931\u8d25\uff0c\u6587\u4ef6\u53ef\u80fd\u5df2\u635f\u574f: {}", (Object)sliceFile, (Object)ex);
            return class_1799.field_8037;
        }
    }

    public static int putTemplate(MinecraftServerLike server, TemplateIndex index, String key, class_1799 stack, class_7225.class_7874 lookup) {
        int targetSlice = index.getOrAllocateSlice();
        if (TemplateSlices.wouldExceedLimit(server.getServer(), targetSlice, TemplateSlices.estimateSize(stack, lookup))) {
            index.rollToNextSlice();
            targetSlice = index.getOrAllocateSlice();
        }
        Path sliceFile = StoragePaths.getSliceFile(server.getServer(), targetSlice);
        StoragePaths.ensureDirectories(server.getServer());
        try {
            class_2487 root;
            if (Files.exists(sliceFile, new LinkOption[0])) {
                root = SafeNbtIo.readCompressed(sliceFile, class_2505.method_53898());
                if (root == null) {
                    root = new class_2487();
                }
            } else {
                root = new class_2487();
            }
            class_2487 templates = root.method_10545("templates") ? root.method_10562("templates") : new class_2487();
            class_2509 ops = lookup != null ? class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup) : class_2509.field_11560;
            DataResult enc = class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)stack);
            enc.result().ifPresent(nbt -> templates.method_10566(key, nbt));
            root.method_10566("templates", (class_2520)templates);
            SafeNbtIo.writeCompressed(root, sliceFile);
            int size = TemplateSlices.estimateSize(stack, lookup);
            index.put(key, targetSlice, size);
            return targetSlice;
        }
        catch (IOException iOException) {
            return targetSlice;
        }
    }

    public static void removeTemplate(MinecraftServerLike server, TemplateIndex index, String key) {
        TemplateIndex.Entry e = index.find(key);
        if (e == null) {
            return;
        }
        Path sliceFile = StoragePaths.getSliceFile(server.getServer(), e.slice);
        if (!Files.exists(sliceFile, new LinkOption[0])) {
            return;
        }
        try {
            class_2487 root = SafeNbtIo.readCompressed(sliceFile, class_2505.method_53898());
            if (root == null) {
                return;
            }
            if (root.method_10545("templates")) {
                class_2487 templates = root.method_10562("templates");
                templates.method_10551(key);
                root.method_10566("templates", (class_2520)templates);
            }
            SafeNbtIo.writeCompressed(root, sliceFile);
            index.remove(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean wouldExceedLimit(MinecraftServer server, int slice, int addBytes) {
        try {
            Path f = StoragePaths.getSliceFile(server, slice);
            long existing = Files.exists(f, new LinkOption[0]) ? Files.size(f) : 0L;
            return existing + (long)Math.max(0, addBytes) > 0x3200000L;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static int estimateSize(class_1799 stack, class_7225.class_7874 lookup) {
        try {
            class_2509 ops = lookup != null ? class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup) : class_2509.field_11560;
            DataResult enc = class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)stack);
            Optional res = enc.result();
            if (res.isEmpty()) {
                return 0;
            }
            String s = ((class_2520)res.get()).toString();
            return s.getBytes(StandardCharsets.UTF_8).length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static interface MinecraftServerLike {
        public MinecraftServer getServer();
    }
}

