/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.player;

import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.player.PlayerStorageService;
import com.portable.storage.player.StoragePersistence;
import com.portable.storage.storage.StorageInventory;
import com.portable.storage.storage.UpgradeInventory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public final class StorageGroupService {
    private StorageGroupService() {
    }

    public static List<StorageInventory> getStoragesByOwner(MinecraftServer server, UUID ownerUuid) {
        ArrayList<StorageInventory> list = new ArrayList<StorageInventory>();
        LinkedHashSet<UUID> added = new LinkedHashSet<UUID>();
        class_3222 ownerOnline = server.method_3760().method_14602(ownerUuid);
        if (ownerOnline != null) {
            if (added.add(ownerUuid)) {
                list.add(PlayerStorageService.getInventory((class_1657)ownerOnline));
            }
        } else if (added.add(ownerUuid)) {
            list.add(StoragePersistence.loadStorage(server, ownerUuid));
        }
        for (class_3222 p : server.method_3760().method_14571()) {
            UpgradeInventory up = PlayerStorageService.getUpgradeInventory((class_1657)p);
            boolean usesOwner = false;
            for (int i = 0; i < up.getSlotCount(); ++i) {
                UUID u;
                class_1799 st = up.getStack(i);
                if (st.method_7960() || st.method_7909() != class_1802.field_16307 || (u = StorageGroupService.tryGetOwnerUuidFromItem(st)) == null || !u.equals(ownerUuid)) continue;
                usesOwner = true;
                break;
            }
            if (!usesOwner || !added.add(p.method_5667())) continue;
            list.add(PlayerStorageService.getInventory((class_1657)p));
        }
        return list;
    }

    public static class_1799 takeFromOwnerGroup(MinecraftServer server, UUID ownerUuid, class_1799 variant, int want) {
        List<StorageInventory> byOwner;
        if (variant == null || variant.method_7960() || want <= 0) {
            return class_1799.field_8037;
        }
        List<StorageInventory> view = StorageGroupService.getStoragesByOwner(server, ownerUuid);
        long remaining = want;
        long got = 0L;
        long ts = System.currentTimeMillis();
        for (StorageInventory s : view) {
            if (remaining <= 0L) break;
            for (int i = 0; i < s.getCapacity() && remaining > 0L; ++i) {
                long can;
                class_1799 disp = s.getDisplayStack(i);
                if (disp.method_7960() || !class_1799.method_31577((class_1799)disp, (class_1799)variant) || (can = Math.min(remaining, s.getCountByIndex(i))) <= 0L) continue;
                long t = s.takeByIndex(i, (int)can, ts);
                got += t;
                remaining -= t;
            }
        }
        if (got <= 0L) {
            return class_1799.field_8037;
        }
        class_1799 out = variant.method_7972();
        out.method_7939((int)Math.min((long)variant.method_7914(), got));
        StorageGroupService.sendSyncToAffectedPlayers(server, ownerUuid);
        class_3222 ownerOnline = server.method_3760().method_14602(ownerUuid);
        if (ownerOnline == null && !(byOwner = StorageGroupService.getStoragesByOwner(server, ownerUuid)).isEmpty()) {
            StoragePersistence.saveStorage(server, ownerUuid, byOwner.get(0));
        }
        return out;
    }

    private static void sendSyncToAffectedPlayers(MinecraftServer server, UUID ownerUuid) {
        List players = server.method_3760().method_14571();
        class_3222 owner = server.method_3760().method_14602(ownerUuid);
        if (owner != null) {
            ServerNetworkingHandlers.sendSync(owner);
        }
        for (class_3222 player : players) {
            if (player.method_5667().equals(ownerUuid)) continue;
            UpgradeInventory upgrades = PlayerStorageService.getUpgradeInventory((class_1657)player);
            boolean usesThisOwner = false;
            for (int i = 0; i < upgrades.getSlotCount(); ++i) {
                UUID barrelOwner;
                class_1799 stack = upgrades.getStack(i);
                if (stack.method_7960() || stack.method_7909() != class_1802.field_16307 || (barrelOwner = StorageGroupService.tryGetOwnerUuidFromItem(stack)) == null || !barrelOwner.equals(ownerUuid)) continue;
                usesThisOwner = true;
                break;
            }
            if (!usesThisOwner) continue;
            ServerNetworkingHandlers.sendSync(player);
        }
    }

    private static UUID tryGetOwnerUuidFromItem(class_1799 stack) {
        try {
            class_9279 comp = (class_9279)stack.method_57824(class_9334.field_49628);
            if (comp == null) {
                return null;
            }
            class_2487 nbt = comp.method_57461();
            if (nbt.method_10545("ps_owner_uuid_most") && nbt.method_10545("ps_owner_uuid_least")) {
                return new UUID(nbt.method_10537("ps_owner_uuid_most"), nbt.method_10537("ps_owner_uuid_least"));
            }
            if (nbt.method_10545("ps_owner_uuid")) {
                return nbt.method_25926("ps_owner_uuid");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

