/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.player;

import com.portable.storage.storage.StorageInventory;
import com.portable.storage.util.SafeNbtIo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public final class StoragePersistence {
    private StoragePersistence() {
    }

    public static StorageInventory loadStorage(MinecraftServer server, UUID uuid) {
        StorageInventory inv = new StorageInventory(0);
        try {
            Path dir = server.method_27050(class_5218.field_24182);
            Path file = dir.resolve(uuid.toString() + ".dat");
            if (!Files.exists(file, new LinkOption[0])) {
                return inv;
            }
            class_2487 root = SafeNbtIo.readCompressed(file, class_2505.method_53898());
            if (root != null && root.method_10545("portable_storage")) {
                inv.readNbt(root.method_10562("portable_storage"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inv;
    }

    public static void saveStorage(MinecraftServer server, UUID uuid, StorageInventory inv) {
        try {
            class_2487 root;
            Path dir = server.method_27050(class_5218.field_24182);
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(uuid.toString() + ".dat");
            if (Files.exists(file, new LinkOption[0])) {
                root = SafeNbtIo.readCompressed(file, class_2505.method_53898());
                if (root == null) {
                    root = new class_2487();
                }
            } else {
                root = new class_2487();
            }
            class_2487 out = new class_2487();
            inv.writeNbt(out);
            root.method_10566("portable_storage", (class_2520)out);
            SafeNbtIo.writeCompressed(root, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

