/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.storage;

public enum AutoEatMode {
    DISABLED(0, 0),
    COUNT_2(1, 2),
    COUNT_4(2, 4),
    COUNT_6(3, 6),
    COUNT_8(4, 8),
    COUNT_10(5, 10),
    COUNT_12(6, 12),
    COUNT_14(7, 14),
    COUNT_16(8, 16),
    COUNT_18(9, 18),
    COUNT_20(10, 20);

    private final int index;
    private final int feedCount;

    private AutoEatMode(int index, int feedCount) {
        this.index = index;
        this.feedCount = feedCount;
    }

    public int getIndex() {
        return this.index;
    }

    public int getFeedCount() {
        return this.feedCount;
    }

    public boolean isEnabled() {
        return this.feedCount > 0;
    }

    public static AutoEatMode fromIndex(int index) {
        for (AutoEatMode mode : AutoEatMode.values()) {
            if (mode.index != index) continue;
            return mode;
        }
        return DISABLED;
    }

    public static AutoEatMode fromFeedCount(int feedCount) {
        for (AutoEatMode mode : AutoEatMode.values()) {
            if (mode.feedCount != feedCount) continue;
            return mode;
        }
        return DISABLED;
    }

    public AutoEatMode next() {
        int nextIndex = (this.index + 1) % AutoEatMode.values().length;
        return AutoEatMode.fromIndex(nextIndex);
    }
}

