/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.storage;

import com.portable.storage.blockentity.BoundBarrelBlockEntity;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BarrelFilterRuleManager {
    public static boolean shouldPickupItem(BoundBarrelBlockEntity barrel, class_1799 itemStack) {
        if (barrel == null || itemStack.method_7960()) {
            return false;
        }
        List<BoundBarrelBlockEntity.FilterRule> filterRules = barrel.getFilterRules();
        if (filterRules.isEmpty()) {
            return true;
        }
        List<BoundBarrelBlockEntity.FilterRule> whitelistRules = filterRules.stream().filter(rule -> rule.enabled && rule.isWhitelist).toList();
        List<BoundBarrelBlockEntity.FilterRule> blacklistRules = filterRules.stream().filter(rule -> rule.enabled && !rule.isWhitelist).toList();
        for (BoundBarrelBlockEntity.FilterRule rule2 : blacklistRules) {
            if (!BarrelFilterRuleManager.matchesRuleDirect(rule2.matchRule, itemStack)) continue;
            return false;
        }
        if (!whitelistRules.isEmpty()) {
            for (BoundBarrelBlockEntity.FilterRule rule2 : whitelistRules) {
                if (!BarrelFilterRuleManager.matchesRuleDirect(rule2.matchRule, itemStack)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean matchesRuleDirect(String rule, class_1799 itemStack) {
        boolean isRegex;
        if (rule == null || rule.isEmpty()) {
            return false;
        }
        boolean bl = isRegex = rule.contains(".*") || rule.contains("^") || rule.contains("$") || rule.contains("[") || rule.contains("]") || rule.contains("+") || rule.contains("?") || rule.contains("|") || rule.contains("(") || rule.contains(")") || rule.contains("{") || rule.contains("}");
        if (isRegex) {
            try {
                Pattern pattern = Pattern.compile(rule, 2);
                return BarrelFilterRuleManager.matchesRegex(pattern, itemStack);
            }
            catch (Exception e) {
                return BarrelFilterRuleManager.matchesExact(rule, itemStack);
            }
        }
        return BarrelFilterRuleManager.matchesExact(rule, itemStack);
    }

    private static boolean matchesRegex(Pattern pattern, class_1799 itemStack) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
        if (pattern.matcher(itemId.toString()).find()) {
            return true;
        }
        String modId = itemId.method_12836();
        if (pattern.matcher(modId).find()) {
            return true;
        }
        String itemName = itemStack.method_7964().getString();
        return pattern.matcher(itemName).find();
    }

    private static boolean matchesExact(String rule, class_1799 itemStack) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
        if (itemId.toString().equals(rule)) {
            return true;
        }
        String modId = itemId.method_12836();
        if (modId.equals(rule)) {
            return true;
        }
        String itemPath = itemId.method_12832();
        if (itemPath.equals(rule)) {
            return true;
        }
        String itemName = itemStack.method_7964().getString();
        return itemName.equals(rule);
    }
}

