/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.storage;

import com.portable.storage.PortableStorage;
import com.portable.storage.blockentity.BoundBarrelBlockEntity;
import com.portable.storage.net.payload.RequestFilterRulesSyncS2CPayload;
import com.portable.storage.net.payload.SyncFilterRulesC2SPayload;
import com.portable.storage.storage.BarrelFilterRuleManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class FilterRuleManager {
    private static final Map<UUID, PlayerFilterRules> playerRules = new ConcurrentHashMap<UUID, PlayerFilterRules>();

    public static void syncPlayerRules(class_3222 player, List<SyncFilterRulesC2SPayload.FilterRule> filterRules, List<SyncFilterRulesC2SPayload.FilterRule> destroyRules) {
        UUID playerId = player.method_5667();
        playerRules.put(playerId, new PlayerFilterRules(filterRules, destroyRules));
        PortableStorage.LOGGER.info("Player {} synced {} filter rules and {} destroy rules", new Object[]{player.method_5477().getString(), filterRules.size(), destroyRules.size()});
    }

    public static PlayerFilterRules getPlayerRules(class_3222 player) {
        return playerRules.get(player.method_5667());
    }

    public static boolean shouldPickupItem(class_3222 player, class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        PlayerFilterRules rules = playerRules.get(player.method_5667());
        if (rules == null || rules.filterRules.isEmpty()) {
            return true;
        }
        ArrayList<SyncFilterRulesC2SPayload.FilterRule> whitelistRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>();
        ArrayList<SyncFilterRulesC2SPayload.FilterRule> blacklistRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>();
        for (SyncFilterRulesC2SPayload.FilterRule rule : rules.filterRules) {
            if (!rule.enabled) continue;
            if (rule.isWhitelist) {
                whitelistRules.add(rule);
                continue;
            }
            blacklistRules.add(rule);
        }
        for (SyncFilterRulesC2SPayload.FilterRule rule : blacklistRules) {
            if (!FilterRuleManager.matchesRuleDirect(itemStack, rule)) continue;
            return false;
        }
        if (!whitelistRules.isEmpty()) {
            for (SyncFilterRulesC2SPayload.FilterRule rule : whitelistRules) {
                if (!FilterRuleManager.matchesRuleDirect(itemStack, rule)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean shouldDestroyItem(class_3222 player, class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        PlayerFilterRules rules = playerRules.get(player.method_5667());
        if (rules == null || rules.destroyRules.isEmpty()) {
            return false;
        }
        for (SyncFilterRulesC2SPayload.FilterRule rule : rules.destroyRules) {
            if (!rule.enabled || !FilterRuleManager.matchesRuleDirect(itemStack, rule)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesRuleDirect(class_1799 itemStack, SyncFilterRulesC2SPayload.FilterRule rule) {
        String itemId = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        String itemName = itemStack.method_7964().getString();
        String modId = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).method_12836();
        boolean isRegex = rule.matchRule.matches(".*[\\[\\](){}.*+?^$|\\\\].*");
        if (isRegex) {
            try {
                Pattern pattern = Pattern.compile(rule.matchRule, 2);
                return pattern.matcher(itemId).find() || pattern.matcher(itemName).find() || pattern.matcher(modId).find();
            }
            catch (PatternSyntaxException e) {
                return FilterRuleManager.matchesExact(itemId, itemName, modId, rule.matchRule);
            }
        }
        return FilterRuleManager.matchesExact(itemId, itemName, modId, rule.matchRule);
    }

    private static boolean matchesExact(String itemId, String itemName, String modId, String rule) {
        String lowerRule = rule.toLowerCase();
        if (itemId.toLowerCase().equals(lowerRule)) {
            return true;
        }
        if (modId.toLowerCase().equals(lowerRule)) {
            return true;
        }
        if (itemId.toLowerCase().endsWith(":" + lowerRule)) {
            return true;
        }
        if (itemName.toLowerCase().equals(lowerRule)) {
            return true;
        }
        if (lowerRule.contains(":")) {
            return itemId.toLowerCase().equals(lowerRule);
        }
        return false;
    }

    public static void clearPlayerRules(UUID playerId) {
        playerRules.remove(playerId);
    }

    public static void requestRulesSync(class_3222 player) {
        PlayerFilterRules rules = playerRules.get(player.method_5667());
        if (rules != null) {
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new RequestFilterRulesSyncS2CPayload());
        PortableStorage.LOGGER.debug("Requested filter rules sync for player {}", (Object)player.method_5477().getString());
    }

    public static boolean shouldPickupItemForBarrel(BoundBarrelBlockEntity barrel, class_1799 itemStack) {
        return BarrelFilterRuleManager.shouldPickupItem(barrel, itemStack);
    }

    public static class PlayerFilterRules {
        public final List<SyncFilterRulesC2SPayload.FilterRule> filterRules;
        public final List<SyncFilterRulesC2SPayload.FilterRule> destroyRules;

        public PlayerFilterRules(List<SyncFilterRulesC2SPayload.FilterRule> filterRules, List<SyncFilterRulesC2SPayload.FilterRule> destroyRules) {
            this.filterRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>(filterRules);
            this.destroyRules = new ArrayList<SyncFilterRulesC2SPayload.FilterRule>(destroyRules);
        }
    }
}

