/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.storage;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class StorageInventory {
    private final List<Entry> variants = new ArrayList<Entry>();
    private List<Integer> sortedIndices = null;

    public StorageInventory(int ignoredCapacity) {
    }

    private static boolean stacksEqual(class_1799 a, class_1799 b) {
        return class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    private void markDirty() {
        this.sortedIndices = null;
    }

    public int getCapacity() {
        return this.variants.size();
    }

    private List<Integer> getSortedIndices() {
        if (this.sortedIndices == null) {
            ArrayList<Integer> idx = new ArrayList<Integer>(this.variants.size());
            for (int i = 0; i < this.variants.size(); ++i) {
                idx.add(i);
            }
            idx.sort((ia, ib) -> {
                String sb;
                Entry a = this.variants.get((int)ia);
                Entry b = this.variants.get((int)ib);
                int c = Long.compare(b.count, a.count);
                if (c != 0) {
                    return c;
                }
                c = Long.compare(b.updatedAt, a.updatedAt);
                if (c != 0) {
                    return c;
                }
                c = class_7923.field_41178.method_10221((Object)a.template.method_7909()).method_12833(class_7923.field_41178.method_10221((Object)b.template.method_7909()));
                if (c != 0) {
                    return c;
                }
                String sa = StorageInventory.buildVariantSignature(a.template);
                c = sa.compareTo(sb = StorageInventory.buildVariantSignature(b.template));
                if (c != 0) {
                    return c;
                }
                return a.template.method_7964().getString().compareToIgnoreCase(b.template.method_7964().getString());
            });
            this.sortedIndices = idx;
        }
        return this.sortedIndices;
    }

    private static String buildVariantSignature(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return "";
        }
        try {
            DataResult encoded = class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack.method_7972());
            return encoded.result().map(Object::toString).orElse("");
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    private Entry getEntryByViewIndex(int index) {
        List<Integer> idx = this.getSortedIndices();
        if (index < 0 || index >= idx.size()) {
            return null;
        }
        return this.variants.get(idx.get(index));
    }

    public long getCountByIndex(int index) {
        Entry e = this.getEntryByViewIndex(index);
        return e == null ? 0L : e.count;
    }

    public class_1799 getDisplayStack(int index) {
        Entry e = this.getEntryByViewIndex(index);
        if (e == null || e.count <= 0L || e.template.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 s = e.template.method_7972();
        s.method_7939((int)Math.min((long)Math.max(1, s.method_7914()), e.count));
        return s;
    }

    public long getTimestampByIndex(int index) {
        Entry e = this.getEntryByViewIndex(index);
        return e != null ? e.updatedAt : 0L;
    }

    public long takeByIndex(int index, long want, long ts) {
        if (want <= 0L) {
            return 0L;
        }
        Entry e = this.getEntryByViewIndex(index);
        if (e == null || e.count <= 0L) {
            return 0L;
        }
        long got = Math.min(e.count, want);
        e.count -= got;
        e.updatedAt = ts;
        if (e.count == 0L) {
            this.variants.remove(e);
        }
        this.markDirty();
        return got;
    }

    public class_1799 insertItemStack(class_1799 stack, long ts) {
        if (stack == null || stack.method_7960()) {
            return class_1799.field_8037;
        }
        for (Entry e : this.variants) {
            if (!StorageInventory.stacksEqual(e.template, stack)) continue;
            this.addToEntry(e, stack.method_7947(), ts);
            return class_1799.field_8037;
        }
        Entry e = new Entry();
        e.template = stack.method_7972();
        e.template.method_7939(1);
        e.count = 0L;
        e.updatedAt = ts;
        this.variants.add(e);
        this.addToEntry(e, stack.method_7947(), ts);
        this.markDirty();
        return class_1799.field_8037;
    }

    public void insertItemStackWithOriginalTimestamp(class_1799 stack, long originalTimestamp) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        for (Entry e : this.variants) {
            if (!StorageInventory.stacksEqual(e.template, stack)) continue;
            try {
                e.count = Math.addExact(e.count, (long)stack.method_7947());
            }
            catch (ArithmeticException ex) {
                e.count = Long.MAX_VALUE;
            }
            this.markDirty();
            return;
        }
        Entry e = new Entry();
        e.template = stack.method_7972();
        e.template.method_7939(1);
        e.count = stack.method_7947();
        e.updatedAt = originalTimestamp;
        this.variants.add(e);
        this.markDirty();
    }

    private void addToEntry(Entry e, long add, long ts) {
        if (add <= 0L) {
            return;
        }
        try {
            e.count = Math.addExact(e.count, add);
        }
        catch (ArithmeticException ex) {
            e.count = Long.MAX_VALUE;
        }
        e.updatedAt = ts;
        this.markDirty();
    }

    public boolean isEmpty() {
        return this.variants.isEmpty();
    }

    public void clear() {
        this.variants.clear();
        this.markDirty();
    }

    public class_2487 writeNbt(class_2487 out) {
        return this.writeNbt(out, null);
    }

    public class_2487 writeNbt(class_2487 out, class_7225.class_7874 lookup) {
        class_2509 ops = lookup != null ? class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup) : class_2509.field_11560;
        class_2499 list = new class_2499();
        for (int vi : this.getSortedIndices()) {
            Boolean glint;
            class_9279 be;
            Entry e = this.variants.get(vi);
            if (e == null || e.count <= 0L || e.template.method_7960()) continue;
            class_2487 c = new class_2487();
            DataResult encoded = class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)e.template);
            encoded.result().ifPresent(nbtElement -> c.method_10566("item_full", nbtElement));
            class_2487 itemTag = new class_2487();
            itemTag.method_10582("id", class_7923.field_41178.method_10221((Object)e.template.method_7909()).toString());
            class_9279 custom = (class_9279)e.template.method_57824(class_9334.field_49628);
            if (custom != null) {
                itemTag.method_10566("custom", (class_2520)custom.method_57461());
            }
            if ((be = (class_9279)e.template.method_57824(class_9334.field_49611)) != null) {
                itemTag.method_10566("block_entity", (class_2520)be.method_57461());
            }
            if ((glint = (Boolean)e.template.method_57824(class_9334.field_49641)) != null && glint.booleanValue()) {
                itemTag.method_10556("glint", true);
            }
            c.method_10566("item", (class_2520)itemTag);
            c.method_10544("count", e.count);
            c.method_10544("ts", e.updatedAt);
            list.add((Object)c);
        }
        out.method_10566("entries", (class_2520)list);
        out.method_10569("capacity", list.size());
        return out;
    }

    public void readNbt(class_2487 in) {
        this.readNbt(in, null);
    }

    public void readNbt(class_2487 in, class_7225.class_7874 lookup) {
        this.clear();
        if (in == null) {
            return;
        }
        if (!in.method_10573("entries", 9)) {
            return;
        }
        class_2499 list = in.method_10554("entries", 10);
        class_2509 ops = lookup != null ? class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup) : class_2509.field_11560;
        for (int i = 0; i < list.size(); ++i) {
            class_1792 item;
            class_2487 itemTag;
            class_2960 id;
            class_2487 c = list.method_10602(i);
            class_1799 template = class_1799.field_8037;
            if (c.method_10545("item_full")) {
                DataResult parse = class_1799.field_24671.parse((DynamicOps)ops, (Object)c.method_10580("item_full"));
                template = parse.result().orElse(class_1799.field_8037);
            }
            if (template.method_7960() && c.method_10573("item", 10) && (id = class_2960.method_12829((String)(itemTag = c.method_10562("item")).method_10558("id"))) != null && (item = (class_1792)class_7923.field_41178.method_10223(id)) != null && item != class_1802.field_8162) {
                template = new class_1799((class_1935)item);
                if (itemTag.method_10573("custom", 10)) {
                    template.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)itemTag.method_10562("custom")));
                }
                if (itemTag.method_10573("block_entity", 10)) {
                    template.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)itemTag.method_10562("block_entity")));
                }
                if (itemTag.method_10573("glint", 1) && itemTag.method_10577("glint")) {
                    template.method_57379(class_9334.field_49641, (Object)true);
                }
            }
            if (template.method_7960()) continue;
            Entry e = new Entry();
            e.template = template;
            e.count = Math.max(0L, c.method_10537("count"));
            long l = e.updatedAt = c.method_10545("ts") ? c.method_10537("ts") : 0L;
            if (e.count <= 0L) continue;
            this.variants.add(e);
        }
        this.markDirty();
    }

    private static final class Entry {
        class_1799 template;
        long count;
        long updatedAt;

        private Entry() {
        }
    }
}

