/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.storage;

public enum StorageType {
    PRIMARY("primary", "portable-storage.storage_type.primary", 36),
    FULL("full", "portable-storage.storage_type.full", -1);

    private final String key;
    private final String displayName;
    private final int capacityLimit;

    private StorageType(String key, String displayName, int capacityLimit) {
        this.key = key;
        this.displayName = displayName;
        this.capacityLimit = capacityLimit;
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTranslationKey() {
        return this.displayName;
    }

    public int getCapacityLimit() {
        return this.capacityLimit;
    }

    public boolean hasCapacityLimit() {
        return this.capacityLimit > 0;
    }

    public static StorageType fromKey(String key) {
        for (StorageType type : StorageType.values()) {
            if (!type.key.equals(key)) continue;
            return type;
        }
        return FULL;
    }
}

