/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.storage;

import com.portable.storage.storage.UpgradeSlotType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class UnifiedUpgradeManager {
    private static final int BASE_SLOT_COUNT = 5;
    private static final int EXTENDED_SLOT_COUNT = 5;
    private final class_1799[] baseSlots;
    private final boolean[] baseSlotDisabled;
    private final class_1799[] extendedSlots;
    private final boolean[] extendedSlotDisabled;
    private class_1799 trashSlot = class_1799.field_8037;
    private boolean trashSlotDisabled = false;
    private class_1799 fluidSlot = class_1799.field_8037;
    private int lavaUnits = 0;
    private int waterUnits = 0;
    private int milkUnits = 0;
    private long xpPool = 0L;
    private boolean levelMaintenanceEnabled = false;

    public UnifiedUpgradeManager() {
        int i;
        this.baseSlots = new class_1799[5];
        this.baseSlotDisabled = new boolean[5];
        this.extendedSlots = new class_1799[5];
        this.extendedSlotDisabled = new boolean[5];
        for (i = 0; i < 5; ++i) {
            this.baseSlots[i] = class_1799.field_8037;
            this.baseSlotDisabled[i] = false;
        }
        for (i = 0; i < 5; ++i) {
            this.extendedSlots[i] = class_1799.field_8037;
            this.extendedSlotDisabled[i] = false;
        }
    }

    public class_1799 getBaseSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return class_1799.field_8037;
        }
        return this.baseSlots[slotIndex];
    }

    public void setBaseSlot(int slotIndex, class_1799 stack) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return;
        }
        this.baseSlots[slotIndex] = stack;
    }

    public boolean isBaseSlotDisabled(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return false;
        }
        return this.baseSlotDisabled[slotIndex];
    }

    public void setBaseSlotDisabled(int slotIndex, boolean disabled) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return;
        }
        this.baseSlotDisabled[slotIndex] = disabled;
    }

    public void toggleBaseSlotDisabled(int slotIndex) {
        this.setBaseSlotDisabled(slotIndex, !this.isBaseSlotDisabled(slotIndex));
    }

    public class_1799 getExtendedSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return class_1799.field_8037;
        }
        return this.extendedSlots[slotIndex];
    }

    public void setExtendedSlot(int slotIndex, class_1799 stack) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return;
        }
        this.extendedSlots[slotIndex] = stack;
    }

    public boolean isExtendedSlotDisabled(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return false;
        }
        return this.extendedSlotDisabled[slotIndex];
    }

    public void setExtendedSlotDisabled(int slotIndex, boolean disabled) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return;
        }
        this.extendedSlotDisabled[slotIndex] = disabled;
    }

    public void toggleExtendedSlotDisabled(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return;
        }
        this.setExtendedSlotDisabled(slotIndex, !this.isExtendedSlotDisabled(slotIndex));
    }

    public class_1799 getTrashSlot() {
        return this.trashSlot;
    }

    public void setTrashSlot(class_1799 stack) {
        this.trashSlot = stack;
    }

    public boolean isTrashSlotDisabled() {
        return this.trashSlotDisabled;
    }

    public void setTrashSlotDisabled(boolean disabled) {
        this.trashSlotDisabled = disabled;
    }

    public void toggleTrashSlotDisabled() {
        this.trashSlotDisabled = !this.trashSlotDisabled;
    }

    public class_1799 getFluidSlot() {
        return this.fluidSlot;
    }

    public void setFluidSlot(class_1799 stack) {
        this.fluidSlot = stack;
    }

    public boolean isChestUpgradeActive() {
        class_1799 chestStack = this.getBaseSlot(2);
        return !chestStack.method_7960() && !this.isBaseSlotDisabled(2);
    }

    public boolean isExtendedSlotEnabled(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 5) {
            return false;
        }
        return this.isChestUpgradeActive() && !this.isExtendedSlotDisabled(slotIndex);
    }

    public boolean isSpectralArrowUpgradeActive() {
        class_1799 stack = this.getExtendedSlot(0);
        return !stack.method_7960() && !this.isExtendedSlotDisabled(0);
    }

    public boolean isBedUpgradeActive() {
        class_1799 stack = this.getExtendedSlot(1);
        return !stack.method_7960() && !this.isExtendedSlotDisabled(1);
    }

    public boolean isXpBottleUpgradeActive() {
        class_1799 stack = this.getExtendedSlot(2);
        return !stack.method_7960() && !this.isExtendedSlotDisabled(2);
    }

    public boolean isPistonUpgradeActive() {
        class_1799 stack = this.getExtendedSlot(3);
        return !stack.method_7960() && !this.isExtendedSlotDisabled(3);
    }

    public boolean isEnchantedGoldenAppleUpgradeActive() {
        class_1799 stack = this.getExtendedSlot(4);
        return !stack.method_7960() && !this.isExtendedSlotDisabled(4);
    }

    public boolean isTrashSlotActive() {
        return !this.trashSlot.method_7960() && !this.trashSlotDisabled;
    }

    public boolean isValidForBaseSlot(int slotIndex, class_1799 stack) {
        UpgradeSlotType slotType = UpgradeSlotType.getBaseSlotType(slotIndex);
        return slotType != null && slotType.isValidItem(stack);
    }

    public boolean isValidForExtendedSlot(int slotIndex, class_1799 stack) {
        UpgradeSlotType slotType = UpgradeSlotType.getExtendedSlotType(slotIndex);
        return slotType != null && slotType.isValidItem(stack);
    }

    public boolean tryInsertBaseSlot(int slotIndex, class_1799 stack, UUID playerUuid, String playerName) {
        if (!this.isValidForBaseSlot(slotIndex, stack) || !this.getBaseSlot(slotIndex).method_7960() || stack.method_7947() != 1) {
            return false;
        }
        class_1799 toInsert = stack.method_7972();
        if (slotIndex == 3 && toInsert.method_31574(class_1802.field_16307)) {
            class_2487 nbt;
            class_9279 customData = (class_9279)toInsert.method_57824(class_9334.field_49628);
            boolean alreadyBound = false;
            if (customData != null && ((nbt = customData.method_57461()).method_25928("ps_owner_uuid") || nbt.method_10545("ps_owner_uuid_most") && nbt.method_10545("ps_owner_uuid_least"))) {
                alreadyBound = true;
            }
            if (!alreadyBound && playerUuid != null) {
                class_2487 customNbt = new class_2487();
                customNbt.method_25927("ps_owner_uuid", playerUuid);
                customNbt.method_10544("ps_owner_uuid_most", playerUuid.getMostSignificantBits());
                customNbt.method_10544("ps_owner_uuid_least", playerUuid.getLeastSignificantBits());
                if (playerName != null) {
                    customNbt.method_10582("ps_owner_name", playerName);
                }
                toInsert.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customNbt));
                toInsert.method_57379(class_9334.field_49641, (Object)true);
            }
        }
        this.setBaseSlot(slotIndex, toInsert);
        return true;
    }

    public boolean tryInsertExtendedSlot(int slotIndex, class_1799 stack) {
        if (!this.isValidForExtendedSlot(slotIndex, stack) || !this.getExtendedSlot(slotIndex).method_7960() || stack.method_7947() != 1) {
            return false;
        }
        this.setExtendedSlot(slotIndex, stack.method_7972());
        return true;
    }

    public boolean tryInsertTrashSlot(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        int maxCount = Math.min(stack.method_7947(), stack.method_7914());
        class_1799 trashStack = stack.method_7972();
        trashStack.method_7939(maxCount);
        this.setTrashSlot(trashStack);
        return true;
    }

    public class_1799 takeBaseSlot(int slotIndex) {
        class_1799 result = this.getBaseSlot(slotIndex);
        this.setBaseSlot(slotIndex, class_1799.field_8037);
        return result;
    }

    public class_1799 takeExtendedSlot(int slotIndex) {
        class_1799 result = this.getExtendedSlot(slotIndex);
        this.setExtendedSlot(slotIndex, class_1799.field_8037);
        return result;
    }

    public class_1799 takeTrashSlot() {
        class_1799 result = this.getTrashSlot();
        this.setTrashSlot(class_1799.field_8037);
        return result;
    }

    public int getFluidUnits(String fluidType) {
        return switch (fluidType) {
            case "lava" -> this.lavaUnits;
            case "water" -> this.waterUnits;
            case "milk" -> this.milkUnits;
            default -> 0;
        };
    }

    public void setFluidUnits(String fluidType, int units) {
        switch (fluidType) {
            case "lava": {
                this.lavaUnits = Math.max(0, units);
                break;
            }
            case "water": {
                this.waterUnits = Math.max(0, units);
                break;
            }
            case "milk": {
                this.milkUnits = Math.max(0, units);
            }
        }
    }

    public void addFluidUnits(String fluidType, int units) {
        this.setFluidUnits(fluidType, this.getFluidUnits(fluidType) + units);
    }

    public boolean removeFluidUnits(String fluidType, int units) {
        int current = this.getFluidUnits(fluidType);
        if (current >= units) {
            this.setFluidUnits(fluidType, current - units);
            return true;
        }
        return false;
    }

    public long getXpPool() {
        return Math.max(0L, this.xpPool);
    }

    public long addToXpPool(long amount) {
        long after;
        if (amount <= 0L) {
            return 0L;
        }
        long before = this.xpPool;
        try {
            after = Math.addExact(before, amount);
        }
        catch (ArithmeticException ex) {
            after = Long.MAX_VALUE;
        }
        this.xpPool = after;
        return after - before;
    }

    public long removeFromXpPool(long amount) {
        if (amount <= 0L) {
            return 0L;
        }
        long removed = Math.min(amount, Math.max(0L, this.xpPool));
        this.xpPool -= removed;
        if (this.xpPool < 0L) {
            this.xpPool = 0L;
        }
        return removed;
    }

    public boolean isLevelMaintenanceEnabled() {
        return this.levelMaintenanceEnabled;
    }

    public void setLevelMaintenanceEnabled(boolean enabled) {
        this.levelMaintenanceEnabled = enabled;
    }

    public void toggleLevelMaintenance() {
        this.levelMaintenanceEnabled = !this.levelMaintenanceEnabled;
    }

    public void writeNbt(class_2487 nbt) {
        class_9279 custom;
        class_2499 baseList = new class_2499();
        for (int i = 0; i < 5; ++i) {
            class_9279 be;
            if (this.baseSlots[i].method_7960()) continue;
            class_2487 slotNbt = new class_2487();
            slotNbt.method_10567("Slot", (byte)i);
            slotNbt.method_10582("id", class_7923.field_41178.method_10221((Object)this.baseSlots[i].method_7909()).toString());
            slotNbt.method_10567("Count", (byte)this.baseSlots[i].method_7947());
            class_9279 custom2 = (class_9279)this.baseSlots[i].method_57824(class_9334.field_49628);
            if (custom2 != null) {
                slotNbt.method_10566("CustomData", (class_2520)custom2.method_57461());
            }
            if ((be = (class_9279)this.baseSlots[i].method_57824(class_9334.field_49611)) != null) {
                slotNbt.method_10566("BlockEntityData", (class_2520)be.method_57461());
            }
            baseList.add((Object)slotNbt);
        }
        nbt.method_10566("BaseUpgrades", (class_2520)baseList);
        class_2487 baseDisabledNbt = new class_2487();
        for (int i = 0; i < 5; ++i) {
            baseDisabledNbt.method_10556("slot" + i, this.baseSlotDisabled[i]);
        }
        nbt.method_10566("BaseDisabledSlots", (class_2520)baseDisabledNbt);
        class_2499 extendedList = new class_2499();
        for (int i = 0; i < 5; ++i) {
            class_9279 be;
            if (this.extendedSlots[i].method_7960()) continue;
            class_2487 slotNbt = new class_2487();
            slotNbt.method_10567("Slot", (byte)i);
            slotNbt.method_10582("id", class_7923.field_41178.method_10221((Object)this.extendedSlots[i].method_7909()).toString());
            slotNbt.method_10567("Count", (byte)this.extendedSlots[i].method_7947());
            custom = (class_9279)this.extendedSlots[i].method_57824(class_9334.field_49628);
            if (custom != null) {
                slotNbt.method_10566("CustomData", (class_2520)custom.method_57461());
            }
            if ((be = (class_9279)this.extendedSlots[i].method_57824(class_9334.field_49611)) != null) {
                slotNbt.method_10566("BlockEntityData", (class_2520)be.method_57461());
            }
            extendedList.add((Object)slotNbt);
        }
        nbt.method_10566("ExtendedUpgrades", (class_2520)extendedList);
        class_2487 extendedDisabledNbt = new class_2487();
        for (int i = 0; i < 5; ++i) {
            extendedDisabledNbt.method_10556("slot" + i, this.extendedSlotDisabled[i]);
        }
        nbt.method_10566("ExtendedDisabledSlots", (class_2520)extendedDisabledNbt);
        if (!this.trashSlot.method_7960()) {
            class_2487 trashNbt = new class_2487();
            trashNbt.method_10582("id", class_7923.field_41178.method_10221((Object)this.trashSlot.method_7909()).toString());
            trashNbt.method_10567("Count", (byte)this.trashSlot.method_7947());
            custom = (class_9279)this.trashSlot.method_57824(class_9334.field_49628);
            if (custom != null) {
                trashNbt.method_10566("CustomData", (class_2520)custom.method_57461());
            }
            nbt.method_10566("TrashSlot", (class_2520)trashNbt);
        }
        nbt.method_10556("TrashSlotDisabled", this.trashSlotDisabled);
        if (!this.fluidSlot.method_7960()) {
            class_2487 fluidNbt = new class_2487();
            fluidNbt.method_10582("id", class_7923.field_41178.method_10221((Object)this.fluidSlot.method_7909()).toString());
            fluidNbt.method_10567("Count", (byte)this.fluidSlot.method_7947());
            custom = (class_9279)this.fluidSlot.method_57824(class_9334.field_49628);
            if (custom != null) {
                fluidNbt.method_10566("CustomData", (class_2520)custom.method_57461());
            }
            nbt.method_10566("FluidSlot", (class_2520)fluidNbt);
        }
        nbt.method_10569("LavaUnits", this.lavaUnits);
        nbt.method_10569("WaterUnits", this.waterUnits);
        nbt.method_10569("MilkUnits", this.milkUnits);
        nbt.method_10544("XpPool", Math.max(0L, this.xpPool));
        nbt.method_10556("LevelMaintenanceEnabled", this.levelMaintenanceEnabled);
    }

    public void readNbt(class_2487 nbt) {
        class_2487 custom;
        class_1799 stack;
        int i;
        int i2;
        for (int i3 = 0; i3 < 5; ++i3) {
            this.baseSlots[i3] = class_1799.field_8037;
        }
        class_2499 baseList = nbt.method_10554("BaseUpgrades", 10);
        for (i2 = 0; i2 < baseList.size(); ++i2) {
            class_1792 item;
            class_2960 id;
            class_2487 slotNbt = baseList.method_10602(i2);
            int slot = slotNbt.method_10571("Slot") & 0xFF;
            if (slot < 0 || slot >= 5 || !slotNbt.method_10545("id") || (id = class_2960.method_12829((String)slotNbt.method_10558("id"))) == null || (item = (class_1792)class_7923.field_41178.method_10223(id)) == null || item == class_1802.field_8162) continue;
            class_1799 stack2 = new class_1799((class_1935)item);
            stack2.method_7939((int)slotNbt.method_10571("Count"));
            if (slotNbt.method_10573("CustomData", 10)) {
                class_2487 custom2 = slotNbt.method_10562("CustomData");
                stack2.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)custom2));
            }
            if (slotNbt.method_10573("BlockEntityData", 10)) {
                class_2487 be = slotNbt.method_10562("BlockEntityData");
                stack2.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)be));
            }
            this.baseSlots[slot] = stack2;
        }
        if (nbt.method_10573("BaseDisabledSlots", 10)) {
            class_2487 baseDisabledNbt = nbt.method_10562("BaseDisabledSlots");
            for (int i4 = 0; i4 < 5; ++i4) {
                this.baseSlotDisabled[i4] = baseDisabledNbt.method_10577("slot" + i4);
            }
        } else {
            for (i2 = 0; i2 < 5; ++i2) {
                this.baseSlotDisabled[i2] = false;
            }
        }
        for (int i5 = 0; i5 < 5; ++i5) {
            this.extendedSlots[i5] = class_1799.field_8037;
        }
        class_2499 extendedList = nbt.method_10554("ExtendedUpgrades", 10);
        for (i = 0; i < extendedList.size(); ++i) {
            class_1792 item;
            class_2960 id;
            class_2487 slotNbt = extendedList.method_10602(i);
            int slot = slotNbt.method_10571("Slot") & 0xFF;
            if (slot < 0 || slot >= 5 || !slotNbt.method_10545("id") || (id = class_2960.method_12829((String)slotNbt.method_10558("id"))) == null || (item = (class_1792)class_7923.field_41178.method_10223(id)) == null || item == class_1802.field_8162) continue;
            class_1799 stack3 = new class_1799((class_1935)item);
            stack3.method_7939((int)slotNbt.method_10571("Count"));
            if (slotNbt.method_10573("CustomData", 10)) {
                class_2487 custom3 = slotNbt.method_10562("CustomData");
                stack3.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)custom3));
            }
            if (slotNbt.method_10573("BlockEntityData", 10)) {
                class_2487 be = slotNbt.method_10562("BlockEntityData");
                stack3.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)be));
            }
            this.extendedSlots[slot] = stack3;
        }
        if (nbt.method_10573("ExtendedDisabledSlots", 10)) {
            class_2487 extendedDisabledNbt = nbt.method_10562("ExtendedDisabledSlots");
            for (int i6 = 0; i6 < 5; ++i6) {
                this.extendedSlotDisabled[i6] = extendedDisabledNbt.method_10577("slot" + i6);
            }
        } else {
            for (i = 0; i < 5; ++i) {
                this.extendedSlotDisabled[i] = false;
            }
        }
        if (nbt.method_10573("TrashSlot", 10)) {
            class_1792 item;
            class_2960 id;
            class_2487 trashNbt = nbt.method_10562("TrashSlot");
            if (trashNbt.method_10545("id") && (id = class_2960.method_12829((String)trashNbt.method_10558("id"))) != null && (item = (class_1792)class_7923.field_41178.method_10223(id)) != null && item != class_1802.field_8162) {
                stack = new class_1799((class_1935)item);
                stack.method_7939((int)trashNbt.method_10571("Count"));
                if (trashNbt.method_10573("CustomData", 10)) {
                    custom = trashNbt.method_10562("CustomData");
                    stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)custom));
                }
                this.trashSlot = stack;
            }
        } else {
            this.trashSlot = class_1799.field_8037;
        }
        this.trashSlotDisabled = nbt.method_10577("TrashSlotDisabled");
        if (nbt.method_10573("FluidSlot", 10)) {
            class_1792 item;
            class_2960 id;
            class_2487 fluidNbt = nbt.method_10562("FluidSlot");
            if (fluidNbt.method_10545("id") && (id = class_2960.method_12829((String)fluidNbt.method_10558("id"))) != null && (item = (class_1792)class_7923.field_41178.method_10223(id)) != null && item != class_1802.field_8162) {
                stack = new class_1799((class_1935)item);
                stack.method_7939((int)fluidNbt.method_10571("Count"));
                if (fluidNbt.method_10573("CustomData", 10)) {
                    custom = fluidNbt.method_10562("CustomData");
                    stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)custom));
                }
                this.fluidSlot = stack;
            }
        } else {
            this.fluidSlot = class_1799.field_8037;
        }
        this.lavaUnits = nbt.method_10550("LavaUnits");
        this.waterUnits = nbt.method_10550("WaterUnits");
        this.milkUnits = nbt.method_10550("MilkUnits");
        this.xpPool = nbt.method_10573("XpPool", 4) ? Math.max(0L, nbt.method_10537("XpPool")) : 0L;
        this.levelMaintenanceEnabled = nbt.method_10573("LevelMaintenanceEnabled", 1) ? nbt.method_10577("LevelMaintenanceEnabled") : false;
    }

    public List<class_1799> getExtendedSlotItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int i = 0; i < 5; ++i) {
            if (this.extendedSlots[i].method_7960()) continue;
            items.add(this.extendedSlots[i].method_7972());
        }
        return items;
    }

    public void clearExtendedSlots() {
        for (int i = 0; i < 5; ++i) {
            this.extendedSlots[i] = class_1799.field_8037;
        }
    }
}

